/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;

public class JavaConstantsGenerator
extends JavaBaseGenerator {
    public JavaConstantsGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void generate() throws Exception {
        StringBuilder rt = new StringBuilder();
        boolean first = true;
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            if (first) {
                first = false;
            } else {
                rt.append("|");
            }
            rt.append(sd.getType());
            this.version = sd.getVersion();
        }
        String template = this.config.getAdornments().get("Constants");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{rt}}", rt.toString());
        template = template.replace("{{version}}", this.version);
        template = template.replace("{{version-mm}}", VersionUtilities.getMajMin((String)this.version) != null ? VersionUtilities.getMajMin((String)this.version) : this.version);
        template = template.replace("{{version-base}}", this.version.contains("-") ? this.version.substring(0, this.version.indexOf("-")) : this.version);
        template = template.replace("{{date}}", this.genDate);
        this.write(template);
        this.flush();
        this.close();
    }
}

