/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.test.utils.CompareUtilities;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.special.TxTesterScrubbers;
import org.hl7.fhir.validation.special.TxTesterSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxServiceTestHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TxServiceTestHelper.class);

    public static String getDiffForValidation(String id, IWorkerContext context, String name, Resource requestParameters, String expectedResponse, String lang, String fp, JsonObject externals, boolean isCodeSystem, Set<String> modes) throws JsonSyntaxException, FileNotFoundException, IOException {
        String diff;
        Object actualResponse;
        Parameters p = (Parameters)requestParameters;
        ValueSet valueSet = null;
        Object valueSetUrl = null;
        if (!isCodeSystem) {
            if (p.hasParameter("valueSetVersion")) {
                valueSetUrl = p.getParameterValue("url").primitiveValue() + "|" + p.getParameterValue("valueSetVersion").primitiveValue();
                valueSet = (ValueSet)context.fetchResource(ValueSet.class, p.getParameterValue("url").primitiveValue(), p.getParameterValue("valueSetVersion").primitiveValue());
            } else {
                valueSetUrl = p.getParameterValue("url").primitiveValue();
                valueSet = (ValueSet)context.fetchResource(ValueSet.class, p.getParameterValue("url").primitiveValue());
            }
        }
        ValidationResult validationResult = null;
        String code = null;
        String system = null;
        String version = null;
        String display = null;
        CodeableConcept codeableConcept = null;
        Parameters parameters = null;
        OperationOutcome operationOutcome = null;
        if (valueSet == null && valueSetUrl != null) {
            String msg = context.formatMessage("Unable_to_resolve_value_Set_", new Object[]{valueSetUrl});
            operationOutcome = new OperationOutcome();
            CodeableConcept codeableConceptWhenNullValueSet = operationOutcome.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setCode(OperationOutcome.IssueType.NOTFOUND).getDetails();
            codeableConceptWhenNullValueSet.addCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "not-found", null);
            codeableConceptWhenNullValueSet.setText(msg);
        } else {
            ValidationOptions options = new ValidationOptions(FhirPublication.R5);
            if (p.hasParameter("displayLanguage")) {
                options = options.withLanguage(p.getParameterString("displayLanguage"));
            } else if (lang != null) {
                options = options.withLanguage(lang);
            }
            if (p.hasParameter("valueset-membership-only") && "true".equals(p.getParameterString("valueset-membership-only"))) {
                options = options.withCheckValueSetOnly();
            }
            if (p.hasParameter("lenient-display-validation") && "true".equals(p.getParameterString("lenient-display-validation"))) {
                options = options.setDisplayWarningMode(true);
            }
            if (p.hasParameter("activeOnly") && "true".equals(p.getParameterString("activeOnly"))) {
                options = options.setActiveOnly(true);
            }
            for (Parameters.ParametersParameterComponent pp : p.getParameter()) {
                if (!Utilities.existsInList((String)pp.getName(), (String[])new String[]{"default-valueset-version", "system-version", "force-system-version", "default-system-version"})) continue;
                context.getExpansionParameters().getParameter().add(pp);
            }
            context.getExpansionParameters().clearParameters("includeAlternateCodes");
            for (Parameters.ParametersParameterComponent pp : p.getParameter()) {
                if (!"includeAlternateCodes".equals(pp.getName())) continue;
                context.getExpansionParameters().addParameter(pp.copy());
            }
            if (p.hasParameter("code")) {
                code = p.getParameterString("code");
                system = p.getParameterString(isCodeSystem ? "url" : "system");
                version = p.getParameterString(isCodeSystem ? "version" : "systemVersion");
                display = p.getParameterString("display");
                validationResult = context.validateCode(options.withGuessSystem(), p.getParameterString(isCodeSystem ? "url" : "system"), p.getParameterString(isCodeSystem ? "version" : "systemVersion"), p.getParameterString("code"), p.getParameterString("display"), valueSet);
            } else if (p.hasParameter("coding")) {
                Coding coding = (Coding)p.getParameterValue("coding");
                code = coding.getCode();
                system = coding.getSystem();
                version = coding.getVersion();
                display = coding.getDisplay();
                validationResult = context.validateCode(options, coding, valueSet);
            } else if (p.hasParameter("codeableConcept")) {
                codeableConcept = (CodeableConcept)p.getParameterValue("codeableConcept");
                validationResult = context.validateCode(options, codeableConcept, valueSet);
            } else {
                throw new Error("validate not done yet for this steup");
            }
        }
        if (operationOutcome == null && validationResult != null && validationResult.getSeverity() == ValidationMessage.IssueSeverity.FATAL) {
            operationOutcome = new OperationOutcome();
            operationOutcome.getIssue().addAll(validationResult.getIssues());
        }
        if (operationOutcome != null) {
            TxTesterSorters.sortOperationOutcome(operationOutcome);
            TxTesterScrubbers.scrubOO(operationOutcome, false);
            actualResponse = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)operationOutcome);
            TxServiceTestHelper.writeDiffToFileSystem(name, expectedResponse, (String)actualResponse);
            diff = new CompareUtilities(modes, externals).checkJsonSrcIsSame(id, expectedResponse, (String)actualResponse);
            if (diff != null) {
                FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
                FileUtilities.stringToFile((String)actualResponse, (String)fp);
                log.error("Test " + name + "failed: " + diff);
            }
            return diff;
        }
        if (parameters == null) {
            parameters = new Parameters();
            if (validationResult.getSystem() != null) {
                parameters.addParameter("system", (DataType)new UriType(validationResult.getSystem()));
            } else if (system != null) {
                parameters.addParameter("system", (DataType)new UriType(system));
            }
            if (validationResult.getCode() != null) {
                if (code != null && !code.equals(validationResult.getCode())) {
                    parameters.addParameter("code", (DataType)new CodeType(code));
                    parameters.addParameter("normalized-code", (DataType)new CodeType(validationResult.getCode()));
                } else {
                    parameters.addParameter("code", (DataType)new CodeType(validationResult.getCode()));
                }
            } else if (code != null) {
                parameters.addParameter("code", (DataType)new CodeType(code));
            }
            if (validationResult.getSeverity() == ValidationMessage.IssueSeverity.ERROR) {
                parameters.addParameter("result", false);
            } else {
                parameters.addParameter("result", true);
            }
            if (validationResult.getMessage() != null) {
                parameters.addParameter("message", validationResult.getMessage());
            }
            if (validationResult.getVersion() != null) {
                parameters.addParameter("version", validationResult.getVersion());
            } else if (version != null) {
                parameters.addParameter("version", (DataType)new StringType(version));
            }
            if (validationResult.getDisplay() != null) {
                parameters.addParameter("display", validationResult.getDisplay());
            } else if (display != null) {
                parameters.addParameter("display", (DataType)new StringType(display));
            }
            if (codeableConcept != null) {
                parameters.addParameter("codeableConcept", (DataType)codeableConcept);
            }
            if (validationResult.isInactive()) {
                parameters.addParameter("inactive", true);
            }
            if (validationResult.getStatus() != null) {
                parameters.addParameter("status", validationResult.getStatus());
            }
            if (validationResult.getUnknownSystems() != null) {
                for (String s : validationResult.getUnknownSystems()) {
                    parameters.addParameter(validationResult.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED ? "x-caused-by-unknown-system" : "x-unknown-system", (DataType)new CanonicalType(s));
                }
            }
            if (validationResult.getIssues().size() > 0) {
                operationOutcome = new OperationOutcome();
                operationOutcome.getIssue().addAll(validationResult.getIssues());
                parameters.addParameter().setName("issues").setResource((Resource)operationOutcome);
            }
        }
        TxTesterSorters.sortParameters(parameters);
        TxTesterScrubbers.scrubParams(parameters);
        actualResponse = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)parameters);
        TxServiceTestHelper.writeDiffToFileSystem(name, expectedResponse, (String)actualResponse);
        diff = new CompareUtilities(modes, externals).checkJsonSrcIsSame(id, expectedResponse, (String)actualResponse);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)actualResponse, (String)fp);
            log.error("Test " + name + "failed: " + diff);
        }
        return diff;
    }

    public static void writeDiffToFileSystem(String testName, String expected, String actual) throws IOException {
        File actualDirectory;
        String rootDirectory = System.getenv("TX_SERVICE_TEST_DIFF_TARGET");
        if (rootDirectory == null || rootDirectory.isEmpty()) {
            return;
        }
        String fullExpected = rootDirectory + "/expected/";
        String fullActual = rootDirectory + "/actual/";
        File expectedDirectory = ManagedFileAccess.file((String)fullExpected);
        if (!expectedDirectory.exists()) {
            expectedDirectory.mkdirs();
        }
        if (!(actualDirectory = ManagedFileAccess.file((String)fullActual)).exists()) {
            actualDirectory.mkdirs();
        }
        FileUtilities.stringToFile((String)expected, (String)(fullExpected + testName + ".json"));
        FileUtilities.stringToFile((String)actual, (String)(fullActual + testName + ".json"));
    }
}

