/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;

public class CPTChecker
extends CodeSystemChecker {
    public CPTChecker(IWorkerContext context, @Nonnull ValidatorSettings settings, XVerExtensionManager xverManager, List<ValidationMessage> errors, ValidatorSession session) {
        super(context, settings, xverManager, errors, session);
    }

    @Override
    public void listPropertyNames(List<String> knownNames) {
        super.listPropertyNames(knownNames);
        this.addName(knownNames, "modifier");
        this.addName(knownNames, "kind");
        this.addName(knownNames, "modified");
        this.addName(knownNames, "code");
        this.addName(knownNames, "telemedicine");
        this.addName(knownNames, "orthopox");
    }

    @Override
    public ValueSetValidator.PropertyValidationRules rulesForFilter(String property, EnumSet<ValueSetValidator.PropertyOperation> ops) {
        switch (property) {
            case "modifier": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
            }
            case "kind": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.None, ops);
            }
            case "modified": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
            }
            case "code": {
                return null;
            }
            case "telemedicine": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
            }
            case "orthopox": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
            }
        }
        return null;
    }
}

