/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;

public class JavaTypeGenerator
extends JavaBaseGenerator {
    public JavaTypeGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void generate() throws Exception {
        String template = this.config.getAdornments().get("ResourceType");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{types-enum}}", this.genEnums());
        template = template.replace("{{types-getPath}}", this.genTypePaths());
        template = template.replace("{{types-fromCode}}", this.genFromCode());
        this.write(template);
        this.flush();
        this.close();
    }

    private String genEnums() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            String tn = sd.getType();
            if (first) {
                first = false;
            } else {
                b.append(",\r\n    ");
            }
            b.append(tn);
        }
        return b.toString();
    }

    private String genTypePaths() {
        StringBuilder b = new StringBuilder();
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            b.append("    case " + sd.getType() + ":\r\n");
            b.append("      return \"" + sd.getType().toLowerCase() + "\";\r\n");
        }
        return b.toString();
    }

    private String genFromCode() {
        StringBuilder b = new StringBuilder();
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            b.append("    if (\"" + sd.getType() + "\".equals(code))\r\n");
            b.append("      return " + sd.getType() + ";\r\n");
        }
        return b.toString();
    }
}

