/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.validation.service.model.FileInfo;
import org.hl7.fhir.validation.service.model.ValidationContext;

public class ValidationRequest {
    @JsonProperty(value="validationContext")
    @JsonAlias(value={"cliContext"})
    @SerializedName(value="validationContext", alternate={"cliContext"})
    private ValidationContext validationContext;
    @JsonProperty(value="filesToValidate")
    @SerializedName(value="filesToValidate")
    private List<FileInfo> filesToValidate = new ArrayList<FileInfo>();
    @JsonProperty(value="sessionId")
    @SerializedName(value="sessionId")
    public String sessionId;

    @JsonProperty(value="validationContext")
    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public ValidationRequest() {
    }

    public ValidationRequest(ValidationContext validationContext, List<FileInfo> filesToValidate) {
        this(validationContext, filesToValidate, null);
    }

    public ValidationRequest(ValidationContext validationContext, List<FileInfo> filesToValidate, String sessionToken) {
        this.validationContext = validationContext;
        this.filesToValidate = filesToValidate;
        this.sessionId = sessionToken;
    }

    @JsonProperty(value="validationContext")
    public ValidationRequest setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
        return this;
    }

    @Deprecated
    @JsonProperty(value="cliContext")
    @SerializedName(value="cliContext")
    public ValidationRequest setCliContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
        return this;
    }

    @SerializedName(value="filesToValidate")
    @JsonProperty(value="filesToValidate")
    public List<FileInfo> getFilesToValidate() {
        return this.filesToValidate;
    }

    @SerializedName(value="filesToValidate")
    @JsonProperty(value="filesToValidate")
    public ValidationRequest setFilesToValidate(List<FileInfo> filesToValidate) {
        this.filesToValidate = filesToValidate;
        return this;
    }

    @SerializedName(value="sessionId")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @SerializedName(value="sessionId")
    @JsonProperty(value="sessionId")
    public ValidationRequest setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String listSourceFiles() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileInfo fp : this.filesToValidate) {
            fileNames.add(fp.getFileName());
        }
        return String.join((CharSequence)", ", fileNames);
    }
}

