/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;

public class LoincChecker
extends CodeSystemChecker {
    public LoincChecker(IWorkerContext context, @Nonnull ValidatorSettings settings, XVerExtensionManager xverManager, List<ValidationMessage> errors, ValidatorSession session) {
        super(context, settings, xverManager, errors, session);
    }

    @Override
    public void listPropertyNames(List<String> knownNames) {
        super.listPropertyNames(knownNames);
        this.addName(knownNames, "concept");
        this.addName(knownNames, "ancestor");
        this.addName(knownNames, "descendent");
        this.addName(knownNames, "parent");
        this.addName(knownNames, "child");
        this.addName(knownNames, "COMPONENT");
        this.addName(knownNames, "PROPERTY");
        this.addName(knownNames, "TIME_ASPCT");
        this.addName(knownNames, "SYSTEM");
        this.addName(knownNames, "SCALE_TYP");
        this.addName(knownNames, "METHOD_TYP");
        this.addName(knownNames, "CLASS");
        this.addName(knownNames, "VersionLastChanged");
        this.addName(knownNames, "CHNG_TYPE");
        this.addName(knownNames, "DefinitionDescription");
        this.addName(knownNames, "STATUS");
        this.addName(knownNames, "CLASSTYPE");
        this.addName(knownNames, "FORMULA");
        this.addName(knownNames, "EXMPL_ANSWERS");
        this.addName(knownNames, "SURVEY_QUEST_TEXT");
        this.addName(knownNames, "SURVEY_QUEST_SRC");
        this.addName(knownNames, "UNITSREQUIRED");
        this.addName(knownNames, "ORDER_OBS");
        this.addName(knownNames, "HL7_FIELD_SUBFIELD_ID");
        this.addName(knownNames, "EXTERNAL_COPYRIGHT_NOTICE");
        this.addName(knownNames, "EXAMPLE_UNITS");
        this.addName(knownNames, "EXAMPLE_UCUM_UNITS");
        this.addName(knownNames, "STATUS_REASON");
        this.addName(knownNames, "STATUS_TEXT");
        this.addName(knownNames, "CHANGE_REASON_PUBLIC");
        this.addName(knownNames, "COMMON_TEST_RANK");
        this.addName(knownNames, "COMMON_ORDER_RANK");
        this.addName(knownNames, "HL7_ATTACHMENT_STRUCTURE");
        this.addName(knownNames, "EXTERNAL_COPYRIGHT_LINK");
        this.addName(knownNames, "PanelType");
        this.addName(knownNames, "AskAtOrderEntry");
        this.addName(knownNames, "AssociatedObservations");
        this.addName(knownNames, "VersionFirstReleased");
        this.addName(knownNames, "ValidHL7AttachmentRequest");
        this.addName(knownNames, "answer-list");
        this.addName(knownNames, "MAP_TO");
        this.addName(knownNames, "analyte");
        this.addName(knownNames, "analyte-core");
        this.addName(knownNames, "analyte-suffix");
        this.addName(knownNames, "analyte-numerator");
        this.addName(knownNames, "analyte-divisor");
        this.addName(knownNames, "analyte-divisor-suffix");
        this.addName(knownNames, "challenge");
        this.addName(knownNames, "adjustment");
        this.addName(knownNames, "count");
        this.addName(knownNames, "time-core");
        this.addName(knownNames, "time-modifier");
        this.addName(knownNames, "system-core");
        this.addName(knownNames, "super-system");
        this.addName(knownNames, "analyte-gene");
        this.addName(knownNames, "category");
        this.addName(knownNames, "search");
        this.addName(knownNames, "rad-modality-modality-type");
        this.addName(knownNames, "rad-modality-modality-subtype");
        this.addName(knownNames, "rad-anatomic-location-region-imaged");
        this.addName(knownNames, "rad-anatomic-location-imaging-focus");
        this.addName(knownNames, "rad-anatomic-location-laterality-presence");
        this.addName(knownNames, "rad-anatomic-location-laterality");
        this.addName(knownNames, "rad-view-aggregation");
        this.addName(knownNames, "rad-view-view-type");
        this.addName(knownNames, "rad-maneuver-maneuver-type");
        this.addName(knownNames, "rad-timing");
        this.addName(knownNames, "rad-pharmaceutical-substance-given");
        this.addName(knownNames, "rad-pharmaceutical-route");
        this.addName(knownNames, "rad-reason-for-exam");
        this.addName(knownNames, "rad-guidance-for-presence");
        this.addName(knownNames, "rad-guidance-for-approach");
        this.addName(knownNames, "rad-guidance-for-action");
        this.addName(knownNames, "rad-guidance-for-object");
        this.addName(knownNames, "rad-subject");
        this.addName(knownNames, "document-kind");
        this.addName(knownNames, "document-role");
        this.addName(knownNames, "document-setting");
        this.addName(knownNames, "document-subject-matter-domain");
        this.addName(knownNames, "document-type-of-service");
        this.addName(knownNames, "answers-for");
        this.addName(knownNames, "answer");
        this.addName(knownNames, "answer-list");
    }

    @Override
    public ValueSetValidator.PropertyValidationRules rulesForFilter(String property, EnumSet<ValueSetValidator.PropertyOperation> ops) {
        if (Utilities.existsInList((String)property, (String[])new String[]{"ancestor", "descendent", "parent", "child", "COMPONENT", "PROPERTY", "TIME_ASPCT", "SYSTEM", "SCALE_TYP", "METHOD_TYP", "CLASS", "answer-list", "MAP_TO", "analyte", "analyte-core", "analyte-suffix", "analyte-numerator", "analyte-divisor", "analyte-divisor-suffix", "challenge", "adjustment", "count", "time-core", "time-modifier", "system-core", "super-system", "analyte-gene", "category", "search", "rad-modality-modality-type", "rad-modality-modality-subtype", "rad-anatomic-location-region-imaged", "rad-anatomic-location-imaging-focus", "rad-anatomic-location-laterality-presence", "rad-anatomic-location-laterality", "rad-view-aggregation", "rad-view-view-type", "rad-maneuver-maneuver-type", "rad-timing", "rad-pharmaceutical-substance-given", "rad-pharmaceutical-route", "rad-reason-for-exam", "rad-guidance-for-presence", "rad-guidance-for-approach", "rad-guidance-for-action", "rad-guidance-for-object", "rad-subject", "document-kind", "document-role", "document-setting", "document-subject-matter-domain", "document-type-of-service", "answers-for", "answer", "answer-list"})) {
            return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.Exists, ValueSetValidator.PropertyOperation.RegEx, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.NotIn)).setChange(true);
        }
        if (Utilities.existsInList((String)property, (String[])new String[]{"VersionLastChanged", "CHNG_TYPE", "DefinitionDescription", "STATUS", "CLASSTYPE", "FORMULA", "EXMPL_ANSWERS", "SURVEY_QUEST_TEXT", "SURVEY_QUEST_SRC", "UNITSREQUIRED", "ORDER_OBS", "HL7_FIELD_SUBFIELD_ID", "EXTERNAL_COPYRIGHT_NOTICE", "EXAMPLE_UNITS", "EXAMPLE_UCUM_UNITS", "STATUS_REASON", "STATUS_TEXT", "CHANGE_REASON_PUBLIC", "COMMON_TEST_RANK", "COMMON_ORDER_RANK", "HL7_ATTACHMENT_STRUCTURE", "EXTERNAL_COPYRIGHT_LINK", "PanelType", "AskAtOrderEntry", "AssociatedObservations", "VersionFirstReleased", "ValidHL7AttachmentRequest"})) {
            return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.String, ValueSetValidator.CodeValidationRule.None, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.Exists, ValueSetValidator.PropertyOperation.RegEx, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.NotIn));
        }
        if (Utilities.existsInList((String)property, (String[])new String[]{"STATUS"})) {
            return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.CodeList, ValueSetValidator.CodeValidationRule.None, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.RegEx, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.NotIn)).setCodes("ACTIVE", "TRIAL", "DISCOURAGED", "DEPRECATED");
        }
        if (Utilities.existsInList((String)property, (String[])new String[]{"copyright"})) {
            return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.CodeList, ValueSetValidator.CodeValidationRule.None, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.RegEx, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.NotIn)).setCodes("LOINC", "3rdParty");
        }
        if (Utilities.existsInList((String)property, (String[])new String[]{"concept"})) {
            return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.None, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.IsNotA));
        }
        if (Utilities.existsInList((String)property, (String[])new String[]{"code"})) {
            return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.None, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.IsNotA));
        }
        return null;
    }
}

