/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.validation.ai.AIAPI;
import org.hl7.fhir.validation.ai.CodeAndTextValidationRequest;
import org.hl7.fhir.validation.ai.CodeAndTextValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGPTAPI
extends AIAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatGPTAPI.class);
    private static final String API_URL = "https://api.openai.com/v1/chat/completions";
    private static final String MODEL = "gpt-4o-mini";
    private String model;

    protected ChatGPTAPI(JsonObject config) {
        super(config);
        this.model = config.has("model") ? config.asString("model") : MODEL;
    }

    @Override
    public List<CodeAndTextValidationResult> validateCodings(List<CodeAndTextValidationRequest> requests) throws IOException {
        ArrayList<List<CodeAndTextValidationRequest>> chunks = new ArrayList<List<CodeAndTextValidationRequest>>();
        for (int i = 0; i < requests.size(); i += 4) {
            chunks.add(requests.subList(i, Math.min(i + 4, requests.size())));
        }
        ArrayList<CodeAndTextValidationResult> results = new ArrayList<CodeAndTextValidationResult>();
        int c = 0;
        for (List list : chunks) {
            StringBuilder prompt = new StringBuilder();
            for (String s : this.config.forceArray("prompt").asStrings()) {
                prompt.append(s);
                prompt.append("\n");
            }
            for (int i = 0; i < list.size(); ++i) {
                CodeAndTextValidationRequest req = (CodeAndTextValidationRequest)list.get(i);
                prompt.append(String.format(this.config.asString("item"), Integer.toString(i + 1), req.getText(), this.getSystemName(req.getSystem()), req.getCode(), req.getDisplay(), req.getContext(), req.getLang()));
            }
            StringBuilder systemPrompt = new StringBuilder();
            for (String s : this.config.forceArray("prompt").asStrings()) {
                systemPrompt.append(s);
                systemPrompt.append("\n");
            }
            System.out.print(".");
            log.debug("  processed request");
            JsonArray json = this.getResponse(prompt.toString(), systemPrompt.toString());
            this.parseValidationResponse(json, list, results);
            c += 4;
        }
        return results;
    }

    public JsonArray getResponse(String prompt, String systemPrompt) throws IOException {
        JsonObject json = new JsonObject();
        json.add("model", this.model);
        json.forceArray("messages").addObject().add("role", "system").add("content", systemPrompt);
        json.forceArray("messages").addObject().add("role", "user").add("content", prompt);
        HTTPResult response = ManagedWebAccess.post((Iterable)Utilities.strings((String[])new String[]{"web"}), (String)API_URL, (byte[])JsonParser.composeBytes((JsonElement)json), (String)"application/json", (String)"application/json");
        response.checkThrowException();
        json = JsonParser.parseObject((String)response.getContentAsString());
        String text = json.getJsonArray("choices").get(0).asJsonObject().getJsonObject("message").asString("content");
        text = text.replace("```", "").substring(4);
        FileUtilities.stringToFile((String)text, (String)Utilities.path((String[])new String[]{"[tmp]", "fhir-validator-chatgpt-response.json"}));
        return (JsonArray)JsonParser.parse((String)text);
    }

    private void parseValidationResponse(JsonArray json, List<CodeAndTextValidationRequest> requests, List<CodeAndTextValidationResult> res) {
        for (JsonObject o : json.asJsonObjects()) {
            CodeAndTextValidationRequest request = requests.get(o.asInteger("index") - 1);
            res.add(new CodeAndTextValidationResult(request, o.asBoolean("isCompatible"), o.asString("explanation"), o.asString("confidence")));
        }
    }
}

