/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.UrlUtil;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class XhtmlValidator
extends BaseValidator {
    private static final HashSet<String> HTML_ELEMENTS = new HashSet<String>(Arrays.asList("p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"));
    private static final HashSet<String> HTML_ATTRIBUTES = new HashSet<String>(Arrays.asList("title", "style", "class", "id", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan"));
    private static final HashSet<String> HTML_COMBO_LIST = new HashSet<String>(Arrays.asList("a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap"));
    private static final HashSet<String> HTML_BLOCK_LIST = new HashSet<String>(Arrays.asList("div", "blockquote", "table", "ol", "ul", "p"));
    private List<ValidationMessage> errors;
    private NodeStack stack;

    public XhtmlValidator(BaseValidator parent, List<ValidationMessage> errors, NodeStack stack) {
        super(parent);
        this.errors = errors;
        this.stack = stack;
    }

    public boolean validate(ValidationContext valContext, Element e, Element resource, String path, XhtmlNode xhtml) {
        boolean ok = true;
        String ns = xhtml.getNsDecl();
        ok = this.rule(this.errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml") && ok;
        ok = this.checkInnerNS(this.errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes()) && ok;
        ok = this.rule(this.errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "div".equals(xhtml.getName()), "XHTML_XHTML_Name_Invalid", xhtml.getName()) && ok;
        ok = this.checkInnerNames(this.errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes(), false) && ok;
        ok = this.checkUrls(this.errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes()) && ok;
        ok = this.checkXhtmlStructure(e.getName(), xhtml) && ok;
        this.checkMixedLangs(this.errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes());
        this.checkForDuplicateIds(this.errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes());
        return ok;
    }

    private boolean checkXhtmlStructure(String path, XhtmlNode x) {
        boolean ok = true;
        for (XhtmlNode c : x.getChildNodes()) {
            switch (c.getNodeType()) {
                case Document: {
                    ok = this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, false, "XHTML_XHTML_BAD_ELEMENT_TYPE", c.getNodeType().toCode(), path) && ok;
                }
                case DocType: 
                case Instruction: {
                    if (x.getNodeType() == NodeType.Document) break;
                    ok = this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, false, "XHTML_XHTML_BAD_ELEMENT_TYPE", c.getNodeType().toCode(), path) && ok;
                    break;
                }
                case Comment: {
                    break;
                }
                case Element: {
                    String cpath = path + "/" + c.getName();
                    switch (c.getName()) {
                        case "p": 
                        case "h1": 
                        case "h2": 
                        case "h3": 
                        case "h4": 
                        case "h5": 
                        case "h6": 
                        case "pre": 
                        case "address": {
                            ok = this.pRules(cpath, c) && ok;
                            break;
                        }
                        case "br": 
                        case "img": 
                        case "hr": {
                            ok = this.noChildren(cpath, c) && ok;
                            break;
                        }
                        case "a": 
                        case "b": 
                        case "em": 
                        case "i": 
                        case "strong": 
                        case "small": 
                        case "big": 
                        case "sub": 
                        case "sup": 
                        case "code": 
                        case "tt": 
                        case "dfn": 
                        case "q": 
                        case "var": 
                        case "abbr": 
                        case "acronym": 
                        case "cite": 
                        case "bdo": 
                        case "kbd": 
                        case "samp": {
                            ok = this.pRules(cpath, c) && ok;
                            ok = this.noRecursion(cpath, c, new String[0]) && ok;
                            break;
                        }
                        case "span": {
                            ok = this.pRules(cpath, c) && ok;
                            break;
                        }
                        case "div": 
                        case "blockquote": {
                            break;
                        }
                        case "table": {
                            ok = this.onlyChildren(cpath, c, "tbody", "tr", "caption", "thead", "tfoot", "col", "colgroup") && ok;
                            break;
                        }
                        case "tr": {
                            ok = this.parent(cpath, c, x, "table", "thead", "tfoot", "tbody") && ok;
                            ok = this.onlyChildren(cpath, c, "td", "th") && ok;
                            break;
                        }
                        case "tbody": 
                        case "thead": 
                        case "tfoot": {
                            ok = this.parent(cpath, c, x, "table") && ok;
                            ok = this.onlyChildren(cpath, c, "tr") && ok;
                            break;
                        }
                        case "ul": 
                        case "ol": {
                            ok = this.onlyChildren(cpath, c, "li") && ok;
                            break;
                        }
                        case "caption": {
                            ok = this.pRules(cpath, c);
                            ok = this.parent(cpath, c, x, "table") && ok;
                            break;
                        }
                        case "colgroup": 
                        case "col": {
                            ok = this.parent(cpath, c, x, "table") && ok;
                            break;
                        }
                        case "th": 
                        case "td": {
                            ok = this.parent(cpath, c, x, "tr", "thead", "tfoot") && ok;
                            break;
                        }
                        case "li": {
                            ok = this.parent(cpath, c, x, "ul", "ol") && ok;
                            break;
                        }
                        case "dl": {
                            ok = this.onlyChildren(cpath, c, "dd", "dt") && ok;
                            break;
                        }
                        case "dd": 
                        case "dt": {
                            ok = this.pRules(cpath, c) && ok;
                            ok = this.parent(cpath, c, x, "dl") && ok;
                            break;
                        }
                        case "map": {
                            ok = this.onlyChildren(cpath, c, "area") && ok;
                            break;
                        }
                        case "area": {
                            ok = this.noChildren(cpath, c) && ok;
                            break;
                        }
                    }
                    if (!c.hasChildren()) break;
                    ok = this.checkXhtmlStructure(cpath, c) && ok;
                    break;
                }
            }
        }
        return ok;
    }

    private boolean pRules(String path, XhtmlNode x) {
        ArrayList<String> list = new ArrayList<String>();
        this.findDescendents(list, x.getName(), x, new HashSet<String>(Arrays.asList("div", "pre", "table", "ul", "ol")));
        return this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, list.isEmpty(), "XHTML_XHTML_BLOCK_IN_PARA", x.getName(), path, CommaSeparatedStringBuilder.join((String)",", list));
    }

    private boolean noRecursion(String path, XhtmlNode x, String ... names) {
        ArrayList<String> list = new ArrayList<String>();
        this.findDescendents(list, x.getName(), x, new HashSet<String>(Arrays.asList(x.getName())));
        return this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, list.isEmpty(), "XHTML_XHTML_NO_RECURSION", x.getName(), path, CommaSeparatedStringBuilder.join((String)",", list));
    }

    private boolean noChildren(String path, XhtmlNode x) {
        return this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, !x.hasChildren(), "XHTML_XHTML_NO_CHILDREN", x.getName(), path);
    }

    private boolean parent(String path, XhtmlNode x, XhtmlNode parent, String ... names) {
        return this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, Utilities.existsInList((String)parent.getName(), (String[])names), "XHTML_XHTML_OUT_OF_PLACE", x.getName(), CommaSeparatedStringBuilder.join((String)"|", (String[])names), parent.getName(), path);
    }

    private boolean onlyChildren(String path, XhtmlNode x, String ... names) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(names));
        ArrayList<String> list = new ArrayList<String>();
        for (XhtmlNode c : x.getChildNodes()) {
            if (c.getNodeType() == NodeType.Text && c.hasContent()) {
                list.add("@text");
                continue;
            }
            if (c.getNodeType() != NodeType.Element || set.contains(c.getName())) continue;
            list.add(c.getName());
        }
        return this.rule(this.errors, "2025-06-16", ValidationMessage.IssueType.STRUCTURE, this.stack, list.isEmpty(), "XHTML_XHTML_ILLEGAL_CHILDREN", x.getName(), path, CommaSeparatedStringBuilder.join((String)",", list));
    }

    private void findDescendents(List<String> list, String path, XhtmlNode x, Set<String> names) {
        for (XhtmlNode c : x.getChildNodes()) {
            if (c.getNodeType() != NodeType.Element) continue;
            String cpath = path + "/" + c.getName();
            if (names.contains(c.getName())) {
                list.add(cpath);
            }
            if (!c.hasChildren()) continue;
            this.findDescendents(list, cpath, c, names);
        }
    }

    private boolean checkInnerNS(List<ValidationMessage> errors, Element e, String path, List<XhtmlNode> list) {
        boolean ok = true;
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            String ns = node.getNsDecl();
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ns == null || "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml") && ok;
            this.checkInnerNS(errors, e, path, (List<XhtmlNode>)node.getChildNodes());
        }
        return ok;
    }

    private void checkForDuplicateIds(List<ValidationMessage> errors, Element e, String path, List<XhtmlNode> list) {
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Integer> duplicates = new HashMap<String, Integer>();
        this.scanXhtmlIds(list, ids, duplicates);
        if (!duplicates.isEmpty()) {
            ArrayList<CallSite> summary = new ArrayList<CallSite>();
            for (String k : Utilities.sorted(duplicates.keySet())) {
                summary.add((CallSite)((Object)(k + " (" + String.valueOf(duplicates.get(k)) + "x)")));
            }
            this.warning(errors, "2025-06-12", ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), path, false, "XHTML_XHTML_DUPLICATE_IDS", CommaSeparatedStringBuilder.join((String)", ", summary));
        }
    }

    private void scanXhtmlIds(List<XhtmlNode> list, Set<String> ids, Map<String, Integer> duplicates) {
        for (XhtmlNode node : list) {
            String name;
            String id = null;
            if (node.hasAttribute("id")) {
                id = node.getAttribute("id");
                if (!ids.contains(id)) {
                    ids.add(id);
                } else {
                    duplicates.put(id, duplicates.getOrDefault(id, 1) + 1);
                }
            }
            if ("a".equals(node.getName()) && node.hasAttribute("name") && !(name = node.getAttribute("name")).equals(id)) {
                if (!ids.contains(name)) {
                    ids.add(name);
                } else {
                    duplicates.put(name, duplicates.getOrDefault(name, 1) + 1);
                }
            }
            if (!node.hasChildren()) continue;
            this.scanXhtmlIds((List<XhtmlNode>)node.getChildNodes(), ids, duplicates);
        }
    }

    private void checkMixedLangs(List<ValidationMessage> errors, Element e, String path, List<XhtmlNode> list) {
        HashSet<String> langs = new HashSet<String>();
        boolean nonLangContent = false;
        for (XhtmlNode node : list) {
            if (node.getNodeType() == NodeType.Element && "div".equals(node.getName()) && XhtmlValidator.isLangDiv(node)) {
                langs.add(node.getAttribute("xml:lang"));
                continue;
            }
            if (!node.hasContent()) continue;
            nonLangContent = true;
        }
        this.warning(errors, "2025-06-07", ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), path, langs.isEmpty() || !nonLangContent, "XHTML_XHTML_MIXED_LANG", CommaSeparatedStringBuilder.join((String)", ", langs));
    }

    public static boolean isLangDiv(XhtmlNode node) {
        return node.hasAttribute("xml:lang");
    }

    private boolean checkInnerNames(List<ValidationMessage> errors, Element e, String path, List<XhtmlNode> list, boolean inPara) {
        boolean ok = true;
        for (XhtmlNode node : list) {
            if (node.getNodeType() == NodeType.Comment) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !node.getContent().startsWith("DOCTYPE"), "XHTML_XHTML_DOCTYPE_ILLEGAL", new Object[0]) && ok;
            }
            if (node.getNodeType() != NodeType.Element) continue;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, HTML_ELEMENTS.contains(node.getName()), "XHTML_XHTML_Element_Illegal", node.getName()) && ok;
            for (String an : node.getAttributes().keySet()) {
                boolean bok = an.startsWith("xmlns") || HTML_ATTRIBUTES.contains(an) || HTML_COMBO_LIST.contains(node.getName() + "." + an);
                if (bok) continue;
                if ("xml:space".equals(an)) {
                    this.hint(errors, "2024-08-03", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "XHTML_XHTML_ATTRIBUTE_XML_SPACE", an, node.getName());
                    continue;
                }
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "XHTML_XHTML_Attribute_Illegal", an, node.getName()) && ok;
            }
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !inPara || !HTML_BLOCK_LIST.contains(node.getName()), "XHTML_XHTML_ELEMENT_ILLEGAL_IN_PARA", node.getName()) && ok;
            ok = this.checkInnerNames(errors, e, path, (List<XhtmlNode>)node.getChildNodes(), inPara || "p".equals(node.getName())) && ok;
        }
        return ok;
    }

    private boolean checkUrls(List<ValidationMessage> errors, Element e, String path, List<XhtmlNode> list) {
        boolean ok = true;
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            if ("a".equals(node.getName())) {
                msg = UrlUtil.checkValidUrl(node.getAttribute("href"), this.context);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("href"), msg) && ok;
            } else if ("img".equals(node.getName())) {
                msg = UrlUtil.checkValidUrl(node.getAttribute("src"), this.context);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("src"), msg) && ok;
            }
            ok = this.checkUrls(errors, e, path, (List<XhtmlNode>)node.getChildNodes()) && ok;
        }
        return ok;
    }
}

