/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public abstract class CodeSystemChecker
extends BaseValidator {
    private boolean noDisplay = false;
    private boolean hasDisplay = false;
    protected List<ValidationMessage> errors;

    protected CodeSystemChecker(IWorkerContext context, @Nonnull ValidatorSettings settings, XVerExtensionManager xverManager, List<ValidationMessage> errors, ValidatorSession session) {
        super(context, settings, xverManager, session);
        this.errors = errors;
    }

    public void checkConcept(String code, String display) {
        if (Utilities.noString((String)display)) {
            this.noDisplay = true;
        } else {
            this.hasDisplay = true;
        }
    }

    public void finish(Element inc, NodeStack stack) {
        this.hint(this.errors, "2023-07-21", ValidationMessage.IssueType.BUSINESSRULE, inc.line(), inc.col(), stack.getLiteralPath(), !this.noDisplay || !this.hasDisplay, "VALUESET_CONCEPT_DISPLAY_PRESENCE_MIXED");
    }

    public void listPropertyNames(List<String> knownNames) {
        knownNames.add("concept");
        knownNames.add("code");
        knownNames.add("status");
        knownNames.add("inactive");
        knownNames.add("effectiveDate");
        knownNames.add("deprecationDate");
        knownNames.add("retirementDate");
        knownNames.add("notSelectable");
        knownNames.add("synonym");
        knownNames.add("comment");
        knownNames.add("itemWeight");
    }

    protected void addName(List<String> knownNames, String code) {
        if (code != null && !knownNames.contains(code)) {
            knownNames.add(code);
        }
    }

    protected EnumSet<ValueSetValidator.PropertyOperation> addToOps(EnumSet<ValueSetValidator.PropertyOperation> set, ValueSetValidator.PropertyOperation ... ops) {
        for (ValueSetValidator.PropertyOperation op : ops) {
            set.add(op);
        }
        return set;
    }

    public ValueSetValidator.PropertyValidationRules rulesForFilter(String property, EnumSet<ValueSetValidator.PropertyOperation> ops) {
        switch (property) {
            case "concept": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, VersionUtilities.isR5Plus((String)this.context.getVersion()) ? this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.DescendentOf, ValueSetValidator.PropertyOperation.DescendentLeaf, ValueSetValidator.PropertyOperation.IsNotA, ValueSetValidator.PropertyOperation.Generalizes, ValueSetValidator.PropertyOperation.ChildOf, ValueSetValidator.PropertyOperation.NotIn) : this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.DescendentOf, ValueSetValidator.PropertyOperation.IsNotA, ValueSetValidator.PropertyOperation.Generalizes, ValueSetValidator.PropertyOperation.NotIn));
            }
            case "code": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, VersionUtilities.isR5Plus((String)this.context.getVersion()) ? this.addToOps(ops, ValueSetValidator.PropertyOperation.RegEx, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.DescendentOf, ValueSetValidator.PropertyOperation.DescendentLeaf, ValueSetValidator.PropertyOperation.IsNotA, ValueSetValidator.PropertyOperation.Generalizes, ValueSetValidator.PropertyOperation.ChildOf, ValueSetValidator.PropertyOperation.NotIn) : this.addToOps(ops, ValueSetValidator.PropertyOperation.RegEx, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.DescendentOf, ValueSetValidator.PropertyOperation.IsNotA, ValueSetValidator.PropertyOperation.Generalizes, ValueSetValidator.PropertyOperation.NotIn));
            }
            case "status": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.None, ops);
            }
            case "inactive": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
            }
            case "effectiveDate": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.DateTime, null, ops);
            }
            case "deprecationDate": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.DateTime, null, ops);
            }
            case "retirementDate": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.DateTime, null, ops);
            }
            case "notSelectable": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
            }
            case "parent": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, ops);
            }
            case "child": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, ops);
            }
            case "partOf": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, ops);
            }
            case "synonym": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.None, ops);
            }
            case "comment": {
                return null;
            }
            case "itemWeight": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Decimal, null, ops);
            }
        }
        return null;
    }

    public String checkFilterValue(String system, String version, String property, String op, String value, ValueSetValidator.PropertyValidationRules rules) {
        return null;
    }

    public StringWithFlag checkFilterValue(String system, String version, String property, String op, String value, ValueSetValidator.PropertyValidationRules rules, ValidationOptions options) {
        return null;
    }

    public class StringWithFlag {
        private String msg;
        private boolean fail;

        public StringWithFlag(String msg, boolean fail) {
            this.msg = msg;
            this.fail = fail;
        }

        public String getMsg() {
            return this.msg;
        }

        public boolean isFail() {
            return this.fail;
        }
    }
}

