/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64InputStream;
import org.hl7.fhir.utilities.Utilities;

public class Base64Util {
    public static boolean isValidBase64(String theEncoded) {
        if (theEncoded == null) {
            return false;
        }
        int charCount = 0;
        boolean ok = true;
        for (int i = 0; i < theEncoded.length(); ++i) {
            char nextChar = theEncoded.charAt(i);
            if (Utilities.isWhitespace((int)nextChar)) continue;
            if (Character.isLetterOrDigit(nextChar)) {
                ++charCount;
            }
            if (nextChar != '/' && nextChar != '=' && nextChar != '+') continue;
            ++charCount;
        }
        if (charCount > 0 && charCount % 4 != 0) {
            ok = false;
        }
        return ok;
    }

    public static boolean base64HasWhitespace(String theEncoded) {
        if (theEncoded == null) {
            return false;
        }
        for (int i = 0; i < theEncoded.length(); ++i) {
            char nextChar = theEncoded.charAt(i);
            if (!Utilities.isWhitespace((int)nextChar)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countBase64DecodedBytes(String theEncoded) {
        Base64InputStream inputStream = new Base64InputStream((InputStream)new ByteArrayInputStream(theEncoded.getBytes(StandardCharsets.UTF_8)));
        try {
            try {
                int counter = 0;
                while (true) {
                    if (inputStream.read() == -1) {
                        int n = counter;
                        return n;
                    }
                    ++counter;
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

