/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.special.TxTestSetup;

public class TxTestData {
    private final JsonObject manifest;
    private final JsonObject externals;
    private final List<Object[]> testData;
    private final NpmPackage npm;
    private final File folder;
    private final String code;
    private final String version;
    private final String testFileName;

    private TxTestData(List<Object[]> testData, JsonObject manifest, JsonObject externals, NpmPackage npm, String code, String version) throws IOException {
        this.testData = testData;
        this.manifest = manifest;
        this.externals = externals;
        this.npm = npm;
        this.folder = null;
        this.code = code;
        this.version = version;
        this.testFileName = "test-cases.json";
    }

    private TxTestData(List<Object[]> testData, JsonObject manifest, JsonObject externals, File folder, String filename, String code, String version) throws IOException {
        this.testData = testData;
        this.manifest = manifest;
        this.externals = externals;
        this.npm = null;
        this.folder = folder;
        this.code = code;
        this.version = version;
        this.testFileName = filename;
    }

    public static TxTestData loadTestDataFromFolder(File folder, String name) throws IOException {
        String contents = FileUtilities.streamToString((InputStream)TxTestData.loadFile(folder, name));
        String externalSource = ManagedFileAccess.file((String)folder.getAbsolutePath(), (String)"messages-tx.fhir.org.json").exists() ? FileUtilities.streamToString((InputStream)TxTestData.loadFile(folder, "messages-tx.fhir.org.json")) : null;
        JsonObject externals = externalSource == null ? new JsonObject() : JsonParser.parseObject((String)externalSource);
        HashMap<CallSite, TxTestSetup> examples = new HashMap<CallSite, TxTestSetup>();
        JsonObject manifest = JsonParser.parseObject((String)contents);
        for (JsonObject suite : manifest.getJsonObjects("suites")) {
            if ("tx.fhir.org".equals(suite.asString("mode"))) continue;
            String sn = suite.asString("name");
            for (JsonObject test : suite.getJsonObjects("tests")) {
                String tn = test.asString("name");
                examples.put((CallSite)((Object)(sn + "." + tn)), new TxTestSetup(suite, test));
            }
        }
        ArrayList names = new ArrayList(examples.size());
        names.addAll(examples.keySet());
        Collections.sort(names);
        ArrayList<Object[]> testData = new ArrayList<Object[]>(examples.size());
        for (String id : names) {
            testData.add(new Object[]{id, examples.get(id)});
        }
        return new TxTestData(testData, manifest, externals, folder, name, manifest.asString("code"), manifest.asString("version"));
    }

    private static InputStream loadFile(File folder, String filename) throws IOException {
        File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{folder.getAbsolutePath(), filename}));
        return ManagedFileAccess.inStream((File)f);
    }

    public static TxTestData loadTestDataFromPackage(String source) throws IOException {
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        NpmPackage npm = pcm.loadPackage(source);
        String contents = FileUtilities.streamToString((InputStream)npm.load("tests", "test-cases.json"));
        String externalSource = FileUtilities.streamToString((InputStream)npm.load("tests", "messages-tx.fhir.org.json"));
        JsonObject externals = JsonParser.parseObject((String)externalSource);
        HashMap<CallSite, TxTestSetup> examples = new HashMap<CallSite, TxTestSetup>();
        JsonObject manifest = JsonParser.parseObject((String)contents);
        for (JsonObject suite : manifest.getJsonObjects("suites")) {
            if ("tx.fhir.org".equals(suite.asString("mode"))) continue;
            String sn = suite.asString("name");
            for (JsonObject test : suite.getJsonObjects("tests")) {
                String tn = test.asString("name");
                examples.put((CallSite)((Object)(sn + "." + tn)), new TxTestSetup(suite, test));
            }
        }
        ArrayList names = new ArrayList(examples.size());
        names.addAll(examples.keySet());
        Collections.sort(names);
        ArrayList<Object[]> testData = new ArrayList<Object[]>(examples.size());
        for (String id : names) {
            testData.add(new Object[]{id, examples.get(id)});
        }
        return new TxTestData(testData, manifest, externals, npm, manifest.asString("code"), manifest.asString("version"));
    }

    public String load(String fn) throws IOException {
        if (this.folder != null) {
            return FileUtilities.streamToString((InputStream)TxTestData.loadFile(this.folder, fn));
        }
        return FileUtilities.streamToString((InputStream)this.npm.load("tests", fn));
    }

    public byte[] loadBytes(String fn) throws IOException {
        if (this.folder != null) {
            return FileUtilities.streamToBytes((InputStream)TxTestData.loadFile(this.folder, fn));
        }
        return FileUtilities.streamToBytes((InputStream)this.npm.load("tests", fn));
    }

    public boolean hasFile(String filename) throws IOException {
        if (this.folder != null) {
            return ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.folder.getAbsolutePath(), filename})).exists();
        }
        return this.npm.hasFile("tests", filename);
    }

    public String loadVersion() throws JsonException, IOException {
        if (this.version == null) {
            return this.readHistory(this.loadBytes("history.json"));
        }
        return this.version;
    }

    private String readHistory(byte[] content) throws JsonException, IOException {
        JsonObject json = JsonParser.parseObject((byte[])content);
        return ((JsonObject)json.getJsonObjects("versions").get(0)).asString("version");
    }

    public String describe() {
        if (this.folder != null) {
            return this.folder.getAbsolutePath();
        }
        return this.npm.name() + "#" + this.npm.version();
    }

    public String code() {
        return this.code;
    }

    public String testFileName() {
        return this.testFileName;
    }

    public JsonObject getManifest() {
        return this.manifest;
    }

    public JsonObject getExternals() {
        return this.externals;
    }

    public List<Object[]> getTestData() {
        return this.testData;
    }
}

