/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.NPMPackageGenerator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.ZipGenerator;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.IgLoader;

public class PackageReGenerator {
    private List<String> packages = new ArrayList<String>();
    private Parameters expansionParameters = new Parameters();
    private ExpansionPackageGeneratorScope scope = ExpansionPackageGeneratorScope.EVERYTHING;
    private String output;
    private ExpansionPackageGeneratorOutputType outputType;
    private boolean hierarchical;
    private boolean json;
    private IWorkerContext context;
    private ContextUtilities cu;
    private Map<String, TerminologyResourceEntry> entries = new HashMap<String, TerminologyResourceEntry>();
    private Set<String> modeParams;
    private List<CanonicalResource> resources = new ArrayList<CanonicalResource>();

    public static void main(String[] args) throws Exception {
        new PackageReGenerator().addPackage("hl7.fhir.us.davinci-alerts").setJson(true).setOutputType(ExpansionPackageGeneratorOutputType.TGZ).setOutput("/Users/grahamegrieve/temp/vs-output.tgz").generateExpansionPackage();
    }

    public PackageReGenerator addPackage(String packageId) {
        this.packages.add(packageId);
        return this;
    }

    public Parameters getExpansionParameters() {
        return this.expansionParameters;
    }

    public PackageReGenerator setExpansionParameters(Parameters expansionParameters) {
        this.expansionParameters = expansionParameters;
        return this;
    }

    public ExpansionPackageGeneratorScope getScope() {
        return this.scope;
    }

    public PackageReGenerator setScope(ExpansionPackageGeneratorScope scope) {
        this.scope = scope;
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public PackageReGenerator setOutput(String output) {
        this.output = output;
        return this;
    }

    public ExpansionPackageGeneratorOutputType getOutputType() {
        return this.outputType;
    }

    public PackageReGenerator setOutputType(ExpansionPackageGeneratorOutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public PackageReGenerator setHierarchical(boolean hierarchical) {
        this.hierarchical = hierarchical;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public PackageReGenerator setJson(boolean json) {
        this.json = json;
        return this;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public PackageReGenerator setContext(IWorkerContext context) {
        this.context = context;
        return this;
    }

    public void generateExpansionPackage() throws IOException {
        if (this.output == null) {
            throw new Error("No output");
        }
        List<NpmPackage> list = this.load();
        for (NpmPackage npm : list) {
            CapabilityStatement cs;
            if (this.modeParams.contains("api")) {
                System.out.println("Processing CapabilityStatements");
                for (String res : npm.listResources(new String[]{"CapabilityStatement"})) {
                    cs = (CapabilityStatement)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)cs);
                }
                System.out.println("Processing OperationDefinitions");
                for (String res : npm.listResources(new String[]{"OperationDefinition"})) {
                    OperationDefinition op = (OperationDefinition)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)op);
                }
                System.out.println("Processing SearchParameters");
                for (String res : npm.listResources(new String[]{"SearchParameter"})) {
                    SearchParameter sp = (SearchParameter)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)sp);
                }
            }
            if (this.modeParams.contains("tx")) {
                System.out.println("Processing CodeSystems");
                for (String res : npm.listResources(new String[]{"CodeSystem"})) {
                    cs = (CodeSystem)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)cs);
                }
                System.out.println("Processing ValueSets");
                for (String res : npm.listResources(new String[]{"ValueSet"})) {
                    ValueSet vs = (ValueSet)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)vs);
                }
                System.out.println("Processing NamingSystems");
                for (String res : npm.listResources(new String[]{"NamingSystem"})) {
                    NamingSystem ns = (NamingSystem)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)ns);
                }
            }
            if (this.modeParams.contains("cnt")) {
                System.out.println("Processing StructureDefinitions");
                for (String res : npm.listResources(new String[]{"StructureDefinition"})) {
                    cs = (StructureDefinition)new JsonParser().parse(npm.loadResource(res));
                    this.processResource((CanonicalResource)cs);
                }
            }
            System.out.println("Processing Bindings");
            for (String res : npm.listResources(new String[]{"StructureDefinition"})) {
                StructureDefinition sd = (StructureDefinition)new JsonParser().parse(npm.loadResource(res));
                this.processSD(sd, npm.id());
            }
            if (!this.modeParams.contains("expansions")) continue;
            System.out.println("Generating Expansions");
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                try {
                    System.out.print("Generate Expansion for " + n + " ... ");
                    ValueSetExpansionOutcome exp = this.context.expandVS(e.valueSet, true, this.hierarchical);
                    if (exp.isOk()) {
                        e.valueSet.setExpansion(exp.getValueset().getExpansion());
                        System.out.println("OK");
                        continue;
                    }
                    e.valueSet.setExpansion(null);
                    e.error = exp.getError();
                    System.out.println(exp.getError());
                }
                catch (Exception ex) {
                    System.out.println("Error= " + ex.getMessage());
                    e.error = ex.getMessage();
                }
            }
        }
        switch (this.outputType) {
            case FOLDER: {
                this.produceFolder();
                break;
            }
            case TGZ: {
                this.producePackage();
                break;
            }
            case ZIP: {
                this.produceZip();
                break;
            }
        }
        System.out.println("Done");
    }

    private void processResource(CanonicalResource res) {
        this.resources.add(res);
        if (this.modeParams.contains("pin")) {
            this.processBase(res, (Base)res);
        }
    }

    private void processBase(CanonicalResource src, Base b) {
        Resource res;
        CanonicalType ct;
        for (Property p : b.children()) {
            for (Base v : p.getValues()) {
                this.processBase(src, v);
            }
        }
        if (b instanceof CanonicalType && !(ct = (CanonicalType)b).hasVersion() && (res = this.context.fetchResource(Resource.class, (String)ct.getValue(), (Resource)src)) != null && res instanceof CanonicalResource) {
            CanonicalResource cr = (CanonicalResource)res;
            ct.addVersion(cr.getVersion());
        }
    }

    private void produceZip() throws IOException {
        System.out.println("Producing Output in Zip " + this.output);
        ZipGenerator zip = new ZipGenerator(this.output);
        HashSet<String> names = new HashSet<String>();
        names.add("manifest");
        if (this.json) {
            zip.addBytes("manifest.json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters), false);
        } else {
            zip.addBytes("manifest.xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters), false);
        }
        if (this.modeParams.contains("expansions")) {
            StringBuilder b = new StringBuilder();
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                Object name = e.valueSet.getIdBase();
                int i = 0;
                while (names.contains(name)) {
                    name = e.valueSet.getIdBase() + ++i;
                }
                names.add((String)name);
                if (e.error == null) {
                    b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                } else {
                    b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                }
                zip.addBytes((String)name + ".json", this.composeResource((CanonicalResource)e.valueSet), false);
            }
            zip.addBytes("valuesets.csv", b.toString().getBytes(StandardCharsets.UTF_8), false);
        }
        zip.close();
    }

    private void producePackage() throws FHIRException, IOException {
        System.out.println("Producing Output Package in " + this.output);
        JsonObject j = new JsonObject();
        j.add("name", "custom.generated");
        j.add("version", "0.0.1");
        j.add("tools-version", 3);
        j.add("type", "Conformance");
        j.forceArray("fhirVersions").add(this.context.getVersion());
        j.forceObject("dependencies").add(VersionUtilities.packageForVersion((String)this.context.getVersion()), this.context.getVersion());
        NPMPackageGenerator gen = new NPMPackageGenerator(this.output, j, new Date(), true);
        HashSet<String> names = new HashSet<String>();
        names.add("manifest");
        if (this.json) {
            gen.addFile("package", "manifest.json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters));
        } else {
            gen.addFile("package", "manifest.xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters));
        }
        if (this.modeParams.contains("expansions")) {
            StringBuilder b = new StringBuilder();
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                Object name = e.valueSet.getIdBase();
                int i = 0;
                while (names.contains(name)) {
                    name = e.valueSet.getIdBase() + ++i;
                }
                names.add((String)name);
                if (e.error == null) {
                    b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                } else {
                    b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                }
                gen.addFile("package", (String)name + ".json", this.composeResource((CanonicalResource)e.valueSet));
            }
            gen.addFile("other", "valuesets.csv", b.toString().getBytes(StandardCharsets.UTF_8));
        }
        gen.finish();
    }

    private void produceFolder() throws IOException {
        System.out.println("Producing Output in folder " + this.output);
        FileUtilities.createDirectory((String)this.output);
        FileUtilities.clearDirectory((String)this.output, (String[])new String[0]);
        HashSet<Object> names = new HashSet<Object>();
        names.add("manifest");
        if (this.json) {
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, "manifest.json"})), (Resource)this.expansionParameters);
        } else {
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, "manifest.xml"})), (Resource)this.expansionParameters);
        }
        for (CanonicalResource cr : this.resources) {
            FileUtilities.bytesToFile((byte[])this.composeResource(cr), (String)Utilities.path((String[])new String[]{this.output, cr.fhirType() + "-" + cr.getIdBase() + (this.json ? ".json" : ".xml")}));
        }
        if (this.modeParams.contains("expansions")) {
            StringBuilder b = new StringBuilder();
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                String name = "ValueSet-" + e.valueSet.getIdBase() + "-expansion";
                int i = 0;
                while (names.contains(name)) {
                    name = e.valueSet.getIdBase() + ++i;
                }
                names.add(name);
                if (e.error == null) {
                    b.append(name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                } else {
                    b.append(name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                }
                FileUtilities.bytesToFile((byte[])this.composeResource((CanonicalResource)e.valueSet), (String)Utilities.path((String[])new String[]{this.output, name + (this.json ? ".json" : ".xml")}));
            }
            FileUtilities.stringToFile((String)b.toString(), (String)Utilities.path((String[])new String[]{this.output, "expansions.csv"}));
        }
    }

    private byte[] composeResource(CanonicalResource cr) throws IOException {
        if (this.json) {
            return new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)cr);
        }
        return new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)cr);
    }

    private void processSD(StructureDefinition sd, String packageId) {
        StructureDefinition bsd;
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            if (!ed.hasBinding() || !ed.getBinding().hasValueSet()) continue;
            this.processValueSet(ed.getBinding().getValueSet(), packageId + ":" + sd.getVersionedUrl() + "#" + ed.getId());
        }
        if (!(this.scope == ExpansionPackageGeneratorScope.IG_ONLY || sd.getBaseDefinition() == null || (bsd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), (Resource)sd)) == null || bsd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition") && this.scope != ExpansionPackageGeneratorScope.EVERYTHING)) {
            this.processSD(bsd, bsd.getSourcePackage().getVID());
        }
    }

    private void processValueSet(String valueSet, String source) {
        String url = this.cu.pinValueSet(valueSet);
        ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, url);
        if (vs != null) {
            TerminologyResourceEntry e = this.entries.get(vs.getVersionedUrl());
            if (e == null) {
                e = new TerminologyResourceEntry();
                e.sources.add((String)source);
                e.valueSet = vs;
                this.entries.put(vs.getVersionedUrl(), e);
                source = vs.getSourcePackage().getVID() + ":" + vs.getVersionedUrl();
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                    for (CanonicalType v : inc.getValueSet()) {
                        if (!v.hasValue()) continue;
                        this.processValueSet(v.primitiveValue(), (String)source);
                    }
                }
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
                    for (CanonicalType v : inc.getValueSet()) {
                        if (!v.hasValue()) continue;
                        this.processValueSet(v.primitiveValue(), (String)source);
                    }
                }
            } else {
                e.sources.add((String)source);
            }
        } else {
            System.out.println("Unable to resolve value set " + valueSet);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<NpmPackage> load() throws IOException {
        ArrayList<NpmPackage> list = new ArrayList<NpmPackage>();
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        for (String packageId : this.packages) {
            NpmPackage npm = pcm.loadPackage(packageId);
            if (this.context == null) {
                String v = npm.fhirVersion();
                NpmPackage core = pcm.loadPackage(VersionUtilities.packageForVersion((String)v));
                NpmPackage tho = pcm.loadPackage("hl7.terminology");
                System.out.println("Load FHIR from " + core.name() + "#" + core.version());
                SimpleWorkerContext ctxt = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(core);
                TerminologyClientFactory factory = new TerminologyClientFactory(ctxt.getVersion());
                ctxt.connectToTSServer((TerminologyClientManager.ITerminologyClientFactory)factory, "http://tx.fhir.org", ctxt.getUserAgent(), null, true);
                IgLoader loader = new IgLoader(pcm, ctxt, ctxt.getVersion());
                loader.loadPackage(tho, true);
                loader.loadPackage(npm, true);
                this.context = ctxt;
                this.context.setExpansionParameters(this.expansionParameters);
                if (this.scope != ExpansionPackageGeneratorScope.EVERYTHING) {
                    // empty if block
                }
            } else {
                IgLoader loader = new IgLoader(pcm, (SimpleWorkerContext)this.context, this.context.getVersion());
                loader.loadPackage(npm, true);
                if (this.scope == ExpansionPackageGeneratorScope.ALL_IGS) {
                    // empty if block
                }
            }
            list.add(npm);
        }
        if (this.cu == null) {
            this.cu = new ContextUtilities(this.context);
        }
        return list;
    }

    public void setModes(Set<String> modeParams) {
        this.modeParams = modeParams;
    }

    public static enum ExpansionPackageGeneratorScope {
        IG_ONLY,
        ALL_IGS,
        EVERYTHING;

    }

    public static enum ExpansionPackageGeneratorOutputType {
        FOLDER,
        ZIP,
        TGZ;

    }

    public static class TerminologyResourceEntry {
        public ValueSet valueSet;
        public Set<String> sources = new HashSet<String>();
        public String error;
    }
}

