/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.renderers;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.OperationOutcome;

public abstract class ValidationOutputRenderer {
    private String runDate;
    protected boolean crumbTrails;
    protected boolean moreThanOne;
    protected PrintStream dst;
    protected boolean showMessageIds;

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public void setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
    }

    public boolean isShowMessageIds() {
        return this.showMessageIds;
    }

    public void setShowMessageIds(boolean showMessageIds) {
        this.showMessageIds = showMessageIds;
    }

    public String getRunDate() {
        return this.runDate;
    }

    public void setRunDate(String runDate) {
        this.runDate = runDate;
    }

    public void start(boolean moreThanOne) {
        this.moreThanOne = moreThanOne;
    }

    public abstract void render(OperationOutcome var1) throws IOException;

    public void render(Bundle bundle) throws IOException {
        throw new Error("Should not call render*Bundle) when handlesBundleDirectly() == false");
    }

    public void finish() {
    }

    public void setOutput(PrintStream dst) {
        this.dst = dst;
    }

    public boolean handlesBundleDirectly() {
        return false;
    }

    public abstract boolean isSingleFile();

    public abstract String getStyleCode();

    public abstract void setFolder(File var1);

    protected String renderMessageId(OperationOutcome.OperationOutcomeIssueComponent issue) {
        return this.showMessageIds ? " {" + issue.getExtensionString("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id") + "}" : "";
    }
}

