/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.testexecutor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.validation.testexecutor.TestExecutor;

public class TxCacheResourceExtractor {
    public static void extractTxCacheResources(String targetDirectory) throws IOException {
        ZipEntry e;
        Path targetPath = Paths.get(targetDirectory, new String[0]);
        URL jar = TestExecutor.class.getProtectionDomain().getCodeSource().getLocation();
        ZipInputStream zip = new ZipInputStream(jar.openStream());
        while ((e = zip.getNextEntry()) != null) {
            TxCacheResourceExtractor.processZipEntry(zip, targetPath, e);
        }
    }

    private static void processZipEntry(ZipInputStream zip, Path targetPath, ZipEntry e) throws IOException {
        String name = e.getName();
        if (!name.startsWith("txCache")) {
            zip.closeEntry();
            return;
        }
        Path sourcePath = Paths.get(name, new String[0]);
        if (sourcePath.getNameCount() <= 1) {
            zip.closeEntry();
            return;
        }
        if (e.isDirectory()) {
            zip.closeEntry();
            return;
        }
        TxCacheResourceExtractor.extractFileFromZipInputStream(zip, sourcePath, targetPath);
    }

    private static void extractFileFromZipInputStream(ZipInputStream zip, Path sourcePath, Path targetPath) throws IOException {
        Path fileTargetPath = targetPath.resolve(sourcePath.subpath(1, sourcePath.getNameCount()));
        TxCacheResourceExtractor.makeFileParentDirsIfNotExist(fileTargetPath);
        FileOutputStream fileOutputStream = ManagedFileAccess.outStream((File)ManagedFileAccess.fromPath((Path)fileTargetPath));
        int c = zip.read();
        while (c != -1) {
            fileOutputStream.write(c);
            c = zip.read();
        }
        zip.closeEntry();
        fileOutputStream.close();
    }

    private static void makeFileParentDirsIfNotExist(Path filePath) throws IOException {
        Path parent = filePath.getParent();
        File f = ManagedFileAccess.fromPath((Path)parent);
        if (!f.exists()) {
            f.mkdirs();
        }
    }
}

