/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.utilities.VersionUtil;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;

public class Display {
    static final String CURLY_START = "\\{\\{";
    static final String CURLY_END = "\\}\\}";

    private static String toMB(long maxMemory) {
        return Long.toString(maxMemory / 0x100000L);
    }

    public static void printCliParamsAndInfo(String[] args) throws IOException {
        System.out.println("  Paths:  Current = " + System.getProperty("user.dir") + ", Package Cache = " + new FilesystemPackageCacheManager.Builder().build().getFolder());
        System.out.print("  Params:");
        for (String s : args) {
            System.out.print(s.contains(" ") ? " \"" + s + "\"" : " " + s);
        }
        System.out.println();
    }

    static final String getMoustacheString(String string) {
        return CURLY_START + string + CURLY_END;
    }

    static final String replacePlaceholders(String input, String[][] placeholders) {
        String output = input;
        for (String[] placeholder : placeholders) {
            output = output.replaceAll(Display.getMoustacheString(placeholder[0]), placeholder[1]);
        }
        return output;
    }

    public static void displayHelpDetails(PrintStream out, String file) {
        Display.displayHelpDetails(out, file, new String[0][]);
    }

    public static void displayHelpDetails(PrintStream out, String file, String[][] placeholders) {
        ClassLoader classLoader = Display.class.getClassLoader();
        InputStream help = classLoader.getResourceAsStream(file);
        try {
            String data = IOUtils.toString((InputStream)help, (String)"UTF-8");
            out.println(Display.replacePlaceholders(data, placeholders));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void displaySystemInfo(PrintStream out) {
        out.println("  Java:   " + System.getProperty("java.version") + " from " + System.getProperty("java.home") + " on " + System.getProperty("os.arch") + " (" + System.getProperty("sun.arch.data.model") + "bit). " + Display.toMB(Runtime.getRuntime().maxMemory()) + "MB available");
    }

    public static void displayVersion(PrintStream out) {
        out.println("FHIR Validation tool " + VersionUtil.getVersionString());
    }
}

