/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValidationContext {
    public static final String INTERNAL_REFERENCES_NAME = "internal.references";
    private Object appContext;
    private String version;
    private Element resource;
    private Element rootResource;
    private Element groupingResource;
    private StructureDefinition profile;
    private boolean checkSpecials = true;
    private Map<String, List<ValidationMessage>> sliceRecords;
    private Set<String> internalRefs;
    private boolean matchetype;

    public ValidationContext(Object appContext) {
        this.appContext = appContext;
    }

    public ValidationContext(Object appContext, Element element) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = element;
        this.internalRefs = this.setupInternalRefs(element);
        this.check();
        this.dump("creating");
    }

    private Set<String> setupInternalRefs(Element element) {
        HashSet res = (HashSet)element.getUserData(INTERNAL_REFERENCES_NAME);
        if (res == null) {
            res = new HashSet();
            element.setUserData(INTERNAL_REFERENCES_NAME, res);
        }
        return res;
    }

    private void check() {
        if (!this.rootResource.hasParentForValidator()) {
            throw new Error("No parent on root resource");
        }
    }

    public ValidationContext(Object appContext, Element element, Element root) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = root;
        this.internalRefs = this.setupInternalRefs(element);
        this.check();
        this.dump("creating");
    }

    public ValidationContext(Object appContext, Element element, Element root, Element groupingResource) {
        this.appContext = appContext;
        this.resource = element;
        this.rootResource = root;
        this.groupingResource = groupingResource;
        this.internalRefs = this.setupInternalRefs(element);
        this.check();
        this.dump("creating");
    }

    public Object getAppContext() {
        return this.appContext;
    }

    public ValidationContext setAppContext(Object appContext) {
        this.appContext = appContext;
        return this;
    }

    public ValidationContext setResource(Element resource) {
        this.resource = resource;
        return this;
    }

    public Element getRootResource() {
        return this.rootResource;
    }

    public ValidationContext setRootResource(Element rootResource) {
        this.rootResource = rootResource;
        this.dump("setting root resource");
        return this;
    }

    public Element getGroupingResource() {
        return this.groupingResource;
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public ValidationContext setProfile(StructureDefinition profile) {
        this.profile = profile;
        return this;
    }

    public Map<String, List<ValidationMessage>> getSliceRecords() {
        return this.sliceRecords;
    }

    public ValidationContext setSliceRecords(Map<String, List<ValidationMessage>> sliceRecords) {
        this.sliceRecords = sliceRecords;
        return this;
    }

    public boolean isCheckSpecials() {
        return this.checkSpecials;
    }

    public void setCheckSpecials(boolean checkSpecials) {
        this.checkSpecials = checkSpecials;
    }

    public Element getResource() {
        return this.resource;
    }

    public void sliceNotes(String url, List<ValidationMessage> record) {
        if (this.sliceRecords != null) {
            this.sliceRecords.put(url, record);
        }
    }

    public ValidationContext forContained(Element element) {
        ValidationContext res = new ValidationContext(this.appContext);
        res.rootResource = this.resource;
        res.resource = element;
        res.profile = this.profile;
        res.groupingResource = this.groupingResource;
        res.version = this.version;
        res.matchetype = this.matchetype;
        res.internalRefs = this.setupInternalRefs(element);
        res.dump("forContained");
        return res;
    }

    public ValidationContext forEntry(Element element, Element groupingResource) {
        ValidationContext res = new ValidationContext(this.appContext);
        res.rootResource = element;
        res.resource = element;
        res.profile = this.profile;
        res.groupingResource = groupingResource;
        res.version = this.version;
        res.matchetype = this.matchetype;
        res.internalRefs = this.setupInternalRefs(element);
        res.dump("forEntry");
        return res;
    }

    public ValidationContext forProfile(StructureDefinition profile) {
        ValidationContext res = new ValidationContext(this.appContext);
        res.resource = this.resource;
        res.rootResource = this.rootResource;
        res.profile = profile;
        res.version = this.version;
        res.matchetype = this.matchetype;
        res.groupingResource = this.groupingResource;
        res.internalRefs = this.internalRefs;
        res.sliceRecords = this.sliceRecords != null ? this.sliceRecords : new HashMap<String, List<ValidationMessage>>();
        res.dump("forProfile " + profile.getUrl());
        return res;
    }

    public ValidationContext forLocalReference(StructureDefinition profile, Element resource) {
        ValidationContext res = new ValidationContext(this.appContext);
        res.resource = resource;
        res.rootResource = resource;
        res.profile = profile;
        res.groupingResource = this.groupingResource;
        res.checkSpecials = false;
        res.matchetype = this.matchetype;
        res.internalRefs = this.setupInternalRefs(resource);
        res.dump("forLocalReference " + profile.getUrl());
        res.version = this.version;
        return res;
    }

    private void dump(String ctxt) {
    }

    public ValidationContext forRemoteReference(StructureDefinition profile, Element resource) {
        ValidationContext res = new ValidationContext(this.appContext);
        res.resource = resource;
        res.rootResource = resource;
        res.profile = profile;
        res.groupingResource = null;
        res.checkSpecials = false;
        res.version = this.version;
        res.matchetype = this.matchetype;
        res.internalRefs = this.setupInternalRefs(resource);
        res.dump("forRemoteReference " + profile.getUrl());
        return res;
    }

    public ValidationContext forSlicing() {
        ValidationContext res = new ValidationContext(this.appContext);
        res.resource = this.resource;
        res.rootResource = this.rootResource;
        res.groupingResource = this.groupingResource;
        res.profile = this.profile;
        res.checkSpecials = false;
        res.version = this.version;
        res.matchetype = this.matchetype;
        res.internalRefs = this.internalRefs;
        res.sliceRecords = new HashMap<String, List<ValidationMessage>>();
        res.dump("forSlicing");
        return res;
    }

    public String getVersion() {
        return this.version;
    }

    public ValidationContext setVersion(String version) {
        this.version = version;
        return this;
    }

    public Set<String> getInternalRefs() {
        return this.internalRefs;
    }

    public boolean isMatchetype() {
        return this.matchetype;
    }

    public void setMatchetype(boolean matchetype) {
        this.matchetype = matchetype;
    }
}

