/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.convertors.loaders.loaderR5.BaseLoaderR5;
import org.hl7.fhir.convertors.loaders.loaderR5.ILoaderKnowledgeProviderR5;
import org.hl7.fhir.convertors.loaders.loaderR5.NullLoaderKnowledgeProviderR5;
import org.hl7.fhir.convertors.loaders.loaderR5.R2016MayToR5Loader;
import org.hl7.fhir.convertors.loaders.loaderR5.R2ToR5Loader;
import org.hl7.fhir.convertors.loaders.loaderR5.R3ToR5Loader;
import org.hl7.fhir.convertors.loaders.loaderR5.R4BToR5Loader;
import org.hl7.fhir.convertors.loaders.loaderR5.R4ToR5Loader;
import org.hl7.fhir.convertors.loaders.loaderR5.R5ToR5Loader;
import org.hl7.fhir.convertors.loaders.loaderR5.R6ToR5Loader;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.OperationOutcomeUtilities;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.service.utils.AsteriskFilter;
import org.hl7.fhir.validation.service.utils.Common;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ValidatorUtils {
    protected static void grabNatives(Map<String, ByteProvider> source, Map<String, ByteProvider> binaries, String prefix) {
        for (Map.Entry<String, ByteProvider> e : source.entrySet()) {
            if (!e.getKey().endsWith(".zip")) continue;
            binaries.put(prefix + "#" + e.getKey(), e.getValue());
        }
    }

    public static BaseLoaderR5 loaderForVersion(String version) {
        return ValidatorUtils.loaderForVersion(version, (ILoaderKnowledgeProviderR5)new NullLoaderKnowledgeProviderR5());
    }

    public static BaseLoaderR5 loaderForVersion(String version, ILoaderKnowledgeProviderR5 loader) {
        if (Utilities.noString((String)version)) {
            return null;
        }
        if (VersionUtilities.isR2Ver((String)version)) {
            return new R2ToR5Loader(Utilities.stringSet((String[])new String[]{"Conformance", "StructureDefinition", "ValueSet", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader);
        }
        if (VersionUtilities.isR2BVer((String)version)) {
            return new R2016MayToR5Loader(Utilities.stringSet((String[])new String[]{"Conformance", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader);
        }
        if (VersionUtilities.isR3Ver((String)version)) {
            return new R3ToR5Loader(Utilities.stringSet((String[])new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader);
        }
        if (VersionUtilities.isR4Ver((String)version)) {
            return new R4ToR5Loader(Utilities.stringSet((String[])new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader, version);
        }
        if (VersionUtilities.isR4BVer((String)version)) {
            return new R4BToR5Loader(Utilities.stringSet((String[])new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader, version);
        }
        if (VersionUtilities.isR5Ver((String)version)) {
            return new R5ToR5Loader(Utilities.stringSet((String[])new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader);
        }
        if (VersionUtilities.isR6Ver((String)version)) {
            return new R6ToR5Loader(Utilities.stringSet((String[])new String[]{"CapabilityStatement", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"}), loader);
        }
        return null;
    }

    protected static Document parseXml(byte[] cnt) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = XMLUtil.newXXEProtectedDocumentBuilderFactory();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(cnt));
    }

    protected static List<ValidationMessage> filterMessages(List<ValidationMessage> messages) {
        ArrayList<ValidationMessage> filteredValidation = new ArrayList<ValidationMessage>();
        for (ValidationMessage e : messages) {
            if (filteredValidation.contains(e)) continue;
            filteredValidation.add(e);
        }
        filteredValidation.sort(null);
        return filteredValidation;
    }

    protected static OperationOutcome messagesToOutcome(List<ValidationMessage> messages, SimpleWorkerContext context, FHIRPathEngine fpe) throws IOException, FHIRException, EOperationOutcome {
        OperationOutcome op = new OperationOutcome();
        for (ValidationMessage vm : ValidatorUtils.filterMessages(messages)) {
            try {
                fpe.parse(vm.getLocation());
            }
            catch (Exception e) {
                System.out.println("Internal error in location for message: '" + e.getMessage() + "', loc = '" + vm.getLocation() + "', err = '" + vm.getMessage() + "'");
            }
            op.getIssue().add(OperationOutcomeUtilities.convertToIssue((ValidationMessage)vm, (OperationOutcome)op));
        }
        if (!op.hasIssue()) {
            op.addIssue().setSeverity(OperationOutcome.IssueSeverity.INFORMATION).setCode(OperationOutcome.IssueType.INFORMATIONAL).getDetails().setText(context.formatMessage("ALL_OK", new Object[0]));
        }
        RenderingContext rc = new RenderingContext((IWorkerContext)context, null, null, "http://hl7.org/fhir", "", context.getLocale(), RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.VALID_RESOURCE);
        RendererFactory.factory((Resource)op, (RenderingContext)rc).renderResource(ResourceWrapper.forResource((ContextUtilities)rc.getContextUtilities(), (Resource)op));
        return op;
    }

    static boolean extractReferences(String name, List<SourceFile> refs, SimpleWorkerContext context) throws IOException {
        if (Common.isNetworkPath(name)) {
            SourceFile src = ValidatorUtils.addSourceFile(refs, name);
            src.date = Long.MAX_VALUE;
            src.process = true;
        } else if (Common.isWildcardPath(name)) {
            File[] files;
            AsteriskFilter filter = new AsteriskFilter(name);
            for (File file : files = ManagedFileAccess.file((String)filter.getDir()).listFiles(filter)) {
                ValidatorUtils.addSourceFile(refs, file);
            }
        } else {
            File file = ManagedFileAccess.file((String)name);
            if (!file.exists()) {
                if (System.console() != null) {
                    System.console().printf(context.formatMessage("Bad_file_path_error", new Object[]{name}), new Object[0]);
                } else {
                    System.out.println(context.formatMessage("Bad_file_path_error", new Object[]{name}));
                }
                throw new IOException("File " + name + " does not exist");
            }
            if (file.isFile()) {
                ValidatorUtils.addSourceFile(refs, file);
            } else {
                for (File fileInDirectory : file.listFiles()) {
                    if (!fileInDirectory.isFile() || FileUtilities.isIgnorableFile((File)fileInDirectory)) continue;
                    ValidatorUtils.addSourceFile(refs, fileInDirectory);
                }
            }
        }
        return refs.size() > 1;
    }

    private static SourceFile addSourceFile(List<SourceFile> refs, File file) {
        SourceFile src = ValidatorUtils.addSourceFile(refs, file.getPath());
        long l = file.lastModified();
        if (src.date != l) {
            src.setProcess(l != 0L);
        }
        src.date = l;
        return src;
    }

    private static SourceFile addSourceFile(List<SourceFile> refs, String path) {
        for (SourceFile t : refs) {
            if (!t.ref.equals(path)) continue;
            return t;
        }
        SourceFile src = new SourceFile();
        src.ref = path;
        refs.add(src);
        return src;
    }

    public static boolean parseSources(List<String> sources, List<SourceFile> refs, SimpleWorkerContext context) throws IOException {
        boolean multipleRefsFound = sources.size() > 1;
        for (String source : sources) {
            multipleRefsFound |= ValidatorUtils.extractReferences(source, refs, context);
        }
        return multipleRefsFound;
    }

    public static class SourceFile {
        private String ref;
        private long date;
        private boolean process;
        private Content cnt;

        public boolean isProcess() {
            return this.process;
        }

        public void setProcess(boolean process) {
            this.process = process;
            this.cnt = null;
        }

        public String getRef() {
            return this.ref;
        }

        public long getDate() {
            return this.date;
        }

        public Content getCnt() {
            return this.cnt;
        }

        public void setCnt(Content cnt) {
            this.cnt = cnt;
        }

        public boolean isKnownToBeMissing() {
            return this.date == 0L;
        }
    }
}

