/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.codegen.Analysis;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.EnumInfo;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;
import org.hl7.fhir.validation.codegen.JavaParserJsonGenerator;
import org.hl7.fhir.validation.codegen.TypeInfo;

public class JavaParserXmlGenerator
extends JavaBaseGenerator {
    private StringBuilder parser = new StringBuilder();
    private StringBuilder pRes = new StringBuilder();
    private StringBuilder pTP = new StringBuilder();
    private StringBuilder pT = new StringBuilder();
    private StringBuilder pFrag = new StringBuilder();
    private StringBuilder pCtype = new StringBuilder();
    private StringBuilder composer = new StringBuilder();
    private StringBuilder cRes = new StringBuilder();
    private StringBuilder cRN = new StringBuilder();
    private StringBuilder cType = new StringBuilder();
    private List<JavaParserJsonGenerator.TypeSpecifier> typeSpecifiers = new ArrayList<JavaParserJsonGenerator.TypeSpecifier>();

    public JavaParserXmlGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void seeClass(Analysis analysis) throws Exception {
        this.generateParser(analysis);
        this.generateComposer(analysis);
        if (!analysis.isAbstract()) {
            this.pFrag.append("    } else if (type.equals(\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getClassName() + "(xpp);\r\n");
            this.pCtype.append("    } else if (xpp.getName().equals(prefix+\"" + analysis.getName() + "\")) {\r\n      return true;\r\n");
            if (analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE) {
                this.pTP.append("    } else if (xpp.getName().equals(prefix+\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getClassName() + "(xpp);\r\n");
                this.pT.append("    } else if (type.equals(\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getClassName() + "(xpp);\r\n");
                this.cType.append("    } else if (type instanceof " + analysis.getClassName() + ") {\r\n       compose" + analysis.getClassName() + "(prefix+\"" + analysis.getName() + "\", (" + analysis.getClassName() + ") type);\r\n");
            }
            if (analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
                this.pRes.append("    } else if (xpp.getName().equals(\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getClassName() + "(xpp);\r\n");
                this.cRes.append("    } else if (resource instanceof " + analysis.getClassName() + ") {\r\n      compose" + analysis.getClassName() + "(\"" + analysis.getName() + "\", (" + analysis.getClassName() + ")resource);\r\n");
                this.cRN.append("    } else if (resource instanceof " + analysis.getClassName() + ") {\r\n      compose" + analysis.getClassName() + "(name, (" + analysis.getClassName() + ")resource);\r\n");
            }
        }
    }

    public void generate() throws Exception {
        String template = this.config.getAdornments().get("XmlParser");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{parser}}", this.parser.toString());
        template = template.replace("{{parse-resource}}", this.pRes.toString());
        template = template.replace("{{parse-type-prefix}}", this.pTP.toString());
        template = template.replace("{{parse-type}}", this.pT.toString());
        template = template.replace("{{parse-fragment}}", this.pFrag.toString());
        template = template.replace("{{check-type}}", this.pCtype.toString());
        template = template.replace("{{composer}}", this.composer.toString());
        template = template.replace("{{compose-resource}}", this.cRes.toString());
        template = template.replace("{{compose-resource-name}}", this.cRN.toString());
        template = template.replace("{{compose-type}}", this.cType.toString());
        this.write(template);
        this.flush();
        this.close();
    }

    private void generateParser(Analysis analysis) throws Exception {
        if (analysis.isAbstract()) {
            this.genInnerAbstract(analysis, analysis.getRootType());
        } else {
            this.genInner(analysis, analysis.getRootType());
        }
        for (TypeInfo ti : analysis.getTypeList()) {
            this.genInner(analysis, ti);
        }
    }

    private void genInner(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String pfx;
        String tn = ti.getName();
        String stn = ti == analysis.getRootType() ? tn : analysis.getClassName() + "." + tn;
        String string = pfx = ti.getDefn().isInlineType() && !tn.startsWith(analysis.getClassName()) ? analysis.getClassName() : "";
        if (!analysis.isAbstract() || ti != analysis.getRootType()) {
            this.parser.append("  protected " + stn + " parse" + pfx + tn + "(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {\r\n");
            this.parser.append("    " + stn + " res = new " + stn + "();\r\n");
            if (ti == analysis.getRootType() && analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
                this.parser.append("    parseResourceAttributes(xpp, res);\r\n");
            }
            for (ElementDefinition ed : ti.getChildren()) {
                if (!ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
                this.parser.append("    if (xpp.getAttributeValue(null, \"" + ed.getName() + "\") != null)\r\n");
                this.parser.append("        res.set" + this.upFirst(this.getElementName(ed.getName(), true)) + "(xpp.getAttributeValue(null, \"" + ed.getName() + "\"));\r\n");
            }
            this.parser.append("    next(xpp);\r\n");
            this.parser.append("    int eventType = nextNoWhitespace(xpp);\r\n");
            this.parser.append("    while (eventType != XmlPullParser.END_TAG) {\r\n");
            this.parser.append("    if (!parse" + pfx + tn + "Content(eventType, xpp, res)) // 1\r\n");
            this.parser.append("        unknownContent(xpp);\r\n");
            this.parser.append("      eventType = nextNoWhitespace(xpp);\r\n");
            this.parser.append("    }\r\n");
            this.parser.append("    next(xpp);\r\n");
            this.parser.append("    parseElementClose(res);\r\n");
            this.parser.append("    return res;\r\n");
            this.parser.append("  }\r\n\r\n");
        }
        this.parser.append("  protected boolean parse" + pfx + tn + "Content(int eventType, XmlPullParser xpp, " + stn + " res) throws XmlPullParserException, IOException, FHIRFormatError {\r\n");
        boolean first = true;
        for (ElementDefinition ed : ti.getChildren()) {
            if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
            this.genElement(analysis, ti, ed, this.matchingInheritedElement(ti.getInheritedChildren(), ed, analysis.getName()), first);
            first = false;
        }
        if (!first) {
            this.parser.append("    } else ");
        } else {
            this.parser.append("    ");
        }
        this.parser.append("if (!parse" + Utilities.urlTail((String)ti.getAncestorName()) + "Content(eventType, xpp, res)){ //2\r\n");
        this.parser.append("      return false;\r\n");
        this.parser.append("    }\r\n");
        this.parser.append("    return true;\r\n");
        this.parser.append("  }\r\n\r\n");
        for (JavaParserJsonGenerator.TypeSpecifier ts : this.typeSpecifiers) {
            this.genTypeSpecifierParser(ts);
        }
        this.typeSpecifiers.clear();
    }

    private void genTypeSpecifierParser(JavaParserJsonGenerator.TypeSpecifier ts) {
        this.parser.append("  protected " + ts.getResName() + " " + ts.getFnName() + "(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {\r\n");
        this.parser.append("    String xsiType = xpp.getAttributeValue(\"xsi\", \"type\");\r\n");
        for (Extension ex : ts.getEd().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            this.parser.append("    if (\"" + Utilities.urlTail((String)ex.getExtensionString("type")) + "\".equals(xsiType)) {\r\n");
            this.parser.append("      return parse" + Utilities.urlTail((String)ex.getExtensionString("type")) + "(xpp);\r\n");
            this.parser.append("    }\r\n");
        }
        this.parser.append("    throw new FHIRFormatError(\"Unable to parse " + ts.getResName() + ": xsi:type '\"+xsiType+\"' not known\");\r\n");
        this.parser.append("  }\r\n\r\n");
    }

    private void genInnerAbstract(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String tn = ti.getName();
        this.parser.append("  protected boolean parse" + this.upFirst(tn).replace(".", "") + "Content(int eventType, XmlPullParser xpp, " + tn + " res) throws XmlPullParserException, IOException, FHIRFormatError {\r\n");
        boolean first = true;
        if (!analysis.isInterface()) {
            for (ElementDefinition ed : ti.getChildren()) {
                if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
                this.genElement(analysis, ti, ed, null, first);
                first = false;
            }
        }
        if (!first) {
            this.parser.append("    } else ");
        } else {
            this.parser.append("    ");
        }
        if (ti.getAncestorName() != null) {
            this.parser.append("if (!parse" + ti.getAncestorName() + "Content(eventType, xpp, res)) { //3 \r\n");
        } else {
            this.parser.append(" { \r\n");
        }
        this.parser.append("        return false;\r\n");
        this.parser.append("    }\r\n");
        this.parser.append("    return true;\r\n");
        this.parser.append("  }\r\n\r\n");
    }

    private void genElement(Analysis analysis, TypeInfo ti, ElementDefinition ed, ElementDefinition inh, boolean first) throws Exception {
        String name = ed.getName();
        if (name.endsWith("[x]") || name.equals("[type]")) {
            String en = name.endsWith("[x]") && !name.equals("[x]") ? name.replace("[x]", "") : "value";
            String pfx = name.endsWith("[x]") && !name.equals("[x]") ? name.replace("[x]", "") : "";
            this.parser.append("    " + (!first ? "} else " : "") + "if (eventType == XmlPullParser.START_TAG && nameIsTypeName(xpp, \"" + pfx + "\")) {\r\n");
            this.parser.append("      res.set" + this.upFirst(this.getElementName(en, false)) + "(parseType(\"" + en + "\", xpp));\r\n");
        } else {
            Object prsr = null;
            if (ed.hasUserData("java.enum")) {
                EnumInfo ei = (EnumInfo)ed.getUserData("java.enum");
                ValueSet vs = ei.getValueSet();
                boolean enShared = vs.hasUserData("shared");
                String en = enShared ? "Enumerations." + ei.getName() : analysis.getClassName() + "." + ei.getName();
                prsr = "parseEnumeration(xpp, " + en + ".NULL, new " + en.substring(0, en.indexOf(".")) + "." + en.substring(en.indexOf(".") + 1) + "EnumFactory())";
            } else {
                String tn = ed.getUserString("java.type");
                if (ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
                    this.typeSpecifiers.add(new JavaParserJsonGenerator.TypeSpecifier("parse" + this.upFirst(tn), tn, ed));
                }
                prsr = tn.contains("Reference(") ? "parseReference(xpp)" : (tn.contains("canonical(") ? "parseCanonical(xpp)" : (tn.contains("(") ? "parse" + tn + "(xpp)" : (tn.startsWith(analysis.getName()) && !tn.equals(analysis.getClassName()) ? "parse" + this.upFirst(tn) + "(xpp)" : (tn.equals("Resource") || tn.equals("DomainResource") ? "parse" + this.upFirst(tn) + "Contained(xpp)" : (this.isPrimitive(ed) ? "parse" + this.upFirst(tn.substring(0, tn.length() - 4)) + "(xpp)" : ((ed.hasContentReference() || ed.isInlineType()) && !tn.startsWith(analysis.getClassName()) ? "parse" + analysis.getClassName() + this.upFirst(tn) + "(xpp)" : "parse" + this.upFirst(tn) + "(xpp)"))))));
            }
            if (ed.unbounded()) {
                this.parser.append("    " + (!first ? "} else " : "") + "if (eventType == XmlPullParser.START_TAG && xpp.getName().equals(\"" + name + "\")) {\r\n");
                this.parser.append("      res.get" + this.upFirst(this.getElementName(name, false)) + "().add(" + (String)prsr + ");\r\n");
            } else if (inh != null && inh.unbounded()) {
                this.parser.append("    " + (!first ? "} else " : "") + "if (eventType == XmlPullParser.START_TAG && xpp.getName().equals(\"" + name + "\")) {\r\n");
                this.parser.append("      res.add" + this.upFirst(this.getElementName(name, false)) + (!ed.typeSummary().equals("xhtml") && (this.isPrimitive(ed) || ed.typeSummary().startsWith("canonical(")) ? "Element" : "") + "(" + (String)prsr + ");\r\n");
            } else {
                this.parser.append("    " + (!first ? "} else " : "") + "if (eventType == XmlPullParser.START_TAG && xpp.getName().equals(\"" + name + "\")) {\r\n");
                this.parser.append("      res.set" + this.upFirst(this.getElementName(name, false)) + (!ed.typeSummary().equals("xhtml") && (this.isPrimitive(ed) || ed.typeSummary().startsWith("canonical(")) ? "Element" : "") + "(" + (String)prsr + ");\r\n");
            }
        }
    }

    private boolean isPrimitive(ElementDefinition e) {
        return this.definitions.hasPrimitiveType(e.typeSummary());
    }

    private void generateComposer(Analysis analysis) throws Exception {
        if (analysis.isAbstract()) {
            this.genInnerAbstractComposer(analysis, analysis.getRootType());
        } else {
            this.genInnerComposer(analysis, analysis.getRootType());
        }
        for (TypeInfo ti : analysis.getTypeList()) {
            this.genInnerComposer(analysis, ti);
        }
    }

    private void genInnerComposer(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String tn = ti.getName();
        String stn = ti == analysis.getRootType() ? tn : analysis.getClassName() + "." + tn;
        String pfx = ti.getDefn().isInlineType() && !tn.startsWith(analysis.getClassName()) ? analysis.getClassName() : "";
        this.composer.append("  protected void compose" + pfx + tn + "(String name, " + stn + " element) throws IOException {\r\n");
        this.composer.append("    if (element != null) {\r\n");
        if (ti == analysis.getRootType() && analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
            this.composer.append("    composeResourceAttributes(element);\r\n");
        }
        for (ElementDefinition ed : ti.getChildren()) {
            if (!ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
            this.composer.append("      if (element.has" + this.upFirst(this.getElementName(ed.getName(), true)) + "Element())\r\n");
            this.composer.append("        xml.attribute(\"" + ed.getName() + "\", element.get" + this.upFirst(this.getElementName(ed.getName(), true)) + "Element().getValue());\r\n");
        }
        this.composer.append("      xml.enter(FHIR_NS, name);\r\n");
        this.composer.append("      compose" + pfx + tn + "Elements(element);\r\n");
        this.composer.append("      composeElementClose(element);\r\n");
        this.composer.append("      xml.exit(FHIR_NS, name);\r\n");
        this.composer.append("    }\r\n");
        this.composer.append("  }\r\n\r\n");
        this.composer.append("  protected void compose" + pfx + tn + "Elements(" + stn + " element) throws IOException {\r\n");
        if (!"Element".equals(tn) && analysis.getAncestor() != null) {
            this.composer.append("    compose" + ti.getAncestorName() + "Elements(element);\r\n");
        }
        for (ElementDefinition ed : ti.getChildren()) {
            if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
            this.genElementCompose(analysis, ti, ed, this.matchingInheritedElement(ti.getInheritedChildren(), ed, analysis.getName()));
        }
        this.composer.append("  }\r\n\r\n");
        for (JavaParserJsonGenerator.TypeSpecifier ts : this.typeSpecifiers) {
            this.genTypeSpecifierCompose(ts);
        }
        this.typeSpecifiers.clear();
    }

    private void genTypeSpecifierCompose(JavaParserJsonGenerator.TypeSpecifier ts) {
        this.composer.append("  protected void " + ts.getFnName() + "(String name, " + ts.getResName() + " element) throws IOException {\r\n");
        boolean first = true;
        for (Extension ex : ts.getEd().getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            String tn = Utilities.urlTail((String)ex.getExtensionString("type"));
            this.composer.append("    " + (first ? "" : "} else ") + "if (element instanceof " + tn + ") {\r\n");
            this.composer.append("      compose" + tn + "(name, (" + tn + ") element);\r\n");
            first = false;
        }
        this.composer.append("    } else {\r\n");
        this.composer.append("      throw new FHIRFormatError(\"Unable to compose " + ts.getResName() + ": Unexpected type \"+element.getClass().getName());\r\n");
        this.composer.append("    }\r\n");
        this.composer.append("  }\r\n");
        this.composer.append("\r\n");
    }

    private void genInnerAbstractComposer(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String tn = ti.getName();
        this.composer.append("  protected void compose" + tn + "Elements(" + tn + " element) throws IOException {\r\n");
        this.composer.append("    compose" + ti.getAncestorName() + "Elements(element);\r\n");
        if (!analysis.isInterface()) {
            for (ElementDefinition ed : ti.getChildren()) {
                if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
                this.genElementCompose(analysis, ti, ed, null);
            }
        }
        this.composer.append("  }\r\n\r\n");
    }

    private void genElementCompose(Analysis analysis, TypeInfo ti, ElementDefinition ed, ElementDefinition inh) throws Exception {
        String name = ed.getName();
        if (name.endsWith("[x]") || name.equals("[type]")) {
            String en = name.endsWith("[x]") && !name.equals("[x]") ? name.replace("[x]", "") : "value";
            String pfx = name.endsWith("[x]") ? name.replace("[x]", "") : "";
            this.composer.append("    if (element.has" + this.upFirst(this.getElementName(en, false)) + "()) {\r\n");
            this.composer.append("      composeType(\"" + pfx + "\", element.get" + this.upFirst(this.getElementName(en, false)) + "());\r\n");
            this.composer.append("    }");
        } else {
            Object comp = null;
            String en = null;
            String tn = ed.getUserString("java.type");
            if (ed.hasUserData("java.enum")) {
                EnumInfo ei = (EnumInfo)ed.getUserData("java.enum");
                ValueSet vs = ei.getValueSet();
                boolean enShared = vs.hasUserData("shared");
                en = enShared ? "Enumerations." + ei.getName() : analysis.getClassName() + "." + ei.getName();
            } else if (tn.equals("XhtmlNode")) {
                tn = "xhtml";
                comp = "composeXhtml";
            } else if (this.isPrimitive(ed)) {
                comp = "compose" + tn.substring(0, tn.length() - 4);
            } else if (tn.contains("Reference(")) {
                comp = "composeReference";
                tn = "Reference";
            } else if (tn.contains("canonical(")) {
                comp = "composeCanonical";
                tn = "CanonicalType";
            } else {
                comp = tn.contains("(") ? "compose" + tn : ((ed.hasContentReference() || ed.isInlineType()) && !tn.startsWith(analysis.getClassName()) ? "compose" + analysis.getClassName() + tn : "compose" + tn);
            }
            if (ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
                this.typeSpecifiers.add(new JavaParserJsonGenerator.TypeSpecifier((String)comp, tn, ed));
            }
            if (ed.unbounded()) {
                if (en != null) {
                    this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) \r\n");
                    this.composer.append("        for (Enumeration<" + en + "> e : element.get" + this.upFirst(this.getElementName(name, false)) + "()) \r\n");
                    this.composer.append("          composeEnumeration(\"" + name + "\", e, new " + en + "EnumFactory());\r\n");
                } else {
                    Object stn = ed.isInlineType() || ed.hasContentReference() ? analysis.getClassName() + "." + tn : tn;
                    this.composer.append("    if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) { \r\n");
                    if (((String)stn).contains(".") || !((String)stn).contains("Component")) {
                        this.composer.append("      for (" + (String)stn + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "()) \r\n");
                    } else {
                        this.composer.append("      for (" + analysis.getName() + "." + (String)stn + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "()) \r\n");
                    }
                    if (ed.typeSummary().equals("Resource")) {
                        this.composer.append("        {\r\n");
                        this.composer.append("          xml.enter(FHIR_NS, \"" + name + "\");\r\n");
                        this.composer.append("          " + (String)comp + "(e);\r\n");
                        this.composer.append("          xml.exit(FHIR_NS, \"" + name + "\");\r\n");
                        this.composer.append("        }\r\n");
                    } else {
                        this.composer.append("          " + (String)comp + "(\"" + name + "\", e); // a\r\n");
                    }
                    this.composer.append("    }\r\n");
                }
            } else if (en != null) {
                this.composer.append("    if (element.has" + this.upFirst(this.getElementName(name, false)) + "Element())\r\n");
                this.composer.append("      composeEnumeration(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), new " + en + "EnumFactory());\r\n");
            } else if (!"xhtml".equals(ed.typeSummary()) && (this.isJavaPrimitive(ed) || ed.typeSummary().startsWith("canonical("))) {
                this.composer.append("    if (element.has" + this.upFirst(this.getElementName(name, false)) + "Element()) {\r\n");
                this.composer.append("      " + (String)comp + "(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element());\r\n");
                this.composer.append("    }\r\n");
            } else if (ed.typeSummary().equals("Resource")) {
                this.composer.append("    if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("      xml.enter(FHIR_NS, \"" + name + "\");\r\n");
                this.composer.append("      " + (String)comp + "(element.get" + this.upFirst(this.getElementName(name, false)) + "());\r\n");
                this.composer.append("      xml.exit(FHIR_NS, \"" + name + "\");\r\n");
                this.composer.append("    }\r\n");
            } else if (inh != null && inh.unbounded()) {
                this.composer.append("    if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("      " + (String)comp + "(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "FirstRep());\r\n");
                this.composer.append("    }\r\n");
            } else {
                this.composer.append("    if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("      " + (String)comp + "(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "());\r\n");
                this.composer.append("    }\r\n");
            }
        }
    }

    private String upFirst(String n) {
        return n.substring(0, 1).toUpperCase() + n.substring(1);
    }
}

