/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.File;
import java.io.PrintStream;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.tasks.ValidationEngineTask;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.EngineMode;
import org.hl7.fhir.validation.special.PackageReGenerator;

public class RePackageTask
extends ValidationEngineTask {
    @Override
    public String getName() {
        return "tx-pack";
    }

    @Override
    public String getDisplayName() {
        return "Generate a terminology pack";
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return cliContext.getMode() == EngineMode.RE_PACKAGE;
    }

    @Override
    public void printHelp(PrintStream out) {
        Display.displayHelpDetails(out, "help/tx-pack.txt");
    }

    @Override
    public void executeTask(ValidationService validationService, ValidationEngine validationEngine, CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        boolean json = cliContext.getFormat() != Manager.FhirFormat.XML;
        String output = cliContext.getOutput();
        File f = ManagedFileAccess.file((String)output);
        PackageReGenerator.ExpansionPackageGeneratorOutputType t = PackageReGenerator.ExpansionPackageGeneratorOutputType.FOLDER;
        if (f.exists() && f.isDirectory()) {
            t = PackageReGenerator.ExpansionPackageGeneratorOutputType.FOLDER;
        } else if (output.endsWith(".zip")) {
            t = PackageReGenerator.ExpansionPackageGeneratorOutputType.ZIP;
        } else if (output.endsWith(".tgz")) {
            t = PackageReGenerator.ExpansionPackageGeneratorOutputType.TGZ;
        }
        PackageReGenerator.ExpansionPackageGeneratorScope scope = PackageReGenerator.ExpansionPackageGeneratorScope.IG_ONLY;
        int c = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!"-scope".equals(args[i])) continue;
            c = i;
        }
        if (c < args.length - 1) {
            switch (args[c + 1].toLowerCase()) {
                case "ig": {
                    scope = PackageReGenerator.ExpansionPackageGeneratorScope.IG_ONLY;
                    break;
                }
                case "igs": {
                    scope = PackageReGenerator.ExpansionPackageGeneratorScope.ALL_IGS;
                    break;
                }
                case "core": {
                    scope = PackageReGenerator.ExpansionPackageGeneratorScope.EVERYTHING;
                    break;
                }
                default: {
                    System.out.println("Unknown scope " + args[c + 1]);
                }
            }
        }
        SimpleWorkerContext ctxt = validationEngine.getContext();
        PackageReGenerator ep = new PackageReGenerator().setContext((IWorkerContext)ctxt).setScope(scope);
        ep.setNpmId(cliContext.getPackageName());
        for (String s : cliContext.getIgs()) {
            ep.addPackage(s);
        }
        if (cliContext.getExpansionParameters() != null) {
            validationEngine.loadExpansionParameters(cliContext.getExpansionParameters());
        }
        ep.setOutput(output).setOutputType(t).setJson(json);
        ep.setModes(cliContext.getModeParams());
        ep.generateExpansionPackage();
    }
}

