/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.text.WordUtils;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.utilities.FileFormat;
import org.hl7.fhir.utilities.SystemExitManager;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.validation.JavaSystemProxyParamSetter;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.tasks.AiTestsTask;
import org.hl7.fhir.validation.cli.tasks.CliTask;
import org.hl7.fhir.validation.cli.tasks.CodeGenTask;
import org.hl7.fhir.validation.cli.tasks.CompareTask;
import org.hl7.fhir.validation.cli.tasks.CompileTask;
import org.hl7.fhir.validation.cli.tasks.ConvertTask;
import org.hl7.fhir.validation.cli.tasks.FhirpathTask;
import org.hl7.fhir.validation.cli.tasks.InstallTask;
import org.hl7.fhir.validation.cli.tasks.InstanceFactoryTask;
import org.hl7.fhir.validation.cli.tasks.LangTransformTask;
import org.hl7.fhir.validation.cli.tasks.NarrativeTask;
import org.hl7.fhir.validation.cli.tasks.PreloadCacheTask;
import org.hl7.fhir.validation.cli.tasks.RePackageTask;
import org.hl7.fhir.validation.cli.tasks.ScanTask;
import org.hl7.fhir.validation.cli.tasks.SnapshotTask;
import org.hl7.fhir.validation.cli.tasks.SpecialTask;
import org.hl7.fhir.validation.cli.tasks.SpreadsheetTask;
import org.hl7.fhir.validation.cli.tasks.StandaloneTask;
import org.hl7.fhir.validation.cli.tasks.TestsTask;
import org.hl7.fhir.validation.cli.tasks.TransformTask;
import org.hl7.fhir.validation.cli.tasks.TxTestsTask;
import org.hl7.fhir.validation.cli.tasks.ValidateTask;
import org.hl7.fhir.validation.cli.tasks.ValidationEngineTask;
import org.hl7.fhir.validation.cli.tasks.VersionTask;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.Params;

public class ValidatorCli {
    private static final ValidationService validationService = new ValidationService();
    protected ValidationService myValidationService;
    final List<CliTask> cliTasks;
    final CliTask defaultCliTask = new ValidateTask();

    protected ValidatorCli(ValidationService validationService) {
        this.myValidationService = validationService;
        this.cliTasks = this.getCliTasks();
    }

    protected List<CliTask> getCliTasks() {
        return List.of(new CompareTask(), new CompileTask(), new ConvertTask(), new FhirpathTask(), new InstallTask(), new LangTransformTask(), new NarrativeTask(), new PreloadCacheTask(), new ScanTask(), new SnapshotTask(), new SpecialTask(), new SpreadsheetTask(), new TestsTask(), new TxTestsTask(), new AiTestsTask(), new TransformTask(), new VersionTask(), new CodeGenTask(), new RePackageTask(), new InstanceFactoryTask(), this.defaultCliTask);
    }

    protected void readParamsAndExecuteTask(CliContext cliContext, String[] args) throws Exception {
        TimeTracker tt = new TimeTracker();
        TimeTracker.Session tts = tt.start("Loading");
        if (cliContext.getLocale() != null) {
            Locale.setDefault(cliContext.getLocale());
        }
        if (Params.hasParam(args, "-no-http-access")) {
            ManagedWebAccess.setAccessPolicy((ManagedWebAccess.WebAccessPolicy)ManagedWebAccess.WebAccessPolicy.PROHIBITED);
        }
        ValidatorCli.setJavaSystemProxyParamsFromParams(args);
        Display.displayVersion(System.out);
        Display.displaySystemInfo(System.out);
        if (cliContext.getFhirSettingsFile() != null) {
            FhirSettings.setExplicitFilePath((String)cliContext.getFhirSettingsFile());
        }
        ManagedWebAccess.loadFromFHIRSettings();
        FileFormat.checkCharsetAndWarnIfNotUTF8((PrintStream)System.out);
        if (this.shouldDisplayHelpToUser(args)) {
            String helpTarget = Params.getParam(args, "-help");
            if (helpTarget != null) {
                this.cliTasks.stream().filter(task -> helpTarget.equals(task.getName())).findFirst().ifPresent(cliTask -> this.displayHelpForTask((CliTask)cliTask));
            } else {
                this.displayHelpForDefaultTask();
            }
            return;
        }
        this.readParamsAndExecuteTask(tt, tts, cliContext, args);
    }

    private void displayHelpForDefaultTask() {
        System.out.println();
        System.out.println(WordUtils.wrap((String)"This is the help text for default usage of the validator. Help for other modes of operation is available by using the parameter '-help [mode]' for one of the following modes:", (int)80));
        System.out.println();
        for (CliTask cliTask : this.cliTasks) {
            if (cliTask.isHidden()) continue;
            System.out.println("  " + cliTask.getName());
        }
        System.out.println();
        System.out.println(this.defaultCliTask.getDisplayName() + " (default usage)");
        System.out.println("=".repeat(this.defaultCliTask.getDisplayName().length()));
        System.out.println();
        this.defaultCliTask.printHelp(System.out);
    }

    private void displayHelpForTask(CliTask cliTask) {
        System.out.println();
        System.out.println("This is the help text for '" + cliTask.getName() + "'. To display all available help options, use the '-help' or 'help' parameter.");
        System.out.println();
        System.out.println(cliTask.getDisplayName());
        System.out.println("=".repeat(cliTask.getDisplayName().length()));
        System.out.println();
        cliTask.printHelp(System.out);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("slf4j.internal.verbosity", "WARN");
        ValidatorCli validatorCli = new ValidatorCli(validationService);
        args = ValidatorCli.addAdditionalParamsForIpsParam(args);
        CliContext cliContext = Params.loadCliContext(args);
        validatorCli.readParamsAndExecuteTask(cliContext, args);
    }

    private static void setJavaSystemProxyParamsFromParams(String[] args) {
        String proxy = Params.hasParam(args, "-proxy") ? Params.getParam(args, "-proxy") : null;
        String httpsProxy = Params.hasParam(args, "-https-proxy") ? Params.getParam(args, "-https-proxy") : null;
        String proxyAuth = Params.hasParam(args, "-auth") ? Params.getParam(args, "-auth") : null;
        JavaSystemProxyParamSetter.setJavaSystemProxyParams(proxy, httpsProxy, proxyAuth);
    }

    private static String[] addAdditionalParamsForIpsParam(String[] args) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (String a : args) {
            if (a.equals("-ips")) {
                res.add("-version");
                res.add("4.0");
                res.add("-check-ips-codes");
                res.add("-ig");
                res.add("hl7.fhir.uv.ips#2.0.0");
                res.add("-profile");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips");
                res.add("-extension");
                res.add("any");
                res.add("-bundle");
                res.add("Composition:0");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips");
                continue;
            }
            if (a.equals("-ips:au")) {
                res.add("-version");
                res.add("4.0");
                res.add("-check-ips-codes");
                res.add("-ig");
                res.add("hl7.fhir.au.ips#current");
                res.add("-profile");
                res.add("http://hl7.org.au/fhir/ips/StructureDefinition/Bundle-au-ips");
                res.add("-extension");
                res.add("any");
                res.add("-bundle");
                res.add("Composition:0");
                res.add("http://hl7.org.au/fhir/ips/StructureDefinition/Composition-au-ips");
                continue;
            }
            if (a.startsWith("-ips#")) {
                res.add("-version");
                res.add("4.0");
                res.add("-check-ips-codes");
                res.add("-ig");
                res.add("hl7.fhir.uv.ips#" + a.substring(5));
                res.add("-profile");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips");
                res.add("-extension");
                res.add("any");
                res.add("-bundle");
                res.add("Composition:0");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips");
                continue;
            }
            if (a.startsWith("-ips$")) {
                res.add("-version");
                res.add("4.0");
                res.add("-check-ips-codes");
                res.add("-ig");
                res.add("hl7.fhir.uv.ips#current$" + a.substring(5));
                res.add("-profile");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips");
                res.add("-extension");
                res.add("any");
                res.add("-bundle");
                res.add("Composition:0");
                res.add("http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips");
                continue;
            }
            if (a.equals("-cda")) {
                res.add("-version");
                res.add("5.0");
                res.add("-ig");
                res.add("hl7.cda.uv.core#2.0.0-sd-snapshot1");
                continue;
            }
            if (a.equals("-ccda")) {
                res.add("-version");
                res.add("5.0");
                res.add("-ig");
                res.add("hl7.cda.us.ccda#3.0.0-ballot");
                continue;
            }
            if (a.equals("-view-definition")) {
                res.add("-version");
                res.add("5.0");
                res.add("-ig");
                res.add("hl7.fhir.uv.sql-on-fhir#current");
                continue;
            }
            res.add(a);
        }
        String[] r = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            r[i] = (String)res.get(i);
        }
        return r;
    }

    private boolean shouldDisplayHelpToUser(String[] args) {
        return args.length == 0 || Params.hasParam(args, "help") || Params.hasParam(args, "-help") || Params.hasParam(args, "?") || Params.hasParam(args, "-?") || Params.hasParam(args, "/?");
    }

    private void readParamsAndExecuteTask(TimeTracker tt, TimeTracker.Session tts, CliContext cliContext, String[] params) throws Exception {
        Display.printCliParamsAndInfo(params);
        CliTask cliTask = this.selectCliTask(cliContext, params);
        if (cliTask instanceof ValidationEngineTask) {
            if (cliContext.getSv() == null) {
                cliContext.setSv(this.myValidationService.determineVersion(cliContext));
            }
            ValidationEngine validationEngine = this.getValidationEngine(tt, cliContext);
            tts.end();
            ((ValidationEngineTask)cliTask).executeTask(this.myValidationService, validationEngine, cliContext, params, tt, tts);
        } else if (cliTask instanceof StandaloneTask) {
            ((StandaloneTask)cliTask).executeTask(cliContext, params, tt, tts);
        }
        if (cliContext.getAdvisorFile() != null) {
            System.out.println("Note: Some validation issues might be hidden by the advisor settings in the file " + cliContext.getAdvisorFile());
        }
        System.out.println("Done. " + tt.report() + ". Max Memory = " + Utilities.describeSize((long)Runtime.getRuntime().maxMemory()));
        SystemExitManager.finish();
    }

    private CliTask selectCliTask(CliContext cliContext, String[] params) {
        CliTask cliTask = null;
        for (CliTask candidateTask : this.cliTasks) {
            if (!candidateTask.shouldExecuteTask(cliContext, params)) continue;
            cliTask = candidateTask;
        }
        if (cliTask == null) {
            cliTask = this.defaultCliTask;
        }
        return cliTask;
    }

    private ValidationEngine getValidationEngine(TimeTracker tt, CliContext cliContext) throws Exception {
        System.out.println("  Locale: " + Locale.getDefault().getDisplayCountry() + "/" + Locale.getDefault().getCountry());
        if (cliContext.getJurisdiction() == null) {
            System.out.println("  Jurisdiction: None specified (locale = " + Locale.getDefault().getCountry() + ")");
            System.out.println("  Note that exceptions and validation failures may happen in the absense of a locale");
        } else {
            System.out.println("  Jurisdiction: " + JurisdictionUtilities.displayJurisdiction((String)cliContext.getJurisdiction()));
        }
        System.out.println("Loading");
        String definitions = "dev".equals(cliContext.getSv()) ? "hl7.fhir.r5.core#current" : VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        ValidationEngine validationEngine = this.myValidationService.initializeValidator(cliContext, definitions, tt);
        return validationEngine;
    }
}

