/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class SnomedCTChecker
extends CodeSystemChecker {
    private boolean noTag = false;
    private List<String> noTags = new ArrayList<String>();
    private boolean hasTag = false;
    private List<String> tags = new ArrayList<String>();

    public SnomedCTChecker(IWorkerContext context, XVerExtensionManager xverManager, boolean debug, List<ValidationMessage> errors) {
        super(context, xverManager, debug, errors);
    }

    @Override
    public void checkConcept(String code, String display) {
        super.checkConcept(code, display);
        if (!Utilities.noString((String)display)) {
            boolean tagged;
            int s = display.lastIndexOf("(");
            int e = display.lastIndexOf(")");
            boolean bl = tagged = e == display.length() - 1 && s > -1 && s > display.length() - 20;
            if (tagged) {
                this.hasTag = true;
                if (this.tags.size() < 5) {
                    this.tags.add(display);
                }
            } else {
                this.noTag = true;
                if (this.noTags.size() < 5) {
                    this.noTags.add(display);
                }
            }
        }
    }

    @Override
    public void finish(Element inc, NodeStack stack) {
        super.finish(inc, stack);
        this.hint((List<ValidationMessage>)this.errors, "2023-07-21", ValidationMessage.IssueType.BUSINESSRULE, inc.line(), inc.col(), stack.getLiteralPath(), !this.noTag || !this.hasTag, "VALUESET_CONCEPT_DISPLAY_SCT_TAG_MIXED", this.tags.toString(), this.noTags.toString());
    }
}

