/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ConceptMapUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.structuremap.ResolvedGroup;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class StructureMapValidator
extends BaseValidator {
    private static final boolean SOURCE = true;
    private static final boolean TARGET = false;
    private FHIRPathEngine fpe;
    private ProfileUtilities profileUtilities;
    private ContextUtilities cu;
    private List<StructureMap> imports = new ArrayList<StructureMap>();

    public StructureMapValidator(IWorkerContext context, TimeTracker timeTracker, FHIRPathEngine fpe, XVerExtensionManager xverManager, ProfileUtilities profileUtilities, Coding jurisdiction) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
        this.jurisdiction = jurisdiction;
        this.profileUtilities = profileUtilities;
        this.cu = new ContextUtilities(context);
    }

    public boolean isAbstractType(List<ElementDefinition.TypeRefComponent> list) {
        if (list.size() != 1) {
            return false;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(list.get(0).getCode());
        return sd != null && sd.getAbstract();
    }

    public boolean validateStructureMap(List<ValidationMessage> errors, Element src, NodeStack stack) {
        boolean ok = true;
        List imports = src.getChildrenByName("import");
        int cc = 0;
        for (Element import_ : imports) {
            ok = this.validateImport(errors, src, import_, stack.push(import_, cc, null, null)) && ok;
            ++cc;
        }
        ArrayList<String> grpNames = new ArrayList<String>();
        List groups = src.getChildrenByName("group");
        boolean fired = false;
        do {
            fired = false;
            cc = 0;
            for (Element group : groups) {
                if (!group.hasUserData("structuremap.validated") && (this.hasInputTypes(group) || group.hasUserData("structuremap.parameters"))) {
                    group.setUserData("structuremap.validated", (Object)true);
                    fired = true;
                    ok = this.validateGroup(errors, src, group, stack.push(group, cc, null, null), grpNames) && ok;
                }
                ++cc;
            }
        } while (fired);
        cc = 0;
        for (Element group : groups) {
            if (!group.hasUserData("structuremap.validated")) {
                this.hint(errors, "2023-03-01", ValidationMessage.IssueType.INFORMATIONAL, group.line(), group.col(), stack.push(group, cc, null, null).getLiteralPath(), ok, "SM_ORPHAN_GROUP", group.getChildValue("name"));
                ok = this.validateGroup(errors, src, group, stack.push(group, cc, null, null), grpNames) && ok;
            }
            ++cc;
        }
        return ok;
    }

    private boolean hasInputTypes(Element group) {
        List inputs = group.getChildrenByName("input");
        for (Element input : inputs) {
            if (input.hasChild("type")) continue;
            return false;
        }
        return true;
    }

    private boolean validateImport(List<ValidationMessage> errors, Element src, Element import_, NodeStack stack) {
        String url = import_.primitiveValue();
        boolean ok = false;
        StructureMap map = (StructureMap)this.context.fetchResource(StructureMap.class, url);
        if (map != null) {
            this.imports.add(map);
            ok = true;
        } else if (url.contains("*")) {
            List maps = this.cu.listMaps(url);
            ok = !maps.isEmpty();
            this.imports.addAll(maps);
        }
        this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, import_.line(), import_.col(), stack.getLiteralPath(), ok, "SM_IMPORT_NOT_FOUND", url);
        return true;
    }

    private boolean validateGroup(List<ValidationMessage> errors, Element src, Element group, NodeStack stack, List<String> grpNames) {
        Element extend;
        String name = group.getChildValue("name");
        boolean ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, group.line(), group.col(), stack.getLiteralPath(), this.idIsValid(name), "SM_NAME_INVALID", name);
        if (!this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, group.line(), group.col(), stack.getLiteralPath(), !grpNames.contains(name), "SM_GROUP_NAME_DUPLICATE", name)) {
            grpNames.add(name);
        }
        if ((extend = group.getNamedChild("extends")) != null) {
            ResolvedGroup grp = this.resolveGroup(extend.primitiveValue(), src);
            if (!this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTSUPPORTED, extend.line(), extend.col(), stack.push(extend, -1, null, null).getLiteralPath(), grp != null, "SM_RULEGROUP_NOT_FOUND", extend.primitiveValue())) {
                ok = false;
            }
        }
        VariableSet variables = new VariableSet();
        VariableSet pvars = (VariableSet)group.getUserData("structuremap.parameters");
        List inputs = group.getChildrenByName("input");
        List structures = src.getChildrenByName("structure");
        int cc = 0;
        for (Element input : inputs) {
            ok = this.validateInput(errors, src, group, input, stack.push(input, cc, null, null), structures, variables, pvars) && ok;
            ++cc;
        }
        List rules = group.getChildrenByName("rule");
        cc = 0;
        for (Element rule : rules) {
            ok = this.validateRule(errors, src, group, rule, stack.push(rule, cc, null, null), variables) && ok;
            ++cc;
        }
        return ok;
    }

    private ResolvedGroup resolveGroup(String grpName, Element src) {
        if (grpName == null) {
            return null;
        }
        List groups = src.getChildrenByName("group");
        for (Element group : groups) {
            String name = group.getChildValue("name");
            if (!grpName.equals(name)) continue;
            return new ResolvedGroup(null, this.makeGroupComponent(group));
        }
        for (StructureMap map : this.imports) {
            for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
                if (!grpName.equals(grp.getName())) continue;
                return new ResolvedGroup(map, grp);
            }
        }
        return null;
    }

    private StructureMap.StructureMapGroupComponent makeGroupComponent(Element group) {
        StructureMap.StructureMapGroupComponent grp = new StructureMap.StructureMapGroupComponent();
        grp.setUserData("element.source", (Object)group);
        grp.setName(group.getChildValue("name"));
        List inputs = group.getChildrenByName("input");
        for (Element input : inputs) {
            StructureMap.StructureMapGroupInputComponent inp = grp.addInput();
            inp.setName(input.getChildValue("name"));
            inp.setType(input.getChildValue("type"));
            try {
                inp.setMode(StructureMap.StructureMapInputMode.fromCode((String)input.getChildValue("mode")));
            }
            catch (Exception exception) {}
        }
        return grp;
    }

    private boolean validateInput(List<ValidationMessage> errors, Element src, Element group, Element input, NodeStack stack, List<Element> structures, VariableSet variables, VariableSet pvars) {
        boolean ok = false;
        String name = input.getChildValue("name");
        String mode = input.getChildValue("mode");
        String type = input.getChildValue("type");
        VariableDefn pv = null;
        if (type == null && pvars != null && (pv = pvars.getVariable(name, mode.equals("source"))) != null) {
            type = pv.getWorkingType();
        }
        if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTSUPPORTED, input.line(), input.col(), stack.getLiteralPath(), this.idIsValid(name), "SM_NAME_INVALID", name) && this.rule(errors, "2023-03-01", ValidationMessage.IssueType.DUPLICATE, input.line(), input.col(), stack.getLiteralPath(), !variables.hasVariable(name), "SM_GROUP_INPUT_DUPLICATE", name)) {
            VariableDefn v = variables.add(name, mode);
            if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, input.line(), input.col(), stack.getLiteralPath(), Utilities.existsInList((String)mode, (String[])new String[]{"source", "target"}), "SM_GROUP_INPUT_MODE_INVALID", name, mode) && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.NOTSUPPORTED, input.line(), input.col(), stack.getLiteralPath(), type != null, "SM_GROUP_INPUT_NO_TYPE", name)) {
                String smode = null;
                StructureDefinition sd = null;
                ElementDefinition ed = null;
                if (pv != null) {
                    sd = pv.getSd();
                    ed = pv.getEd();
                } else {
                    Element structure = this.findStructure(structures, type);
                    if (structure != null) {
                        smode = structure.getChildValue("mode");
                        String url = structure.getChildValue("url");
                        sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
                        if (sd == null) {
                            this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, input.line(), input.col(), stack.getLiteralPath(), sd != null, "SM_GROUP_INPUT_TYPE_UNKNOWN_STRUCTURE", type, url);
                        }
                    } else if (type != null) {
                        sd = this.context.fetchTypeDefinition(type);
                        if (sd == null) {
                            this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, input.line(), input.col(), stack.getLiteralPath(), sd != null, "SM_GROUP_INPUT_TYPE_UNKNOWN_TYPE", type);
                        }
                    } else {
                        this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTSUPPORTED, input.line(), input.col(), stack.getLiteralPath(), structure != null, "SM_GROUP_INPUT_TYPE_NOT_DECLARED", type);
                        ok = false;
                    }
                    if (sd != null) {
                        ed = sd.getSnapshot().getElementFirstRep();
                    }
                }
                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTSUPPORTED, input.line(), input.col(), stack.getLiteralPath(), smode == null || mode.equals(smode), "SM_GROUP_INPUT_MODE_MISMATCH", type, mode, smode)) {
                    v.setType(1, sd, ed, null);
                    ok = true;
                }
            }
        }
        return ok;
    }

    private Element findStructure(List<Element> structures, String type) {
        for (Element structure : structures) {
            String t = structure.getChildValue("alias");
            if (!type.equals(t)) continue;
            return structure;
        }
        return null;
    }

    private boolean idIsValid(String name) {
        return name != null && name.matches("[a-zA-Z][a-zA-Z0-9]*");
    }

    private boolean validateRule(List<ValidationMessage> errors, Element src, Element group, Element rule, NodeStack stack, VariableSet variables) {
        String name = rule.getChildValue("name");
        boolean ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, rule.line(), rule.col(), stack.getLiteralPath(), this.idIsValid(name), "SM_NAME_INVALID", name);
        RuleInformation ruleInfo = new RuleInformation();
        VariableSet lvars = variables.copy();
        List sources = rule.getChildrenByName("source");
        int cc = 0;
        for (Object source : sources) {
            ok = this.validateRuleSource(errors, src, group, rule, (Element)source, stack.push((Element)source, cc, null, null), lvars, ruleInfo, cc) && ok;
            ++cc;
        }
        List targets = rule.getChildrenByName("target");
        cc = 0;
        for (Object target : targets) {
            ok = this.validateRuleTarget(errors, src, group, rule, (Element)target, stack.push((Element)target, cc, null, null), lvars, ruleInfo) && ok;
            ++cc;
        }
        List rules = rule.getChildrenByName("rule");
        cc = 0;
        for (Element child : rules) {
            ok = this.validateRule(errors, src, group, child, stack.push(child, cc, null, null), lvars) && ok;
            ++cc;
        }
        List dependents = rule.getChildrenByName("dependent");
        cc = 0;
        for (Element dependent : dependents) {
            ok = this.validateDependent(errors, src, group, dependent, stack.push(dependent, cc, null, null), lvars) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean validateRuleSource(List<ValidationMessage> errors, Element src, Element group, Element rule, Element source, NodeStack stack, VariableSet variables, RuleInformation ruleInfo, int loopCounter) {
        boolean ok;
        String context = source.getChildValue("context");
        if (loopCounter > 0) {
            ruleInfo.setDefVariable(null);
        }
        boolean bl = ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), this.idIsValid(context), "SM_NAME_INVALID", context) && this.rule(errors, "2023-03-01", ValidationMessage.IssueType.UNKNOWN, source.line(), source.col(), stack.getLiteralPath(), variables.hasVariable(context, true), "SM_SOURCE_CONTEXT_UNKNOWN", context);
        if (ok) {
            VariableDefn v = variables.getVariable(context, true);
            if (v.hasTypeInfo()) {
                String element = source.getChildValue("element");
                if (element != null) {
                    String path = v.getEd().getPath() + "." + element;
                    String variable = source.getChildValue("variable");
                    VariableDefn vn = null;
                    if (this.hint(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), variable != null, "SM_RULE_SOURCE_UNASSIGNED")) {
                        if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), this.idIsValid(variable), "SM_NAME_INVALID", variable)) {
                            vn = variables.add(variable, v.getMode());
                            if (loopCounter == 0) {
                                ruleInfo.setDefVariable(variable);
                            }
                        } else {
                            ok = false;
                        }
                    }
                    List<ElementDefinitionSource> els = this.getElementDefinitions(v.getSd(), v.getEd(), v.getType(), element);
                    if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), !els.isEmpty(), "SM_SOURCE_PATH_INVALID", context, element, path)) {
                        if (this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), els.size() == 1, "SM_TARGET_PATH_MULTIPLE_MATCHES", context, element, v.getEd().getPath() + "." + element, this.render(els))) {
                            ElementDefinitionSource el = els.get(0);
                            String type = source.getChildValue("type");
                            if (type != null) {
                                ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), this.hasType(el.getEd(), type), "SM_SOURCE_TYPE_INVALID", type, path, el.getEd().typeSummary()) && ok;
                            }
                            String min = source.getChildValue("min");
                            this.hint(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), min == null || this.isMoreOrEqual(min, v.getEd().getMin()), "SM_RULE_SOURCE_MIN_REDUNDANT", min, v.getEd().getMin());
                            int existingMax = this.multiplyCardinality(v.getMax(), el.getEd().getMax());
                            String max = source.getChildValue("max");
                            int iMax = this.readMax(max, existingMax);
                            this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, source.line(), source.col(), stack.getLiteralPath(), iMax <= existingMax, "SM_RULE_SOURCE_MAX_REDUNDANT", max, v.getMax());
                            ruleInfo.seeCardinality(iMax);
                            if (vn != null) {
                                vn.setType(iMax, el.getSd(), el.getEd(), type);
                            }
                        }
                    } else {
                        ok = false;
                    }
                }
            } else {
                String variable = source.getChildValue("variable");
                if (variable != null) {
                    variables.add(variable, v.getMode());
                }
            }
        }
        return ok;
    }

    private boolean hasType(ElementDefinition ed, String type) {
        for (ElementDefinition.TypeRefComponent td : ed.getType()) {
            StructureDefinition sd = this.context.fetchTypeDefinition(td.getWorkingCode());
            if (sd == null || !type.equals(sd.getType())) continue;
            return true;
        }
        return false;
    }

    private int readMax(String max, int existingMax) {
        if (max == null || !Utilities.isInteger((String)max)) {
            return existingMax;
        }
        return Integer.parseInt(max);
    }

    private int multiplyCardinality(int max, String max2) {
        if (max == Integer.MAX_VALUE || "*".equals(max2)) {
            return Integer.MAX_VALUE;
        }
        return max * Integer.parseInt(max2);
    }

    private boolean validateRuleTarget(List<ValidationMessage> errors, Element src, Element group, Element rule, Element target, NodeStack stack, VariableSet variables, RuleInformation ruleInfo) {
        VariableDefn v;
        boolean ok;
        String context = target.getChildValue("context");
        if (context == null) {
            return true;
        }
        boolean bl = ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), this.idIsValid(context), "SM_NAME_INVALID", context) && this.rule(errors, "2023-03-01", ValidationMessage.IssueType.UNKNOWN, target.line(), target.col(), stack.getLiteralPath(), variables.hasVariable(context, false), "SM_TARGET_CONTEXT_UNKNOWN", context);
        if (ok && (v = variables.getVariable(context, false)).hasTypeInfo()) {
            String element;
            String listMode = target.getChildValue("listMode");
            String listRuleId = target.getChildValue("listRuleId");
            this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), listRuleId == null || "share".equals(listMode), "SM_LIST_RULE_ID_ONLY_WHEN_SHARE", new Object[0]);
            if (!ruleInfo.isList()) {
                this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), listMode == null, "SM_NO_LIST_MODE_NEEDED", new Object[0]);
                this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), listRuleId == null, "SM_NO_LIST_RULE_ID_NEEDED", new Object[0]);
            }
            VariableDefn vn = null;
            String variable = target.getChildValue("variable");
            if (variable != null) {
                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), this.idIsValid(variable), "SM_NAME_INVALID", variable)) {
                    vn = variables.add(variable, v.getMode());
                } else {
                    ok = false;
                }
            }
            if ((element = target.getChildValue("element")) != null) {
                List<ElementDefinitionSource> els = this.getElementDefinitions(v.getSd(), v.getEd(), v.getType(), element);
                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), !els.isEmpty(), "SM_TARGET_PATH_INVALID", context, element, v.getEd().getPath() + "." + element)) {
                    if (this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), els.size() == 1 || this.isElementandSlicing(els), "SM_TARGET_PATH_MULTIPLE_MATCHES", context, element, v.getEd().getPath() + "." + element, this.render(els))) {
                        ElementDefinitionSource el = els.get(0);
                        String transform = target.getChildValue("transform");
                        List params = target.getChildren("parameter");
                        if (transform == null) {
                            transform = "create";
                            this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() == 0, "SM_TARGET_NO_TRANSFORM_NO_CHECKED", transform);
                        }
                        String type = null;
                        type = el.getEd().getType().size() == 1 ? el.getEd().getTypeFirstRep().getWorkingCode() : this.inferType(ruleInfo, variables, rule, transform, params);
                        switch (transform) {
                            case "create": {
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() < 2, "SM_TARGET_TRANSFORM_PARAM_COUNT_RANGE", "create", "0", "1", params.size())) {
                                    StructureDefinition sdt;
                                    if (params.size() != 1) break;
                                    type = ((Element)params.get(0)).getChildValue("value");
                                    if (!Utilities.isAbsoluteUrl((String)type) && !Utilities.isAbsoluteUrl((String)(type = this.resolveType(type, "target", src))) && (sdt = this.context.fetchTypeDefinition(type)) != null) {
                                        type = sdt.getType();
                                    }
                                    this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), type != null, "SM_TARGET_TRANSFORM_TYPE_UNPROCESSIBLE", "create");
                                    break;
                                }
                                ok = false;
                                break;
                            }
                            case "copy": {
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() < 2, "SM_TARGET_TRANSFORM_PARAM_COUNT_RANGE", "create", "0", "1", params.size())) {
                                    if (params.size() != 1) break;
                                    type = ((Element)params.get(0)).getChildValue("value");
                                    this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), type != null, "SM_TARGET_TRANSFORM_TYPE_UNPROCESSIBLE", "copy");
                                    break;
                                }
                                ok = false;
                                break;
                            }
                            case "reference": {
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() == 1, "SM_TARGET_TRANSFORM_PARAM_COUNT_RANGE", "reference", "0", "1", params.size())) {
                                    type = "string";
                                    break;
                                }
                                ok = false;
                                break;
                            }
                            case "evaluate": {
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() == 1, "SM_TARGET_TRANSFORM_PARAM_COUNT_SINGLE", "evaluate", "1", params.size())) {
                                    String exp = ((Element)params.get(0)).getChildValue("value");
                                    if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, ((Element)params.get(0)).line(), ((Element)params.get(0)).col(), stack.getLiteralPath(), exp != null, "SM_TARGET_TRANSFORM_PARAM_UNPROCESSIBLE", "0", params.size())) {
                                        try {
                                            TypeDetails td = this.fpe.check((Object)variables, v.getSd().getUrl(), v.getEd().getPath(), this.fpe.parse(exp));
                                            if (td.getTypes().size() != 1) break;
                                            type = td.getType();
                                        }
                                        catch (Exception e) {
                                            this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, ((Element)params.get(0)).line(), ((Element)params.get(0)).col(), stack.getLiteralPath(), false, "SM_TARGET_TRANSFORM_EXPRESSION_ERROR", e.getMessage());
                                        }
                                        break;
                                    }
                                    ok = false;
                                    break;
                                }
                                ok = false;
                                break;
                            }
                            case "cc": {
                                ok = this.rule(errors, "2023-05-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() == 2 || params.size() == 3, "SM_TARGET_TRANSFORM_MISSING_PARAMS", transform) && ok;
                                ok = this.checkParamExistsOrPrimitive(errors, params.size() > 0 ? ((Element)params.get(0)).getNamedChild("value") : null, "cc", "system", target, variables, stack, ok, true);
                                ok = this.checkParamExistsOrPrimitive(errors, params.size() > 1 ? ((Element)params.get(1)).getNamedChild("value") : null, "cc", "code", target, variables, stack, ok, true);
                                ok = this.checkParamExistsOrPrimitive(errors, params.size() > 2 ? ((Element)params.get(2)).getNamedChild("value") : null, "cc", "display", target, variables, stack, ok, false);
                                break;
                            }
                            case "append": {
                                ok = this.rule(errors, "2023-05-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() > 0, "SM_TARGET_TRANSFORM_MISSING_PARAMS", transform) && ok;
                                for (int i = 0; i < params.size(); ++i) {
                                    ok = this.checkParamExistsOrPrimitive(errors, ((Element)params.get(1)).getNamedChild("value"), "cc", "parameter " + i, target, variables, stack, ok, false);
                                }
                                break;
                            }
                            case "uuid": {
                                ok = this.rule(errors, "2023-05-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() == 0, "SM_TARGET_TRANSFORM_MISSING_PARAMS", transform) && ok;
                                break;
                            }
                            case "translate": {
                                ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), params.size() == 3, "SM_TARGET_TRANSFORM_MISSING_PARAMS", transform) && ok;
                                Element srcE = params.size() > 0 ? ((Element)params.get(0)).getNamedChild("value") : null;
                                Element mapE = params.size() > 1 ? ((Element)params.get(1)).getNamedChild("value") : null;
                                Element modeE = params.size() > 2 ? ((Element)params.get(2)).getNamedChild("value") : null;
                                VariableDefn sv = null;
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), srcE != null, "SM_TARGET_TRANSFORM_TRANSLATE_NO_PARAM", "source")) {
                                    if ("id".equals(srcE.fhirType())) {
                                        sv = variables.getVariable(srcE.getValue(), true);
                                        this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), sv != null, "SM_TARGET_TRANSFORM_TRANSLATE_UNKNOWN_SOURCE", srcE.getValue());
                                    }
                                } else {
                                    ok = false;
                                }
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), mapE != null, "SM_TARGET_TRANSFORM_TRANSLATE_NO_PARAM", "map_uri")) {
                                    String ref = mapE.getValue();
                                    ConceptMap cm = null;
                                    if (ref.startsWith("#")) {
                                        cm = (ConceptMap)this.loadContainedResource(errors, stack.getLiteralPath(), src, ref.substring(1), ConceptMap.class);
                                        ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTFOUND, target.line(), target.col(), stack.getLiteralPath(), srcE != null, "SM_TARGET_TRANSFORM_TRANSLATE_CM_NOT_FOUND", ref) && ok;
                                    } else {
                                        cm = (ConceptMap)this.context.fetchResource(ConceptMap.class, ref);
                                        this.warning(errors, "2023-03-01", ValidationMessage.IssueType.NOTFOUND, target.line(), target.col(), stack.getLiteralPath(), srcE != null, "SM_TARGET_TRANSFORM_TRANSLATE_CM_NOT_FOUND", ref);
                                    }
                                    if (cm != null && (v != null && v.hasTypeInfo() || sv != null && sv.hasTypeInfo())) {
                                        boolean bl2 = ok = this.checkConceptMap(errors, target.line(), target.col(), stack.getLiteralPath(), cm, sv == null ? null : sv.getEd(), el == null ? null : el.getEd()) && ok;
                                    }
                                }
                                if (modeE == null) break;
                                String t = modeE.getValue();
                                if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), Utilities.existsInList((String)t, (String[])new String[]{"code", "system", "display", "Coding", "CodeableConcept"}), "SM_TARGET_TRANSFORM_TRANSLATE_CM_BAD_MODE", t)) break;
                                ok = false;
                                break;
                            }
                            default: {
                                this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), false, "SM_TARGET_TRANSFORM_NOT_CHECKED", transform);
                                ok = false;
                            }
                        }
                        if (vn != null) {
                            this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), type != null, "SM_TARGET_TYPE_MULTIPLE_POSSIBLE", el.getEd().typeSummary());
                            vn.setType(ruleInfo.getMaxCount(), el.getSd(), el.getEd(), type);
                        }
                    }
                } else {
                    ok = false;
                }
            }
        }
        return ok;
    }

    private boolean checkParamExistsOrPrimitive(List<ValidationMessage> errors, Element e, String string, String string2, Element target, VariableSet variables, NodeStack stack, boolean ok, boolean mandatory) {
        if (!mandatory && e == null) {
            return ok;
        }
        if (this.rule(errors, "2023-05-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), e != null, "SM_TARGET_TRANSFORM_TRANSLATE_NO_PARAM", "system")) {
            if ("id".equals(e.fhirType())) {
                VariableDefn sv = variables.getVariable(e.getValue(), true);
                this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), e != null, "SM_TARGET_TRANSFORM_OP_UNKNOWN_SOURCE", "cc", "system", e.getValue());
            } else {
                this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.getLiteralPath(), e.isPrimitive(), "SM_TARGET_TRANSFORM_OP_INVALID_TYPE", "cc", "system", e.fhirType());
            }
            return ok;
        }
        return false;
    }

    private boolean isElementandSlicing(List<ElementDefinitionSource> els) {
        if (els.size() == 0) {
            return false;
        }
        String path = els.get(0).getEd().getPath();
        for (int i = 1; i < els.size(); ++i) {
            if (els.get(i).getEd().hasSliceName() && els.get(i).getEd().getPath().equals(path)) continue;
            return false;
        }
        return true;
    }

    private boolean checkConceptMap(List<ValidationMessage> errors, int line, int col, String literalPath, ConceptMap cm, ElementDefinition srcED, ElementDefinition tgtED) {
        ValueSetExpansionOutcome vse;
        ValueSet vs;
        ValueSetExpansionOutcome vse2;
        boolean ok = true;
        ValueSet srcVS = null;
        if (srcED != null && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, srcED.getBinding().hasValueSet() && srcED.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED, "SM_TARGET_TRANSLATE_BINDING_SOURCE", new Object[0]) && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, (srcVS = (ValueSet)this.context.fetchResource(ValueSet.class, srcED.getBinding().getValueSet())) != null, "SM_TARGET_TRANSLATE_BINDING_VS_SOURCE", new Object[0]) && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, (vse2 = this.context.expandVS(srcVS, true, false)).isOk(), "SM_TARGET_TRANSLATE_BINDING_VSE_SOURCE", vse2.getError())) {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ValueSet.ValueSetExpansionContainsComponent c : vse2.getValueset().getExpansion().getContains()) {
                if (!ConceptMapUtilities.hasMappingForSource((ConceptMap)cm, (String)c.getSystem(), (String)c.getVersion(), (String)c.getCode())) continue;
                b.append(c.getCode());
            }
            if (b.count() > 0) {
                this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, srcED.getBinding().hasValueSet() && srcED.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED, "SM_TARGET_TRANSLATE_BINDING_SOURCE_UNMAPPED", b.toString());
            }
        }
        if (srcED != null && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, tgtED.getBinding().hasValueSet() && tgtED.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED, "SM_TARGET_TRANSLATE_BINDING_TARGET", new Object[0]) && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, (vs = (ValueSet)this.context.fetchResource(ValueSet.class, tgtED.getBinding().getValueSet())) != null, "SM_TARGET_TRANSLATE_BINDING_VS_TARGET", new Object[0]) && this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, (vse = this.context.expandVS(vs, true, false)).isOk(), "SM_TARGET_TRANSLATE_BINDING_VSE_TARGET", vse.getError())) {
            ArrayList<String> systems = new ArrayList<String>();
            if (srcVS != null) {
                for (ValueSet.ConceptSetComponent inc : srcVS.getCompose().getInclude()) {
                    systems.add(inc.getSystem());
                }
            }
            List codes = ConceptMapUtilities.listTargets((ConceptMap)cm, systems);
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding code : codes) {
                if (!ValueSetUtilities.hasCodeInExpansion((ValueSet)vse.getValueset(), (Coding)code)) continue;
                b.append(code.getCode());
            }
            if (b.count() > 0) {
                this.warning(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, line, col, literalPath, srcED.getBinding().hasValueSet() && srcED.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED, "SM_TARGET_TRANSLATE_BINDING_TARGET_WRONG", b.toString());
            }
        }
        return ok;
    }

    private String inferType(RuleInformation ruleInfo, VariableSet variables, Element rule, String transform, List<Element> params) {
        block4: {
            String type;
            List dependents;
            block5: {
                VariableDefn v;
                if (ruleInfo.getDefVariable() == null || !Utilities.existsInList((String)transform, (String[])new String[]{"create", "copy"}) || !params.isEmpty() || (v = variables.getVariable(ruleInfo.getDefVariable(), true)) == null || v.getEd() == null || v.getEd().getType().size() != 1 && v.getType() == null) break block4;
                dependents = rule.getChildrenByName("dependent");
                String string = type = v.getType() != null ? this.getTypeFromDefn(v.getEd(), v.getType()) : v.getEd().getTypeFirstRep().getWorkingCode();
                if (dependents.size() != 1 || !"DefaultMappingGroupAnonymousAlias".equals(((Element)dependents.get(0)).getChildValue("name"))) break block5;
                for (StructureMap map : this.imports) {
                    for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
                        String tgtType;
                        String grpType;
                        if (grp.getTypeMode() == StructureMap.StructureMapGroupTypeMode.NULL || grp.getInput().size() != 2 || !this.sameTypes(type, grpType = this.getTypeForGroupInput(map, grp, (StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0))) || (tgtType = this.getTypeForGroupInput(map, grp, (StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1))) == null) continue;
                        return tgtType;
                    }
                }
                break block4;
            }
            if (dependents.size() != 0) break block4;
            for (StructureMap map : this.imports) {
                for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
                    String tgtType;
                    String grpType;
                    if (grp.getTypeMode() != StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES || grp.getInput().size() != 2 || !this.sameTypes(type, grpType = this.getTypeForGroupInput(map, grp, (StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0))) || (tgtType = this.getTypeForGroupInput(map, grp, (StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1))) == null) continue;
                    return tgtType;
                }
            }
        }
        return null;
    }

    private String getTypeFromDefn(ElementDefinition ed, String type) {
        for (ElementDefinition.TypeRefComponent td : ed.getType()) {
            StructureDefinition sd = this.context.fetchTypeDefinition(td.getWorkingCode());
            if (sd == null || !type.equals(sd.getType())) continue;
            return td.getWorkingCode();
        }
        return type;
    }

    private boolean sameTypes(String type1, String type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (!Utilities.isAbsoluteUrl((String)type1)) {
            type1 = "http://hl7.org/fhir/StructureDefinition/" + (String)type1;
        }
        if (!Utilities.isAbsoluteUrl((String)type2)) {
            type2 = "http://hl7.org/fhir/StructureDefinition/" + (String)type2;
        }
        return ((String)type1).equals(type2);
    }

    private String getTypeForGroupInput(StructureMap map, StructureMap.StructureMapGroupComponent grp, StructureMap.StructureMapGroupInputComponent input) {
        if (input == null) {
            return null;
        }
        String type = input.getType();
        if (type == null) {
            return null;
        }
        StructureMap.StructureMapModelMode mode = input.getMode() == StructureMap.StructureMapInputMode.SOURCE ? StructureMap.StructureMapModelMode.SOURCE : StructureMap.StructureMapModelMode.TARGET;
        for (StructureMap.StructureMapStructureComponent st : map.getStructure()) {
            if (!type.equals(st.getAlias()) || mode != st.getMode()) continue;
            return st.getUrl();
        }
        return type;
    }

    private List<String> listTypes(List<ElementDefinition.TypeRefComponent> types) {
        ArrayList<String> res = new ArrayList<String>();
        for (ElementDefinition.TypeRefComponent td : types) {
            res.add(td.getWorkingCode());
        }
        Collections.sort(res);
        return res;
    }

    private String render(List<ElementDefinitionSource> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinitionSource t : list) {
            b.append(t.getEd().getId());
        }
        return b.toString();
    }

    private List<ElementDefinitionSource> getElementDefinitions(StructureDefinition sd, ElementDefinition ed, String type, String element) {
        ArrayList<ElementDefinitionSource> result = new ArrayList<ElementDefinitionSource>();
        List children = this.profileUtilities.getChildList(sd, ed);
        if (children == null || children.isEmpty()) {
            this.getElementDefinitionChildrenFromTypes(result, sd, ed, type, element);
        } else {
            for (ElementDefinition t : children) {
                if (!t.getNameBase().equals(element)) continue;
                if (t.hasContentReference()) {
                    StructureDefinition sdt;
                    String url = t.getContentReference().substring(0, t.getContentReference().indexOf("#"));
                    String path = t.getContentReference().substring(t.getContentReference().indexOf("#") + 1);
                    StructureDefinition structureDefinition = sdt = "".equals(url) || url.equals(sd.getUrl()) ? sd : (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
                    if (sdt == null) {
                        throw new Error("Unable to resolve " + url);
                    }
                    ElementDefinition t2 = sdt.getSnapshot().getElementByPath(path);
                    if (t2 == null) {
                        throw new Error("Unable to resolve " + path + " in " + url);
                    }
                    result.add(new ElementDefinitionSource(sdt, t2));
                    continue;
                }
                result.add(new ElementDefinitionSource(sd, t));
            }
        }
        return result;
    }

    private void getElementDefinitionChildrenFromTypes(List<ElementDefinitionSource> result, StructureDefinition sd, ElementDefinition ed, String type, String element) {
        for (ElementDefinition.TypeRefComponent td : ed.getType()) {
            String tn = td.getWorkingCode();
            StructureDefinition sdt = this.context.fetchTypeDefinition(tn);
            if (type != null && !tn.equals(type) && (sdt == null || !sdt.getType().equals(type))) continue;
            StructureDefinition tsd = this.context.fetchTypeDefinition(td.getWorkingCode());
            if (tsd != null) {
                for (ElementDefinition t : tsd.getSnapshot().getElement()) {
                    if (Utilities.charCount((String)t.getPath(), (char)'.') != 1 || !t.getNameBase().equals(element)) continue;
                    result.add(new ElementDefinitionSource(tsd, t));
                }
                continue;
            }
            System.out.println("Unable to find type " + type);
        }
    }

    private boolean isLessOrEqual(String value, String limit) {
        if (Utilities.isInteger((String)value) || !Utilities.isInteger((String)limit)) {
            int l;
            int v = Integer.parseInt(value);
            return v <= (l = Integer.parseInt(limit));
        }
        return true;
    }

    private boolean isMoreOrEqual(String value, int limit) {
        if (Utilities.isInteger((String)value)) {
            int v = Integer.parseInt(value);
            return v >= limit;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateDependent(List<ValidationMessage> errors, Element src, Element group, Element dependent, NodeStack stack, VariableSet variables) {
        block10: {
            block11: {
                block9: {
                    ok = true;
                    name = dependent.getChildValue("name");
                    if (!"DefaultMappingGroupAnonymousAlias".equals(name)) break block9;
                    srcVar = variables.getVariable("vvv", true);
                    tgtVar = variables.getVariable("vvv", false);
                    if (srcVar != null && srcVar.hasTypeInfo() && tgtVar != null && tgtVar.hasTypeInfo()) {
                        srcType = srcVar.getWorkingType();
                        tgtType = tgtVar.getWorkingType();
                        if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTFOUND, dependent.line(), dependent.col(), stack.getLiteralPath(), srcType != null, "SM_SOURCE_TYPE_NOT_FOUND", new Object[0]) && this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTFOUND, dependent.line(), dependent.col(), stack.getLiteralPath(), tgtType != null, "SM_TARGET_TYPE_NOT_FOUND", new Object[0])) {
                            grp = this.findDefaultGroup(src, srcType, tgtType);
                            ok = this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTFOUND, dependent.line(), dependent.col(), stack.getLiteralPath(), grp != null, "SM_MATCHING_RULEGROUP_NOT_FOUND", new Object[]{srcType, tgtType}) != false && ok != false;
                        } else {
                            ok = false;
                        }
                    }
                    break block10;
                }
                grp = this.resolveGroup(name, src);
                if (!this.rule(errors, "2023-03-01", ValidationMessage.IssueType.NOTFOUND, dependent.line(), dependent.col(), stack.getLiteralPath(), grp != null, "SM_RULEGROUP_NOT_FOUND", new Object[]{name})) break block11;
                params = dependent.getChildren(VersionUtilities.isR5Plus((String)this.context.getVersion()) != false ? "parameter" : "variable");
                if (!this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, dependent.line(), dependent.col(), stack.getLiteralPath(), params.size() == grp.getTargetGroup().getInput().size(), "SM_RULEGROUP_PARAM_COUNT_MISMATCH", new Object[]{name, params.size(), grp.getTargetGroup().getInput().size()})) break block10;
                lvars = new VariableSet();
                cc = 0;
                for (Element param : params) {
                    block13: {
                        block12: {
                            pstack = stack.push(param, cc, null, null);
                            input = (StructureMap.StructureMapGroupInputComponent)grp.getTargetGroup().getInput().get(cc);
                            iType = this.resolveType(grp, input, src);
                            pname = input.getName();
                            v = this.getParameter(errors, param, pstack, variables, input.getMode());
                            if (v == null) break block12;
                            if (!this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, param.line(), param.col(), pstack.getLiteralPath(), v.mode.equals(input.getMode().toCode()), "SM_DEPENDENT_PARAM_MODE_MISMATCH", new Object[]{param.getChildValue("name"), v.mode, input.getMode().toCode(), grp.getTargetGroup().getName()})) ** GOTO lbl-1000
                            v0 = new Object[6];
                            v0[0] = pname;
                            v0[1] = v.summary();
                            v0[2] = input.getType();
                            v0[3] = grp.getTargetGroup().getName();
                            v0[4] = input.getType();
                            v1 = v0[5] = grp.getTargetMap() == null ? "$this" : grp.getTargetMap().getVersionedUrl();
                            if (this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, param.line(), param.col(), pstack.getLiteralPath(), this.typesMatch(v, iType), "SM_DEPENDENT_PARAM_TYPE_MISMATCH", v0)) {
                                lvars.add(pname, v);
                            } else lbl-1000:
                            // 2 sources

                            {
                                ok = false;
                            }
                            break block13;
                        }
                        ok = false;
                    }
                    ++cc;
                }
                if (ok && grp.getTargetGroup().hasUserData("element.source")) {
                    g = (Element)grp.getTargetGroup().getUserData("element.source");
                    if (g.hasUserData("structuremap.parameters")) {
                        pvars = (VariableSet)g.getUserData("structuremap.parameters");
                        this.rule(errors, "2023-03-01", ValidationMessage.IssueType.INVALID, dependent.line(), dependent.col(), stack.getLiteralPath(), pvars.matches(lvars), "SM_DEPENDENT_PARAM_TYPE_MISMATCH_DUPLICATE", new Object[]{grp.getTargetGroup().getName(), pvars.summary(), lvars.summary()});
                    } else {
                        g.setUserData("structuremap.parameters", (Object)lvars);
                    }
                }
                break block10;
            }
            ok = false;
        }
        return ok;
    }

    private String resolveType(ResolvedGroup grp, StructureMap.StructureMapGroupInputComponent input, Element map) {
        if (grp.getTargetMap() == null) {
            List structures = map.getChildrenByName("structure");
            for (Element structure : structures) {
                String alias = structure.getChildValue("alias");
                if (alias == null || !alias.equals(input.getType())) continue;
                return structure.getChildValue("url");
            }
        } else {
            for (StructureMap.StructureMapStructureComponent struc : grp.getTargetMap().getStructure()) {
                if (!struc.hasAlias() || !struc.getAlias().equals(input.getType())) continue;
                return struc.getUrl();
            }
        }
        return input.getType();
    }

    private String resolveType(String type, String mode, Element map) {
        List structures = map.getChildrenByName("structure");
        for (Element structure : structures) {
            String alias = structure.getChildValue("alias");
            if (alias == null || !alias.equals(type) || mode != null && !mode.equals(structure.getNamedChildValue("mode"))) continue;
            return structure.getChildValue("url");
        }
        return type;
    }

    private StructureMap.StructureMapGroupComponent findDefaultGroup(Element src, String srcType, String tgtType) {
        List groups = src.getChildrenByName("group");
        for (Element group : groups) {
            List inputs;
            if (!Utilities.existsInList((String)group.getChildValue("typeMode"), (String[])new String[]{"types", "type-and-types"}) || (inputs = group.getChildrenByName("input")).size() != 2 || !"source".equals(((Element)inputs.get(0)).getChildValue("mode")) || !"source".equals(((Element)inputs.get(0)).getChildValue("mode"))) continue;
            String srcT = this.resolveInputType(src, (Element)inputs.get(0));
            String tgtT = this.resolveInputType(src, (Element)inputs.get(1));
            if (!this.sameTypes(srcT, srcType) || !this.sameTypes(tgtT, tgtType)) continue;
            return this.makeGroupComponent(group);
        }
        for (StructureMap map : this.imports) {
            for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
                if (grp.getTypeMode() != StructureMap.StructureMapGroupTypeMode.TYPES && grp.getTypeMode() != StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES || grp.getInput().size() != 2 || ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0)).getMode() != StructureMap.StructureMapInputMode.SOURCE || ((StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1)).getMode() != StructureMap.StructureMapInputMode.TARGET) continue;
                String srcT = this.resolveInputType(map, (StructureMap.StructureMapGroupInputComponent)grp.getInput().get(0));
                String tgtT = this.resolveInputType(map, (StructureMap.StructureMapGroupInputComponent)grp.getInput().get(1));
                if (!this.sameTypes(srcT, srcType) || !this.sameTypes(tgtT, tgtType)) continue;
                return grp;
            }
        }
        return null;
    }

    private String resolveInputType(StructureMap map, StructureMap.StructureMapGroupInputComponent input) {
        String type = input.getType();
        if (type == null) {
            return null;
        }
        for (StructureMap.StructureMapStructureComponent structure : map.getStructure()) {
            if (!type.equals(structure.getAlias())) continue;
            return structure.getUrl();
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd == null ? null : sd.getUrl();
    }

    private String resolveInputType(Element src, Element input) {
        String type = input.getChildValue("type");
        if (type == null) {
            return null;
        }
        for (Element structure : input.getChildren("structure")) {
            if (!type.equals(structure.getChildValue("alias"))) continue;
            return structure.getChildValue("url");
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd == null ? null : sd.getUrl();
    }

    private boolean typesMatch(VariableDefn v, String type) {
        if (type == null || !v.hasTypeInfo()) {
            return true;
        }
        if (v.getSd().getUrl().equals(type) || v.getSd().getType().equals(type)) {
            return true;
        }
        if (v.getType() != null && v.getType().equals(type)) {
            return true;
        }
        for (ElementDefinition.TypeRefComponent tr : v.getEd().getType()) {
            if (!type.equals(tr.getWorkingCode()) && !type.equals("http://hl7.org/fhir/StructureDefinition/" + tr.getWorkingCode())) continue;
            return true;
        }
        StructureDefinition tsd = this.context.fetchTypeDefinition(type);
        if (tsd == null) {
            return false;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(v.getType());
        while (sd != null) {
            if (sd.getUrl().equals(tsd.getUrl())) {
                return true;
            }
            sd = this.context.fetchTypeDefinition(sd.getBaseDefinition());
        }
        return false;
    }

    private VariableDefn getParameter(List<ValidationMessage> errors, Element param, NodeStack pstack, VariableSet variables, StructureMap.StructureMapInputMode mode) {
        if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
            Element v = param.getNamedChild("value");
            if (v.fhirType().equals("id")) {
                return variables.getVariable(v.primitiveValue(), mode == StructureMap.StructureMapInputMode.SOURCE);
            }
            String type = v.fhirType();
            StructureDefinition sd = this.context.fetchTypeDefinition(type);
            return new VariableDefn("$", "source").setType(1, sd, sd.getSnapshot().getElementFirstRep(), null);
        }
        return variables.getVariable(param.primitiveValue(), mode == StructureMap.StructureMapInputMode.SOURCE);
    }

    public class VariableSet {
        private List<VariableDefn> list = new ArrayList<VariableDefn>();

        public boolean hasVariable(String name) {
            for (VariableDefn v : this.list) {
                if (!name.equals(v.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean hasVariable(String name, boolean source) {
            for (VariableDefn v : this.list) {
                if (!name.equals(v.getName()) || source != "source".equals(v.getMode())) continue;
                return true;
            }
            return false;
        }

        public VariableDefn add(String name, String mode) {
            this.list.removeIf(item -> item.getName().equals(name) && item.getMode().equals(mode));
            VariableDefn v = new VariableDefn(name, mode);
            this.list.add(v);
            return v;
        }

        public VariableSet copy() {
            VariableSet set = new VariableSet();
            for (VariableDefn v : this.list) {
                set.list.add(v.copy());
            }
            return set;
        }

        public VariableDefn getVariable(String name, boolean source) {
            for (VariableDefn v : this.list) {
                if (!name.equals(v.getName()) || source != "source".equals(v.getMode())) continue;
                return v;
            }
            return null;
        }

        public VariableDefn getVariable(String name) {
            VariableDefn t = null;
            for (VariableDefn v : this.list) {
                if (!name.equals(v.getName())) continue;
                t = t == null ? v : null;
            }
            return t;
        }

        public void add(String pname, VariableDefn v) {
            VariableDefn vn = v.copy();
            vn.name = pname;
            this.list.add(vn);
        }

        public String summary() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (VariableDefn v : this.list) {
                b.append(v.summary());
            }
            return b.toString();
        }

        public boolean matches(VariableSet other) {
            if (this.list.size() != other.list.size()) {
                return false;
            }
            for (int i = 0; i < this.list.size(); ++i) {
                if (this.list.get(i).matches(other.list.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public class VariableDefn {
        private String name;
        private String mode;
        private int max;
        private StructureDefinition sd;
        private ElementDefinition ed;
        private String type;

        protected VariableDefn(String name, String mode) {
            this.name = name;
            this.mode = mode;
        }

        public VariableDefn setType(int max, StructureDefinition sd, ElementDefinition ed, String type) {
            this.max = max;
            this.sd = sd;
            this.ed = ed;
            this.type = type;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getMode() {
            return this.mode;
        }

        public VariableDefn copy() {
            VariableDefn n = new VariableDefn(this.name, this.mode);
            n.max = this.max;
            n.sd = this.sd;
            n.ed = this.ed;
            n.type = this.type;
            return n;
        }

        public boolean hasTypeInfo() {
            return this.sd != null;
        }

        public int getMax() {
            return this.max;
        }

        public StructureDefinition getSd() {
            return this.sd;
        }

        public ElementDefinition getEd() {
            return this.ed;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getWorkingType() {
            if (this.type != null) {
                if (this.ed != null) {
                    for (ElementDefinition.TypeRefComponent td : this.ed.getType()) {
                        StructureDefinition sd = StructureMapValidator.this.context.fetchTypeDefinition(td.getWorkingCode());
                        if (sd == null || !sd.getType().equals(this.type)) continue;
                        return td.getWorkingCode();
                    }
                }
                return this.type;
            }
            if (this.ed != null) {
                if (!this.ed.getPath().contains(".")) {
                    return this.ed.getPath();
                }
                if (StructureMapValidator.this.isAbstractType(this.ed.getType())) {
                    return this.sd.getUrl() + "#" + this.ed.getPath();
                }
                if (this.ed.getType().size() == 1) {
                    return ((ElementDefinition.TypeRefComponent)this.ed.getType().get(0)).getWorkingCode();
                }
            }
            return null;
        }

        public String summary() {
            return this.mode + " " + this.getWorkingType() + " " + this.name;
        }

        public boolean matches(VariableDefn other) {
            if (!this.name.equals(other.name) || !this.mode.equals(other.mode)) {
                return false;
            }
            if (this.sd == null && other.sd == null) {
                return true;
            }
            if (this.sd == null || other.sd == null) {
                return false;
            }
            return this.sd.getUrl().equals(other.sd.getUrl()) && this.ed.getPath().equals(other.ed.getPath()) && Utilities.stringsEqual((String)this.type, (String)other.type);
        }

        public String toString() {
            return this.summary();
        }
    }

    public class RuleInformation {
        int maxCount = 1;
        String defVariable;

        public void seeCardinality(int max) {
            this.maxCount = max == Integer.MAX_VALUE || this.maxCount == Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.maxCount *= max);
        }

        public boolean isList() {
            return this.maxCount > 1;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public String getDefVariable() {
            return this.defVariable;
        }

        public void setDefVariable(String defVariable) {
            this.defVariable = defVariable;
        }
    }

    public class ElementDefinitionSource {
        private StructureDefinition sd;
        private ElementDefinition ed;

        protected ElementDefinitionSource(StructureDefinition sd, ElementDefinition ed) {
            this.sd = sd;
            this.ed = ed;
        }

        public StructureDefinition getSd() {
            return this.sd;
        }

        public ElementDefinition getEd() {
            return this.ed;
        }
    }
}

