/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;

public class CodeSystemValidator
extends BaseValidator {
    public CodeSystemValidator(IWorkerContext context, XVerExtensionManager xverManager) {
        super(context, xverManager);
    }

    public List<ValidationMessage> validate(CodeSystem cs, boolean forBuild) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        this.checkCodesUnique(cs, errors);
        return errors;
    }

    private void checkCodesUnique(CodeSystem cs, List<ValidationMessage> errors) {
        HashSet<String> codes = new HashSet<String>();
        this.checkCodes(codes, cs.getConcept(), "CodeSystem.where(id = '" + cs.getId() + "')", errors);
    }

    private void checkCodes(Set<String> codes, List<CodeSystem.ConceptDefinitionComponent> list, String path, List<ValidationMessage> errors) {
        for (CodeSystem.ConceptDefinitionComponent cc : list) {
            String npath = path + ".concept.where(code = '" + cc.getCode() + "')";
            if (codes.contains(cc.getCode())) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, npath, false, "Duplicate Code " + cc.getCode(), new Object[0]);
            }
            codes.add(cc.getCode());
            this.checkCodes(codes, cc.getConcept(), npath, errors);
        }
    }
}

