/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.util.Collections;
import java.util.Comparator;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.ValueSet;

public class TxTesterSorters {
    public static void sortParameters(Parameters po) {
        Collections.sort(po.getParameter(), new ParameterSorter());
    }

    public static void sortValueSet(ValueSet vs) {
        Collections.sort(vs.getExtension(), new ExtensionSorter());
        if (vs.hasExpansion()) {
            Collections.sort(vs.getExpansion().getParameter(), new ExpParameterSorter());
            Collections.sort(vs.getExpansion().getProperty(), new PropertyDefnSorter());
            Collections.sort(vs.getExpansion().getExtension(), new ExtensionSorter());
            for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
                TxTesterSorters.sortContainsFeatures(cc);
            }
        }
    }

    public static void sortContainsFeatures(ValueSet.ValueSetExpansionContainsComponent cc) {
        Collections.sort(cc.getExtension(), new ExtensionSorter());
        Collections.sort(cc.getDesignation(), new DesignationSorter());
        Collections.sort(cc.getProperty(), new PropertyValueSorter());
        for (ValueSet.ValueSetExpansionContainsComponent c : cc.getContains()) {
            TxTesterSorters.sortContainsFeatures(c);
        }
    }

    public static class ParameterSorter
    implements Comparator<Parameters.ParametersParameterComponent> {
        @Override
        public int compare(Parameters.ParametersParameterComponent o1, Parameters.ParametersParameterComponent o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            Collections.sort(o1.getPart(), new ParameterSorter());
            Collections.sort(o2.getPart(), new ParameterSorter());
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class ExpParameterSorter
    implements Comparator<ValueSet.ValueSetExpansionParameterComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionParameterComponent o1, ValueSet.ValueSetExpansionParameterComponent o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class PropertyValueSorter
    implements Comparator<ValueSet.ConceptPropertyComponent> {
        @Override
        public int compare(ValueSet.ConceptPropertyComponent o1, ValueSet.ConceptPropertyComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class ExtensionSorter
    implements Comparator<Extension> {
        @Override
        public int compare(Extension o1, Extension o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }

    public static class PropertyDefnSorter
    implements Comparator<ValueSet.ValueSetExpansionPropertyComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionPropertyComponent o1, ValueSet.ValueSetExpansionPropertyComponent o2) {
            int i = o1.getUri().compareTo(o2.getUri());
            if (i == 0) {
                return o1.getCode().compareTo(o2.getCode());
            }
            return i;
        }
    }

    public static class DesignationSorter
    implements Comparator<ValueSet.ConceptReferenceDesignationComponent> {
        @Override
        public int compare(ValueSet.ConceptReferenceDesignationComponent o1, ValueSet.ConceptReferenceDesignationComponent o2) {
            if (o1.hasLanguage() && o2.hasLanguage()) {
                return o1.getLanguage().compareTo(o2.getLanguage());
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

