/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceFactory;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.utils.structuremap.ResolvedGroup;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.ValidatorUtils;

public class R4R5MapTester {
    private boolean saveProcess = false;
    private SimpleWorkerContext context;
    private FilesystemPackageCacheManager pcm;
    private StructureMapUtilities utils;
    private List<StructureMap> allMaps;

    public static void main(String[] args) throws JsonException, IOException {
        new R4R5MapTester().testMaps(args[0]);
    }

    public void testMaps(String src) throws JsonException, IOException {
        this.log("Load Test Outcomes");
        JsonObject json = JsonParser.parseObjectFromFile((String)Utilities.path((String[])new String[]{src, "input", "_data", "conversions.json"}));
        this.log("Load R5");
        this.pcm = new FilesystemPackageCacheManager(true);
        this.context = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(this.pcm.loadPackage("hl7.fhir.r5.core#current"));
        this.log("Load Maps");
        this.loadPackage("hl7.fhir.uv.extensions#dev");
        this.loadPackage("hl7.fhir.r4.core#4.0.1");
        this.loadPackage("hl7.fhir.r4b.core#4.3.0");
        this.log("Load R4 Examples");
        NpmPackage r4Examples = this.pcm.loadPackage("hl7.fhir.r4.examples");
        this.log("Load R4B Examples");
        NpmPackage r4bExamples = this.pcm.loadPackage("hl7.fhir.r4b.examples");
        this.utils = new StructureMapUtilities((IWorkerContext)this.context);
        this.allMaps = this.context.fetchResourcesByType(StructureMap.class);
        this.log("Go. " + this.context.getResourceNames().size() + " types of resources");
        this.log("Map Count = " + this.allMaps.size());
        boolean changed = false;
        for (JsonProperty jp : json.getProperties()) {
            String rn = jp.getName();
            this.log("  " + rn);
            JsonObject o = json.getJsonObject(rn);
            StructureDefinition sd = this.context.fetchTypeDefinition(rn);
            List mapSrc = this.utils.getMapsForUrl(this.allMaps, sd.getUrl(), StructureMap.StructureMapInputMode.SOURCE);
            List mapTgt = this.utils.getMapsForUrl(this.allMaps, sd.getUrl(), StructureMap.StructureMapInputMode.TARGET);
            changed = this.checkMaps(sd, o.getJsonObject("r4"), "http://hl7.org/fhir/4.0", mapSrc, mapTgt, r4Examples) || changed;
            changed = this.checkMaps(sd, o.getJsonObject("r4b"), "http://hl7.org/fhir/4.3", mapSrc, mapTgt, r4bExamples) || changed;
        }
        if (changed) {
            JsonParser.compose((JsonElement)json, (OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{src, "input", "_data", "conversions.json"})), (boolean)true);
        }
    }

    private void loadPackage(String pid) throws FHIRException, IOException {
        this.log("Load " + pid);
        NpmPackage npm = this.pcm.loadPackage(pid);
        IWorkerContext.IContextResourceLoader loader = ValidatorUtils.loaderForVersion(npm.fhirVersion());
        loader.setPatchUrls(VersionUtilities.isCorePackage((String)npm.id()));
        int count = this.context.loadFromPackage(npm, loader);
    }

    private boolean checkMaps(StructureDefinition sd, JsonObject json, String ns, List<StructureMap> mapSrc, List<StructureMap> mapTgt, NpmPackage examples) throws IOException {
        List src = this.utils.getMapsForUrlPrefix(mapSrc, ns, StructureMap.StructureMapInputMode.TARGET);
        List tgt = this.utils.getMapsForUrlPrefix(mapTgt, ns, StructureMap.StructureMapInputMode.SOURCE);
        if (src.size() + tgt.size() == 0) {
            json.set("status", "No Maps Defined");
            json.set("testColor", "#dddddd");
            json.set("testMessage", "--");
        } else {
            boolean isDraft = false;
            for (StructureMap map : src) {
                isDraft = map.getStatus() == Enumerations.PublicationStatus.DRAFT || isDraft;
            }
            for (StructureMap map : tgt) {
                isDraft = map.getStatus() == Enumerations.PublicationStatus.DRAFT || isDraft;
            }
            json.set("status", src.size() + tgt.size() + " Maps Defined" + (isDraft ? " (draft)" : ""));
            json.set("testColor", "#ffcccc");
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
                if (tgt.size() == 1 && src.size() == 1) {
                    StructureMap tgtM = (StructureMap)tgt.get(0);
                    ResolvedGroup tgtG = this.utils.getGroupForUrl(tgtM, sd.getUrl(), StructureMap.StructureMapInputMode.TARGET);
                    String tgtU = this.utils.getInputType(tgtG, StructureMap.StructureMapInputMode.SOURCE);
                    assert (tgtU.startsWith(ns));
                    StructureMap srcM = (StructureMap)src.get(0);
                    ResolvedGroup srcG = this.utils.getGroupForUrl(srcM, sd.getUrl(), StructureMap.StructureMapInputMode.SOURCE);
                    String srcU = this.utils.getInputType(srcG, StructureMap.StructureMapInputMode.TARGET);
                    assert (srcU.startsWith(ns));
                    if (!srcU.equals(tgtU)) {
                        json.set("testMessage", "Maps do not round trip to same resource (" + Utilities.tail((String)srcU) + " -> " + Utilities.tail((String)tgtU) + ") - can't test");
                    } else {
                        StructureDefinition tsd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, srcU);
                        if (tsd == null) {
                            json.set("testMessage", "Undefined type " + srcU);
                        } else {
                            this.testRoundTrips(sd, json, tgtG, srcG, tsd, examples);
                        }
                    }
                } else {
                    json.set("testMessage", "Multiple matching maps (" + src.size() + "/" + tgt.size() + ") - no tests performed");
                }
            } else {
                json.set("testColor", "#eeeeee");
                json.set("testMessage", "n/a");
            }
        }
        return true;
    }

    private void testRoundTrips(StructureDefinition sd, JsonObject json, ResolvedGroup tgtG, ResolvedGroup srcG, StructureDefinition tsd, NpmPackage examples) throws IOException {
        Stats stats = new Stats();
        for (String s : examples.listResources(new String[]{tsd.getType()})) {
            this.log("  Test " + examples.id() + "::" + s);
            try {
                this.testRoundTrip(sd, tsd, tgtG, srcG, stats, examples.load("package", s));
            }
            catch (Exception e) {
                this.log("error: " + e.getMessage());
                stats.error("Error: " + e.getMessage());
            }
        }
        json.set("total", stats.totalCount());
        json.set("parsed", stats.parseCount());
        json.set("testMessage", stats.summary());
        if (stats.ok()) {
            json.set("testColor", "#d4ffdf");
        }
    }

    private void testRoundTrip(StructureDefinition sd, StructureDefinition tsd, ResolvedGroup tgtG, ResolvedGroup srcG, Stats stats, InputStream stream) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        stats.example();
        Element r4 = new org.hl7.fhir.r5.elementmodel.JsonParser((IWorkerContext)this.context).setLogical(tsd).parseSingle(stream);
        stats.parsed();
        String id = r4.getIdBase();
        this.checkSave(id, "src.loaded", r4);
        Resource r5 = ResourceFactory.createResource((String)sd.getType());
        this.utils.transform((Object)this.context, (Base)r4, tgtG.getTargetMap(), (Base)r4);
        stats.forward();
    }

    private void checkSave(String id, String state, Element e) {
        if (this.saveProcess) {
            // empty if block
        }
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    public class Stats {
        private Set<String> errors = new HashSet<String>();
        private int total;
        private int parsed;
        private int forward;

        public void example() {
            ++this.total;
        }

        public void parsed() {
            ++this.parsed;
        }

        public void error(String s) {
            this.errors.add(s);
        }

        public void forward() {
            ++this.forward;
        }

        public int totalCount() {
            return this.total;
        }

        public int parseCount() {
            return this.parsed;
        }

        public String summary() {
            if (this.errors.size() == 0) {
                return "All OK";
            }
            return String.join((CharSequence)", ", this.errors);
        }

        public boolean ok() {
            return this.errors.size() == 0;
        }
    }
}

