/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class ConceptMapValidator
extends BaseValidator {
    private InstanceValidator parent;

    public ConceptMapValidator(IWorkerContext context, TimeTracker timeTracker, InstanceValidator parent, XVerExtensionManager xverManager, Coding jurisdiction) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
        this.jurisdiction = jurisdiction;
        this.parent = parent;
    }

    public boolean validateConceptMap(List<ValidationMessage> errors, Element cm, NodeStack stack, ValidationOptions options) {
        int ci;
        boolean ok = true;
        HashMap<String, PropertyDefinition> props = new HashMap<String, PropertyDefinition>();
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
            List properties = cm.getChildrenByName("property");
            ci = 0;
            for (Object property : properties) {
                String code = property.getChildValue("code");
                String type = property.getChildValue("type");
                String system = property.getChildValue("system");
                CodeSystem cs = system != null ? this.context.fetchCodeSystem(system) : null;
                ok = this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, property.line(), property.col(), stack.push((Element)property, ci, null, null).getLiteralPath(), !"code".equals(type) || system != null, "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_NO_SYSTEM", new Object[0]) && ok;
                this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, property.line(), property.col(), stack.push((Element)property, ci, null, null).getLiteralPath(), system == null || cs != null, "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_UNKNOWN_SYSTEM", system);
                if (code != null) {
                    props.put(code, new PropertyDefinition(type, system, cs));
                }
                ++ci;
            }
            List attributes = cm.getChildrenByName("additionalAttribute");
            for (Element attribute : attributes) {
                String code = attribute.getChildValue("code");
                String type = attribute.getChildValue("type");
                if (code == null) continue;
                attribs.put(code, type);
            }
        }
        List groups = cm.getChildrenByName("group");
        ci = 0;
        for (Element group : groups) {
            ok = this.validateGroup(errors, group, stack.push(group, ci, null, null), props, attribs) && ok;
            ++ci;
        }
        if (!stack.isContained()) {
            ok = this.checkShareableConceptMap(errors, cm, stack) && ok;
        }
        return ok;
    }

    private boolean validateGroup(List<ValidationMessage> errors, Element grp, NodeStack stack, Map<String, PropertyDefinition> props, Map<String, String> attribs) {
        boolean ok = true;
        CodeSystem srcCS = null;
        CodeSystem tgtCS = null;
        Element e = grp.getNamedChild("source");
        if (this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, grp.line(), grp.col(), stack.getLiteralPath(), e != null, "CONCEPTMAP_GROUP_SOURCE_MISSING", new Object[0])) {
            srcCS = this.context.fetchCodeSystem(e.getValue());
            if (this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), srcCS != null, "CONCEPTMAP_GROUP_SOURCE_UNKNOWN", e.getValue())) {
                if (srcCS.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                    srcCS = null;
                } else if (!this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), this.isOkCodeSystem(srcCS), "CONCEPTMAP_GROUP_SOURCE_INCOMPLETE", e.getValue(), srcCS.getContent().toCode())) {
                    srcCS = null;
                }
            }
        }
        e = grp.getNamedChild("target");
        if (this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, grp.line(), grp.col(), stack.getLiteralPath(), e != null, "CONCEPTMAP_GROUP_TARGET_MISSING", new Object[0])) {
            tgtCS = this.context.fetchCodeSystem(e.getValue());
            if (this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), tgtCS != null, "CONCEPTMAP_GROUP_TARGET_UNKNOWN", e.getValue())) {
                if (tgtCS.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                    tgtCS = null;
                } else if (!this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), this.isOkCodeSystem(tgtCS), "CONCEPTMAP_GROUP_TARGET_INCOMPLETE", e.getValue(), tgtCS.getContent().toCode())) {
                    tgtCS = null;
                }
            }
        }
        List elements = grp.getChildrenByName("element");
        int ci = 0;
        for (Element element : elements) {
            ok = this.validateGroupElement(errors, element, stack.push(element, ci, null, null), srcCS, tgtCS, props, attribs) && ok;
            ++ci;
        }
        return ok;
    }

    private boolean isOkCodeSystem(CodeSystem tgtCS) {
        return tgtCS.getContent() != CodeSystem.CodeSystemContentMode.EXAMPLE && tgtCS.getContent() != CodeSystem.CodeSystemContentMode.FRAGMENT;
    }

    private boolean validateGroupElement(List<ValidationMessage> errors, Element src, NodeStack stack, CodeSystem srcCS, CodeSystem tgtCS, Map<String, PropertyDefinition> props, Map<String, String> attribs) {
        boolean ok = true;
        Element code = src.getNamedChild("code");
        if (code != null && srcCS != null) {
            String c = code.getValue();
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode((CodeSystem)srcCS, (String)c);
            if (this.warningOrError(srcCS.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE, errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), stack.push(code, -1, null, null).getLiteralPath(), cd != null, "CONCEPTMAP_GROUP_SOURCE_CODE_INVALID", c, srcCS.getVersionedUrl())) {
                Element display = src.getNamedChild("display");
                if (display != null) {
                    List displays = CodeSystemUtilities.getDisplays((CodeSystem)srcCS, (CodeSystem.ConceptDefinitionComponent)cd);
                    ok = this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), stack.push(code, -1, null, null).getLiteralPath(), displays.contains(display.getValue()), "CONCEPTMAP_GROUP_SOURCE_DISPLAY_INVALID", display.getValue(), displays) && ok;
                }
            } else {
                ok = false;
            }
        }
        List targets = src.getChildrenByName("target");
        int ci = 0;
        for (Element target : targets) {
            ok = this.validateGroupElementTarget(errors, target, stack.push(target, ci, null, null), srcCS, tgtCS, props, attribs) && ok;
            ++ci;
        }
        return ok;
    }

    private boolean validateGroupElementTarget(List<ValidationMessage> errors, Element tgt, NodeStack stack, CodeSystem srcCS, CodeSystem tgtCS, Map<String, PropertyDefinition> props, Map<String, String> attribs) {
        boolean ok = true;
        Element code = tgt.getNamedChild("code");
        if (code != null && tgtCS != null) {
            String c = code.getValue();
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode((CodeSystem)tgtCS, (String)c);
            if (this.warningOrError(tgtCS.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE, errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), stack.push(code, -1, null, null).getLiteralPath(), cd != null, "CONCEPTMAP_GROUP_TARGET_CODE_INVALID", c, tgtCS.getVersionedUrl())) {
                Element display = tgt.getNamedChild("display");
                if (display != null) {
                    List displays = CodeSystemUtilities.getDisplays((CodeSystem)tgtCS, (CodeSystem.ConceptDefinitionComponent)cd);
                    ok = this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), stack.push(code, -1, null, null).getLiteralPath(), displays.contains(display.getValue()), "CONCEPTMAP_GROUP_TARGET_DISPLAY_INVALID", display.getValue(), displays) && ok;
                }
            } else {
                ok = false;
            }
        }
        if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
            List properties = tgt.getChildrenByName("property");
            int ci = 0;
            for (Element property : properties) {
                ok = this.validateGroupElementTargetProperty(errors, property, stack.push(property, ci, null, null), props) && ok;
                ++ci;
            }
            List attributes = tgt.getChildrenByName("dependsOn");
            ci = 0;
            for (Element attribute : attributes) {
                ok = this.validateGroupElementTargetAttribute(errors, attribute, stack.push(attribute, ci, null, null), attribs) && ok;
                ++ci;
            }
            attributes = tgt.getChildrenByName("product");
            ci = 0;
            for (Element attribute : attributes) {
                ok = this.validateGroupElementTargetAttribute(errors, attribute, stack.push(attribute, ci, null, null), attribs) && ok;
                ++ci;
            }
        }
        return ok;
    }

    private boolean validateGroupElementTargetProperty(List<ValidationMessage> errors, Element property, NodeStack stack, Map<String, PropertyDefinition> props) {
        boolean ok = true;
        Element codeE = property.getNamedChild("code");
        Element valueE = property.getNamedChild("value");
        String code = codeE.getValue();
        if (this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stack.push(codeE, -1, null, null).getLiteralPath(), props.containsKey(code), "CONCEPTMAP_GROUP_TARGET_PROPERTY_INVALID", code, props.keySet())) {
            PropertyDefinition defn = props.get(code);
            NodeStack stackV = stack.push(valueE, -1, null, null);
            if (this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stackV.getLiteralPath(), valueE.fhirType().equals(defn.getType()), "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_MISMATCH", valueE.fhirType(), defn.getType())) {
                if (valueE.fhirType().equals("code")) {
                    ok = defn.getCs() != null ? this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stackV.getLiteralPath(), CodeSystemUtilities.findCode((List)defn.getCs().getConcept(), (String)valueE.getValue()) != null, "CONCEPTMAP_GROUP_TARGET_PROPERTY_CODE_INVALID", valueE.getValue(), defn.getCs().getVersionedUrl()) && ok : false;
                }
            } else {
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean validateGroupElementTargetAttribute(List<ValidationMessage> errors, Element attribute, NodeStack stack, Map<String, String> attribs) {
        boolean ok = true;
        Element codeE = attribute.getNamedChild("attribute");
        Element valueE = attribute.getNamedChild("value");
        String code = codeE.getValue();
        if (this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stack.push(codeE, -1, null, null).getLiteralPath(), attribs.containsKey(code), "CONCEPTMAP_GROUP_TARGET_PROPERTY_INVALID", code, attribs.keySet())) {
            NodeStack stackV = stack.push(valueE, -1, null, null);
            ok = this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stackV.getLiteralPath(), valueE.fhirType().equals(attribs.get(code)), "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_MISMATCH", valueE.fhirType(), attribs.get(code)) && ok;
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean checkShareableConceptMap(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        if (this.parent.isForPublication()) {
            if (this.isHL7(cs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url"), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version"), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title"), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name"), "CONCEPTMAP_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status"), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental"), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description"), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "description") && ok;
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url"), "CONCEPTMAP_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version"), "CONCEPTMAP_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title"), "CONCEPTMAP_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name"), "CONCEPTMAP_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status"), "CONCEPTMAP_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental"), "CONCEPTMAP_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description"), "CONCEPTMAP_SHAREABLE_MISSING", "description");
        }
        return true;
    }

    public class PropertyDefinition {
        private String type;
        private String system;
        private CodeSystem cs;

        protected PropertyDefinition(String type, String system, CodeSystem cs) {
            this.type = type;
            this.system = system;
            this.cs = cs;
        }

        public String getType() {
            return this.type;
        }

        public String getSystem() {
            return this.system;
        }

        public CodeSystem getCs() {
            return this.cs;
        }
    }
}

