/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.ValidatorUtils;

public class ResourceChecker {
    protected static Manager.FhirFormat checkIsResource(SimpleWorkerContext context, boolean debug, byte[] cnt, String filename) {
        System.out.println("   ..Detect format for " + filename);
        try {
            Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.JSON);
            return Manager.FhirFormat.JSON;
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("Not JSON: " + e.getMessage());
            }
            try {
                ValidatorUtils.parseXml(cnt);
                return Manager.FhirFormat.XML;
            }
            catch (Exception e2) {
                if (debug) {
                    System.out.println("Not XML: " + e2.getMessage());
                }
                try {
                    Manager.parse((IWorkerContext)context, (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)Manager.FhirFormat.TURTLE);
                    return Manager.FhirFormat.TURTLE;
                }
                catch (Exception e3) {
                    if (debug) {
                        System.out.println("Not Turtle: " + e3.getMessage());
                    }
                    try {
                        new StructureMapUtilities((IWorkerContext)context, null, null).parse(TextFile.bytesToString((byte[])cnt), null);
                        return Manager.FhirFormat.TEXT;
                    }
                    catch (Exception e4) {
                        if (debug) {
                            System.out.println("Not Text: " + e4.getMessage());
                        }
                        if (debug) {
                            System.out.println("     .. not a resource: " + filename);
                        }
                        return null;
                    }
                }
            }
        }
    }

    protected static Manager.FhirFormat checkIsResource(SimpleWorkerContext context, boolean debug, String path) throws IOException {
        String ext = Utilities.getFileExtension((String)path);
        if (Utilities.existsInList((String)ext, (String[])new String[]{"xml"})) {
            return Manager.FhirFormat.XML;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"json"})) {
            return Manager.FhirFormat.JSON;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"ttl"})) {
            return Manager.FhirFormat.TURTLE;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"map"})) {
            return Manager.FhirFormat.TEXT;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"txt"})) {
            return Manager.FhirFormat.TEXT;
        }
        return ResourceChecker.checkIsResource(context, debug, TextFile.fileToBytes((String)path), path);
    }
}

