/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JSONUtil;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.cli.services.IPackageInstaller;

public class StandAloneValidatorFetcher
implements IResourceValidator.IValidatorResourceFetcher {
    List<String> mappingsUris = new ArrayList<String>();
    private FilesystemPackageCacheManager pcm;
    private IWorkerContext context;
    private IPackageInstaller installer;

    public StandAloneValidatorFetcher(FilesystemPackageCacheManager pcm, IWorkerContext context, IPackageInstaller installer) {
        this.pcm = pcm;
        this.context = context;
        this.installer = installer;
    }

    public Element fetch(Object appContext, String url) throws FHIRException {
        throw new FHIRException("The URL '" + url + "' is not known to the FHIR validator, and has not been provided as part of the setup / parameters");
    }

    public IResourceValidator.ReferenceValidationPolicy validationPolicy(Object appContext, String path, String url) {
        return IResourceValidator.ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS;
    }

    public boolean resolveURL(Object appContext, String path, String url, String type) throws IOException, FHIRException {
        VersionUtilities.VersionURLInfo vu;
        if (!Utilities.isAbsoluteUrl((String)url)) {
            return false;
        }
        if (url.contains("|")) {
            url = url.substring(0, url.lastIndexOf("|"));
        }
        if (type.equals("uri") && this.isMappingUri(url)) {
            return true;
        }
        String pid = null;
        String ver = null;
        String base = this.findBaseUrl(url);
        if (base == null) {
            return !url.startsWith("http://hl7.org/fhir") && !type.equals("canonical");
        }
        pid = base.equals("http://terminology.hl7.org") ? "hl7.terminology" : (url.startsWith("http://hl7.org/fhir") ? this.pcm.getPackageId(base) : this.pcm.findCanonicalInLocalCache(base));
        String string = ver = url.contains("|") ? url.substring(url.indexOf("|") + 1) : null;
        if (pid == null && Utilities.startsWithInList((String)url, (String[])new String[]{"http://hl7.org/fhir", "http://terminology.hl7.org"})) {
            return false;
        }
        if (url.startsWith("http://hl7.org/fhir") && (vu = VersionUtilities.parseVersionUrl((String)url)) != null) {
            NpmPackage pi = this.pcm.loadPackage(VersionUtilities.packageForVersion((String)vu.getVersion()), VersionUtilities.getCurrentVersion((String)vu.getVersion()));
            return pi.hasCanonical(vu.getUrl());
        }
        if (pid != null && this.installer.packageExists(pid, ver)) {
            this.installer.loadPackage(pid, ver);
            NpmPackage pi = this.pcm.loadPackage(pid);
            return pi.hasCanonical(url);
        }
        return !url.startsWith("http://hl7.org/fhir") && !type.equals("canonical");
    }

    private boolean isMappingUri(String url) {
        if (this.mappingsUris.isEmpty()) {
            try {
                JsonObject json = JsonTrackingParser.fetchJson((String)"http://hl7.org/fhir/mappingspaces.json");
                for (JsonObject ms : JSONUtil.objects((JsonObject)json, (String)"spaces")) {
                    this.mappingsUris.add(JSONUtil.str((JsonObject)ms, (String)"url"));
                }
            }
            catch (IOException e) {
                this.mappingsUris.add("http://hl7.org/fhir/fivews");
                this.mappingsUris.add("http://hl7.org/fhir/workflow");
                this.mappingsUris.add("http://hl7.org/fhir/interface");
                this.mappingsUris.add("http://hl7.org/v2");
                this.mappingsUris.add("http://loinc.org");
                this.mappingsUris.add("http://snomed.org/attributebinding");
                this.mappingsUris.add("http://snomed.info/conceptdomain");
                this.mappingsUris.add("http://hl7.org/v3/cda");
                this.mappingsUris.add("http://hl7.org/v3");
                this.mappingsUris.add("http://nema.org/dicom");
                this.mappingsUris.add("http://w3.org/vcard");
                this.mappingsUris.add("http://ihe.net/xds");
                this.mappingsUris.add("http://www.w3.org/ns/prov");
                this.mappingsUris.add("http://ietf.org/rfc/2445");
                this.mappingsUris.add("http://www.omg.org/spec/ServD/1.0/");
                this.mappingsUris.add("http://metadata-standards.org/11179/");
                this.mappingsUris.add("http://ihe.net/data-element-exchange");
                this.mappingsUris.add("http://openehr.org");
                this.mappingsUris.add("http://siframework.org/ihe-sdc-profile");
                this.mappingsUris.add("http://siframework.org/cqf");
                this.mappingsUris.add("http://www.cdisc.org/define-xml");
                this.mappingsUris.add("http://www.cda-adc.ca/en/services/cdanet/");
                this.mappingsUris.add("http://www.pharmacists.ca/");
                this.mappingsUris.add("http://www.healthit.gov/quality-data-model");
                this.mappingsUris.add("http://hl7.org/orim");
                this.mappingsUris.add("http://hl7.org/fhir/w5");
                this.mappingsUris.add("http://hl7.org/fhir/logical");
                this.mappingsUris.add("http://hl7.org/fhir/auditevent");
                this.mappingsUris.add("http://hl7.org/fhir/provenance");
                this.mappingsUris.add("http://hl7.org/qidam");
                this.mappingsUris.add("http://cap.org/ecc");
                this.mappingsUris.add("http://fda.gov/UDI");
                this.mappingsUris.add("http://hl7.org/fhir/object-implementation");
                this.mappingsUris.add("http://github.com/MDMI/ReferentIndexContent");
                this.mappingsUris.add("http://ncpdp.org/SCRIPT10_6");
                this.mappingsUris.add("http://clinicaltrials.gov");
                this.mappingsUris.add("http://hl7.org/fhir/rr");
                this.mappingsUris.add("http://www.hl7.org/v3/PORX_RM020070UV");
                this.mappingsUris.add("https://bridgmodel.nci.nih.gov");
                this.mappingsUris.add("http://hl7.org/fhir/composition");
                this.mappingsUris.add("http://hl7.org/fhir/documentreference");
                this.mappingsUris.add("https://en.wikipedia.org/wiki/Identification_of_medicinal_products");
                this.mappingsUris.add("urn:iso:std:iso:11073:10201");
                this.mappingsUris.add("urn:iso:std:iso:11073:10207");
            }
        }
        return this.mappingsUris.contains(url);
    }

    private String findBaseUrl(String url) {
        String[] p = url.split("\\/");
        for (int i = 1; i < p.length; ++i) {
            if (!Utilities.existsInList((String)p[i], (List)this.context.getResourceNames())) continue;
            StringBuilder b = new StringBuilder(p[0]);
            for (int j = 1; j < i; ++j) {
                b.append("/");
                b.append(p[j]);
            }
            return b.toString();
        }
        return null;
    }

    public byte[] fetchRaw(String url) throws MalformedURLException, IOException {
        throw new FHIRException("The URL '" + url + "' is not known to the FHIR validator, and has not been provided as part of the setup / parameters");
    }

    public IResourceValidator.IValidatorResourceFetcher setLocale(Locale locale) {
        return null;
    }

    public CanonicalResource fetchCanonicalResource(String url) throws URISyntaxException {
        String[] p = url.split("\\/");
        String root = this.getRoot(p, url);
        if (root != null) {
            TerminologyClient c = TerminologyClientFactory.makeClient((String)root, (String)this.context.getVersion());
            return c.read(p[p.length - 2], p[p.length - 1]);
        }
        throw new FHIRException("The URL '" + url + "' is not known to the FHIR validator, and has not been provided as part of the setup / parameters");
    }

    private String getRoot(String[] p, String url) {
        if (p.length > 3 && Utilities.isValidId((String)p[p.length - 1]) && this.context.getResourceNames().contains(p[p.length - 2])) {
            url = url.substring(0, url.lastIndexOf("/"));
            return url.substring(0, url.lastIndexOf("/"));
        }
        return null;
    }

    public boolean fetchesCanonicalResource(String url) {
        return true;
    }
}

