/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class StandAloneValidatorFetcher
implements IResourceValidator.IValidatorResourceFetcher {
    private FilesystemPackageCacheManager pcm;
    private IWorkerContext context;
    private IPackageInstaller installer;

    public StandAloneValidatorFetcher(FilesystemPackageCacheManager pcm, IWorkerContext context, IPackageInstaller installer) {
        this.pcm = pcm;
        this.context = context;
        this.installer = installer;
    }

    public Element fetch(Object appContext, String url) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        throw new Error("Not done yet");
    }

    public IResourceValidator.ReferenceValidationPolicy validationPolicy(Object appContext, String path, String url) {
        throw new Error("Not done yet");
    }

    public boolean resolveURL(Object appContext, String path, String url) throws IOException, FHIRException {
        VersionUtilities.VersionURLInfo vu;
        if (!Utilities.isAbsoluteUrl((String)url)) {
            return false;
        }
        String pid = null;
        String ver = null;
        String base = this.findBaseUrl(url);
        if (base == null) {
            return false;
        }
        pid = base.equals("http://terminology.hl7.org") ? "hl7.terminology" : (url.startsWith("http://hl7.org/fhir") ? this.pcm.getPackageId(base) : this.pcm.findCanonicalInLocalCache(base));
        String string = ver = url.contains("|") ? url.substring(url.indexOf("|") + 1) : null;
        if (pid == null) {
            return false;
        }
        if (url.startsWith("http://hl7.org/fhir") && (vu = VersionUtilities.parseVersionUrl((String)url)) != null) {
            NpmPackage pi = this.pcm.loadPackage(VersionUtilities.packageForVersion((String)vu.getVersion()), VersionUtilities.getCurrentVersion((String)vu.getVersion()));
            return pi.hasCanonical(vu.getUrl());
        }
        if (pid != null && this.installer.packageExists(pid, ver)) {
            this.installer.loadPackage(pid, ver);
            NpmPackage pi = this.pcm.loadPackage(pid);
            return pi.hasCanonical(url);
        }
        return !url.startsWith("http://hl7.org/fhir");
    }

    private String findBaseUrl(String url) {
        String[] p = url.split("\\/");
        for (int i = 1; i < p.length; ++i) {
            if (!Utilities.existsInList((String)p[i], (List)this.context.getResourceNames())) continue;
            StringBuilder b = new StringBuilder(p[0]);
            for (int j = 1; j < i; ++j) {
                b.append("/");
                b.append(p[j]);
            }
            return b.toString();
        }
        return null;
    }

    public byte[] fetchRaw(String url) throws MalformedURLException, IOException {
        throw new Error("Not done yet");
    }

    public void setLocale(Locale locale) {
        throw new Error("Not done yet");
    }

    public CanonicalResource fetchCanonicalResource(String url) throws URISyntaxException {
        String[] p = url.split("\\/");
        String root = this.getRoot(p, url);
        if (root != null) {
            TerminologyClient c = TerminologyClientFactory.makeClient((String)root, (String)this.context.getVersion());
            return c.read(p[p.length - 2], p[p.length - 1]);
        }
        throw new FHIRException("Not done yet");
    }

    private String getRoot(String[] p, String url) {
        if (p.length > 3 && Utilities.isValidId((String)p[p.length - 1]) && this.context.getResourceNames().contains(p[p.length - 2])) {
            url = url.substring(0, url.lastIndexOf("/"));
            return url.substring(0, url.lastIndexOf("/"));
        }
        return null;
    }

    public boolean fetchesCanonicalResource(String url) {
        return true;
    }

    public static interface IPackageInstaller {
        public boolean packageExists(String var1, String var2) throws IOException, FHIRException;

        public void loadPackage(String var1, String var2) throws IOException, FHIRException;
    }
}

