/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.validation.cli.utils.VersionUtil;

public class Display {
    private static String toMB(long maxMemory) {
        return Long.toString(maxMemory / 0x100000L);
    }

    public static void printCliArgumentsAndInfo(String[] args) throws IOException {
        System.out.println("  Paths:  Current = " + System.getProperty("user.dir") + ", Package Cache = " + new FilesystemPackageCacheManager(true, 3).getFolder());
        System.out.print("  Params:");
        for (String s : args) {
            System.out.print(s.contains(" ") ? " \"" + s + "\"" : " " + s);
        }
        System.out.println();
    }

    public static void displayHelpDetails() {
        ClassLoader classLoader = Display.class.getClassLoader();
        File file = new File(classLoader.getResource("help.txt").getFile());
        try {
            String data = FileUtils.readFileToString((File)file, (String)"UTF-8");
            System.out.println(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void displaySystemInfo() {
        System.out.println("  Java:   " + System.getProperty("java.version") + " from " + System.getProperty("java.home") + " on " + System.getProperty("os.arch") + " (" + System.getProperty("sun.arch.data.model") + "bit). " + Display.toMB(Runtime.getRuntime().maxMemory()) + "MB available");
    }

    public static void displayVersion() {
        System.out.println("FHIR Validation tool " + VersionUtil.getVersionString());
    }
}

