/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.File;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ComparisonService;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.utils.Common;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.EngineMode;
import org.hl7.fhir.validation.cli.utils.Params;

public class ValidatorCli {
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";

    public static void main(String[] args) throws Exception {
        TimeTracker tt = new TimeTracker();
        TimeTracker.Session tts = tt.start("Loading");
        Display.displayVersion();
        Display.displaySystemInfo();
        if (Params.hasParam(args, "-proxy")) {
            String[] p = Params.getParam(args, "-proxy").split("\\:");
            System.setProperty(HTTP_PROXY_HOST, p[0]);
            System.setProperty(HTTP_PROXY_PORT, p[1]);
        }
        CliContext cliContext = Params.loadCliContext(args);
        if (Params.hasParam(args, "-tests")) {
            Common.runValidationEngineTests();
        } else if (ValidatorCli.shouldDisplayHelpToUser(args)) {
            Display.displayHelpDetails();
        } else if (Params.hasParam(args, "-compare")) {
            if (ValidatorCli.destinationDirectoryValid(Params.getParam(args, "-dest"))) {
                ValidatorCli.doLeftRightComparison(args, cliContext, tt);
            }
        } else {
            Display.printCliArgumentsAndInfo(args);
            ValidatorCli.doValidation(tt, tts, cliContext);
        }
    }

    private static boolean destinationDirectoryValid(String dest) {
        if (dest == null) {
            System.out.println("no -dest parameter provided");
            return false;
        }
        if (!new File(dest).isDirectory()) {
            System.out.println("Specified destination (-dest parameter) is not valid: \"" + dest + "\")");
            return false;
        }
        System.out.println("Valid destination directory provided: \"" + dest + "\")");
        return true;
    }

    private static boolean shouldDisplayHelpToUser(String[] args) {
        return args.length == 0 || Params.hasParam(args, "help") || Params.hasParam(args, "?") || Params.hasParam(args, "-?") || Params.hasParam(args, "/?");
    }

    private static void doLeftRightComparison(String[] args, CliContext cliContext, TimeTracker tt) throws Exception {
        Display.printCliArgumentsAndInfo(args);
        if (cliContext.getSv() == null) {
            cliContext.setSv(ValidationService.determineVersion(cliContext));
        }
        String v = VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        String definitions = VersionUtilities.packageForVersion((String)v) + "#" + v;
        ValidationEngine validator = ValidationService.getValidator(cliContext, definitions, tt);
        ComparisonService.doLeftRightComparison(args, Params.getParam(args, "-dest"), validator);
    }

    private static void doValidation(TimeTracker tt, TimeTracker.Session tts, CliContext cliContext) throws Exception {
        if (cliContext.getSv() == null) {
            cliContext.setSv(ValidationService.determineVersion(cliContext));
        }
        System.out.println("Loading");
        String definitions = VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        ValidationEngine validator = ValidationService.getValidator(cliContext, definitions, tt);
        tts.end();
        switch (cliContext.getMode()) {
            case TRANSFORM: {
                ValidationService.transform(cliContext, validator);
                break;
            }
            case NARRATIVE: {
                ValidationService.generateNarrative(cliContext, validator);
                break;
            }
            case SNAPSHOT: {
                ValidationService.generateSnapshot(cliContext, validator);
                break;
            }
            case CONVERT: {
                ValidationService.convertSources(cliContext, validator);
                break;
            }
            case FHIRPATH: {
                ValidationService.evaluateFhirpath(cliContext, validator);
                break;
            }
            case VERSION: {
                ValidationService.transformVersion(cliContext, validator);
                break;
            }
            default: {
                for (String s : cliContext.getProfiles()) {
                    if (validator.getContext().hasResource(StructureDefinition.class, s) || validator.getContext().hasResource(ImplementationGuide.class, s)) continue;
                    System.out.println("  Fetch Profile from " + s);
                    validator.loadProfile(cliContext.getLocations().getOrDefault(s, s));
                }
                System.out.println("Validating");
                if (cliContext.getMode() == EngineMode.SCAN) {
                    ValidationService.validateScan(cliContext, validator);
                    break;
                }
                ValidationService.validateSources(cliContext, validator);
            }
        }
        System.out.println("Done. " + tt.report());
    }
}

