/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class StructureDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;

    public StructureDefinitionValidator(IWorkerContext context, TimeTracker timeTracker, FHIRPathEngine fpe) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
    }

    public void validateStructureDefinition(List<ValidationMessage> errors, Element src, NodeStack stack) {
        try {
            StructureDefinition sd = this.loadAsSD(src);
            List snapshot = sd.getSnapshot().getElement();
            sd.setSnapshot(null);
            StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (this.warning(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "Unable_to_find_base__for_", sd.getBaseDefinition(), "StructureDefinition, so can't check the differential") && this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasDerivation(), "SD_MUST_HAVE_DERIVATION", sd.getUrl()) && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                ArrayList msgs = new ArrayList();
                ProfileUtilities pu = new ProfileUtilities(this.context, msgs, null);
                pu.generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir", sd.getName());
                if (msgs.size() > 0) {
                    for (ValidationMessage msg : msgs) {
                        String loc = msg.getLocation();
                        if (loc.contains("#")) {
                            msg.setLocation(stack.getLiteralPath() + ".differential.element.where(path = '" + loc.substring(loc.indexOf("#") + 1) + "')");
                        } else {
                            msg.setLocation(stack.getLiteralPath());
                        }
                        errors.add(msg);
                    }
                }
                if (!snapshot.isEmpty()) {
                    int was = snapshot.size();
                    int is = sd.getSnapshot().getElement().size();
                    this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), was == is, "SNAPSHOT_EXISTING_PROBLEM", was, is);
                }
            }
        }
        catch (IOException | FHIRException e) {
            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "ERROR_GENERATING_SNAPSHOT", e.getMessage());
        }
        List differentials = src.getChildrenByName("differential");
        List snapshots = src.getChildrenByName("snapshot");
        for (Element differential : differentials) {
            this.validateElementList(errors, differential, stack.push(differential, -1, null, null), false, snapshots.size() > 0);
        }
        for (Element snapshot : snapshots) {
            this.validateElementList(errors, snapshot, stack.push(snapshot, -1, null, null), true, true);
        }
    }

    private void validateElementList(List<ValidationMessage> errors, Element elementList, NodeStack stack, boolean snapshot, boolean hasSnapshot) {
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (Element element : elements) {
            this.validateElementDefinition(errors, element, stack.push(element, cc, null, null), snapshot, hasSnapshot);
            ++cc;
        }
    }

    private void validateElementDefinition(List<ValidationMessage> errors, Element element, NodeStack stack, boolean snapshot, boolean hasSnapshot) {
        boolean typeMustSupport = false;
        List types = element.getChildrenByName("type");
        for (Element type : types) {
            if (!this.hasMustSupportExtension(type)) continue;
            typeMustSupport = true;
        }
        if (typeMustSupport) {
            if (snapshot) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_SNAPSHOT", element.getNamedChildValue("path"));
            } else {
                this.hint(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), hasSnapshot || "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_DIFF", element.getNamedChildValue("path"));
            }
        }
    }

    private boolean hasMustSupportExtension(Element type) {
        if ("true".equals(this.getExtensionValue(type, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        List profiles = type.getChildrenByName("profile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        profiles = type.getChildrenByName("targetProfile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        return false;
    }

    private String getExtensionValue(Element element, String url) {
        List extensions = element.getChildrenByName("extension");
        for (Element extension : extensions) {
            if (!url.equals(extension.getNamedChildValue("url"))) continue;
            return extension.getNamedChildValue("value");
        }
        return null;
    }

    private StructureDefinition loadAsSD(Element src) throws FHIRException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)src, (OutputStream)bs, (Manager.FhirFormat)Manager.FhirFormat.JSON, (IParser.OutputStyle)IParser.OutputStyle.NORMAL, null);
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_30_50.convertResource((Resource)r3, (boolean)false);
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            org.hl7.fhir.r4.model.Resource r4 = new JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
        }
        return (StructureDefinition)new org.hl7.fhir.r5.formats.JsonParser().parse(bs.toByteArray());
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

