/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.VersionUtil;
import org.hl7.fhir.validation.cli.ValidatorGui;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ComparisonService;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.utils.Common;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.Params;

public class Validator {
    private static CliContext cliContext;

    private static String getNamedParam(String[] args, String param) {
        boolean found = false;
        for (String a : args) {
            if (found) {
                return a;
            }
            if (!a.equals(param)) continue;
            found = true;
        }
        return null;
    }

    private static String toMB(long maxMemory) {
        return Long.toString(maxMemory / 0x100000L);
    }

    private static CliContext getCliContext() {
        if (cliContext == null) {
            cliContext = new CliContext();
        }
        return cliContext;
    }

    private static void goToWebPage(String url) {
        try {
            URI uri = new URI(url);
            Desktop.getDesktop().browse(uri);
            System.out.println("Web page opened in browser");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        TimeTracker tt = new TimeTracker();
        TimeTracker.Session tts = tt.start("Loading");
        System.out.println("FHIR Validation tool " + VersionUtil.getVersionString());
        System.out.println("  Java:   " + System.getProperty("java.version") + " from " + System.getProperty("java.home") + " on " + System.getProperty("os.arch") + " (" + System.getProperty("sun.arch.data.model") + "bit). " + Validator.toMB(Runtime.getRuntime().maxMemory()) + "MB available");
        String proxy = Validator.getNamedParam(args, "-proxy");
        if (!Utilities.noString((String)proxy)) {
            String[] p = proxy.split("\\:");
            System.setProperty("http.proxyHost", p[0]);
            System.setProperty("http.proxyPort", p[1]);
        }
        if (Params.hasParam(args, "-gui")) {
            cliContext = Params.loadCliContext(args);
            String v = Common.getVersion(args);
            String definitions = VersionUtilities.packageForVersion((String)v) + "#" + v;
            ValidationEngine validationEngine = Common.getValidationEngine(v, definitions, cliContext.getTxLog(), null);
            ValidatorGui.start(cliContext, validationEngine, true);
        } else if (Params.hasParam(args, "-tests")) {
            Common.runValidationEngineTests();
        } else if (args.length == 0 || Params.hasParam(args, "help") || Params.hasParam(args, "?") || Params.hasParam(args, "-?") || Params.hasParam(args, "/?")) {
            Display.displayHelpDetails();
        } else if (Params.hasParam(args, "-compare")) {
            Display.printCliArgumentsAndInfo(args);
            String dest = Params.getParam(args, "-dest");
            if (dest == null) {
                System.out.println("no -dest parameter provided");
            } else if (!new File(dest).isDirectory()) {
                System.out.println("Specified destination (-dest parameter) is not valid: \"" + dest + "\")");
            } else {
                cliContext = Params.loadCliContext(args);
                if (cliContext.getSv() == null) {
                    cliContext.setSv(Validator.determineVersion(cliContext));
                }
                String v = VersionUtilities.getCurrentVersion((String)cliContext.getSv());
                String definitions = VersionUtilities.packageForVersion((String)v) + "#" + v;
                ValidationEngine validator = ValidationService.getValidator(cliContext, definitions, tt);
                ComparisonService.doLeftRightComparison(args, dest, validator);
            }
        } else {
            Display.printCliArgumentsAndInfo(args);
            cliContext = Params.loadCliContext(args);
            if (cliContext.getSv() == null) {
                cliContext.setSv(Validator.determineVersion(cliContext));
            }
            System.out.println("Loading");
            String definitions = VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
            ValidationEngine validator = ValidationService.getValidator(cliContext, definitions, tt);
            tts.end();
            if (cliContext.getMode() == EngineMode.VERSION) {
                ValidationService.transformVersion(cliContext, validator);
            } else if (cliContext.getMode() == EngineMode.TRANSFORM) {
                ValidationService.transform(cliContext, validator);
            } else if (cliContext.getMode() == EngineMode.NARRATIVE) {
                ValidationService.generateNarrative(cliContext, validator);
            } else if (cliContext.getMode() == EngineMode.SNAPSHOT) {
                ValidationService.generateSnapshot(cliContext, validator);
            } else if (cliContext.getMode() == EngineMode.CONVERT) {
                ValidationService.convertSources(cliContext, validator);
            } else if (cliContext.getMode() == EngineMode.FHIRPATH) {
                ValidationService.evaluateFhirpath(cliContext, validator);
            } else {
                for (String s : cliContext.getProfiles()) {
                    if (validator.getContext().hasResource(StructureDefinition.class, s) || validator.getContext().hasResource(ImplementationGuide.class, s)) continue;
                    System.out.println("  Fetch Profile from " + s);
                    validator.loadProfile(cliContext.getLocations().getOrDefault(s, s));
                }
                System.out.println("Validating");
                if (cliContext.getMode() == EngineMode.SCAN) {
                    ValidationService.validateScan(cliContext, validator);
                } else {
                    ValidationService.validateSources(cliContext, validator);
                }
            }
            System.out.println("Done. " + tt.report());
        }
    }

    public static String determineVersion(CliContext cliContext) throws Exception {
        if (cliContext.getMode() != EngineMode.VALIDATION) {
            return "current";
        }
        System.out.println("Scanning for versions (no -version parameter):");
        ValidationEngine.VersionSourceInformation versions = ValidationService.scanForVersions(cliContext);
        for (String s : versions.getReport()) {
            System.out.println("  " + s);
        }
        if (versions.isEmpty()) {
            System.out.println("-> Using Default version '4.5'");
            return "current";
        }
        if (versions.size() == 1) {
            System.out.println("-> use version " + versions.version());
            return versions.version();
        }
        throw new Exception("-> Multiple versions found. Specify a particular version using the -version parameter");
    }

    public static enum EngineMode {
        VALIDATION,
        TRANSFORM,
        NARRATIVE,
        SNAPSHOT,
        SCAN,
        CONVERT,
        FHIRPATH,
        VERSION;

    }
}

