/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class ValueSetValidator
extends BaseValidator {
    public ValueSetValidator(IWorkerContext context, TimeTracker timeTracker) {
        super(context);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
    }

    public void validateValueSet(List<ValidationMessage> errors, Element vs, NodeStack stack) {
        if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            List composes = vs.getChildrenByName("compose");
            int cc = 0;
            for (Element compose : composes) {
                this.validateValueSetCompose(errors, compose, stack.push(compose, cc, null, null));
                ++cc;
            }
        }
    }

    private void validateValueSetCompose(List<ValidationMessage> errors, Element compose, NodeStack stack) {
        List includes = compose.getChildrenByName("include");
        int ci = 0;
        for (Element include : includes) {
            this.validateValueSetInclude(errors, include, stack.push(include, ci, null, null));
            ++ci;
        }
        List excludes = compose.getChildrenByName("exclude");
        int ce = 0;
        for (Element exclude : excludes) {
            this.validateValueSetInclude(errors, exclude, stack.push(exclude, ce, null, null));
            ++ce;
        }
    }

    private void validateValueSetInclude(List<ValidationMessage> errors, Element include, NodeStack stack) {
        String system = include.getChildValue("system");
        String version = include.getChildValue("version");
        boolean systemOk = true;
        List valuesets = include.getChildrenByName("valueSet");
        int i = 0;
        for (Element ve : valuesets) {
            String v = ve.getValue();
            ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, v);
            if (vs == null) {
                NodeStack ns = stack.push(ve, i, ve.getProperty().getDefinition(), ve.getProperty().getDefinition());
                Resource rs = this.context.fetchResource(Resource.class, v);
                if (rs != null) {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_INVALID_TYPE", v, rs.fhirType());
                } else {
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_UNKNOWN", v);
                }
            }
            ++i;
        }
        List concepts = include.getChildrenByName("concept");
        List filters = include.getChildrenByName("filter");
        if (!Utilities.noString((String)system)) {
            int cc = 0;
            for (Element concept : concepts) {
                if (systemOk && !this.validateValueSetIncludeConcept(errors, concept, stack.push(concept, cc, null, null), system, version)) {
                    systemOk = false;
                }
                ++cc;
            }
            int cf = 0;
            for (Element filter : filters) {
                if (systemOk && !this.validateValueSetIncludeFilter(errors, include, stack.push(filter, cf, null, null), system, version)) {
                    systemOk = false;
                }
                ++cf;
            }
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), systemOk, version == null ? "VALUESET_UNC_SYSTEM_WARNING" : "VALUESET_UNC_SYSTEM_WARNING_VER", new Object[0]);
        } else {
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), filters.size() == 0 && concepts.size() == 0, "VALUESET_NO_SYSTEM_WARNING", new Object[0]);
        }
    }

    private boolean validateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version) {
        String code = concept.getChildValue("code");
        if (version == null) {
            IWorkerContext.ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null), null);
            if (vv.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, code);
        } else {
            IWorkerContext.ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null).setVersion(version), null);
            if (vv.getErrorClass() == ValueSetExpander.TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, code);
        }
        return true;
    }

    private boolean validateValueSetIncludeFilter(List<ValidationMessage> errors, Element include, NodeStack push, String system, String version) {
        return true;
    }
}

