/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.EntrySummary;
import org.hl7.fhir.validation.instance.utils.IndexedElement;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class BundleValidator
extends BaseValidator {
    public static final String URI_REGEX3 = "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AllergyIntolerance|AdverseEvent|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BodySite|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition (aka Problem)|Consent|Contract|Coverage|DataElement|DetectedIssue|Device|DeviceComponent|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EligibilityRequest|EligibilityResponse|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|ExpansionProfile|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingManifest|ImagingStudy|Immunization|ImmunizationRecommendation|ImplementationGuide|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationRequest|MedicationStatement|MessageDefinition|MessageHeader|NamingSystem|NutritionOrder|Observation|OperationDefinition|OperationOutcome|Organization|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|ProcedureRequest|ProcessRequest|ProcessResponse|Provenance|Questionnaire|QuestionnaireResponse|ReferralRequest|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|Sequence|ServiceDefinition|Slot|Specimen|StructureDefinition|StructureMap|Subscription|Substance|SupplyDelivery|SupplyRequest|Task|TestScript|TestReport|ValueSet|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private String serverBase;

    public BundleValidator(IWorkerContext context, String serverBase) {
        super(context);
        this.serverBase = serverBase;
    }

    public void validateBundle(List<ValidationMessage> errors, Element bundle, NodeStack stack, boolean checkSpecials) {
        String id;
        String fullUrl;
        ArrayList<Element> entries = new ArrayList<Element>();
        bundle.getNamedChildren("entry", entries);
        String type = bundle.getNamedChildValue("type");
        type = StringUtils.defaultString((String)type);
        if (entries.size() == 0) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Bundle_BUNDLE_Entry_NoFirst", new Object[0]);
        } else {
            Element resource;
            Element firstEntry = (Element)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 1, null, null);
            fullUrl = firstEntry.getNamedChildValue("fullUrl");
            if (type.equals("document")) {
                resource = firstEntry.getNamedChild("resource");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    id = resource.getNamedChildValue("id");
                    this.validateDocument(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id);
                }
                if (!VersionUtilities.isThisOrLater((String)Enumerations.FHIRVersion._4_0_1.getDisplay(), (String)bundle.getProperty().getStructure().getFhirVersion().getDisplay())) {
                    this.handleSpecialCaseForLastUpdated(bundle, errors, stack);
                }
                this.checkAllInterlinked(errors, entries, stack, bundle, true);
            }
            if (type.equals("message")) {
                resource = firstEntry.getNamedChild("resource");
                id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    this.validateMessage(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id);
                }
                this.checkAllInterlinked(errors, entries, stack, bundle, VersionUtilities.isR5Ver((String)this.context.getVersion()));
            }
        }
        for (Element entry : entries) {
            fullUrl = entry.getNamedChildValue("fullUrl");
            String url = this.getCanonicalURLForEntry(entry);
            id = this.getIdForEntry(entry);
            if (url == null) continue;
            if (!(!url.equals(fullUrl) || url.matches(this.uriRegexForVersion()) && url.endsWith("/" + id) || this.isV3orV2Url(url))) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "Bundle_BUNDLE_Entry_MismatchIdUrl", url, fullUrl, id);
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), !url.equals(fullUrl) || this.serverBase == null || url.equals(Utilities.pathURL((String[])new String[]{this.serverBase, entry.getNamedChild("resource").fhirType(), id})), "Bundle_BUNDLE_Entry_Canonical", url, fullUrl);
        }
    }

    private void validateDocument(List<ValidationMessage> errors, List<Element> entries, Element composition, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getType().equals("Composition"), "Bundle_BUNDLE_Entry_Document", new Object[0])) {
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "subject", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, true, "author", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "encounter", "Composition");
            this.validateDocumentReference(errors, entries, composition, stack, fullUrl, id, false, "custodian", "Composition");
            this.validateDocumentSubReference(errors, entries, composition, stack, fullUrl, id, "Composition", "attester", false, "party");
            this.validateDocumentSubReference(errors, entries, composition, stack, fullUrl, id, "Composition", "event", true, "detail");
            this.validateSections(errors, entries, composition, stack, fullUrl, id);
        }
    }

    private void validateSections(List<ValidationMessage> errors, List<Element> entries, Element focus, NodeStack stack, String fullUrl, String id) {
        ArrayList sections = new ArrayList();
        focus.getNamedChildren("section", sections);
        int i = 1;
        for (Element section : sections) {
            NodeStack localStack = stack.push(section, i, null, null);
            this.validateDocumentReference(errors, entries, section, stack, fullUrl, id, false, "author", "Section");
            this.validateDocumentReference(errors, entries, section, stack, fullUrl, id, false, "focus", "Section");
            ArrayList sectionEntries = new ArrayList();
            section.getNamedChildren("entry", sectionEntries);
            int j = 1;
            for (Element sectionEntry : sectionEntries) {
                NodeStack localStack2 = localStack.push(sectionEntry, j, null, null);
                this.validateBundleReference(errors, entries, sectionEntry, "Section Entry", localStack2, fullUrl, "Composition", id);
                ++j;
            }
            this.validateSections(errors, entries, section, localStack, fullUrl, id);
            ++i;
        }
    }

    public void validateDocumentSubReference(List<ValidationMessage> errors, List<Element> entries, Element composition, NodeStack stack, String fullUrl, String id, String title, String parent, boolean repeats, String propName) {
        ArrayList list = new ArrayList();
        composition.getNamedChildren(parent, list);
        int i = 1;
        for (Element elem : list) {
            this.validateDocumentReference(errors, entries, elem, stack.push(elem, i, null, null), fullUrl, id, repeats, propName, title + "." + parent);
            ++i;
        }
    }

    public void validateDocumentReference(List<ValidationMessage> errors, List<Element> entries, Element composition, NodeStack stack, String fullUrl, String id, boolean repeats, String propName, String title) {
        if (repeats) {
            ArrayList list = new ArrayList();
            composition.getNamedChildren(propName, list);
            int i = 1;
            for (Element elem : list) {
                this.validateBundleReference(errors, entries, elem, title + "." + propName, stack.push(elem, i, null, null), fullUrl, "Composition", id);
                ++i;
            }
        } else {
            Element elem = composition.getNamedChild(propName);
            if (elem != null) {
                this.validateBundleReference(errors, entries, elem, title + "." + propName, stack.push(elem, -1, null, null), fullUrl, "Composition", id);
            }
        }
    }

    private void validateMessage(List<ValidationMessage> errors, List<Element> entries, Element messageHeader, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, messageHeader.line(), messageHeader.col(), stack.getLiteralPath(), messageHeader.getType().equals("MessageHeader"), "Validation_BUNDLE_Message", new Object[0])) {
            List elements = messageHeader.getChildren("focus");
            for (Element elem : elements) {
                this.validateBundleReference(errors, entries, elem, "MessageHeader Data", stack.push(elem, -1, null, null), fullUrl, "MessageHeader", id);
            }
        }
    }

    private void validateBundleReference(List<ValidationMessage> errors, List<Element> entries, Element ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        String reference = null;
        try {
            reference = ref.getNamedChildValue("reference");
        }
        catch (Error error) {
            // empty catch block
        }
        if (ref != null && !Utilities.noString((String)reference) && !reference.startsWith("#")) {
            Element target = this.resolveInBundle(entries, reference, fullUrl, type, id);
            this.rule(errors, ValidationMessage.IssueType.INVALID, ref.line(), ref.col(), stack.addToLiteralPath("reference"), target != null, "Bundle_BUNDLE_Entry_NotFound", reference, name);
        }
    }

    private void handleSpecialCaseForLastUpdated(Element bundle, List<ValidationMessage> errors, NodeStack stack) {
        boolean ok = bundle.hasChild("meta") && bundle.getNamedChild("meta").hasChild("lastUpdated") && bundle.getNamedChild("meta").getNamedChild("lastUpdated").hasValue();
        this.ruleHtml(errors, ValidationMessage.IssueType.REQUIRED, stack.getLiteralPath(), ok, "Bundle_Document_Date_Missing", "Bundle_Document_Date_Missing_html");
    }

    private void checkAllInterlinked(List<ValidationMessage> errors, List<Element> entries, NodeStack stack, Element bundle, boolean isError) {
        boolean foundRevLinks;
        ArrayList<EntrySummary> entryList = new ArrayList<EntrySummary>();
        for (Element entry : entries) {
            Element r = entry.getNamedChild("resource");
            if (r == null) continue;
            entryList.add(new EntrySummary(entry, r));
        }
        for (EntrySummary e : entryList) {
            Set<String> references = this.findReferences(e.getEntry());
            Iterator<String> iterator = references.iterator();
            while (iterator.hasNext()) {
                EntrySummary t;
                String ref = iterator.next();
                Element tgt = this.resolveInBundle(entries, ref, e.getEntry().getChildValue("fullUrl"), e.getResource().fhirType(), e.getResource().getIdBase());
                if (tgt == null || (t = this.entryForTarget(entryList, tgt)) == null) continue;
                e.getTargets().add(t);
            }
        }
        HashSet<EntrySummary> visited = new HashSet<EntrySummary>();
        this.visitLinked(visited, (EntrySummary)entryList.get(0));
        do {
            foundRevLinks = false;
            for (EntrySummary e : entryList) {
                if (visited.contains(e)) continue;
                boolean add = false;
                for (EntrySummary t : e.getTargets()) {
                    if (!visited.contains(t)) continue;
                    add = true;
                }
                if (!add) continue;
                foundRevLinks = true;
                this.visitLinked(visited, e);
            }
        } while (foundRevLinks);
        int i = 0;
        for (EntrySummary e : entryList) {
            Element entry = e.getEntry();
            if (isError) {
                this.rule(errors, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + ']'), visited.contains(e), "Bundle_BUNDLE_Entry_Orphan", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "");
            } else {
                this.warning(errors, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + ']'), visited.contains(e), "Bundle_BUNDLE_Entry_Orphan", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "");
            }
            ++i;
        }
    }

    private String uriRegexForVersion() {
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            return URI_REGEX3;
        }
        return "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CapabilityStatement2|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseIssue|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceFocus|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationUsage|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    }

    private String getCanonicalURLForEntry(Element entry) {
        Element e = entry.getNamedChild("resource");
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("url");
    }

    private String getIdForEntry(Element entry) {
        Element e = entry.getNamedChild("resource");
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("id");
    }

    private void validateResourceIds(List<ValidationMessage> errors, List<Element> entries, NodeStack stack) {
        int i = 1;
        for (Element entry : entries) {
            String id;
            String fullUrl = entry.getNamedChildValue("fullUrl");
            Element resource = entry.getNamedChild("resource");
            String string = id = resource != null ? resource.getNamedChildValue("id") : null;
            if (id != null && fullUrl != null) {
                String urlId = null;
                if (fullUrl.startsWith("https://") || fullUrl.startsWith("http://")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(47) + 1);
                } else if (fullUrl.startsWith("urn:uuid") || fullUrl.startsWith("urn:oid")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(58) + 1);
                }
                this.rule(errors, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + i + "]"), urlId.equals(id), "Bundle_BUNDLE_Entry_IdUrlMismatch", id, fullUrl);
            }
            ++i;
        }
    }

    private EntrySummary entryForTarget(List<EntrySummary> entryList, Element tgt) {
        for (EntrySummary e : entryList) {
            if (e.getEntry() != tgt) continue;
            return e;
        }
        return null;
    }

    private void visitLinked(Set<EntrySummary> visited, EntrySummary t) {
        if (!visited.contains(t)) {
            visited.add(t);
            for (EntrySummary e : t.getTargets()) {
                this.visitLinked(visited, e);
            }
        }
    }

    private void followResourceLinks(Element entry, Map<String, Element> visitedResources, Map<Element, Element> candidateEntries, List<Element> candidateResources, List<ValidationMessage> errors, NodeStack stack) {
        this.followResourceLinks(entry, visitedResources, candidateEntries, candidateResources, errors, stack, 0);
    }

    private void followResourceLinks(Element entry, Map<String, Element> visitedResources, Map<Element, Element> candidateEntries, List<Element> candidateResources, List<ValidationMessage> errors, NodeStack stack, int depth) {
        Element resource = entry.getNamedChild("resource");
        if (visitedResources.containsValue(resource)) {
            return;
        }
        visitedResources.put(entry.getNamedChildValue("fullUrl"), resource);
        String type = null;
        Set<String> references = this.findReferences(resource);
        for (String reference : references) {
            IndexedElement r = this.getFromBundle(stack.getElement(), reference, entry.getChildValue("fullUrl"), new ArrayList<ValidationMessage>(), stack.addToLiteralPath("entry[" + candidateResources.indexOf(resource) + "]"), type, "transaction".equals(stack.getElement().getChildValue("type")));
            if (r == null || visitedResources.containsValue(r.getMatch())) continue;
            this.followResourceLinks(candidateEntries.get(r.getMatch()), visitedResources, candidateEntries, candidateResources, errors, stack, depth + 1);
        }
    }

    private Set<String> findReferences(Element start) {
        HashSet<String> references = new HashSet<String>();
        this.findReferences(start, references);
        return references;
    }

    private void findReferences(Element start, Set<String> references) {
        for (Element child : start.getChildren()) {
            String ref;
            if (child.getType().equals("Reference") && (ref = child.getChildValue("reference")) != null && !ref.startsWith("#")) {
                references.add(ref);
            }
            if ((child.getType().equals("url") || child.getType().equals("uri") || child.getType().equals("canonical")) && (ref = child.primitiveValue()) != null && !ref.startsWith("#")) {
                references.add(ref);
            }
            this.findReferences(child, references);
        }
    }

    private boolean isV3orV2Url(String url) {
        return url.startsWith("http://hl7.org/fhir/v3/") || url.startsWith("http://hl7.org/fhir/v2/");
    }
}

