/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.convertors.IGR2ConvertorAdvisor;
import org.hl7.fhir.convertors.R2016MayToR4Loader;
import org.hl7.fhir.convertors.R2ToR4Loader;
import org.hl7.fhir.convertors.R3ToR4Loader;
import org.hl7.fhir.convertors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.VersionConvertor_10_40;
import org.hl7.fhir.convertors.VersionConvertor_14_40;
import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.context.SimpleWorkerContext;
import org.hl7.fhir.r4.elementmodel.Manager;
import org.hl7.fhir.r4.formats.FormatUtilities;
import org.hl7.fhir.r4.formats.RdfParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.FhirPublication;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceFactory;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.terminologies.ConceptMapEngine;
import org.hl7.fhir.r4.utils.IResourceValidator;
import org.hl7.fhir.r4.utils.NarrativeGenerator;
import org.hl7.fhir.r4.utils.OperationOutcomeUtilities;
import org.hl7.fhir.r4.utils.StructureMapUtilities;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.r4.utils.ValidationProfileSet;
import org.hl7.fhir.r4.validation.InstanceValidator;
import org.hl7.fhir.r4.validation.XmlValidator;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.NpmPackage;
import org.hl7.fhir.utilities.cache.PackageCacheManager;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.xml.sax.SAXException;

public class ValidationEngine {
    private SimpleWorkerContext context;
    private Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    private boolean doNative;
    private boolean noInvariantChecks;
    private boolean hintAboutNonMustSupport;
    private boolean anyExtensionsAllowed = false;
    private String version;
    private PackageCacheManager pcm;
    private PrintWriter mapLog;
    private boolean debug;

    public ValidationEngine() throws IOException {
        this.pcm = new PackageCacheManager(true, 3);
    }

    public void loadInitialDefinitions(String src) throws Exception {
        this.loadDefinitions(src);
    }

    public void setTerminologyServer(String src, String log, FhirPublication version) throws Exception {
        this.connectToTSServer(src, log, version);
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public void setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    public ValidationEngine(String src, String txsrvr, String txLog, FhirPublication version) throws Exception {
        this.pcm = new PackageCacheManager(true, 3);
        this.loadInitialDefinitions(src);
        this.setTerminologyServer(txsrvr, txLog, version);
    }

    public ValidationEngine(String src) throws Exception {
        this.loadDefinitions(src);
        this.pcm = new PackageCacheManager(true, 3);
    }

    private void loadDefinitions(String src) throws Exception {
        Map<String, byte[]> source = this.loadIgSource(src);
        if (this.version == null) {
            this.version = this.getVersionFromPack(source);
        }
        this.context = SimpleWorkerContext.fromDefinitions(source, (SimpleWorkerContext.IContextResourceLoader)this.loaderForVersion());
        this.context.setAllowLoadingDuplicates(true);
        this.context.setExpansionProfile(this.makeExpProfile());
        this.grabNatives(source, "http://hl7.org/fhir");
    }

    private SimpleWorkerContext.IContextResourceLoader loaderForVersion() {
        if (Utilities.noString((String)this.version)) {
            return null;
        }
        if (this.version.equals("1.0.2")) {
            return new R2ToR4Loader();
        }
        if (this.version.equals("1.4.0")) {
            return new R2016MayToR4Loader();
        }
        if (this.version.equals("3.0.1")) {
            return new R3ToR4Loader();
        }
        return null;
    }

    private String getVersionFromPack(Map<String, byte[]> source) {
        if (source.containsKey("version.info")) {
            IniFile vi = new IniFile((InputStream)new ByteArrayInputStream(this.removeBom(source.get("version.info"))));
            return vi.getStringProperty("FHIR", "version");
        }
        throw new Error("Missing version.info?");
    }

    private byte[] removeBom(byte[] bs) {
        if (bs.length > 3 && bs[0] == -17 && bs[1] == -69 && bs[2] == -65) {
            return Arrays.copyOfRange(bs, 3, bs.length);
        }
        return bs;
    }

    private Parameters makeExpProfile() {
        Parameters ep = new Parameters();
        ep.addParameter("profile-url", "http://hl7.org/fhir/ExpansionProfile/dc8fd4bc-091a-424a-8a3b-6198ef146891");
        return ep;
    }

    private byte[] loadProfileSource(String src) throws Exception {
        if (Utilities.noString((String)src)) {
            throw new FHIRException("Profile Source '" + src + "' could not be processed");
        }
        if (src.startsWith("https:") || src.startsWith("http:")) {
            return this.loadProfileFromUrl(src);
        }
        if (new File(src).exists()) {
            return this.loadProfileFromFile(src);
        }
        throw new FHIRException("Definitions Source '" + src + "' could not be processed");
    }

    private byte[] loadProfileFromUrl(String src) throws Exception {
        try {
            URL url = new URL(src + "?nocache=" + System.currentTimeMillis());
            URLConnection c = url.openConnection();
            return IOUtils.toByteArray((InputStream)c.getInputStream());
        }
        catch (Exception e) {
            throw new Exception("Unable to find definitions at URL '" + src + "': " + e.getMessage(), e);
        }
    }

    private byte[] loadProfileFromFile(String src) throws FileNotFoundException, IOException {
        File f = new File(src);
        if (f.isDirectory()) {
            throw new IOException("You must provide a file name, not a directory name");
        }
        return TextFile.fileToBytes((String)src);
    }

    private Map<String, byte[]> loadIgSource(String src) throws Exception {
        if (src.startsWith("https:") || src.startsWith("http:")) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            if (!Utilities.noString((String)(pid = this.pcm.getPackageId(src)))) {
                return this.fetchByPackage(pid + (v == null ? "" : "#" + v));
            }
            return this.fetchFromUrl(src + (v == null ? "" : "|" + v));
        }
        File f = new File(src);
        if (f.exists()) {
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                return this.loadPackage(new FileInputStream(Utilities.path((String[])new String[]{src, "package.tgz"})), Utilities.path((String[])new String[]{src, "package.tgz"}));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "igpack.zip"})));
            }
            if (f.isDirectory() && new File(Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                return this.readZip(new FileInputStream(Utilities.path((String[])new String[]{src, "validator.pack"})));
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f);
            }
            if (src.endsWith(".tgz")) {
                return this.loadPackage(new FileInputStream(src), src);
            }
            if (src.endsWith(".pack")) {
                return this.readZip(new FileInputStream(src));
            }
            if (src.endsWith("igpack.zip")) {
                return this.readZip(new FileInputStream(src));
            }
            Manager.FhirFormat fmt = this.checkIsResource(src);
            if (fmt != null) {
                HashMap<String, byte[]> res = new HashMap<String, byte[]>();
                res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), TextFile.fileToBytes((String)src));
                return res;
            }
        } else if ((src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+$") || src.matches("^[a-z][a-z0-9\\_\\-]*(\\.[a-z0-9\\_\\-]+)+\\#[a-z0-9\\-\\_]+(\\.[a-z0-9\\-\\_]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            return this.fetchByPackage(src);
        }
        throw new Exception("Unable to find/resolve/read -ig " + src);
    }

    private Map<String, byte[]> fetchFromUrl(String src) throws Exception {
        if (src.endsWith(".tgz")) {
            return this.loadPackage(this.fetchFromUrlSpecific(src, false), src);
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true);
        if (stream != null) {
            return this.loadPackage(stream, Utilities.pathURL((String[])new String[]{src, "package.tgz"}));
        }
        stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "igpack.zip"}), true);
        if (stream != null) {
            return this.readZip(stream);
        }
        stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        if (stream != null) {
            return this.readZip(stream);
        }
        stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        Manager.FhirFormat fmt = this.checkIsResource(stream, src);
        if (fmt != null) {
            HashMap<String, byte[]> res = new HashMap<String, byte[]>();
            res.put(Utilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), TextFile.fileToBytes((String)src));
            return res;
        }
        throw new Exception("Unable to find/resolve/read -ig " + src);
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws Exception {
        try {
            URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
            URLConnection c = url.openConnection();
            return c.getInputStream();
        }
        catch (Exception e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private Map<String, byte[]> scanDirectory(File f) throws FileNotFoundException, IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (File ff : f.listFiles()) {
            Manager.FhirFormat fmt;
            if (this.isIgnoreFile(ff) || (fmt = this.checkIsResource(ff.getAbsolutePath())) == null) continue;
            res.put(Utilities.changeFileExt((String)ff.getName(), (String)("." + fmt.getExtension())), TextFile.fileToBytes((String)ff.getAbsolutePath()));
        }
        return res;
    }

    private boolean isIgnoreFile(File ff) {
        return Utilities.existsInList((String)ff.getName(), (String[])new String[]{".DS_Store"});
    }

    private Map<String, byte[]> loadPackage(InputStream stream, String name) throws FileNotFoundException, IOException {
        return this.loadPackage(this.pcm.extractLocally(stream, name));
    }

    public Map<String, byte[]> loadPackage(NpmPackage pi) throws IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (String s : pi.list("package")) {
            if (!s.startsWith("CodeSystem-") && !s.startsWith("ConceptMap-") && !s.startsWith("ImplementationGuide-") && !s.startsWith("StructureMap-") && !s.startsWith("ValueSet-") && !s.startsWith("StructureDefinition-")) continue;
            res.put(s, TextFile.streamToBytes((InputStream)pi.load("package", s)));
        }
        String ini = "[FHIR]\r\nversion=" + pi.fhirVersion() + "\r\n";
        res.put("version.info", ini.getBytes());
        return res;
    }

    private Map<String, byte[]> readZip(InputStream stream) throws IOException {
        ZipEntry ze;
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            int n;
            String name = ze.getName();
            ZipInputStream in = zip;
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((n = ((InputStream)in).read(buf, 0, 1024)) > -1) {
                b.write(buf, 0, n);
            }
            res.put(name, b.toByteArray());
            zip.closeEntry();
        }
        zip.close();
        return res;
    }

    public void log(String message) {
        System.out.println(message);
    }

    private Map<String, byte[]> fetchByPackage(String src) throws Exception {
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (this.pcm == null) {
            this.log("Creating Package manager?");
            this.pcm = new PackageCacheManager(true, 3);
        }
        NpmPackage pi = null;
        if (version == null) {
            pi = this.pcm.loadPackageFromCacheOnly(id);
            if (pi != null) {
                this.log("   ... Using version " + pi.version());
            }
        } else {
            pi = this.pcm.loadPackageFromCacheOnly(id, version);
        }
        if (pi == null) {
            return this.resolvePackage(id, version);
        }
        return this.loadPackage(pi);
    }

    private Map<String, byte[]> resolvePackage(String id, String v) throws Exception {
        try {
            this.pcm.checkBuildLoaded();
        }
        catch (IOException e) {
            this.log("Unable to connect to build.fhir.org to check on packages");
        }
        NpmPackage pi = this.pcm.loadPackage(id, v);
        if (pi != null && v == null) {
            this.log("   ... Using version " + pi.version());
        }
        return this.loadPackage(pi);
    }

    public SimpleWorkerContext getContext() {
        return this.context;
    }

    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    public void setNoInvariantChecks(boolean value) {
        this.noInvariantChecks = value;
    }

    private Manager.FhirFormat checkIsResource(InputStream stream, String filename) {
        System.out.println("   ..Detect format for " + filename);
        try {
            Manager.parse((IWorkerContext)this.context, (InputStream)stream, (Manager.FhirFormat)Manager.FhirFormat.XML);
            return Manager.FhirFormat.XML;
        }
        catch (Exception exception) {
            try {
                Manager.parse((IWorkerContext)this.context, (InputStream)stream, (Manager.FhirFormat)Manager.FhirFormat.JSON);
                return Manager.FhirFormat.JSON;
            }
            catch (Exception exception2) {
                try {
                    Manager.parse((IWorkerContext)this.context, (InputStream)stream, (Manager.FhirFormat)Manager.FhirFormat.TURTLE);
                    return Manager.FhirFormat.TURTLE;
                }
                catch (Exception exception3) {
                    try {
                        new StructureMapUtilities((IWorkerContext)this.context, null, null).parse(TextFile.streamToString((InputStream)stream), null);
                        return Manager.FhirFormat.TEXT;
                    }
                    catch (Exception exception4) {
                        System.out.println("     .. not a resource: " + filename);
                        return null;
                    }
                }
            }
        }
    }

    private Manager.FhirFormat checkIsResource(String path) throws FileNotFoundException {
        String ext = Utilities.getFileExtension((String)path);
        if (Utilities.existsInList((String)ext, (String[])new String[]{"xml"})) {
            return Manager.FhirFormat.XML;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"json"})) {
            return Manager.FhirFormat.JSON;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"ttl"})) {
            return Manager.FhirFormat.TURTLE;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"map"})) {
            return Manager.FhirFormat.TEXT;
        }
        if (Utilities.existsInList((String)ext, (String[])new String[]{"txt"})) {
            return Manager.FhirFormat.TEXT;
        }
        return this.checkIsResource(new FileInputStream(path), path);
    }

    public void connectToTSServer(String url, String log, FhirPublication version) throws URISyntaxException, FHIRException {
        this.context.setTlogging(false);
        if (url != null) {
            throw new NotImplementedException("Do not use R4 validator... being phased out");
        }
        this.context.setCanRunWithoutTerminology(true);
    }

    public void loadProfile(String src) throws Exception {
        if (this.context.hasResource(StructureDefinition.class, src)) {
            return;
        }
        if (this.context.hasResource(ImplementationGuide.class, src)) {
            return;
        }
        byte[] source = this.loadProfileSource(src);
        Manager.FhirFormat fmt = FormatUtilities.determineFormat((byte[])source);
        Resource r = FormatUtilities.makeParser((Manager.FhirFormat)fmt).parse(source);
        this.context.cacheResource(r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadIg(String src) throws IOException, FHIRException, Exception {
        String canonical = null;
        Map<String, byte[]> source = this.loadIgSource(src);
        String version = "4.0.0";
        if (this.version != null) {
            version = this.version;
        }
        if (source.containsKey("version.info")) {
            version = this.readInfoVersion(source.get("version.info"));
        }
        for (Map.Entry<String, byte[]> t : source.entrySet()) {
            String fn = t.getKey();
            if (this.exemptFile(fn)) continue;
            if (this.debug) {
                System.out.print("* load file: " + fn);
            }
            Resource r = null;
            try {
                org.hl7.fhir.dstu3.model.Resource res;
                if (version.equals("3.0.1") || version.equals("3.0.0")) {
                    if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                        res = new org.hl7.fhir.dstu3.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                        res = new org.hl7.fhir.dstu3.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    } else {
                        if (!fn.endsWith(".txt") && !fn.endsWith(".map")) throw new Exception("Unsupported format for " + fn);
                        res = new org.hl7.fhir.dstu3.utils.StructureMapUtilities(null).parse(new String(t.getValue()));
                    }
                    r = VersionConvertor_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)res, (boolean)false);
                } else if (version.equals("1.4.0")) {
                    if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                        res = new org.hl7.fhir.dstu2016may.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    } else {
                        if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new Exception("Unsupported format for " + fn);
                        res = new JsonParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    }
                    r = VersionConvertor_14_40.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
                } else if (version.equals("1.0.2")) {
                    if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                        res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    } else {
                        if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new Exception("Unsupported format for " + fn);
                        res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    }
                    IGR2ConvertorAdvisor advisor = new IGR2ConvertorAdvisor();
                    r = new VersionConvertor_10_40((VersionConvertorAdvisor40)advisor).convertResource((org.hl7.fhir.dstu2.model.Resource)res);
                } else {
                    if (!version.equals("4.0.0")) throw new Exception("Unsupported version " + version);
                    if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                        r = new XmlParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                        r = new org.hl7.fhir.r4.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(t.getValue()));
                    } else if (fn.endsWith(".txt")) {
                        r = new StructureMapUtilities((IWorkerContext)this.context, null, null).parse(TextFile.bytesToString((byte[])t.getValue()), fn);
                    } else {
                        if (!fn.endsWith(".txt") && !fn.endsWith(".map")) throw new Exception("Unsupported format for " + fn);
                        r = new StructureMapUtilities(null).parse(new String(t.getValue()), fn);
                    }
                }
                if (this.debug) {
                    System.out.println(" .. success");
                }
            }
            catch (Exception e) {
                if (!this.debug) throw new Exception("Error parsing " + fn + ": " + e.getMessage(), e);
                System.out.println(" .. failed: " + e.getMessage());
                throw new Exception("Error parsing " + fn + ": " + e.getMessage(), e);
            }
            if (r == null) continue;
            this.context.cacheResource(r);
            if (!(r instanceof ImplementationGuide) || !(canonical = ((ImplementationGuide)r).getUrl()).contains("/ImplementationGuide/")) continue;
            Resource r2 = r.copy();
            ((ImplementationGuide)r2).setUrl(canonical.substring(0, canonical.indexOf("/ImplementationGuide/")));
            this.context.cacheResource(r2);
        }
        if (canonical == null) return;
        this.grabNatives(source, canonical);
    }

    private boolean exemptFile(String fn) {
        return Utilities.existsInList((String)fn, (String[])new String[]{"spec.internals", "version.info", "schematron.zip"});
    }

    private String readInfoVersion(byte[] bs) throws IOException {
        String is = TextFile.bytesToString((byte[])bs);
        is = is.trim();
        IniFile ini = new IniFile((InputStream)new ByteArrayInputStream(TextFile.stringToBytes((String)is, (boolean)false)));
        return ini.getStringProperty("FHIR", "version");
    }

    private void grabNatives(Map<String, byte[]> source, String prefix) {
        for (Map.Entry<String, byte[]> e : source.entrySet()) {
            if (!e.getKey().endsWith(".zip")) continue;
            this.binaries.put(prefix + "#" + e.getKey(), e.getValue());
        }
    }

    public void setQuestionnaires(List<String> questionnaires) {
    }

    public void setNative(boolean doNative) {
        this.doNative = doNative;
    }

    public Content loadContent(String source, String opName) throws Exception {
        Map<String, byte[]> s = this.loadIgSource(source);
        Content res = new Content();
        if (s.size() != 1) {
            throw new Exception("Unable to find resource " + source + " to " + opName);
        }
        for (Map.Entry<String, byte[]> t : s.entrySet()) {
            res.focus = t.getValue();
            if (t.getKey().endsWith(".json")) {
                res.cntType = Manager.FhirFormat.JSON;
                continue;
            }
            if (t.getKey().endsWith(".xml")) {
                res.cntType = Manager.FhirFormat.XML;
                continue;
            }
            if (t.getKey().endsWith(".ttl")) {
                res.cntType = Manager.FhirFormat.TURTLE;
                continue;
            }
            if (t.getKey().endsWith(".txt") || t.getKey().endsWith(".map")) {
                res.cntType = Manager.FhirFormat.TEXT;
                continue;
            }
            throw new Exception("Todo: Determining resource type is not yet done");
        }
        return res;
    }

    public OperationOutcome validate(String source, List<String> profiles) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        l.add(source);
        return (OperationOutcome)this.validate(l, profiles);
    }

    public Resource validate(List<String> sources, List<String> profiles) throws Exception {
        ArrayList<String> refs = new ArrayList<String>();
        boolean asBundle = this.handleSources(sources, refs);
        Bundle results = new Bundle();
        results.setType(Bundle.BundleType.COLLECTION);
        for (String ref : refs) {
            Content cnt = this.loadContent(ref, "validate");
            if (refs.size() > 1) {
                System.out.println("Validate " + ref);
            }
            try {
                OperationOutcome outcome = this.validate(ref, cnt.focus, cnt.cntType, profiles);
                ToolingExtensions.addStringExtension((DomainResource)outcome, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file", (String)ref);
                if (refs.size() > 1) {
                    this.produceValidationSummary(outcome);
                }
                results.addEntry().setResource((Resource)outcome);
            }
            catch (Throwable e) {
                System.out.println("Validation Infrastructure fail validating " + ref + ": " + e.getMessage());
            }
        }
        if (asBundle) {
            return results;
        }
        return results.getEntryFirstRep().getResource();
    }

    private void produceValidationSummary(OperationOutcome oo) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : oo.getIssue()) {
            if (iss.getSeverity() != OperationOutcome.IssueSeverity.ERROR && iss.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            System.out.println("  " + iss.getSeverity().toCode() + ": " + iss.getDetails().getText());
        }
    }

    public OperationOutcome validateString(String location, String source, Manager.FhirFormat format, List<String> profiles) throws Exception {
        return this.validate(location, source.getBytes(), format, profiles);
    }

    public boolean handleSources(List<String> sources, List<String> refs) throws IOException {
        boolean asBundle = sources.size() > 1;
        for (String source : sources) {
            if (!this.handleSource(source, refs)) continue;
            asBundle = true;
        }
        return asBundle;
    }

    private boolean handleSource(String name, List<String> refs) throws IOException {
        boolean isBundle = false;
        if (name.startsWith("https:") || name.startsWith("http:")) {
            refs.add(name);
        } else if (name.contains("*")) {
            isBundle = true;
            AsteriskFilter filter = new AsteriskFilter(name);
            File[] files = new File(filter.getDir()).listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                refs.add(files[i].getPath());
            }
        } else {
            File file = new File(name);
            if (!file.exists()) {
                throw new IOException("File " + name + " does not exist");
            }
            if (file.isFile()) {
                refs.add(name);
            } else {
                isBundle = true;
                for (int i = 0; i < file.listFiles().length; ++i) {
                    File[] fileList = file.listFiles();
                    if (!fileList[i].isFile()) continue;
                    refs.add(fileList[i].getPath());
                }
            }
        }
        return isBundle;
    }

    public OperationOutcome validate(String location, byte[] source, Manager.FhirFormat cntType, List<String> profiles) throws Exception {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            if (cntType == Manager.FhirFormat.JSON) {
                this.validateJsonSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.XML) {
                this.validateXmlSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.TURTLE) {
                this.validateSHEX(location, messages);
            }
        }
        InstanceValidator validator = this.getValidator();
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, new ValidationProfileSet(profiles, true));
        return this.messagesToOutcome(messages);
    }

    public OperationOutcome validate(String location, byte[] source, Manager.FhirFormat cntType, List<String> profiles, IResourceValidator.IdStatus resourceIdRule, boolean anyExtensionsAllowed, IResourceValidator.BestPracticeWarningLevel bpWarnings, IResourceValidator.CheckDisplayOption displayOption) throws Exception {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            if (cntType == Manager.FhirFormat.JSON) {
                this.validateJsonSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.XML) {
                this.validateXmlSchema(location, messages);
            }
            if (cntType == Manager.FhirFormat.TURTLE) {
                this.validateSHEX(location, messages);
            }
        }
        InstanceValidator validator = this.getValidator();
        validator.setResourceIdRule(resourceIdRule);
        validator.setBestPracticeWarningLevel(bpWarnings);
        validator.setCheckDisplay(displayOption);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, new ValidationProfileSet(profiles, true));
        return this.messagesToOutcome(messages);
    }

    private void validateSHEX(String location, List<ValidationMessage> messages) {
        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.INFORMATIONAL, location, "SHEX Validation is not done yet", ValidationMessage.IssueSeverity.INFORMATION));
    }

    private void validateXmlSchema(String location, List<ValidationMessage> messages) throws FileNotFoundException, IOException, SAXException {
        XmlValidator xml = new XmlValidator(messages, this.loadSchemas(), this.loadTransforms());
        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.INFORMATIONAL, location, "XML Schema Validation is not done yet", ValidationMessage.IssueSeverity.INFORMATION));
    }

    private Map<String, byte[]> loadSchemas() throws IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : this.readZip(new ByteArrayInputStream(this.binaries.get("http://hl7.org/fhir#fhir-all-xsd.zip"))).entrySet()) {
            if (e.getKey().equals("fhir-single.xsd")) {
                res.put(e.getKey(), e.getValue());
            }
            if (!e.getKey().equals("fhir-invariants.sch")) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private Map<String, byte[]> loadTransforms() throws IOException {
        HashMap<String, byte[]> res = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : this.readZip(new ByteArrayInputStream(this.binaries.get("http://hl7.org/fhir#fhir-all-xsd.zip"))).entrySet()) {
            if (!e.getKey().endsWith(".xsl")) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private void validateJsonSchema(String location, List<ValidationMessage> messages) {
        messages.add(new ValidationMessage(ValidationMessage.Source.InstanceValidator, ValidationMessage.IssueType.INFORMATIONAL, location, "JSON Schema Validation is not done yet", ValidationMessage.IssueSeverity.INFORMATION));
    }

    private List<ValidationMessage> filterMessages(List<ValidationMessage> messages) {
        ArrayList<ValidationMessage> filteredValidation = new ArrayList<ValidationMessage>();
        for (ValidationMessage e : messages) {
            if (filteredValidation.contains(e)) continue;
            filteredValidation.add(e);
        }
        filteredValidation.sort(null);
        return filteredValidation;
    }

    private OperationOutcome messagesToOutcome(List<ValidationMessage> messages) throws DefinitionException {
        OperationOutcome op = new OperationOutcome();
        for (ValidationMessage vm : this.filterMessages(messages)) {
            op.getIssue().add(OperationOutcomeUtilities.convertToIssue((ValidationMessage)vm, (OperationOutcome)op));
        }
        new NarrativeGenerator("", "", (IWorkerContext)this.context).generate(null, op);
        return op;
    }

    public static String issueSummary(OperationOutcome.OperationOutcomeIssueComponent issue) {
        String source = ToolingExtensions.readStringExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        return issue.getSeverity().toString() + " @ " + issue.getLocation() + " " + issue.getDetails().getText() + (source != null ? " (src = " + source + ")" : "");
    }

    public Resource transform(String source, String map) throws Exception {
        Content cnt = this.loadContent(source, "validate");
        return this.transform(cnt.focus, cnt.cntType, map);
    }

    public Resource transform(byte[] source, Manager.FhirFormat cntType, String mapUri) throws Exception {
        ArrayList<Resource> outputs = new ArrayList<Resource>();
        StructureMapUtilities scu = new StructureMapUtilities((IWorkerContext)this.context, (StructureMapUtilities.ITransformerServices)new TransformSupportServices(outputs));
        org.hl7.fhir.r4.elementmodel.Element src = Manager.parse((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(source), (Manager.FhirFormat)cntType);
        StructureMap map = this.context.getTransform(mapUri);
        if (map == null) {
            throw new Error("Unable to find map " + mapUri + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        scu.transform(null, (Base)src, map, null);
        if (outputs.size() == 0) {
            throw new Exception("This transform did not produce an output");
        }
        if (outputs.size() > 1) {
            throw new Exception("This transform did produced multiple outputs which is not supported in this context");
        }
        return (Resource)outputs.get(0);
    }

    public DomainResource generate(String source) throws Exception {
        Resource res;
        Content cnt = this.loadContent(source, "validate");
        if (cnt.cntType == Manager.FhirFormat.XML) {
            res = new XmlParser().parse(cnt.focus);
        } else if (cnt.cntType == Manager.FhirFormat.JSON) {
            res = new org.hl7.fhir.r4.formats.JsonParser().parse(cnt.focus);
        } else if (cnt.cntType == Manager.FhirFormat.TURTLE) {
            res = new RdfParser().parse(cnt.focus);
        } else {
            throw new Error("Not supported yet");
        }
        new NarrativeGenerator("", "", (IWorkerContext)this.context).generate((DomainResource)res, null);
        return (DomainResource)res;
    }

    public StructureDefinition snapshot(String source) throws Exception {
        Resource res;
        Content cnt = this.loadContent(source, "validate");
        if (cnt.cntType == Manager.FhirFormat.XML) {
            res = new XmlParser().parse(cnt.focus);
        } else if (cnt.cntType == Manager.FhirFormat.JSON) {
            res = new org.hl7.fhir.r4.formats.JsonParser().parse(cnt.focus);
        } else if (cnt.cntType == Manager.FhirFormat.TURTLE) {
            res = new RdfParser().parse(cnt.focus);
        } else {
            throw new Error("Not supported yet");
        }
        if (!(res instanceof StructureDefinition)) {
            throw new Exception("Require a StructureDefinition for generating a snapshot");
        }
        StructureDefinition sd = (StructureDefinition)res;
        StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        new ProfileUtilities((IWorkerContext)this.context, null, null).generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir/R4", sd.getName());
        return sd;
    }

    public void seeResource(Resource r) throws FHIRException {
        this.context.cacheResource(r);
    }

    public void dropResource(String type, String id) {
        this.context.dropResource(type, id);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public InstanceValidator getValidator() {
        InstanceValidator validator = new InstanceValidator((IWorkerContext)this.context, null);
        validator.setHintAboutNonMustSupport(this.hintAboutNonMustSupport);
        validator.setAnyExtensionsAllowed(this.anyExtensionsAllowed);
        validator.setNoInvariantChecks(this.isNoInvariantChecks());
        return validator;
    }

    public void setMapLog(String mapLog) throws FileNotFoundException {
        this.mapLog = new PrintWriter(mapLog);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private class Content {
        byte[] focus = null;
        Manager.FhirFormat cntType = null;

        private Content() {
        }
    }

    private class AsteriskFilter
    implements FilenameFilter {
        String dir;
        String regex;

        public AsteriskFilter(String filter) throws IOException {
            if (!filter.matches("(.*(\\\\|\\/))*(.*)\\*(.*)")) {
                throw new IOException("Filter names must have the following syntax: [directorypath][prefix]?*[suffix]?   I.e. The asterisk must be in the filename, not the directory path");
            }
            this.dir = filter.replaceAll("(.*(\\\\|\\/))*(.*)\\*(.*)", "$1");
            String expression = filter.replaceAll("(.*(\\\\|\\/))*(.*)", "$3");
            this.regex = "";
            for (int i = 0; i < expression.length(); ++i) {
                this.regex = Character.isAlphabetic(expression.codePointAt(i)) || Character.isDigit(expression.codePointAt(i)) ? this.regex + expression.charAt(i) : (expression.charAt(i) == '*' ? this.regex + ".*" : this.regex + "\\" + expression.charAt(i));
            }
            File f = new File(this.dir);
            if (!f.exists()) {
                throw new IOException("Directory " + this.dir + " does not exist");
            }
            if (!f.isDirectory()) {
                throw new IOException("Directory " + this.dir + " is not a directory");
            }
        }

        @Override
        public boolean accept(File dir, String s) {
            boolean match = s.matches(this.regex);
            return match;
        }

        public String getDir() {
            return this.dir;
        }
    }

    public class TransformSupportServices
    implements StructureMapUtilities.ITransformerServices {
        private List<Resource> outputs;

        public TransformSupportServices(List<Resource> outputs) {
            this.outputs = outputs;
        }

        public void log(String message) {
            if (ValidationEngine.this.mapLog != null) {
                ValidationEngine.this.mapLog.println(message);
            }
            System.out.println(message);
        }

        public Base createType(Object appInfo, String name) throws FHIRException {
            StructureDefinition sd = (StructureDefinition)ValidationEngine.this.context.fetchResource(StructureDefinition.class, name);
            if (sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
                return Manager.build((IWorkerContext)ValidationEngine.this.context, (StructureDefinition)sd);
            }
            if (name.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                name = name.substring("http://hl7.org/fhir/StructureDefinition/".length());
            }
            return ResourceFactory.createResourceOrType((String)name);
        }

        public Base createResource(Object appInfo, Base res, boolean atRootofTransform) {
            if (atRootofTransform) {
                this.outputs.add((Resource)res);
            }
            return res;
        }

        public Coding translate(Object appInfo, Coding source, String conceptMapUrl) throws FHIRException {
            ConceptMapEngine cme = new ConceptMapEngine(ValidationEngine.this.context);
            return cme.translate(source, conceptMapUrl);
        }

        public Base resolveReference(Object appContext, String url) throws FHIRException {
            throw new FHIRException("resolveReference is not supported yet");
        }

        public List<Base> performSearch(Object appContext, String url) throws FHIRException {
            throw new FHIRException("performSearch is not supported yet");
        }
    }
}

