/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.utilities.xml.XMLUtil;

public class MeasureContext {
    public static final String USER_DATA_ELM = "validator.ELM";
    private List<Library> libs = new ArrayList<Library>();
    private Measure measure;
    private Element report;

    public MeasureContext() {
    }

    public MeasureContext(Measure measure, Element report) {
        this.measure = measure;
        this.report = report;
    }

    public void seeLibrary(Library l) {
        this.libs.add(l);
        for (Attachment att : l.getContent()) {
            if (!"application/elm+xml".equals(att.getContentType())) continue;
            try {
                l.setUserData(USER_DATA_ELM, (Object)XMLUtil.parseToDom((byte[])att.getData(), (boolean)true));
            }
            catch (Exception e) {
                l.setUserData(USER_DATA_ELM, (Object)e.getMessage());
            }
        }
    }

    public List<Measure.MeasureGroupComponent> groups() {
        return this.measure.getGroup();
    }

    public Measure measure() {
        return this.measure;
    }

    public String reportType() {
        return this.report.getChildValue("type");
    }

    public String scoring() {
        return this.measure.getScoring().getCodingFirstRep().getCode();
    }

    public List<Library> libraries() {
        return this.libs;
    }
}

