/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli;

import io.javalin.Javalin;
import java.awt.Desktop;
import java.net.URI;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.RestEndpoints;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.utils.Common;

public class ValidatorGui {
    private static final int GUI_FRONTEND_PORT = 8081;
    private static final String PAGE_ADDRESS = "http://localhost:8081/home";
    private static final String WEB_APP_FILE_LOCATION = "/public";
    private static Javalin app;

    private ValidatorGui() {
    }

    public static void main(String[] args) throws Exception {
        CliContext cliContext = new CliContext();
        String v = Common.getVersion(args);
        String definitions = VersionUtilities.packageForVersion((String)v) + "#" + v;
        ValidationEngine validationEngine = Common.getValidationEngine(v, definitions, cliContext.getTxLog());
        ValidatorGui.start(new CliContext(), validationEngine, false);
    }

    public static int getPort() {
        return 8081;
    }

    public static void start(CliContext currentContext, ValidationEngine validationEngine, boolean bootBrowser) {
        app = Javalin.create();
        new RestEndpoints().initRestEndpoints(app, currentContext, validationEngine);
        ValidatorGui.app.config.addStaticFiles(WEB_APP_FILE_LOCATION);
        app.start(8081);
        if (bootBrowser) {
            ValidatorGui.openBrowser();
        }
    }

    public static void openBrowser() {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(PAGE_ADDRESS));
            }
            catch (Exception e) {
                System.out.println("Error opening web browser to validator GUI.\nYou can try to open the page manually at:: http://localhost:8081/home\nError:: " + e.getMessage());
            }
        }
    }

    public static void stop() {
        app.stop();
    }
}

