/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RemittanceOutcome {
    COMPLETE,
    ERROR,
    NULL;


    public static RemittanceOutcome fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        throw new FHIRException("Unknown RemittanceOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case ERROR: {
                return "error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/remittance-outcome";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLETE: {
                return "The processing completed without errors.";
            }
            case ERROR: {
                return "The processing identified errors.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLETE: {
                return "Complete";
            }
            case ERROR: {
                return "Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

