/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.MetricCategory;

public class MetricCategoryEnumFactory
implements EnumFactory<MetricCategory> {
    @Override
    public MetricCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("measurement".equals(codeString)) {
            return MetricCategory.MEASUREMENT;
        }
        if ("setting".equals(codeString)) {
            return MetricCategory.SETTING;
        }
        if ("calculation".equals(codeString)) {
            return MetricCategory.CALCULATION;
        }
        if ("unspecified".equals(codeString)) {
            return MetricCategory.UNSPECIFIED;
        }
        throw new IllegalArgumentException("Unknown MetricCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MetricCategory code) {
        if (code == MetricCategory.NULL) {
            return null;
        }
        if (code == MetricCategory.MEASUREMENT) {
            return "measurement";
        }
        if (code == MetricCategory.SETTING) {
            return "setting";
        }
        if (code == MetricCategory.CALCULATION) {
            return "calculation";
        }
        if (code == MetricCategory.UNSPECIFIED) {
            return "unspecified";
        }
        return "?";
    }

    @Override
    public String toSystem(MetricCategory code) {
        return code.getSystem();
    }
}

