/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.LinkageType;

public class LinkageTypeEnumFactory
implements EnumFactory<LinkageType> {
    @Override
    public LinkageType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("source".equals(codeString)) {
            return LinkageType.SOURCE;
        }
        if ("alternate".equals(codeString)) {
            return LinkageType.ALTERNATE;
        }
        if ("historical".equals(codeString)) {
            return LinkageType.HISTORICAL;
        }
        throw new IllegalArgumentException("Unknown LinkageType code '" + codeString + "'");
    }

    @Override
    public String toCode(LinkageType code) {
        if (code == LinkageType.NULL) {
            return null;
        }
        if (code == LinkageType.SOURCE) {
            return "source";
        }
        if (code == LinkageType.ALTERNATE) {
            return "alternate";
        }
        if (code == LinkageType.HISTORICAL) {
            return "historical";
        }
        return "?";
    }

    @Override
    public String toSystem(LinkageType code) {
        return code.getSystem();
    }
}

