/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.DiagnosticOrderStatus;

public class DiagnosticOrderStatusEnumFactory
implements EnumFactory<DiagnosticOrderStatus> {
    @Override
    public DiagnosticOrderStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return DiagnosticOrderStatus.PROPOSED;
        }
        if ("draft".equals(codeString)) {
            return DiagnosticOrderStatus.DRAFT;
        }
        if ("planned".equals(codeString)) {
            return DiagnosticOrderStatus.PLANNED;
        }
        if ("requested".equals(codeString)) {
            return DiagnosticOrderStatus.REQUESTED;
        }
        if ("received".equals(codeString)) {
            return DiagnosticOrderStatus.RECEIVED;
        }
        if ("accepted".equals(codeString)) {
            return DiagnosticOrderStatus.ACCEPTED;
        }
        if ("in-progress".equals(codeString)) {
            return DiagnosticOrderStatus.INPROGRESS;
        }
        if ("review".equals(codeString)) {
            return DiagnosticOrderStatus.REVIEW;
        }
        if ("completed".equals(codeString)) {
            return DiagnosticOrderStatus.COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return DiagnosticOrderStatus.CANCELLED;
        }
        if ("suspended".equals(codeString)) {
            return DiagnosticOrderStatus.SUSPENDED;
        }
        if ("rejected".equals(codeString)) {
            return DiagnosticOrderStatus.REJECTED;
        }
        if ("failed".equals(codeString)) {
            return DiagnosticOrderStatus.FAILED;
        }
        if ("entered-in-error".equals(codeString)) {
            return DiagnosticOrderStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown DiagnosticOrderStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(DiagnosticOrderStatus code) {
        if (code == DiagnosticOrderStatus.NULL) {
            return null;
        }
        if (code == DiagnosticOrderStatus.PROPOSED) {
            return "proposed";
        }
        if (code == DiagnosticOrderStatus.DRAFT) {
            return "draft";
        }
        if (code == DiagnosticOrderStatus.PLANNED) {
            return "planned";
        }
        if (code == DiagnosticOrderStatus.REQUESTED) {
            return "requested";
        }
        if (code == DiagnosticOrderStatus.RECEIVED) {
            return "received";
        }
        if (code == DiagnosticOrderStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == DiagnosticOrderStatus.INPROGRESS) {
            return "in-progress";
        }
        if (code == DiagnosticOrderStatus.REVIEW) {
            return "review";
        }
        if (code == DiagnosticOrderStatus.COMPLETED) {
            return "completed";
        }
        if (code == DiagnosticOrderStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == DiagnosticOrderStatus.SUSPENDED) {
            return "suspended";
        }
        if (code == DiagnosticOrderStatus.REJECTED) {
            return "rejected";
        }
        if (code == DiagnosticOrderStatus.FAILED) {
            return "failed";
        }
        if (code == DiagnosticOrderStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(DiagnosticOrderStatus code) {
        return code.getSystem();
    }
}

