/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ContractSubtype;

public class ContractSubtypeEnumFactory
implements EnumFactory<ContractSubtype> {
    @Override
    public ContractSubtype fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("disclosure-CA".equals(codeString)) {
            return ContractSubtype.DISCLOSURECA;
        }
        if ("disclosure-US".equals(codeString)) {
            return ContractSubtype.DISCLOSUREUS;
        }
        throw new IllegalArgumentException("Unknown ContractSubtype code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractSubtype code) {
        if (code == ContractSubtype.NULL) {
            return null;
        }
        if (code == ContractSubtype.DISCLOSURECA) {
            return "disclosure-CA";
        }
        if (code == ContractSubtype.DISCLOSUREUS) {
            return "disclosure-US";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractSubtype code) {
        return code.getSystem();
    }
}

