/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ContentType;

public class ContentTypeEnumFactory
implements EnumFactory<ContentType> {
    @Override
    public ContentType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("xml".equals(codeString)) {
            return ContentType.XML;
        }
        if ("json".equals(codeString)) {
            return ContentType.JSON;
        }
        throw new IllegalArgumentException("Unknown ContentType code '" + codeString + "'");
    }

    @Override
    public String toCode(ContentType code) {
        if (code == ContentType.NULL) {
            return null;
        }
        if (code == ContentType.XML) {
            return "xml";
        }
        if (code == ContentType.JSON) {
            return "json";
        }
        return "?";
    }

    @Override
    public String toSystem(ContentType code) {
        return code.getSystem();
    }
}

