/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="StructureDefinition", profile="http://hl7.org/fhir/Profile/StructureDefinition")
public class StructureDefinition
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Absolute URL used to reference this StructureDefinition", formalDefinition="An absolute URL that is used to identify this structure definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure definition is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the StructureDefinition", formalDefinition="Formal identifier that is used to identify this StructureDefinition when it is represented in other formats, or referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI), (if it's not possible to use the literal URI).")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the StructureDefinition", formalDefinition="The identifier that is used to identify this version of the StructureDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the StructureDefinition author manually.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this StructureDefinition", formalDefinition="A free text natural language name identifying the StructureDefinition.")
    protected StringType name;
    @Child(name="display", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Use this name when displaying the value", formalDefinition="Defined so that applications can use this name when displaying the value of the extension to the user.")
    protected StringType display;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the StructureDefinition.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This StructureDefinition was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the structure definition.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<StructureDefinitionContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for this version of the StructureDefinition", formalDefinition="The date this version of the structure definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the structure definition changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the StructureDefinition", formalDefinition="A free text natural language description of the StructureDefinition and its use.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of structure definitions.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Scope and Usage this structure definition is for", formalDefinition="Explains why this structure definition is needed and why it's been constrained as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.")
    protected StringType copyright;
    @Child(name="code", type={Coding.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Assist with indexing and finding", formalDefinition="A set of terms from external terminologies that may be used to assist with indexing and searching of templates.")
    protected List<Coding> code;
    @Child(name="fhirVersion", type={IdType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version this StructureDefinition targets", formalDefinition="The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 1.4.0 for this version.")
    protected IdType fhirVersion;
    @Child(name="mapping", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External specification that the content is mapped to", formalDefinition="An external specification that the content is mapped to.")
    protected List<StructureDefinitionMappingComponent> mapping;
    @Child(name="kind", type={CodeType.class}, order=17, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="datatype | resource | logical", formalDefinition="Defines the kind of structure that this definition is describing.")
    protected Enumeration<StructureDefinitionKind> kind;
    @Child(name="abstract", type={BooleanType.class}, order=18, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the structure is abstract", formalDefinition="Whether structure this definition describes is abstract or not  - that is, whether an actual exchanged item can ever be of this type.")
    protected BooleanType abstract_;
    @Child(name="contextType", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="resource | datatype | extension", formalDefinition="If this is an extension, Identifies the context within FHIR resources where the extension can be used.")
    protected Enumeration<ExtensionContext> contextType;
    @Child(name="context", type={StringType.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Where the extension can be used in instances", formalDefinition="Identifies the types of resource or data type elements to which the extension can be applied.")
    protected List<StringType> context;
    @Child(name="baseType", type={CodeType.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Any datatype or resource, including abstract ones", formalDefinition="The type of type that this structure is derived from - a data type, an extension, a resource, including abstract ones. If this field is present, it indicates that the structure definition is deriving from this type. If it is not present, then the structure definition is the definition of a base abstract structure.")
    protected CodeType baseType;
    @Child(name="baseDefinition", type={UriType.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Definition that this type is constrained/specialized from", formalDefinition="An absolute URI that is the base structure from which this type is derived, either by specialization or constraint.")
    protected UriType baseDefinition;
    @Child(name="derivation", type={CodeType.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="specialization | constraint - How relates to base definition", formalDefinition="How the type relates to the baseDefinition.")
    protected Enumeration<TypeDerivationRule> derivation;
    @Child(name="snapshot", type={}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Snapshot view of the structure", formalDefinition="A snapshot view is expressed in a stand alone form that can be used and interpreted without considering the base StructureDefinition.")
    protected StructureDefinitionSnapshotComponent snapshot;
    @Child(name="differential", type={}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Differential view of the structure", formalDefinition="A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies.")
    protected StructureDefinitionDifferentialComponent differential;
    private static final long serialVersionUID = -1505153076L;
    @SearchParamDefinition(name="abstract", path="StructureDefinition.abstract", description="Whether the structure is abstract", type="token")
    public static final String SP_ABSTRACT = "abstract";
    public static final TokenClientParam ABSTRACT = new TokenClientParam("abstract");
    @SearchParamDefinition(name="status", path="StructureDefinition.status", description="The current status of the profile", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="experimental", path="StructureDefinition.experimental", description="If for testing purposes, not real usage", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="display", path="StructureDefinition.display", description="Use this name when displaying the value", type="string")
    public static final String SP_DISPLAY = "display";
    public static final StringClientParam DISPLAY = new StringClientParam("display");
    @SearchParamDefinition(name="ext-context", path="StructureDefinition.context", description="Where the extension can be used in instances", type="string")
    public static final String SP_EXT_CONTEXT = "ext-context";
    public static final StringClientParam EXT_CONTEXT = new StringClientParam("ext-context");
    @SearchParamDefinition(name="code", path="StructureDefinition.code", description="A code for the profile", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="StructureDefinition.date", description="The profile publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="type", path="StructureDefinition.baseType", description="Any datatype or resource, including abstract ones", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="StructureDefinition.url", description="Absolute URL used to reference this StructureDefinition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="kind", path="StructureDefinition.kind", description="datatype | resource | logical", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="version", path="StructureDefinition.version", description="The version identifier of the profile", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="publisher", path="StructureDefinition.publisher", description="Name of the publisher of the profile", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="derivation", path="StructureDefinition.derivation", description="specialization | constraint - How relates to base definition", type="token")
    public static final String SP_DERIVATION = "derivation";
    public static final TokenClientParam DERIVATION = new TokenClientParam("derivation");
    @SearchParamDefinition(name="base-path", path="StructureDefinition.snapshot.element.base.path | StructureDefinition.differential.element.base.path", description="Path that identifies the base element", type="token")
    public static final String SP_BASE_PATH = "base-path";
    public static final TokenClientParam BASE_PATH = new TokenClientParam("base-path");
    @SearchParamDefinition(name="valueset", path="StructureDefinition.snapshot.element.binding.valueSet", description="A vocabulary binding reference", type="reference")
    public static final String SP_VALUESET = "valueset";
    public static final ReferenceClientParam VALUESET = new ReferenceClientParam("valueset");
    public static final Include INCLUDE_VALUESET = new Include("StructureDefinition:valueset").toLocked();
    @SearchParamDefinition(name="context-type", path="StructureDefinition.contextType", description="resource | datatype | extension", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="description", path="StructureDefinition.description", description="Text search in the description of the profile", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="StructureDefinition.name", description="Name of the profile", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="base", path="StructureDefinition.baseDefinition", description="Definition that this type is constrained/specialized from", type="uri")
    public static final String SP_BASE = "base";
    public static final UriClientParam BASE = new UriClientParam("base");
    @SearchParamDefinition(name="context", path="StructureDefinition.useContext", description="A use context assigned to the structure", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="path", path="StructureDefinition.snapshot.element.path | StructureDefinition.differential.element.path", description="A path that is constrained in the profile", type="token")
    public static final String SP_PATH = "path";
    public static final TokenClientParam PATH = new TokenClientParam("path");
    @SearchParamDefinition(name="identifier", path="StructureDefinition.identifier", description="The identifier of the profile", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public StructureDefinition() {
    }

    public StructureDefinition(UriType url, StringType name, Enumeration<Enumerations.ConformanceResourceStatus> status, Enumeration<StructureDefinitionKind> kind, BooleanType abstract_) {
        this.url = url;
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.abstract_ = abstract_;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public StructureDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public StructureDefinition setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public StructureDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public StructureDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public StructureDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public StructureDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public StructureDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public StringType getDisplayElement() {
        if (this.display == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.display");
            }
            if (Configuration.doAutoCreate()) {
                this.display = new StringType();
            }
        }
        return this.display;
    }

    public boolean hasDisplayElement() {
        return this.display != null && !this.display.isEmpty();
    }

    public boolean hasDisplay() {
        return this.display != null && !this.display.isEmpty();
    }

    public StructureDefinition setDisplayElement(StringType value) {
        this.display = value;
        return this;
    }

    public String getDisplay() {
        return this.display == null ? null : (String)this.display.getValue();
    }

    public StructureDefinition setDisplay(String value) {
        if (Utilities.noString((String)value)) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public StructureDefinition setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public StructureDefinition setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public StructureDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public StructureDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public StructureDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public StructureDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<StructureDefinitionContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<StructureDefinitionContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (StructureDefinitionContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureDefinitionContactComponent addContact() {
        StructureDefinitionContactComponent t = new StructureDefinitionContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<StructureDefinitionContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public StructureDefinition addContact(StructureDefinitionContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<StructureDefinitionContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public StructureDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public StructureDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public StructureDefinition setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public StructureDefinition setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public StructureDefinition addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public StructureDefinition setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public StructureDefinition setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public StructureDefinition setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public StructureDefinition setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<Coding> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        return this.code;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (Coding item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addCode() {
        Coding t = new Coding();
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return t;
    }

    public StructureDefinition addCode(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<Coding>();
        }
        this.code.add(t);
        return this;
    }

    public IdType getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new IdType();
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public StructureDefinition setFhirVersionElement(IdType value) {
        this.fhirVersion = value;
        return this;
    }

    public String getFhirVersion() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public StructureDefinition setFhirVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.fhirVersion = null;
        } else {
            if (this.fhirVersion == null) {
                this.fhirVersion = new IdType();
            }
            this.fhirVersion.setValue(value);
        }
        return this;
    }

    public List<StructureDefinitionMappingComponent> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMappingComponent>();
        }
        return this.mapping;
    }

    public boolean hasMapping() {
        if (this.mapping == null) {
            return false;
        }
        for (StructureDefinitionMappingComponent item : this.mapping) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureDefinitionMappingComponent addMapping() {
        StructureDefinitionMappingComponent t = new StructureDefinitionMappingComponent();
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return t;
    }

    public StructureDefinition addMapping(StructureDefinitionMappingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return this;
    }

    public Enumeration<StructureDefinitionKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<StructureDefinitionKind>(new StructureDefinitionKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public StructureDefinition setKindElement(Enumeration<StructureDefinitionKind> value) {
        this.kind = value;
        return this;
    }

    public StructureDefinitionKind getKind() {
        return this.kind == null ? null : (StructureDefinitionKind)((Object)this.kind.getValue());
    }

    public StructureDefinition setKind(StructureDefinitionKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<StructureDefinitionKind>(new StructureDefinitionKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public BooleanType getAbstractElement() {
        if (this.abstract_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.abstract_");
            }
            if (Configuration.doAutoCreate()) {
                this.abstract_ = new BooleanType();
            }
        }
        return this.abstract_;
    }

    public boolean hasAbstractElement() {
        return this.abstract_ != null && !this.abstract_.isEmpty();
    }

    public boolean hasAbstract() {
        return this.abstract_ != null && !this.abstract_.isEmpty();
    }

    public StructureDefinition setAbstractElement(BooleanType value) {
        this.abstract_ = value;
        return this;
    }

    public boolean getAbstract() {
        return this.abstract_ == null || this.abstract_.isEmpty() ? false : (Boolean)this.abstract_.getValue();
    }

    public StructureDefinition setAbstract(boolean value) {
        if (this.abstract_ == null) {
            this.abstract_ = new BooleanType();
        }
        this.abstract_.setValue((Object)value);
        return this;
    }

    public Enumeration<ExtensionContext> getContextTypeElement() {
        if (this.contextType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.contextType");
            }
            if (Configuration.doAutoCreate()) {
                this.contextType = new Enumeration<ExtensionContext>(new ExtensionContextEnumFactory());
            }
        }
        return this.contextType;
    }

    public boolean hasContextTypeElement() {
        return this.contextType != null && !this.contextType.isEmpty();
    }

    public boolean hasContextType() {
        return this.contextType != null && !this.contextType.isEmpty();
    }

    public StructureDefinition setContextTypeElement(Enumeration<ExtensionContext> value) {
        this.contextType = value;
        return this;
    }

    public ExtensionContext getContextType() {
        return this.contextType == null ? null : (ExtensionContext)((Object)this.contextType.getValue());
    }

    public StructureDefinition setContextType(ExtensionContext value) {
        if (value == null) {
            this.contextType = null;
        } else {
            if (this.contextType == null) {
                this.contextType = new Enumeration<ExtensionContext>(new ExtensionContextEnumFactory());
            }
            this.contextType.setValue((Object)value);
        }
        return this;
    }

    public List<StringType> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<StringType>();
        }
        return this.context;
    }

    public boolean hasContext() {
        if (this.context == null) {
            return false;
        }
        for (StringType item : this.context) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addContextElement() {
        StringType t = new StringType();
        if (this.context == null) {
            this.context = new ArrayList<StringType>();
        }
        this.context.add(t);
        return t;
    }

    public StructureDefinition addContext(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.context == null) {
            this.context = new ArrayList<StringType>();
        }
        this.context.add(t);
        return this;
    }

    public boolean hasContext(String value) {
        if (this.context == null) {
            return false;
        }
        for (StringType v : this.context) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public CodeType getBaseTypeElement() {
        if (this.baseType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.baseType");
            }
            if (Configuration.doAutoCreate()) {
                this.baseType = new CodeType();
            }
        }
        return this.baseType;
    }

    public boolean hasBaseTypeElement() {
        return this.baseType != null && !this.baseType.isEmpty();
    }

    public boolean hasBaseType() {
        return this.baseType != null && !this.baseType.isEmpty();
    }

    public StructureDefinition setBaseTypeElement(CodeType value) {
        this.baseType = value;
        return this;
    }

    public String getBaseType() {
        return this.baseType == null ? null : (String)this.baseType.getValue();
    }

    public StructureDefinition setBaseType(String value) {
        if (Utilities.noString((String)value)) {
            this.baseType = null;
        } else {
            if (this.baseType == null) {
                this.baseType = new CodeType();
            }
            this.baseType.setValue(value);
        }
        return this;
    }

    public UriType getBaseDefinitionElement() {
        if (this.baseDefinition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.baseDefinition");
            }
            if (Configuration.doAutoCreate()) {
                this.baseDefinition = new UriType();
            }
        }
        return this.baseDefinition;
    }

    public boolean hasBaseDefinitionElement() {
        return this.baseDefinition != null && !this.baseDefinition.isEmpty();
    }

    public boolean hasBaseDefinition() {
        return this.baseDefinition != null && !this.baseDefinition.isEmpty();
    }

    public StructureDefinition setBaseDefinitionElement(UriType value) {
        this.baseDefinition = value;
        return this;
    }

    public String getBaseDefinition() {
        return this.baseDefinition == null ? null : (String)this.baseDefinition.getValue();
    }

    public StructureDefinition setBaseDefinition(String value) {
        if (Utilities.noString((String)value)) {
            this.baseDefinition = null;
        } else {
            if (this.baseDefinition == null) {
                this.baseDefinition = new UriType();
            }
            this.baseDefinition.setValue(value);
        }
        return this;
    }

    public Enumeration<TypeDerivationRule> getDerivationElement() {
        if (this.derivation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.derivation");
            }
            if (Configuration.doAutoCreate()) {
                this.derivation = new Enumeration<TypeDerivationRule>(new TypeDerivationRuleEnumFactory());
            }
        }
        return this.derivation;
    }

    public boolean hasDerivationElement() {
        return this.derivation != null && !this.derivation.isEmpty();
    }

    public boolean hasDerivation() {
        return this.derivation != null && !this.derivation.isEmpty();
    }

    public StructureDefinition setDerivationElement(Enumeration<TypeDerivationRule> value) {
        this.derivation = value;
        return this;
    }

    public TypeDerivationRule getDerivation() {
        return this.derivation == null ? null : (TypeDerivationRule)((Object)this.derivation.getValue());
    }

    public StructureDefinition setDerivation(TypeDerivationRule value) {
        if (value == null) {
            this.derivation = null;
        } else {
            if (this.derivation == null) {
                this.derivation = new Enumeration<TypeDerivationRule>(new TypeDerivationRuleEnumFactory());
            }
            this.derivation.setValue((Object)value);
        }
        return this;
    }

    public StructureDefinitionSnapshotComponent getSnapshot() {
        if (this.snapshot == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.snapshot");
            }
            if (Configuration.doAutoCreate()) {
                this.snapshot = new StructureDefinitionSnapshotComponent();
            }
        }
        return this.snapshot;
    }

    public boolean hasSnapshot() {
        return this.snapshot != null && !this.snapshot.isEmpty();
    }

    public StructureDefinition setSnapshot(StructureDefinitionSnapshotComponent value) {
        this.snapshot = value;
        return this;
    }

    public StructureDefinitionDifferentialComponent getDifferential() {
        if (this.differential == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.differential");
            }
            if (Configuration.doAutoCreate()) {
                this.differential = new StructureDefinitionDifferentialComponent();
            }
        }
        return this.differential;
    }

    public boolean hasDifferential() {
        return this.differential != null && !this.differential.isEmpty();
    }

    public StructureDefinition setDifferential(StructureDefinitionDifferentialComponent value) {
        this.differential = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this structure definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure definition is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this StructureDefinition when it is represented in other formats, or referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI), (if it's not possible to use the literal URI).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the StructureDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the StructureDefinition author manually.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the StructureDefinition.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_DISPLAY, "string", "Defined so that applications can use this name when displaying the value of the extension to the user.", 0, Integer.MAX_VALUE, this.display));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the StructureDefinition.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_EXPERIMENTAL, "boolean", "This StructureDefinition was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the structure definition.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date this version of the structure definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the structure definition changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the StructureDefinition and its use.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of structure definitions.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "Explains why this structure definition is needed and why it's been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property(SP_CODE, "Coding", "A set of terms from external terminologies that may be used to assist with indexing and searching of templates.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 1.4.0 for this version.", 0, Integer.MAX_VALUE, this.fhirVersion));
        childrenList.add(new Property("mapping", "", "An external specification that the content is mapped to.", 0, Integer.MAX_VALUE, this.mapping));
        childrenList.add(new Property(SP_KIND, SP_CODE, "Defines the kind of structure that this definition is describing.", 0, Integer.MAX_VALUE, this.kind));
        childrenList.add(new Property(SP_ABSTRACT, "boolean", "Whether structure this definition describes is abstract or not  - that is, whether an actual exchanged item can ever be of this type.", 0, Integer.MAX_VALUE, this.abstract_));
        childrenList.add(new Property("contextType", SP_CODE, "If this is an extension, Identifies the context within FHIR resources where the extension can be used.", 0, Integer.MAX_VALUE, this.contextType));
        childrenList.add(new Property(SP_CONTEXT, "string", "Identifies the types of resource or data type elements to which the extension can be applied.", 0, Integer.MAX_VALUE, this.context));
        childrenList.add(new Property("baseType", SP_CODE, "The type of type that this structure is derived from - a data type, an extension, a resource, including abstract ones. If this field is present, it indicates that the structure definition is deriving from this type. If it is not present, then the structure definition is the definition of a base abstract structure.", 0, Integer.MAX_VALUE, this.baseType));
        childrenList.add(new Property("baseDefinition", "uri", "An absolute URI that is the base structure from which this type is derived, either by specialization or constraint.", 0, Integer.MAX_VALUE, this.baseDefinition));
        childrenList.add(new Property(SP_DERIVATION, SP_CODE, "How the type relates to the baseDefinition.", 0, Integer.MAX_VALUE, this.derivation));
        childrenList.add(new Property("snapshot", "", "A snapshot view is expressed in a stand alone form that can be used and interpreted without considering the base StructureDefinition.", 0, Integer.MAX_VALUE, this.snapshot));
        childrenList.add(new Property("differential", "", "A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies.", 0, Integer.MAX_VALUE, this.differential));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 1671764162: {
                Base[] baseArray;
                if (this.display == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.display;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1619874672: {
                Base[] baseArray;
                if (this.requirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requirements;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case 837556430: {
                return this.mapping == null ? new Base[]{} : this.mapping.toArray(new Base[this.mapping.size()]);
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.kind;
                }
                return baseArray;
            }
            case 1732898850: {
                Base[] baseArray;
                if (this.abstract_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.abstract_;
                }
                return baseArray;
            }
            case -102839927: {
                Base[] baseArray;
                if (this.contextType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.contextType;
                }
                return baseArray;
            }
            case 951530927: {
                return this.context == null ? new Base[]{} : this.context.toArray(new Base[this.context.size()]);
            }
            case -1721484885: {
                Base[] baseArray;
                if (this.baseType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.baseType;
                }
                return baseArray;
            }
            case 1139771140: {
                Base[] baseArray;
                if (this.baseDefinition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.baseDefinition;
                }
                return baseArray;
            }
            case -1353885513: {
                Base[] baseArray;
                if (this.derivation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.derivation;
                }
                return baseArray;
            }
            case 284874180: {
                Base[] baseArray;
                if (this.snapshot == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.snapshot;
                }
                return baseArray;
            }
            case -1196150917: {
                Base[] baseArray;
                if (this.differential == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.differential;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case 1671764162: {
                this.display = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((StructureDefinitionContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case -1619874672: {
                this.requirements = this.castToString(value);
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case 3059181: {
                this.getCode().add(this.castToCoding(value));
                break;
            }
            case 461006061: {
                this.fhirVersion = this.castToId(value);
                break;
            }
            case 837556430: {
                this.getMapping().add((StructureDefinitionMappingComponent)value);
                break;
            }
            case 3292052: {
                this.kind = new StructureDefinitionKindEnumFactory().fromType(value);
                break;
            }
            case 1732898850: {
                this.abstract_ = this.castToBoolean(value);
                break;
            }
            case -102839927: {
                this.contextType = new ExtensionContextEnumFactory().fromType(value);
                break;
            }
            case 951530927: {
                this.getContext().add(this.castToString(value));
                break;
            }
            case -1721484885: {
                this.baseType = this.castToCode(value);
                break;
            }
            case 1139771140: {
                this.baseDefinition = this.castToUri(value);
                break;
            }
            case -1353885513: {
                this.derivation = new TypeDerivationRuleEnumFactory().fromType(value);
                break;
            }
            case 284874180: {
                this.snapshot = (StructureDefinitionSnapshotComponent)value;
                break;
            }
            case -1196150917: {
                this.differential = (StructureDefinitionDifferentialComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_DISPLAY)) {
            this.display = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((StructureDefinitionContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals(SP_CODE)) {
            this.getCode().add(this.castToCoding(value));
        } else if (name.equals("fhirVersion")) {
            this.fhirVersion = this.castToId(value);
        } else if (name.equals("mapping")) {
            this.getMapping().add((StructureDefinitionMappingComponent)value);
        } else if (name.equals(SP_KIND)) {
            this.kind = new StructureDefinitionKindEnumFactory().fromType(value);
        } else if (name.equals(SP_ABSTRACT)) {
            this.abstract_ = this.castToBoolean(value);
        } else if (name.equals("contextType")) {
            this.contextType = new ExtensionContextEnumFactory().fromType(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.getContext().add(this.castToString(value));
        } else if (name.equals("baseType")) {
            this.baseType = this.castToCode(value);
        } else if (name.equals("baseDefinition")) {
            this.baseDefinition = this.castToUri(value);
        } else if (name.equals(SP_DERIVATION)) {
            this.derivation = new TypeDerivationRuleEnumFactory().fromType(value);
        } else if (name.equals("snapshot")) {
            this.snapshot = (StructureDefinitionSnapshotComponent)value;
        } else if (name.equals("differential")) {
            this.differential = (StructureDefinitionDifferentialComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case 1671764162: {
                throw new FHIRException("Cannot make property display as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1619874672: {
                throw new FHIRException("Cannot make property requirements as it is not a complex type");
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case 3059181: {
                return this.addCode();
            }
            case 461006061: {
                throw new FHIRException("Cannot make property fhirVersion as it is not a complex type");
            }
            case 837556430: {
                return this.addMapping();
            }
            case 3292052: {
                throw new FHIRException("Cannot make property kind as it is not a complex type");
            }
            case 1732898850: {
                throw new FHIRException("Cannot make property abstract as it is not a complex type");
            }
            case -102839927: {
                throw new FHIRException("Cannot make property contextType as it is not a complex type");
            }
            case 951530927: {
                throw new FHIRException("Cannot make property context as it is not a complex type");
            }
            case -1721484885: {
                throw new FHIRException("Cannot make property baseType as it is not a complex type");
            }
            case 1139771140: {
                throw new FHIRException("Cannot make property baseDefinition as it is not a complex type");
            }
            case -1353885513: {
                throw new FHIRException("Cannot make property derivation as it is not a complex type");
            }
            case 284874180: {
                return this.getSnapshot();
            }
            case -1196150917: {
                return this.getDifferential();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.name");
        }
        if (name.equals(SP_DISPLAY)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.display");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.copyright");
        }
        if (name.equals(SP_CODE)) {
            return this.addCode();
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.fhirVersion");
        }
        if (name.equals("mapping")) {
            return this.addMapping();
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.kind");
        }
        if (name.equals(SP_ABSTRACT)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.abstract");
        }
        if (name.equals("contextType")) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.contextType");
        }
        if (name.equals(SP_CONTEXT)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.context");
        }
        if (name.equals("baseType")) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.baseType");
        }
        if (name.equals("baseDefinition")) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.baseDefinition");
        }
        if (name.equals(SP_DERIVATION)) {
            throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.derivation");
        }
        if (name.equals("snapshot")) {
            this.snapshot = new StructureDefinitionSnapshotComponent();
            return this.snapshot;
        }
        if (name.equals("differential")) {
            this.differential = new StructureDefinitionDifferentialComponent();
            return this.differential;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "StructureDefinition";
    }

    @Override
    public StructureDefinition copy() {
        StructureDefinition dst = new StructureDefinition();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.display = this.display == null ? null : this.display.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<StructureDefinitionContactComponent>();
            for (StructureDefinitionContactComponent structureDefinitionContactComponent : this.contact) {
                dst.contact.add(structureDefinitionContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        StringType stringType3 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.code != null) {
            dst.code = new ArrayList<Coding>();
            for (Coding coding : this.code) {
                dst.code.add(coding.copy());
            }
        }
        IdType idType = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.mapping != null) {
            dst.mapping = new ArrayList<StructureDefinitionMappingComponent>();
            for (StructureDefinitionMappingComponent structureDefinitionMappingComponent : this.mapping) {
                dst.mapping.add(structureDefinitionMappingComponent.copy());
            }
        }
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
        Enumeration<ExtensionContext> enumeration = dst.contextType = this.contextType == null ? null : this.contextType.copy();
        if (this.context != null) {
            dst.context = new ArrayList<StringType>();
            for (StringType stringType4 : this.context) {
                dst.context.add(stringType4.copy());
            }
        }
        dst.baseType = this.baseType == null ? null : this.baseType.copy();
        dst.baseDefinition = this.baseDefinition == null ? null : this.baseDefinition.copy();
        dst.derivation = this.derivation == null ? null : this.derivation.copy();
        dst.snapshot = this.snapshot == null ? null : this.snapshot.copy();
        dst.differential = this.differential == null ? null : this.differential.copy();
        return dst;
    }

    protected StructureDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition o = (StructureDefinition)other;
        return StructureDefinition.compareDeep(this.url, o.url, true) && StructureDefinition.compareDeep(this.identifier, o.identifier, true) && StructureDefinition.compareDeep(this.version, o.version, true) && StructureDefinition.compareDeep(this.name, o.name, true) && StructureDefinition.compareDeep(this.display, o.display, true) && StructureDefinition.compareDeep(this.status, o.status, true) && StructureDefinition.compareDeep(this.experimental, o.experimental, true) && StructureDefinition.compareDeep(this.publisher, o.publisher, true) && StructureDefinition.compareDeep(this.contact, o.contact, true) && StructureDefinition.compareDeep(this.date, o.date, true) && StructureDefinition.compareDeep(this.description, o.description, true) && StructureDefinition.compareDeep(this.useContext, o.useContext, true) && StructureDefinition.compareDeep(this.requirements, o.requirements, true) && StructureDefinition.compareDeep(this.copyright, o.copyright, true) && StructureDefinition.compareDeep(this.code, o.code, true) && StructureDefinition.compareDeep(this.fhirVersion, o.fhirVersion, true) && StructureDefinition.compareDeep(this.mapping, o.mapping, true) && StructureDefinition.compareDeep(this.kind, o.kind, true) && StructureDefinition.compareDeep(this.abstract_, o.abstract_, true) && StructureDefinition.compareDeep(this.contextType, o.contextType, true) && StructureDefinition.compareDeep(this.context, o.context, true) && StructureDefinition.compareDeep(this.baseType, o.baseType, true) && StructureDefinition.compareDeep(this.baseDefinition, o.baseDefinition, true) && StructureDefinition.compareDeep(this.derivation, o.derivation, true) && StructureDefinition.compareDeep(this.snapshot, o.snapshot, true) && StructureDefinition.compareDeep(this.differential, o.differential, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition o = (StructureDefinition)other;
        return StructureDefinition.compareValues(this.url, o.url, true) && StructureDefinition.compareValues(this.version, o.version, true) && StructureDefinition.compareValues(this.name, o.name, true) && StructureDefinition.compareValues(this.display, o.display, true) && StructureDefinition.compareValues(this.status, o.status, true) && StructureDefinition.compareValues(this.experimental, o.experimental, true) && StructureDefinition.compareValues(this.publisher, o.publisher, true) && StructureDefinition.compareValues(this.date, o.date, true) && StructureDefinition.compareValues(this.description, o.description, true) && StructureDefinition.compareValues(this.requirements, o.requirements, true) && StructureDefinition.compareValues(this.copyright, o.copyright, true) && StructureDefinition.compareValues(this.fhirVersion, o.fhirVersion, true) && StructureDefinition.compareValues(this.kind, o.kind, true) && StructureDefinition.compareValues(this.abstract_, o.abstract_, true) && StructureDefinition.compareValues(this.contextType, o.contextType, true) && StructureDefinition.compareValues(this.context, o.context, true) && StructureDefinition.compareValues(this.baseType, o.baseType, true) && StructureDefinition.compareValues(this.baseDefinition, o.baseDefinition, true) && StructureDefinition.compareValues(this.derivation, o.derivation, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.display != null && !this.display.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.code != null && !this.code.isEmpty() || this.fhirVersion != null && !this.fhirVersion.isEmpty() || this.mapping != null && !this.mapping.isEmpty() || this.kind != null && !this.kind.isEmpty() || this.abstract_ != null && !this.abstract_.isEmpty() || this.contextType != null && !this.contextType.isEmpty() || this.context != null && !this.context.isEmpty() || this.baseType != null && !this.baseType.isEmpty() || this.baseDefinition != null && !this.baseDefinition.isEmpty() || this.derivation != null && !this.derivation.isEmpty() || this.snapshot != null && !this.snapshot.isEmpty() || this.differential != null && !this.differential.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.StructureDefinition;
    }

    @Block
    public static class StructureDefinitionContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the structure definition.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureDefinitionContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public StructureDefinitionContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public StructureDefinitionContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(StructureDefinition.SP_NAME, "string", "The name of an individual to contact regarding the structure definition.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(StructureDefinition.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(StructureDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionContactComponent copy() {
            StructureDefinitionContactComponent dst = new StructureDefinitionContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionContactComponent)) {
                return false;
            }
            StructureDefinitionContactComponent o = (StructureDefinitionContactComponent)other;
            return StructureDefinitionContactComponent.compareDeep(this.name, o.name, true) && StructureDefinitionContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionContactComponent)) {
                return false;
            }
            StructureDefinitionContactComponent o = (StructureDefinitionContactComponent)other;
            return StructureDefinitionContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.contact";
        }
    }

    @Block
    public static class StructureDefinitionMappingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identity", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internal id when this mapping is used", formalDefinition="An Internal id that is used to identify this mapping set when specific mappings are made.")
        protected IdType identity;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies what this mapping refers to", formalDefinition="An absolute URI that identifies the specification that this mapping is expressed to.")
        protected UriType uri;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Names what this mapping refers to", formalDefinition="A name for the specification that is being mapped to.")
        protected StringType name;
        @Child(name="comments", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Versions, Issues, Scope limitations etc.", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.")
        protected StringType comments;
        private static final long serialVersionUID = 299630820L;

        public StructureDefinitionMappingComponent() {
        }

        public StructureDefinitionMappingComponent(IdType identity) {
            this.identity = identity;
        }

        public IdType getIdentityElement() {
            if (this.identity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.identity");
                }
                if (Configuration.doAutoCreate()) {
                    this.identity = new IdType();
                }
            }
            return this.identity;
        }

        public boolean hasIdentityElement() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public boolean hasIdentity() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public StructureDefinitionMappingComponent setIdentityElement(IdType value) {
            this.identity = value;
            return this;
        }

        public String getIdentity() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public StructureDefinitionMappingComponent setIdentity(String value) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public StructureDefinitionMappingComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public StructureDefinitionMappingComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureDefinitionMappingComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public StructureDefinitionMappingComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getCommentsElement() {
            if (this.comments == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.comments");
                }
                if (Configuration.doAutoCreate()) {
                    this.comments = new StringType();
                }
            }
            return this.comments;
        }

        public boolean hasCommentsElement() {
            return this.comments != null && !this.comments.isEmpty();
        }

        public boolean hasComments() {
            return this.comments != null && !this.comments.isEmpty();
        }

        public StructureDefinitionMappingComponent setCommentsElement(StringType value) {
            this.comments = value;
            return this;
        }

        public String getComments() {
            return this.comments == null ? null : (String)this.comments.getValue();
        }

        public StructureDefinitionMappingComponent setComments(String value) {
            if (Utilities.noString((String)value)) {
                this.comments = null;
            } else {
                if (this.comments == null) {
                    this.comments = new StringType();
                }
                this.comments.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identity", "id", "An Internal id that is used to identify this mapping set when specific mappings are made.", 0, Integer.MAX_VALUE, this.identity));
            childrenList.add(new Property("uri", "uri", "An absolute URI that identifies the specification that this mapping is expressed to.", 0, Integer.MAX_VALUE, this.uri));
            childrenList.add(new Property(StructureDefinition.SP_NAME, "string", "A name for the specification that is being mapped to.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("comments", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, Integer.MAX_VALUE, this.comments));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    Base[] baseArray;
                    if (this.identity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identity;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -602415628: {
                    Base[] baseArray;
                    if (this.comments == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comments;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    this.identity = this.castToId(value);
                    break;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -602415628: {
                    this.comments = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identity")) {
                this.identity = this.castToId(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else if (name.equals(StructureDefinition.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("comments")) {
                this.comments = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    throw new FHIRException("Cannot make property identity as it is not a complex type");
                }
                case 116076: {
                    throw new FHIRException("Cannot make property uri as it is not a complex type");
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -602415628: {
                    throw new FHIRException("Cannot make property comments as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identity")) {
                throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.identity");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.uri");
            }
            if (name.equals(StructureDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.name");
            }
            if (name.equals("comments")) {
                throw new FHIRException("Cannot call addChild on a singleton property StructureDefinition.comments");
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionMappingComponent copy() {
            StructureDefinitionMappingComponent dst = new StructureDefinitionMappingComponent();
            this.copyValues(dst);
            dst.identity = this.identity == null ? null : this.identity.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.comments = this.comments == null ? null : this.comments.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionMappingComponent)) {
                return false;
            }
            StructureDefinitionMappingComponent o = (StructureDefinitionMappingComponent)other;
            return StructureDefinitionMappingComponent.compareDeep(this.identity, o.identity, true) && StructureDefinitionMappingComponent.compareDeep(this.uri, o.uri, true) && StructureDefinitionMappingComponent.compareDeep(this.name, o.name, true) && StructureDefinitionMappingComponent.compareDeep(this.comments, o.comments, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionMappingComponent)) {
                return false;
            }
            StructureDefinitionMappingComponent o = (StructureDefinitionMappingComponent)other;
            return StructureDefinitionMappingComponent.compareValues(this.identity, o.identity, true) && StructureDefinitionMappingComponent.compareValues(this.uri, o.uri, true) && StructureDefinitionMappingComponent.compareValues(this.name, o.name, true) && StructureDefinitionMappingComponent.compareValues(this.comments, o.comments, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identity != null && !this.identity.isEmpty() || this.uri != null && !this.uri.isEmpty() || this.name != null && !this.name.isEmpty() || this.comments != null && !this.comments.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.mapping";
        }
    }

    public static class StructureDefinitionKindEnumFactory
    implements EnumFactory<StructureDefinitionKind> {
        @Override
        public StructureDefinitionKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("datatype".equals(codeString)) {
                return StructureDefinitionKind.DATATYPE;
            }
            if ("resource".equals(codeString)) {
                return StructureDefinitionKind.RESOURCE;
            }
            if ("logical".equals(codeString)) {
                return StructureDefinitionKind.LOGICAL;
            }
            throw new IllegalArgumentException("Unknown StructureDefinitionKind code '" + codeString + "'");
        }

        public Enumeration<StructureDefinitionKind> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("datatype".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.DATATYPE);
            }
            if ("resource".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.RESOURCE);
            }
            if ("logical".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.LOGICAL);
            }
            throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureDefinitionKind code) {
            if (code == StructureDefinitionKind.NULL) {
                return null;
            }
            if (code == StructureDefinitionKind.DATATYPE) {
                return "datatype";
            }
            if (code == StructureDefinitionKind.RESOURCE) {
                return "resource";
            }
            if (code == StructureDefinitionKind.LOGICAL) {
                return "logical";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureDefinitionKind code) {
            return code.getSystem();
        }
    }

    public static enum StructureDefinitionKind {
        DATATYPE,
        RESOURCE,
        LOGICAL,
        NULL;


        public static StructureDefinitionKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("datatype".equals(codeString)) {
                return DATATYPE;
            }
            if ("resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("logical".equals(codeString)) {
                return LOGICAL;
            }
            throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DATATYPE: {
                    return "datatype";
                }
                case RESOURCE: {
                    return "resource";
                }
                case LOGICAL: {
                    return "logical";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DATATYPE: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case LOGICAL: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DATATYPE: {
                    return "A data type - either a primitive or complex structure that defines a set of data elements. These can be used throughout Resource and extension definitions.";
                }
                case RESOURCE: {
                    return "A resource defined by the FHIR specification.";
                }
                case LOGICAL: {
                    return "A logical model - a conceptual package of data that will be mapped to resources for implementation.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DATATYPE: {
                    return "Data Type";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case LOGICAL: {
                    return "Logical Model";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ExtensionContextEnumFactory
    implements EnumFactory<ExtensionContext> {
        @Override
        public ExtensionContext fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("resource".equals(codeString)) {
                return ExtensionContext.RESOURCE;
            }
            if ("datatype".equals(codeString)) {
                return ExtensionContext.DATATYPE;
            }
            if ("extension".equals(codeString)) {
                return ExtensionContext.EXTENSION;
            }
            throw new IllegalArgumentException("Unknown ExtensionContext code '" + codeString + "'");
        }

        public Enumeration<ExtensionContext> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("resource".equals(codeString)) {
                return new Enumeration<ExtensionContext>(this, ExtensionContext.RESOURCE);
            }
            if ("datatype".equals(codeString)) {
                return new Enumeration<ExtensionContext>(this, ExtensionContext.DATATYPE);
            }
            if ("extension".equals(codeString)) {
                return new Enumeration<ExtensionContext>(this, ExtensionContext.EXTENSION);
            }
            throw new FHIRException("Unknown ExtensionContext code '" + codeString + "'");
        }

        @Override
        public String toCode(ExtensionContext code) {
            if (code == ExtensionContext.NULL) {
                return null;
            }
            if (code == ExtensionContext.RESOURCE) {
                return "resource";
            }
            if (code == ExtensionContext.DATATYPE) {
                return "datatype";
            }
            if (code == ExtensionContext.EXTENSION) {
                return "extension";
            }
            return "?";
        }

        @Override
        public String toSystem(ExtensionContext code) {
            return code.getSystem();
        }
    }

    public static enum ExtensionContext {
        RESOURCE,
        DATATYPE,
        EXTENSION,
        NULL;


        public static ExtensionContext fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("datatype".equals(codeString)) {
                return DATATYPE;
            }
            if ("extension".equals(codeString)) {
                return EXTENSION;
            }
            throw new FHIRException("Unknown ExtensionContext code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RESOURCE: {
                    return "resource";
                }
                case DATATYPE: {
                    return "datatype";
                }
                case EXTENSION: {
                    return "extension";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RESOURCE: {
                    return "http://hl7.org/fhir/extension-context";
                }
                case DATATYPE: {
                    return "http://hl7.org/fhir/extension-context";
                }
                case EXTENSION: {
                    return "http://hl7.org/fhir/extension-context";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RESOURCE: {
                    return "The context is all elements matching a particular resource element path.";
                }
                case DATATYPE: {
                    return "The context is all nodes matching a particular data type element path (root or repeating element) or all elements referencing a particular primitive data type (expressed as the datatype name).";
                }
                case EXTENSION: {
                    return "The context is a particular extension from a particular profile, a uri that identifies the extension definition.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RESOURCE: {
                    return "Resource";
                }
                case DATATYPE: {
                    return "Datatype";
                }
                case EXTENSION: {
                    return "Extension";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class TypeDerivationRuleEnumFactory
    implements EnumFactory<TypeDerivationRule> {
        @Override
        public TypeDerivationRule fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("specialization".equals(codeString)) {
                return TypeDerivationRule.SPECIALIZATION;
            }
            if ("constraint".equals(codeString)) {
                return TypeDerivationRule.CONSTRAINT;
            }
            throw new IllegalArgumentException("Unknown TypeDerivationRule code '" + codeString + "'");
        }

        public Enumeration<TypeDerivationRule> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("specialization".equals(codeString)) {
                return new Enumeration<TypeDerivationRule>(this, TypeDerivationRule.SPECIALIZATION);
            }
            if ("constraint".equals(codeString)) {
                return new Enumeration<TypeDerivationRule>(this, TypeDerivationRule.CONSTRAINT);
            }
            throw new FHIRException("Unknown TypeDerivationRule code '" + codeString + "'");
        }

        @Override
        public String toCode(TypeDerivationRule code) {
            if (code == TypeDerivationRule.NULL) {
                return null;
            }
            if (code == TypeDerivationRule.SPECIALIZATION) {
                return "specialization";
            }
            if (code == TypeDerivationRule.CONSTRAINT) {
                return "constraint";
            }
            return "?";
        }

        @Override
        public String toSystem(TypeDerivationRule code) {
            return code.getSystem();
        }
    }

    public static enum TypeDerivationRule {
        SPECIALIZATION,
        CONSTRAINT,
        NULL;


        public static TypeDerivationRule fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("specialization".equals(codeString)) {
                return SPECIALIZATION;
            }
            if ("constraint".equals(codeString)) {
                return CONSTRAINT;
            }
            throw new FHIRException("Unknown TypeDerivationRule code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SPECIALIZATION: {
                    return "specialization";
                }
                case CONSTRAINT: {
                    return "constraint";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SPECIALIZATION: {
                    return "http://hl7.org/fhir/type-derivation-rule";
                }
                case CONSTRAINT: {
                    return "http://hl7.org/fhir/type-derivation-rule";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SPECIALIZATION: {
                    return "This definition defines a new type that adds additional elements to the base type";
                }
                case CONSTRAINT: {
                    return "This definition adds additional rules to an existing concrete type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SPECIALIZATION: {
                    return "Specialization";
                }
                case CONSTRAINT: {
                    return "Constraint";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class StructureDefinitionSnapshotComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="element", type={ElementDefinition.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of elements in the resource (if no StructureDefinition)", formalDefinition="Captures constraints on each element within the resource.")
        protected List<ElementDefinition> element;
        private static final long serialVersionUID = 53896641L;

        public List<ElementDefinition> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            return this.element;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (ElementDefinition item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ElementDefinition addElement() {
            ElementDefinition t = new ElementDefinition();
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return t;
        }

        public StructureDefinitionSnapshotComponent addElement(ElementDefinition t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("element", "ElementDefinition", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    this.getElement().add(this.castToElementDefinition(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("element")) {
                this.getElement().add(this.castToElementDefinition(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.addElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("element")) {
                return this.addElement();
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionSnapshotComponent copy() {
            StructureDefinitionSnapshotComponent dst = new StructureDefinitionSnapshotComponent();
            this.copyValues(dst);
            if (this.element != null) {
                dst.element = new ArrayList<ElementDefinition>();
                for (ElementDefinition i : this.element) {
                    dst.element.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionSnapshotComponent)) {
                return false;
            }
            StructureDefinitionSnapshotComponent o = (StructureDefinitionSnapshotComponent)other;
            return StructureDefinitionSnapshotComponent.compareDeep(this.element, o.element, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionSnapshotComponent)) {
                return false;
            }
            StructureDefinitionSnapshotComponent o = (StructureDefinitionSnapshotComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.element == null || this.element.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.snapshot";
        }
    }

    @Block
    public static class StructureDefinitionDifferentialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="element", type={ElementDefinition.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of elements in the resource (if no StructureDefinition)", formalDefinition="Captures constraints on each element within the resource.")
        protected List<ElementDefinition> element;
        private static final long serialVersionUID = 53896641L;

        public List<ElementDefinition> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            return this.element;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (ElementDefinition item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ElementDefinition addElement() {
            ElementDefinition t = new ElementDefinition();
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return t;
        }

        public StructureDefinitionDifferentialComponent addElement(ElementDefinition t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("element", "ElementDefinition", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    this.getElement().add(this.castToElementDefinition(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("element")) {
                this.getElement().add(this.castToElementDefinition(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.addElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("element")) {
                return this.addElement();
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionDifferentialComponent copy() {
            StructureDefinitionDifferentialComponent dst = new StructureDefinitionDifferentialComponent();
            this.copyValues(dst);
            if (this.element != null) {
                dst.element = new ArrayList<ElementDefinition>();
                for (ElementDefinition i : this.element) {
                    dst.element.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionDifferentialComponent)) {
                return false;
            }
            StructureDefinitionDifferentialComponent o = (StructureDefinitionDifferentialComponent)other;
            return StructureDefinitionDifferentialComponent.compareDeep(this.element, o.element, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StructureDefinitionDifferentialComponent)) {
                return false;
            }
            StructureDefinitionDifferentialComponent o = (StructureDefinitionDifferentialComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.element == null || this.element.isEmpty());
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.differential";
        }
    }
}

