/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Questionnaire", profile="http://hl7.org/fhir/Profile/Questionnaire")
public class Questionnaire
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Globally unique logical identifier for  questionnaire", formalDefinition="An absolute URL that is used to identify this questionnaire when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this questionnaire is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifiers for this questionnaire", formalDefinition="This records identifiers associated with this question set that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier for this version of Questionnaire", formalDefinition="The version number assigned by the publisher for business reasons.  It may remain the same when the resource is updated.")
    protected StringType version;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | published | retired", formalDefinition="The lifecycle status of the questionnaire as a whole.")
    protected Enumeration<QuestionnaireStatus> status;
    @Child(name="date", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date this version was authored", formalDefinition="The date that this questionnaire was last changed.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization/individual who designed the questionnaire", formalDefinition="Organization or person responsible for developing and maintaining the questionnaire.")
    protected StringType publisher;
    @Child(name="telecom", type={ContactPoint.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact information of the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactPoint> telecom;
    @Child(name="useContext", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Questionnaire intends to support these contexts", formalDefinition="A code that identifies the questionnaire as falling into a particular group of like questionnaires; e.g. \"Pediatric\", \"Admissions\", \"Research\", \"Demographic\", \"Opinion Survey\", etc.")
    protected List<CodeableConcept> useContext;
    @Child(name="title", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for the questionnaire", formalDefinition="The name or label associated with this questionnaire.")
    protected StringType title;
    @Child(name="concept", type={Coding.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Concept that represents the overall questionnaire", formalDefinition="Identifies a how this question or group of questions is known in a particular terminology such as LOINC.")
    protected List<Coding> concept;
    @Child(name="subjectType", type={CodeType.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource that can be subject of QuestionnaireResponse", formalDefinition="Identifies the types of subjects that can be the subject of the questionnaire.")
    protected List<CodeType> subjectType;
    @Child(name="item", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Questions and sections within the Questionnaire", formalDefinition="The questions and groupings of questions that make up the questionnaire.")
    protected List<QuestionnaireItemComponent> item;
    private static final long serialVersionUID = 1271324566L;
    @SearchParamDefinition(name="title", path="Questionnaire.title", description="All or part of the name of the questionnaire", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="Questionnaire.status", description="The status of the questionnaire", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="context", path="Questionnaire.useContext", description="A use context assigned to the questionnaire", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="code", path="Questionnaire.item.concept", description="A code that corresponds to the questionnaire or one of its groups", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="Questionnaire.date", description="When the questionnaire was last changed", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Questionnaire.identifier", description="An identifier for the questionnaire", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="Questionnaire.version", description="The business version of the questionnaire", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");
    @SearchParamDefinition(name="publisher", path="Questionnaire.publisher", description="The author of the questionnaire", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");

    public Questionnaire() {
    }

    public Questionnaire(Enumeration<QuestionnaireStatus> status) {
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Questionnaire setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Questionnaire setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Questionnaire addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Questionnaire setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Questionnaire setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Enumeration<QuestionnaireStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<QuestionnaireStatus>(new QuestionnaireStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Questionnaire setStatusElement(Enumeration<QuestionnaireStatus> value) {
        this.status = value;
        return this;
    }

    public QuestionnaireStatus getStatus() {
        return this.status == null ? null : (QuestionnaireStatus)((Object)this.status.getValue());
    }

    public Questionnaire setStatus(QuestionnaireStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<QuestionnaireStatus>(new QuestionnaireStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Questionnaire setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Questionnaire setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public Questionnaire setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public Questionnaire setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Questionnaire addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public Questionnaire addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Questionnaire setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Questionnaire setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<Coding> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<Coding>();
        }
        return this.concept;
    }

    public boolean hasConcept() {
        if (this.concept == null) {
            return false;
        }
        for (Coding item : this.concept) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addConcept() {
        Coding t = new Coding();
        if (this.concept == null) {
            this.concept = new ArrayList<Coding>();
        }
        this.concept.add(t);
        return t;
    }

    public Questionnaire addConcept(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.concept == null) {
            this.concept = new ArrayList<Coding>();
        }
        this.concept.add(t);
        return this;
    }

    public List<CodeType> getSubjectType() {
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        return this.subjectType;
    }

    public boolean hasSubjectType() {
        if (this.subjectType == null) {
            return false;
        }
        for (CodeType item : this.subjectType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addSubjectTypeElement() {
        CodeType t = new CodeType();
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        this.subjectType.add(t);
        return t;
    }

    public Questionnaire addSubjectType(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        this.subjectType.add(t);
        return this;
    }

    public boolean hasSubjectType(String value) {
        if (this.subjectType == null) {
            return false;
        }
        for (CodeType v : this.subjectType) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<QuestionnaireItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItemComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (QuestionnaireItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public QuestionnaireItemComponent addItem() {
        QuestionnaireItemComponent t = new QuestionnaireItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Questionnaire addItem(QuestionnaireItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("url", "uri", "An absolute URL that is used to identify this questionnaire when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this questionnaire is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this question set that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "The version number assigned by the publisher for business reasons.  It may remain the same when the resource is updated.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The lifecycle status of the questionnaire as a whole.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date that this questionnaire was last changed.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_PUBLISHER, "string", "Organization or person responsible for developing and maintaining the questionnaire.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("telecom", "ContactPoint", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property("useContext", "CodeableConcept", "A code that identifies the questionnaire as falling into a particular group of like questionnaires; e.g. \"Pediatric\", \"Admissions\", \"Research\", \"Demographic\", \"Opinion Survey\", etc.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property(SP_TITLE, "string", "The name or label associated with this questionnaire.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("concept", "Coding", "Identifies a how this question or group of questions is known in a particular terminology such as LOINC.", 0, Integer.MAX_VALUE, this.concept));
        childrenList.add(new Property("subjectType", SP_CODE, "Identifies the types of subjects that can be the subject of the questionnaire.", 0, Integer.MAX_VALUE, this.subjectType));
        childrenList.add(new Property("item", "", "The questions and groupings of questions that make up the questionnaire.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.publisher;
                }
                return baseArray;
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.title;
                }
                return baseArray;
            }
            case 951024232: {
                return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
            }
            case -603200890: {
                return this.subjectType == null ? new Base[]{} : this.subjectType.toArray(new Base[this.subjectType.size()]);
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new QuestionnaireStatusEnumFactory().fromType(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case 110371416: {
                this.title = this.castToString(value);
                break;
            }
            case 951024232: {
                this.getConcept().add(this.castToCoding(value));
                break;
            }
            case -603200890: {
                this.getSubjectType().add(this.castToCode(value));
                break;
            }
            case 3242771: {
                this.getItem().add((QuestionnaireItemComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new QuestionnaireStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("concept")) {
            this.getConcept().add(this.castToCoding(value));
        } else if (name.equals("subjectType")) {
            this.getSubjectType().add(this.castToCode(value));
        } else if (name.equals("item")) {
            this.getItem().add((QuestionnaireItemComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 110371416: {
                throw new FHIRException("Cannot make property title as it is not a complex type");
            }
            case 951024232: {
                return this.addConcept();
            }
            case -603200890: {
                throw new FHIRException("Cannot make property subjectType as it is not a complex type");
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.publisher");
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.title");
        }
        if (name.equals("concept")) {
            return this.addConcept();
        }
        if (name.equals("subjectType")) {
            throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.subjectType");
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Questionnaire";
    }

    @Override
    public Questionnaire copy() {
        Questionnaire dst = new Questionnaire();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        StringType stringType2 = dst.title = this.title == null ? null : this.title.copy();
        if (this.concept != null) {
            dst.concept = new ArrayList<Coding>();
            for (Coding coding : this.concept) {
                dst.concept.add(coding.copy());
            }
        }
        if (this.subjectType != null) {
            dst.subjectType = new ArrayList<CodeType>();
            for (CodeType codeType : this.subjectType) {
                dst.subjectType.add(codeType.copy());
            }
        }
        if (this.item != null) {
            dst.item = new ArrayList<QuestionnaireItemComponent>();
            for (QuestionnaireItemComponent questionnaireItemComponent : this.item) {
                dst.item.add(questionnaireItemComponent.copy());
            }
        }
        return dst;
    }

    protected Questionnaire typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Questionnaire)) {
            return false;
        }
        Questionnaire o = (Questionnaire)other;
        return Questionnaire.compareDeep(this.url, o.url, true) && Questionnaire.compareDeep(this.identifier, o.identifier, true) && Questionnaire.compareDeep(this.version, o.version, true) && Questionnaire.compareDeep(this.status, o.status, true) && Questionnaire.compareDeep(this.date, o.date, true) && Questionnaire.compareDeep(this.publisher, o.publisher, true) && Questionnaire.compareDeep(this.telecom, o.telecom, true) && Questionnaire.compareDeep(this.useContext, o.useContext, true) && Questionnaire.compareDeep(this.title, o.title, true) && Questionnaire.compareDeep(this.concept, o.concept, true) && Questionnaire.compareDeep(this.subjectType, o.subjectType, true) && Questionnaire.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Questionnaire)) {
            return false;
        }
        Questionnaire o = (Questionnaire)other;
        return Questionnaire.compareValues(this.url, o.url, true) && Questionnaire.compareValues(this.version, o.version, true) && Questionnaire.compareValues(this.status, o.status, true) && Questionnaire.compareValues(this.date, o.date, true) && Questionnaire.compareValues(this.publisher, o.publisher, true) && Questionnaire.compareValues(this.title, o.title, true) && Questionnaire.compareValues(this.subjectType, o.subjectType, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.status != null && !this.status.isEmpty() || this.date != null && !this.date.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.title != null && !this.title.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.subjectType != null && !this.subjectType.isEmpty() || this.item != null && !this.item.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Questionnaire;
    }

    public static class QuestionnaireStatusEnumFactory
    implements EnumFactory<QuestionnaireStatus> {
        @Override
        public QuestionnaireStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return QuestionnaireStatus.DRAFT;
            }
            if ("published".equals(codeString)) {
                return QuestionnaireStatus.PUBLISHED;
            }
            if ("retired".equals(codeString)) {
                return QuestionnaireStatus.RETIRED;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireStatus code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<QuestionnaireStatus>(this, QuestionnaireStatus.DRAFT);
            }
            if ("published".equals(codeString)) {
                return new Enumeration<QuestionnaireStatus>(this, QuestionnaireStatus.PUBLISHED);
            }
            if ("retired".equals(codeString)) {
                return new Enumeration<QuestionnaireStatus>(this, QuestionnaireStatus.RETIRED);
            }
            throw new FHIRException("Unknown QuestionnaireStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireStatus code) {
            if (code == QuestionnaireStatus.NULL) {
                return null;
            }
            if (code == QuestionnaireStatus.DRAFT) {
                return "draft";
            }
            if (code == QuestionnaireStatus.PUBLISHED) {
                return "published";
            }
            if (code == QuestionnaireStatus.RETIRED) {
                return "retired";
            }
            return "?";
        }

        @Override
        public String toSystem(QuestionnaireStatus code) {
            return code.getSystem();
        }
    }

    public static enum QuestionnaireStatus {
        DRAFT,
        PUBLISHED,
        RETIRED,
        NULL;


        public static QuestionnaireStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("published".equals(codeString)) {
                return PUBLISHED;
            }
            if ("retired".equals(codeString)) {
                return RETIRED;
            }
            throw new FHIRException("Unknown QuestionnaireStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case PUBLISHED: {
                    return "published";
                }
                case RETIRED: {
                    return "retired";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/questionnaire-status";
                }
                case PUBLISHED: {
                    return "http://hl7.org/fhir/questionnaire-status";
                }
                case RETIRED: {
                    return "http://hl7.org/fhir/questionnaire-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "This Questionnaire is not ready for official use.";
                }
                case PUBLISHED: {
                    return "This Questionnaire is ready for use.";
                }
                case RETIRED: {
                    return "This Questionnaire should no longer be used to gather data.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case PUBLISHED: {
                    return "Published";
                }
                case RETIRED: {
                    return "Retired";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class QuestionnaireItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="To link questionnaire with questionnaire response", formalDefinition="An identifier that is unique within the Questionnaire allowing linkage to the equivalent item in a QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="concept", type={Coding.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Concept that represents this item within in a questionnaire", formalDefinition="Identifies a how this group of questions is known in a particular terminology such as LOINC.")
        protected List<Coding> concept;
        @Child(name="prefix", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. \"1(a)\", \"2.5.3\"", formalDefinition="A short label for a particular group, question or set of display text within the questionnaire.")
        protected StringType prefix;
        @Child(name="text", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Primary text for the item", formalDefinition="The name of a section, the text of a question or text content for a text item.")
        protected StringType text;
        @Child(name="type", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="group | display | boolean | decimal | integer | date | dateTime +", formalDefinition="Identifies the type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).")
        protected Enumeration<QuestionnaireItemType> type;
        @Child(name="enableWhen", type={}, order=6, min=0, max=-1, modifier=true, summary=false)
        @Description(shortDefinition="Only allow data when:", formalDefinition="If present, indicates that this item should only be enabled (displayed/allow answers to be captured) when the specified condition is true.")
        protected List<QuestionnaireItemEnableWhenComponent> enableWhen;
        @Child(name="required", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the item must be included in data results", formalDefinition="If true, indicates that the item must be present in a \"completed\" QuestionnaireResponse.  If false, the item may be skipped when answering the questionnaire.")
        protected BooleanType required;
        @Child(name="repeats", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the item may repeat", formalDefinition="Whether the item may occur multiple times in the instance, containing multiple sets of answers.")
        protected BooleanType repeats;
        @Child(name="readOnly", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Don't allow human editing", formalDefinition="If true, the value cannot be changed by a human respondent to the Questionnaire.")
        protected BooleanType readOnly;
        @Child(name="maxLength", type={IntegerType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="No more than this many characters", formalDefinition="The maximum number of characters that are permitted in the answer to be considered a \"valid\" QuestionnaireResponse.")
        protected IntegerType maxLength;
        @Child(name="options", type={ValueSet.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Valueset containing permitted answers", formalDefinition="Reference to a value set containing a list of codes representing permitted answers for the question.")
        protected Reference options;
        protected ValueSet optionsTarget;
        @Child(name="option", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Permitted answer", formalDefinition="For a \"choice\" question, identifies one of the permitted answers for the question.")
        protected List<QuestionnaireItemOptionComponent> option;
        @Child(name="initial", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, InstantType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Initial presumed answer for question", formalDefinition="The value that should be pre-populated when rendering the questionnaire for user input.")
        protected Type initial;
        @Child(name="item", type={QuestionnaireItemComponent.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire items", formalDefinition="Allows text, questions and other groups to be nested beneath a question or group.")
        protected List<QuestionnaireItemComponent> item;
        private static final long serialVersionUID = -1787693458L;

        public QuestionnaireItemComponent() {
        }

        public QuestionnaireItemComponent(Enumeration<QuestionnaireItemType> type) {
            this.type = type;
        }

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public QuestionnaireItemComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public QuestionnaireItemComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public List<Coding> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (Coding item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addConcept() {
            Coding t = new Coding();
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            this.concept.add(t);
            return t;
        }

        public QuestionnaireItemComponent addConcept(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            this.concept.add(t);
            return this;
        }

        public StringType getPrefixElement() {
            if (this.prefix == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.prefix");
                }
                if (Configuration.doAutoCreate()) {
                    this.prefix = new StringType();
                }
            }
            return this.prefix;
        }

        public boolean hasPrefixElement() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public boolean hasPrefix() {
            return this.prefix != null && !this.prefix.isEmpty();
        }

        public QuestionnaireItemComponent setPrefixElement(StringType value) {
            this.prefix = value;
            return this;
        }

        public String getPrefix() {
            return this.prefix == null ? null : (String)this.prefix.getValue();
        }

        public QuestionnaireItemComponent setPrefix(String value) {
            if (Utilities.noString((String)value)) {
                this.prefix = null;
            } else {
                if (this.prefix == null) {
                    this.prefix = new StringType();
                }
                this.prefix.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public QuestionnaireItemComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public QuestionnaireItemComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Enumeration<QuestionnaireItemType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<QuestionnaireItemType>(new QuestionnaireItemTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public QuestionnaireItemComponent setTypeElement(Enumeration<QuestionnaireItemType> value) {
            this.type = value;
            return this;
        }

        public QuestionnaireItemType getType() {
            return this.type == null ? null : (QuestionnaireItemType)((Object)this.type.getValue());
        }

        public QuestionnaireItemComponent setType(QuestionnaireItemType value) {
            if (this.type == null) {
                this.type = new Enumeration<QuestionnaireItemType>(new QuestionnaireItemTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public List<QuestionnaireItemEnableWhenComponent> getEnableWhen() {
            if (this.enableWhen == null) {
                this.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
            }
            return this.enableWhen;
        }

        public boolean hasEnableWhen() {
            if (this.enableWhen == null) {
                return false;
            }
            for (QuestionnaireItemEnableWhenComponent item : this.enableWhen) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemEnableWhenComponent addEnableWhen() {
            QuestionnaireItemEnableWhenComponent t = new QuestionnaireItemEnableWhenComponent();
            if (this.enableWhen == null) {
                this.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
            }
            this.enableWhen.add(t);
            return t;
        }

        public QuestionnaireItemComponent addEnableWhen(QuestionnaireItemEnableWhenComponent t) {
            if (t == null) {
                return this;
            }
            if (this.enableWhen == null) {
                this.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
            }
            this.enableWhen.add(t);
            return this;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public QuestionnaireItemComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public QuestionnaireItemComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public BooleanType getRepeatsElement() {
            if (this.repeats == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.repeats");
                }
                if (Configuration.doAutoCreate()) {
                    this.repeats = new BooleanType();
                }
            }
            return this.repeats;
        }

        public boolean hasRepeatsElement() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public boolean hasRepeats() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public QuestionnaireItemComponent setRepeatsElement(BooleanType value) {
            this.repeats = value;
            return this;
        }

        public boolean getRepeats() {
            return this.repeats == null || this.repeats.isEmpty() ? false : (Boolean)this.repeats.getValue();
        }

        public QuestionnaireItemComponent setRepeats(boolean value) {
            if (this.repeats == null) {
                this.repeats = new BooleanType();
            }
            this.repeats.setValue((Object)value);
            return this;
        }

        public BooleanType getReadOnlyElement() {
            if (this.readOnly == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.readOnly");
                }
                if (Configuration.doAutoCreate()) {
                    this.readOnly = new BooleanType();
                }
            }
            return this.readOnly;
        }

        public boolean hasReadOnlyElement() {
            return this.readOnly != null && !this.readOnly.isEmpty();
        }

        public boolean hasReadOnly() {
            return this.readOnly != null && !this.readOnly.isEmpty();
        }

        public QuestionnaireItemComponent setReadOnlyElement(BooleanType value) {
            this.readOnly = value;
            return this;
        }

        public boolean getReadOnly() {
            return this.readOnly == null || this.readOnly.isEmpty() ? false : (Boolean)this.readOnly.getValue();
        }

        public QuestionnaireItemComponent setReadOnly(boolean value) {
            if (this.readOnly == null) {
                this.readOnly = new BooleanType();
            }
            this.readOnly.setValue((Object)value);
            return this;
        }

        public IntegerType getMaxLengthElement() {
            if (this.maxLength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.maxLength");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxLength = new IntegerType();
                }
            }
            return this.maxLength;
        }

        public boolean hasMaxLengthElement() {
            return this.maxLength != null && !this.maxLength.isEmpty();
        }

        public boolean hasMaxLength() {
            return this.maxLength != null && !this.maxLength.isEmpty();
        }

        public QuestionnaireItemComponent setMaxLengthElement(IntegerType value) {
            this.maxLength = value;
            return this;
        }

        public int getMaxLength() {
            return this.maxLength == null || this.maxLength.isEmpty() ? 0 : (Integer)this.maxLength.getValue();
        }

        public QuestionnaireItemComponent setMaxLength(int value) {
            if (this.maxLength == null) {
                this.maxLength = new IntegerType();
            }
            this.maxLength.setValue((Object)value);
            return this;
        }

        public Reference getOptions() {
            if (this.options == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.options");
                }
                if (Configuration.doAutoCreate()) {
                    this.options = new Reference();
                }
            }
            return this.options;
        }

        public boolean hasOptions() {
            return this.options != null && !this.options.isEmpty();
        }

        public QuestionnaireItemComponent setOptions(Reference value) {
            this.options = value;
            return this;
        }

        public ValueSet getOptionsTarget() {
            if (this.optionsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemComponent.options");
                }
                if (Configuration.doAutoCreate()) {
                    this.optionsTarget = new ValueSet();
                }
            }
            return this.optionsTarget;
        }

        public QuestionnaireItemComponent setOptionsTarget(ValueSet value) {
            this.optionsTarget = value;
            return this;
        }

        public List<QuestionnaireItemOptionComponent> getOption() {
            if (this.option == null) {
                this.option = new ArrayList<QuestionnaireItemOptionComponent>();
            }
            return this.option;
        }

        public boolean hasOption() {
            if (this.option == null) {
                return false;
            }
            for (QuestionnaireItemOptionComponent item : this.option) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemOptionComponent addOption() {
            QuestionnaireItemOptionComponent t = new QuestionnaireItemOptionComponent();
            if (this.option == null) {
                this.option = new ArrayList<QuestionnaireItemOptionComponent>();
            }
            this.option.add(t);
            return t;
        }

        public QuestionnaireItemComponent addOption(QuestionnaireItemOptionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.option == null) {
                this.option = new ArrayList<QuestionnaireItemOptionComponent>();
            }
            this.option.add(t);
            return this;
        }

        public Type getInitial() {
            return this.initial;
        }

        public BooleanType getInitialBooleanType() throws FHIRException {
            if (!(this.initial instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.initial;
        }

        public boolean hasInitialBooleanType() {
            return this.initial instanceof BooleanType;
        }

        public DecimalType getInitialDecimalType() throws FHIRException {
            if (!(this.initial instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.initial;
        }

        public boolean hasInitialDecimalType() {
            return this.initial instanceof DecimalType;
        }

        public IntegerType getInitialIntegerType() throws FHIRException {
            if (!(this.initial instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.initial;
        }

        public boolean hasInitialIntegerType() {
            return this.initial instanceof IntegerType;
        }

        public DateType getInitialDateType() throws FHIRException {
            if (!(this.initial instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (DateType)this.initial;
        }

        public boolean hasInitialDateType() {
            return this.initial instanceof DateType;
        }

        public DateTimeType getInitialDateTimeType() throws FHIRException {
            if (!(this.initial instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.initial;
        }

        public boolean hasInitialDateTimeType() {
            return this.initial instanceof DateTimeType;
        }

        public InstantType getInitialInstantType() throws FHIRException {
            if (!(this.initial instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (InstantType)this.initial;
        }

        public boolean hasInitialInstantType() {
            return this.initial instanceof InstantType;
        }

        public TimeType getInitialTimeType() throws FHIRException {
            if (!(this.initial instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (TimeType)this.initial;
        }

        public boolean hasInitialTimeType() {
            return this.initial instanceof TimeType;
        }

        public StringType getInitialStringType() throws FHIRException {
            if (!(this.initial instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (StringType)this.initial;
        }

        public boolean hasInitialStringType() {
            return this.initial instanceof StringType;
        }

        public UriType getInitialUriType() throws FHIRException {
            if (!(this.initial instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (UriType)this.initial;
        }

        public boolean hasInitialUriType() {
            return this.initial instanceof UriType;
        }

        public Attachment getInitialAttachment() throws FHIRException {
            if (!(this.initial instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (Attachment)this.initial;
        }

        public boolean hasInitialAttachment() {
            return this.initial instanceof Attachment;
        }

        public Coding getInitialCoding() throws FHIRException {
            if (!(this.initial instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (Coding)this.initial;
        }

        public boolean hasInitialCoding() {
            return this.initial instanceof Coding;
        }

        public Quantity getInitialQuantity() throws FHIRException {
            if (!(this.initial instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (Quantity)this.initial;
        }

        public boolean hasInitialQuantity() {
            return this.initial instanceof Quantity;
        }

        public Reference getInitialReference() throws FHIRException {
            if (!(this.initial instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.initial.getClass().getName() + " was encountered");
            }
            return (Reference)this.initial;
        }

        public boolean hasInitialReference() {
            return this.initial instanceof Reference;
        }

        public boolean hasInitial() {
            return this.initial != null && !this.initial.isEmpty();
        }

        public QuestionnaireItemComponent setInitial(Type value) {
            this.initial = value;
            return this;
        }

        public List<QuestionnaireItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireItemComponent>();
            }
            return this.item;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (QuestionnaireItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionnaireItemComponent addItem() {
            QuestionnaireItemComponent t = new QuestionnaireItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public QuestionnaireItemComponent addItem(QuestionnaireItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<QuestionnaireItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("linkId", "string", "An identifier that is unique within the Questionnaire allowing linkage to the equivalent item in a QuestionnaireResponse resource.", 0, Integer.MAX_VALUE, this.linkId));
            childrenList.add(new Property("concept", "Coding", "Identifies a how this group of questions is known in a particular terminology such as LOINC.", 0, Integer.MAX_VALUE, this.concept));
            childrenList.add(new Property("prefix", "string", "A short label for a particular group, question or set of display text within the questionnaire.", 0, Integer.MAX_VALUE, this.prefix));
            childrenList.add(new Property("text", "string", "The name of a section, the text of a question or text content for a text item.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("type", Questionnaire.SP_CODE, "Identifies the type of questionnaire item this is - whether text for display, a grouping of other items or a particular type of data to be captured (string, integer, coded choice, etc.).", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("enableWhen", "", "If present, indicates that this item should only be enabled (displayed/allow answers to be captured) when the specified condition is true.", 0, Integer.MAX_VALUE, this.enableWhen));
            childrenList.add(new Property("required", "boolean", "If true, indicates that the item must be present in a \"completed\" QuestionnaireResponse.  If false, the item may be skipped when answering the questionnaire.", 0, Integer.MAX_VALUE, this.required));
            childrenList.add(new Property("repeats", "boolean", "Whether the item may occur multiple times in the instance, containing multiple sets of answers.", 0, Integer.MAX_VALUE, this.repeats));
            childrenList.add(new Property("readOnly", "boolean", "If true, the value cannot be changed by a human respondent to the Questionnaire.", 0, Integer.MAX_VALUE, this.readOnly));
            childrenList.add(new Property("maxLength", "integer", "The maximum number of characters that are permitted in the answer to be considered a \"valid\" QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.maxLength));
            childrenList.add(new Property("options", "Reference(ValueSet)", "Reference to a value set containing a list of codes representing permitted answers for the question.", 0, Integer.MAX_VALUE, this.options));
            childrenList.add(new Property("option", "", "For a \"choice\" question, identifies one of the permitted answers for the question.", 0, Integer.MAX_VALUE, this.option));
            childrenList.add(new Property("initial[x]", "boolean|decimal|integer|date|dateTime|instant|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The value that should be pre-populated when rendering the questionnaire for user input.", 0, Integer.MAX_VALUE, this.initial));
            childrenList.add(new Property("item", "@Questionnaire.item", "Allows text, questions and other groups to be nested beneath a question or group.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    Base[] baseArray;
                    if (this.linkId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.linkId;
                    }
                    return baseArray;
                }
                case 951024232: {
                    return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
                }
                case -980110702: {
                    Base[] baseArray;
                    if (this.prefix == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.prefix;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.text;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
                case 1893321565: {
                    return this.enableWhen == null ? new Base[]{} : this.enableWhen.toArray(new Base[this.enableWhen.size()]);
                }
                case -393139297: {
                    Base[] baseArray;
                    if (this.required == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.required;
                    }
                    return baseArray;
                }
                case 1094288952: {
                    Base[] baseArray;
                    if (this.repeats == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.repeats;
                    }
                    return baseArray;
                }
                case -867683742: {
                    Base[] baseArray;
                    if (this.readOnly == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.readOnly;
                    }
                    return baseArray;
                }
                case -791400086: {
                    Base[] baseArray;
                    if (this.maxLength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.maxLength;
                    }
                    return baseArray;
                }
                case -1249474914: {
                    Base[] baseArray;
                    if (this.options == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.options;
                    }
                    return baseArray;
                }
                case -1010136971: {
                    return this.option == null ? new Base[]{} : this.option.toArray(new Base[this.option.size()]);
                }
                case 1948342084: {
                    Base[] baseArray;
                    if (this.initial == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.initial;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    this.linkId = this.castToString(value);
                    break;
                }
                case 951024232: {
                    this.getConcept().add(this.castToCoding(value));
                    break;
                }
                case -980110702: {
                    this.prefix = this.castToString(value);
                    break;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    break;
                }
                case 3575610: {
                    this.type = new QuestionnaireItemTypeEnumFactory().fromType(value);
                    break;
                }
                case 1893321565: {
                    this.getEnableWhen().add((QuestionnaireItemEnableWhenComponent)value);
                    break;
                }
                case -393139297: {
                    this.required = this.castToBoolean(value);
                    break;
                }
                case 1094288952: {
                    this.repeats = this.castToBoolean(value);
                    break;
                }
                case -867683742: {
                    this.readOnly = this.castToBoolean(value);
                    break;
                }
                case -791400086: {
                    this.maxLength = this.castToInteger(value);
                    break;
                }
                case -1249474914: {
                    this.options = this.castToReference(value);
                    break;
                }
                case -1010136971: {
                    this.getOption().add((QuestionnaireItemOptionComponent)value);
                    break;
                }
                case 1948342084: {
                    this.initial = (Type)value;
                    break;
                }
                case 3242771: {
                    this.getItem().add((QuestionnaireItemComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = this.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add(this.castToCoding(value));
            } else if (name.equals("prefix")) {
                this.prefix = this.castToString(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = new QuestionnaireItemTypeEnumFactory().fromType(value);
            } else if (name.equals("enableWhen")) {
                this.getEnableWhen().add((QuestionnaireItemEnableWhenComponent)value);
            } else if (name.equals("required")) {
                this.required = this.castToBoolean(value);
            } else if (name.equals("repeats")) {
                this.repeats = this.castToBoolean(value);
            } else if (name.equals("readOnly")) {
                this.readOnly = this.castToBoolean(value);
            } else if (name.equals("maxLength")) {
                this.maxLength = this.castToInteger(value);
            } else if (name.equals("options")) {
                this.options = this.castToReference(value);
            } else if (name.equals("option")) {
                this.getOption().add((QuestionnaireItemOptionComponent)value);
            } else if (name.equals("initial[x]")) {
                this.initial = (Type)value;
            } else if (name.equals("item")) {
                this.getItem().add((QuestionnaireItemComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1102667083: {
                    throw new FHIRException("Cannot make property linkId as it is not a complex type");
                }
                case 951024232: {
                    return this.addConcept();
                }
                case -980110702: {
                    throw new FHIRException("Cannot make property prefix as it is not a complex type");
                }
                case 3556653: {
                    throw new FHIRException("Cannot make property text as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 1893321565: {
                    return this.addEnableWhen();
                }
                case -393139297: {
                    throw new FHIRException("Cannot make property required as it is not a complex type");
                }
                case 1094288952: {
                    throw new FHIRException("Cannot make property repeats as it is not a complex type");
                }
                case -867683742: {
                    throw new FHIRException("Cannot make property readOnly as it is not a complex type");
                }
                case -791400086: {
                    throw new FHIRException("Cannot make property maxLength as it is not a complex type");
                }
                case -1249474914: {
                    return this.getOptions();
                }
                case -1010136971: {
                    return this.addOption();
                }
                case 871077564: {
                    return this.getInitial();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.linkId");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("prefix")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.prefix");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.text");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.type");
            }
            if (name.equals("enableWhen")) {
                return this.addEnableWhen();
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.required");
            }
            if (name.equals("repeats")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.repeats");
            }
            if (name.equals("readOnly")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.readOnly");
            }
            if (name.equals("maxLength")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.maxLength");
            }
            if (name.equals("options")) {
                this.options = new Reference();
                return this.options;
            }
            if (name.equals("option")) {
                return this.addOption();
            }
            if (name.equals("initialBoolean")) {
                this.initial = new BooleanType();
                return this.initial;
            }
            if (name.equals("initialDecimal")) {
                this.initial = new DecimalType();
                return this.initial;
            }
            if (name.equals("initialInteger")) {
                this.initial = new IntegerType();
                return this.initial;
            }
            if (name.equals("initialDate")) {
                this.initial = new DateType();
                return this.initial;
            }
            if (name.equals("initialDateTime")) {
                this.initial = new DateTimeType();
                return this.initial;
            }
            if (name.equals("initialInstant")) {
                this.initial = new InstantType();
                return this.initial;
            }
            if (name.equals("initialTime")) {
                this.initial = new TimeType();
                return this.initial;
            }
            if (name.equals("initialString")) {
                this.initial = new StringType();
                return this.initial;
            }
            if (name.equals("initialUri")) {
                this.initial = new UriType();
                return this.initial;
            }
            if (name.equals("initialAttachment")) {
                this.initial = new Attachment();
                return this.initial;
            }
            if (name.equals("initialCoding")) {
                this.initial = new Coding();
                return this.initial;
            }
            if (name.equals("initialQuantity")) {
                this.initial = new Quantity();
                return this.initial;
            }
            if (name.equals("initialReference")) {
                this.initial = new Reference();
                return this.initial;
            }
            if (name.equals("item")) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemComponent copy() {
            QuestionnaireItemComponent dst = new QuestionnaireItemComponent();
            this.copyValues(dst);
            StringType stringType = dst.linkId = this.linkId == null ? null : this.linkId.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<Coding>();
                for (Coding coding : this.concept) {
                    dst.concept.add(coding.copy());
                }
            }
            dst.prefix = this.prefix == null ? null : this.prefix.copy();
            dst.text = this.text == null ? null : this.text.copy();
            Enumeration<QuestionnaireItemType> enumeration = dst.type = this.type == null ? null : this.type.copy();
            if (this.enableWhen != null) {
                dst.enableWhen = new ArrayList<QuestionnaireItemEnableWhenComponent>();
                for (QuestionnaireItemEnableWhenComponent questionnaireItemEnableWhenComponent : this.enableWhen) {
                    dst.enableWhen.add(questionnaireItemEnableWhenComponent.copy());
                }
            }
            dst.required = this.required == null ? null : this.required.copy();
            dst.repeats = this.repeats == null ? null : this.repeats.copy();
            dst.readOnly = this.readOnly == null ? null : this.readOnly.copy();
            dst.maxLength = this.maxLength == null ? null : this.maxLength.copy();
            Reference reference = dst.options = this.options == null ? null : this.options.copy();
            if (this.option != null) {
                dst.option = new ArrayList<QuestionnaireItemOptionComponent>();
                for (QuestionnaireItemOptionComponent questionnaireItemOptionComponent : this.option) {
                    dst.option.add(questionnaireItemOptionComponent.copy());
                }
            }
            Type type = dst.initial = this.initial == null ? null : this.initial.copy();
            if (this.item != null) {
                dst.item = new ArrayList<QuestionnaireItemComponent>();
                for (QuestionnaireItemComponent questionnaireItemComponent : this.item) {
                    dst.item.add(questionnaireItemComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireItemComponent)) {
                return false;
            }
            QuestionnaireItemComponent o = (QuestionnaireItemComponent)other;
            return QuestionnaireItemComponent.compareDeep(this.linkId, o.linkId, true) && QuestionnaireItemComponent.compareDeep(this.concept, o.concept, true) && QuestionnaireItemComponent.compareDeep(this.prefix, o.prefix, true) && QuestionnaireItemComponent.compareDeep(this.text, o.text, true) && QuestionnaireItemComponent.compareDeep(this.type, o.type, true) && QuestionnaireItemComponent.compareDeep(this.enableWhen, o.enableWhen, true) && QuestionnaireItemComponent.compareDeep(this.required, o.required, true) && QuestionnaireItemComponent.compareDeep(this.repeats, o.repeats, true) && QuestionnaireItemComponent.compareDeep(this.readOnly, o.readOnly, true) && QuestionnaireItemComponent.compareDeep(this.maxLength, o.maxLength, true) && QuestionnaireItemComponent.compareDeep(this.options, o.options, true) && QuestionnaireItemComponent.compareDeep(this.option, o.option, true) && QuestionnaireItemComponent.compareDeep(this.initial, o.initial, true) && QuestionnaireItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireItemComponent)) {
                return false;
            }
            QuestionnaireItemComponent o = (QuestionnaireItemComponent)other;
            return QuestionnaireItemComponent.compareValues(this.linkId, o.linkId, true) && QuestionnaireItemComponent.compareValues(this.prefix, o.prefix, true) && QuestionnaireItemComponent.compareValues(this.text, o.text, true) && QuestionnaireItemComponent.compareValues(this.type, o.type, true) && QuestionnaireItemComponent.compareValues(this.required, o.required, true) && QuestionnaireItemComponent.compareValues(this.repeats, o.repeats, true) && QuestionnaireItemComponent.compareValues(this.readOnly, o.readOnly, true) && QuestionnaireItemComponent.compareValues(this.maxLength, o.maxLength, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.linkId != null && !this.linkId.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.prefix != null && !this.prefix.isEmpty() || this.text != null && !this.text.isEmpty() || this.type != null && !this.type.isEmpty() || this.enableWhen != null && !this.enableWhen.isEmpty() || this.required != null && !this.required.isEmpty() || this.repeats != null && !this.repeats.isEmpty() || this.readOnly != null && !this.readOnly.isEmpty() || this.maxLength != null && !this.maxLength.isEmpty() || this.options != null && !this.options.isEmpty() || this.option != null && !this.option.isEmpty() || this.initial != null && !this.initial.isEmpty() || this.item != null && !this.item.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item";
        }
    }

    @Block
    public static class QuestionnaireItemOptionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={IntegerType.class, DateType.class, TimeType.class, StringType.class, Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Answer value", formalDefinition="Identifies a specific answer that's allowed as the answer to a question.")
        protected Type value;
        private static final long serialVersionUID = -732981989L;

        public QuestionnaireItemOptionComponent() {
        }

        public QuestionnaireItemOptionComponent(Type value) {
            this.value = value;
        }

        public Type getValue() {
            return this.value;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this.value instanceof DateType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public QuestionnaireItemOptionComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("value[x]", "integer|date|time|string|Coding", "Identifies a specific answer that's allowed as the answer to a question.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemOptionComponent copy() {
            QuestionnaireItemOptionComponent dst = new QuestionnaireItemOptionComponent();
            this.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireItemOptionComponent)) {
                return false;
            }
            QuestionnaireItemOptionComponent o = (QuestionnaireItemOptionComponent)other;
            return QuestionnaireItemOptionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireItemOptionComponent)) {
                return false;
            }
            QuestionnaireItemOptionComponent o = (QuestionnaireItemOptionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.value == null || this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item.option";
        }
    }

    @Block
    public static class QuestionnaireItemEnableWhenComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="question", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Question that determines whether item is enabled", formalDefinition="The linkId for the question whose answer (or lack of answer) governs whether this item is enabled.")
        protected StringType question;
        @Child(name="answered", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Enable when answered or not", formalDefinition="If present, indicates that this item should be enabled only if the specified question is answered or not answered.")
        protected BooleanType answered;
        @Child(name="answer", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, InstantType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value question must have", formalDefinition="If present, then the answer for the referenced question must match this answer for all components present in the enableWhen.answer.")
        protected Type answer;
        private static final long serialVersionUID = 903205698L;

        public QuestionnaireItemEnableWhenComponent() {
        }

        public QuestionnaireItemEnableWhenComponent(StringType question) {
            this.question = question;
        }

        public StringType getQuestionElement() {
            if (this.question == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemEnableWhenComponent.question");
                }
                if (Configuration.doAutoCreate()) {
                    this.question = new StringType();
                }
            }
            return this.question;
        }

        public boolean hasQuestionElement() {
            return this.question != null && !this.question.isEmpty();
        }

        public boolean hasQuestion() {
            return this.question != null && !this.question.isEmpty();
        }

        public QuestionnaireItemEnableWhenComponent setQuestionElement(StringType value) {
            this.question = value;
            return this;
        }

        public String getQuestion() {
            return this.question == null ? null : (String)this.question.getValue();
        }

        public QuestionnaireItemEnableWhenComponent setQuestion(String value) {
            if (this.question == null) {
                this.question = new StringType();
            }
            this.question.setValue(value);
            return this;
        }

        public BooleanType getAnsweredElement() {
            if (this.answered == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionnaireItemEnableWhenComponent.answered");
                }
                if (Configuration.doAutoCreate()) {
                    this.answered = new BooleanType();
                }
            }
            return this.answered;
        }

        public boolean hasAnsweredElement() {
            return this.answered != null && !this.answered.isEmpty();
        }

        public boolean hasAnswered() {
            return this.answered != null && !this.answered.isEmpty();
        }

        public QuestionnaireItemEnableWhenComponent setAnsweredElement(BooleanType value) {
            this.answered = value;
            return this;
        }

        public boolean getAnswered() {
            return this.answered == null || this.answered.isEmpty() ? false : (Boolean)this.answered.getValue();
        }

        public QuestionnaireItemEnableWhenComponent setAnswered(boolean value) {
            if (this.answered == null) {
                this.answered = new BooleanType();
            }
            this.answered.setValue((Object)value);
            return this;
        }

        public Type getAnswer() {
            return this.answer;
        }

        public BooleanType getAnswerBooleanType() throws FHIRException {
            if (!(this.answer instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.answer;
        }

        public boolean hasAnswerBooleanType() {
            return this.answer instanceof BooleanType;
        }

        public DecimalType getAnswerDecimalType() throws FHIRException {
            if (!(this.answer instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.answer;
        }

        public boolean hasAnswerDecimalType() {
            return this.answer instanceof DecimalType;
        }

        public IntegerType getAnswerIntegerType() throws FHIRException {
            if (!(this.answer instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.answer;
        }

        public boolean hasAnswerIntegerType() {
            return this.answer instanceof IntegerType;
        }

        public DateType getAnswerDateType() throws FHIRException {
            if (!(this.answer instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (DateType)this.answer;
        }

        public boolean hasAnswerDateType() {
            return this.answer instanceof DateType;
        }

        public DateTimeType getAnswerDateTimeType() throws FHIRException {
            if (!(this.answer instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.answer;
        }

        public boolean hasAnswerDateTimeType() {
            return this.answer instanceof DateTimeType;
        }

        public InstantType getAnswerInstantType() throws FHIRException {
            if (!(this.answer instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (InstantType)this.answer;
        }

        public boolean hasAnswerInstantType() {
            return this.answer instanceof InstantType;
        }

        public TimeType getAnswerTimeType() throws FHIRException {
            if (!(this.answer instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (TimeType)this.answer;
        }

        public boolean hasAnswerTimeType() {
            return this.answer instanceof TimeType;
        }

        public StringType getAnswerStringType() throws FHIRException {
            if (!(this.answer instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (StringType)this.answer;
        }

        public boolean hasAnswerStringType() {
            return this.answer instanceof StringType;
        }

        public UriType getAnswerUriType() throws FHIRException {
            if (!(this.answer instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (UriType)this.answer;
        }

        public boolean hasAnswerUriType() {
            return this.answer instanceof UriType;
        }

        public Attachment getAnswerAttachment() throws FHIRException {
            if (!(this.answer instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Attachment)this.answer;
        }

        public boolean hasAnswerAttachment() {
            return this.answer instanceof Attachment;
        }

        public Coding getAnswerCoding() throws FHIRException {
            if (!(this.answer instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Coding)this.answer;
        }

        public boolean hasAnswerCoding() {
            return this.answer instanceof Coding;
        }

        public Quantity getAnswerQuantity() throws FHIRException {
            if (!(this.answer instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Quantity)this.answer;
        }

        public boolean hasAnswerQuantity() {
            return this.answer instanceof Quantity;
        }

        public Reference getAnswerReference() throws FHIRException {
            if (!(this.answer instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.answer.getClass().getName() + " was encountered");
            }
            return (Reference)this.answer;
        }

        public boolean hasAnswerReference() {
            return this.answer instanceof Reference;
        }

        public boolean hasAnswer() {
            return this.answer != null && !this.answer.isEmpty();
        }

        public QuestionnaireItemEnableWhenComponent setAnswer(Type value) {
            this.answer = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("question", "string", "The linkId for the question whose answer (or lack of answer) governs whether this item is enabled.", 0, Integer.MAX_VALUE, this.question));
            childrenList.add(new Property("answered", "boolean", "If present, indicates that this item should be enabled only if the specified question is answered or not answered.", 0, Integer.MAX_VALUE, this.answered));
            childrenList.add(new Property("answer[x]", "boolean|decimal|integer|date|dateTime|instant|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "If present, then the answer for the referenced question must match this answer for all components present in the enableWhen.answer.", 0, Integer.MAX_VALUE, this.answer));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    Base[] baseArray;
                    if (this.question == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.question;
                    }
                    return baseArray;
                }
                case -499559203: {
                    Base[] baseArray;
                    if (this.answered == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.answered;
                    }
                    return baseArray;
                }
                case -1412808770: {
                    Base[] baseArray;
                    if (this.answer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.answer;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    this.question = this.castToString(value);
                    break;
                }
                case -499559203: {
                    this.answered = this.castToBoolean(value);
                    break;
                }
                case -1412808770: {
                    this.answer = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("question")) {
                this.question = this.castToString(value);
            } else if (name.equals("answered")) {
                this.answered = this.castToBoolean(value);
            } else if (name.equals("answer[x]")) {
                this.answer = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1165870106: {
                    throw new FHIRException("Cannot make property question as it is not a complex type");
                }
                case -499559203: {
                    throw new FHIRException("Cannot make property answered as it is not a complex type");
                }
                case 1693524994: {
                    return this.getAnswer();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("question")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.question");
            }
            if (name.equals("answered")) {
                throw new FHIRException("Cannot call addChild on a singleton property Questionnaire.answered");
            }
            if (name.equals("answerBoolean")) {
                this.answer = new BooleanType();
                return this.answer;
            }
            if (name.equals("answerDecimal")) {
                this.answer = new DecimalType();
                return this.answer;
            }
            if (name.equals("answerInteger")) {
                this.answer = new IntegerType();
                return this.answer;
            }
            if (name.equals("answerDate")) {
                this.answer = new DateType();
                return this.answer;
            }
            if (name.equals("answerDateTime")) {
                this.answer = new DateTimeType();
                return this.answer;
            }
            if (name.equals("answerInstant")) {
                this.answer = new InstantType();
                return this.answer;
            }
            if (name.equals("answerTime")) {
                this.answer = new TimeType();
                return this.answer;
            }
            if (name.equals("answerString")) {
                this.answer = new StringType();
                return this.answer;
            }
            if (name.equals("answerUri")) {
                this.answer = new UriType();
                return this.answer;
            }
            if (name.equals("answerAttachment")) {
                this.answer = new Attachment();
                return this.answer;
            }
            if (name.equals("answerCoding")) {
                this.answer = new Coding();
                return this.answer;
            }
            if (name.equals("answerQuantity")) {
                this.answer = new Quantity();
                return this.answer;
            }
            if (name.equals("answerReference")) {
                this.answer = new Reference();
                return this.answer;
            }
            return super.addChild(name);
        }

        @Override
        public QuestionnaireItemEnableWhenComponent copy() {
            QuestionnaireItemEnableWhenComponent dst = new QuestionnaireItemEnableWhenComponent();
            this.copyValues(dst);
            dst.question = this.question == null ? null : this.question.copy();
            dst.answered = this.answered == null ? null : this.answered.copy();
            dst.answer = this.answer == null ? null : this.answer.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireItemEnableWhenComponent)) {
                return false;
            }
            QuestionnaireItemEnableWhenComponent o = (QuestionnaireItemEnableWhenComponent)other;
            return QuestionnaireItemEnableWhenComponent.compareDeep(this.question, o.question, true) && QuestionnaireItemEnableWhenComponent.compareDeep(this.answered, o.answered, true) && QuestionnaireItemEnableWhenComponent.compareDeep(this.answer, o.answer, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionnaireItemEnableWhenComponent)) {
                return false;
            }
            QuestionnaireItemEnableWhenComponent o = (QuestionnaireItemEnableWhenComponent)other;
            return QuestionnaireItemEnableWhenComponent.compareValues(this.question, o.question, true) && QuestionnaireItemEnableWhenComponent.compareValues(this.answered, o.answered, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.question != null && !this.question.isEmpty() || this.answered != null && !this.answered.isEmpty() || this.answer != null && !this.answer.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Questionnaire.item.enableWhen";
        }
    }

    public static class QuestionnaireItemTypeEnumFactory
    implements EnumFactory<QuestionnaireItemType> {
        @Override
        public QuestionnaireItemType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("group".equals(codeString)) {
                return QuestionnaireItemType.GROUP;
            }
            if ("display".equals(codeString)) {
                return QuestionnaireItemType.DISPLAY;
            }
            if ("question".equals(codeString)) {
                return QuestionnaireItemType.QUESTION;
            }
            if ("boolean".equals(codeString)) {
                return QuestionnaireItemType.BOOLEAN;
            }
            if ("decimal".equals(codeString)) {
                return QuestionnaireItemType.DECIMAL;
            }
            if ("integer".equals(codeString)) {
                return QuestionnaireItemType.INTEGER;
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return QuestionnaireItemType.DATE;
            }
            if ("dateTime".equals(codeString)) {
                return QuestionnaireItemType.DATETIME;
            }
            if ("instant".equals(codeString)) {
                return QuestionnaireItemType.INSTANT;
            }
            if ("time".equals(codeString)) {
                return QuestionnaireItemType.TIME;
            }
            if ("string".equals(codeString)) {
                return QuestionnaireItemType.STRING;
            }
            if ("text".equals(codeString)) {
                return QuestionnaireItemType.TEXT;
            }
            if ("url".equals(codeString)) {
                return QuestionnaireItemType.URL;
            }
            if ("choice".equals(codeString)) {
                return QuestionnaireItemType.CHOICE;
            }
            if ("open-choice".equals(codeString)) {
                return QuestionnaireItemType.OPENCHOICE;
            }
            if ("attachment".equals(codeString)) {
                return QuestionnaireItemType.ATTACHMENT;
            }
            if ("reference".equals(codeString)) {
                return QuestionnaireItemType.REFERENCE;
            }
            if ("quantity".equals(codeString)) {
                return QuestionnaireItemType.QUANTITY;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireItemType code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireItemType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("group".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.GROUP);
            }
            if ("display".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DISPLAY);
            }
            if ("question".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.QUESTION);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.BOOLEAN);
            }
            if ("decimal".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DECIMAL);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.INTEGER);
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DATE);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.DATETIME);
            }
            if ("instant".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.INSTANT);
            }
            if ("time".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.TIME);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.STRING);
            }
            if ("text".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.TEXT);
            }
            if ("url".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.URL);
            }
            if ("choice".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.CHOICE);
            }
            if ("open-choice".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.OPENCHOICE);
            }
            if ("attachment".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.ATTACHMENT);
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.REFERENCE);
            }
            if ("quantity".equals(codeString)) {
                return new Enumeration<QuestionnaireItemType>(this, QuestionnaireItemType.QUANTITY);
            }
            throw new FHIRException("Unknown QuestionnaireItemType code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireItemType code) {
            if (code == QuestionnaireItemType.NULL) {
                return null;
            }
            if (code == QuestionnaireItemType.GROUP) {
                return "group";
            }
            if (code == QuestionnaireItemType.DISPLAY) {
                return "display";
            }
            if (code == QuestionnaireItemType.QUESTION) {
                return "question";
            }
            if (code == QuestionnaireItemType.BOOLEAN) {
                return "boolean";
            }
            if (code == QuestionnaireItemType.DECIMAL) {
                return "decimal";
            }
            if (code == QuestionnaireItemType.INTEGER) {
                return "integer";
            }
            if (code == QuestionnaireItemType.DATE) {
                return Questionnaire.SP_DATE;
            }
            if (code == QuestionnaireItemType.DATETIME) {
                return "dateTime";
            }
            if (code == QuestionnaireItemType.INSTANT) {
                return "instant";
            }
            if (code == QuestionnaireItemType.TIME) {
                return "time";
            }
            if (code == QuestionnaireItemType.STRING) {
                return "string";
            }
            if (code == QuestionnaireItemType.TEXT) {
                return "text";
            }
            if (code == QuestionnaireItemType.URL) {
                return "url";
            }
            if (code == QuestionnaireItemType.CHOICE) {
                return "choice";
            }
            if (code == QuestionnaireItemType.OPENCHOICE) {
                return "open-choice";
            }
            if (code == QuestionnaireItemType.ATTACHMENT) {
                return "attachment";
            }
            if (code == QuestionnaireItemType.REFERENCE) {
                return "reference";
            }
            if (code == QuestionnaireItemType.QUANTITY) {
                return "quantity";
            }
            return "?";
        }

        @Override
        public String toSystem(QuestionnaireItemType code) {
            return code.getSystem();
        }
    }

    public static enum QuestionnaireItemType {
        GROUP,
        DISPLAY,
        QUESTION,
        BOOLEAN,
        DECIMAL,
        INTEGER,
        DATE,
        DATETIME,
        INSTANT,
        TIME,
        STRING,
        TEXT,
        URL,
        CHOICE,
        OPENCHOICE,
        ATTACHMENT,
        REFERENCE,
        QUANTITY,
        NULL;


        public static QuestionnaireItemType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("group".equals(codeString)) {
                return GROUP;
            }
            if ("display".equals(codeString)) {
                return DISPLAY;
            }
            if ("question".equals(codeString)) {
                return QUESTION;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("decimal".equals(codeString)) {
                return DECIMAL;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return DATE;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("instant".equals(codeString)) {
                return INSTANT;
            }
            if ("time".equals(codeString)) {
                return TIME;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("text".equals(codeString)) {
                return TEXT;
            }
            if ("url".equals(codeString)) {
                return URL;
            }
            if ("choice".equals(codeString)) {
                return CHOICE;
            }
            if ("open-choice".equals(codeString)) {
                return OPENCHOICE;
            }
            if ("attachment".equals(codeString)) {
                return ATTACHMENT;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("quantity".equals(codeString)) {
                return QUANTITY;
            }
            throw new FHIRException("Unknown QuestionnaireItemType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GROUP: {
                    return "group";
                }
                case DISPLAY: {
                    return "display";
                }
                case QUESTION: {
                    return "question";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case INTEGER: {
                    return "integer";
                }
                case DATE: {
                    return Questionnaire.SP_DATE;
                }
                case DATETIME: {
                    return "dateTime";
                }
                case INSTANT: {
                    return "instant";
                }
                case TIME: {
                    return "time";
                }
                case STRING: {
                    return "string";
                }
                case TEXT: {
                    return "text";
                }
                case URL: {
                    return "url";
                }
                case CHOICE: {
                    return "choice";
                }
                case OPENCHOICE: {
                    return "open-choice";
                }
                case ATTACHMENT: {
                    return "attachment";
                }
                case REFERENCE: {
                    return "reference";
                }
                case QUANTITY: {
                    return "quantity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GROUP: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DISPLAY: {
                    return "http://hl7.org/fhir/item-type";
                }
                case QUESTION: {
                    return "http://hl7.org/fhir/item-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DECIMAL: {
                    return "http://hl7.org/fhir/item-type";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DATE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/item-type";
                }
                case INSTANT: {
                    return "http://hl7.org/fhir/item-type";
                }
                case TIME: {
                    return "http://hl7.org/fhir/item-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/item-type";
                }
                case TEXT: {
                    return "http://hl7.org/fhir/item-type";
                }
                case URL: {
                    return "http://hl7.org/fhir/item-type";
                }
                case CHOICE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case OPENCHOICE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case ATTACHMENT: {
                    return "http://hl7.org/fhir/item-type";
                }
                case REFERENCE: {
                    return "http://hl7.org/fhir/item-type";
                }
                case QUANTITY: {
                    return "http://hl7.org/fhir/item-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GROUP: {
                    return "An item with no direct answer but which has descendant items that are questions";
                }
                case DISPLAY: {
                    return "Text for display that will not capture an answer or have descendants";
                }
                case QUESTION: {
                    return "An item that defines a specific answer to be captured (and may have descendant items)";
                }
                case BOOLEAN: {
                    return "Question with a yes/no answer";
                }
                case DECIMAL: {
                    return "Question with is a real number answer";
                }
                case INTEGER: {
                    return "Question with an integer answer";
                }
                case DATE: {
                    return "Question with adate answer";
                }
                case DATETIME: {
                    return "Question with a date and time answer";
                }
                case INSTANT: {
                    return "Question with a system timestamp answer";
                }
                case TIME: {
                    return "Question with a time (hour/minute/second) answer independent of date.";
                }
                case STRING: {
                    return "Question with a short (few words to short sentence) free-text entry answer";
                }
                case TEXT: {
                    return "Question with a long (potentially multi-paragraph) free-text entry (still captured as a string) answer";
                }
                case URL: {
                    return "Question with a url (website, FTP site, etc.) answer";
                }
                case CHOICE: {
                    return "Question with a Coding drawn from a list of options as an answer";
                }
                case OPENCHOICE: {
                    return "Answer is a Coding drawn from a list of options or a free-text entry captured as Coding.display";
                }
                case ATTACHMENT: {
                    return "Question with binary content such as a image, PDF, etc. as an answer";
                }
                case REFERENCE: {
                    return "Question with a reference to another resource (practitioner, organization, etc.) as an answer";
                }
                case QUANTITY: {
                    return "Question with a combination of a numeric value and unit, potentially with a comparator (<, >, etc.) as an answer.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GROUP: {
                    return "Group";
                }
                case DISPLAY: {
                    return "Display";
                }
                case QUESTION: {
                    return "Question";
                }
                case BOOLEAN: {
                    return "Boolean";
                }
                case DECIMAL: {
                    return "Decimal";
                }
                case INTEGER: {
                    return "Integer";
                }
                case DATE: {
                    return "Date";
                }
                case DATETIME: {
                    return "Date Time";
                }
                case INSTANT: {
                    return "Instant";
                }
                case TIME: {
                    return "Time";
                }
                case STRING: {
                    return "String";
                }
                case TEXT: {
                    return "Text";
                }
                case URL: {
                    return "Url";
                }
                case CHOICE: {
                    return "Choice";
                }
                case OPENCHOICE: {
                    return "Open Choice";
                }
                case ATTACHMENT: {
                    return "Attachment";
                }
                case REFERENCE: {
                    return "Reference";
                }
                case QUANTITY: {
                    return "Quantity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

