/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ModuleMetadata")
public class ModuleMetadata
extends Type
implements ICompositeType {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical URL to reference this module", formalDefinition="An absolute URL that is used to identify this module when it is referenced. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this module definition is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier(s) for the module", formalDefinition="A logical identifier for the module such as the CMS or NQF identifiers for a measure artifact.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The version of the module, if any", formalDefinition="The version of the module, if any. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge modules, refer to the Decision Support Service specification. Note that the version is required for non-experimental published artifact.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A machine-friendly name for the module", formalDefinition="A machine-friendly name for the module. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A user-friendly title for the module", formalDefinition="A short, descriptive, user-friendly title for the module.")
    protected StringType title;
    @Child(name="type", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="module | library | decision-support-rule | documentation-template | order-set", formalDefinition="Identifies the type of knowledge module, such as a rule, library, documentation template, or measure.")
    protected Enumeration<ModuleMetadataType> type;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | inactive", formalDefinition="The status of the module.")
    protected Enumeration<ModuleMetadataStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="Determines whether the module was developed for testing purposes (or education/evaluation/marketing), and is not intended to be used in production environments.")
    protected BooleanType experimental;
    @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the module", formalDefinition="A free text natural language description of the module from the consumer's perspective.")
    protected StringType description;
    @Child(name="purpose", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the purpose of the module", formalDefinition="A brief description of the purpose of the module.")
    protected StringType purpose;
    @Child(name="usage", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the module", formalDefinition="A detailed description of how the module is used from a clinical perspective.")
    protected StringType usage;
    @Child(name="publicationDate", type={DateType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Publication date for this version of the module", formalDefinition="The date on which the module was published.")
    protected DateType publicationDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Last review date for the module", formalDefinition="The date on which the module content was last reviewed.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The effective date range for the module", formalDefinition="The period during which the module content is effective.")
    protected Period effectivePeriod;
    @Child(name="coverage", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the context of use for this module", formalDefinition="Specifies various attributes of the patient population for whom and/or environment of care in which the knowledge module is applicable.")
    protected List<ModuleMetadataCoverageComponent> coverage;
    @Child(name="topic", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Descriptional topics for the module", formalDefinition="Clinical topics related to the content of the module.")
    protected List<CodeableConcept> topic;
    @Child(name="contributor", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A content contributor", formalDefinition="A contributor to the content of the module, including authors, editors, reviewers, and endorsers.")
    protected List<ModuleMetadataContributorComponent> contributor;
    @Child(name="publisher", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the module (also known as the steward for the module). This information is required for non-experimental published artifacts.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<ModuleMetadataContactComponent> contact;
    @Child(name="copyright", type={StringType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the module and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the module.")
    protected StringType copyright;
    @Child(name="relatedResource", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Related resources for the module", formalDefinition="Related resources such as additional documentation, justification, or bibliographic references.")
    protected List<ModuleMetadataRelatedResourceComponent> relatedResource;
    private static final long serialVersionUID = 1528493169L;

    public ModuleMetadata() {
    }

    public ModuleMetadata(Enumeration<ModuleMetadataType> type, Enumeration<ModuleMetadataStatus> status) {
        this.type = type;
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ModuleMetadata setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ModuleMetadata setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ModuleMetadata addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ModuleMetadata setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ModuleMetadata setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ModuleMetadata setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ModuleMetadata setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ModuleMetadata setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public ModuleMetadata setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public Enumeration<ModuleMetadataType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ModuleMetadataType>(new ModuleMetadataTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ModuleMetadata setTypeElement(Enumeration<ModuleMetadataType> value) {
        this.type = value;
        return this;
    }

    public ModuleMetadataType getType() {
        return this.type == null ? null : (ModuleMetadataType)((Object)this.type.getValue());
    }

    public ModuleMetadata setType(ModuleMetadataType value) {
        if (this.type == null) {
            this.type = new Enumeration<ModuleMetadataType>(new ModuleMetadataTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Enumeration<ModuleMetadataStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ModuleMetadataStatus>(new ModuleMetadataStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ModuleMetadata setStatusElement(Enumeration<ModuleMetadataStatus> value) {
        this.status = value;
        return this;
    }

    public ModuleMetadataStatus getStatus() {
        return this.status == null ? null : (ModuleMetadataStatus)((Object)this.status.getValue());
    }

    public ModuleMetadata setStatus(ModuleMetadataStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ModuleMetadataStatus>(new ModuleMetadataStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public ModuleMetadata setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public ModuleMetadata setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ModuleMetadata setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ModuleMetadata setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public StringType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new StringType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ModuleMetadata setPurposeElement(StringType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ModuleMetadata setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new StringType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public ModuleMetadata setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public ModuleMetadata setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public DateType getPublicationDateElement() {
        if (this.publicationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.publicationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.publicationDate = new DateType();
            }
        }
        return this.publicationDate;
    }

    public boolean hasPublicationDateElement() {
        return this.publicationDate != null && !this.publicationDate.isEmpty();
    }

    public boolean hasPublicationDate() {
        return this.publicationDate != null && !this.publicationDate.isEmpty();
    }

    public ModuleMetadata setPublicationDateElement(DateType value) {
        this.publicationDate = value;
        return this;
    }

    public Date getPublicationDate() {
        return this.publicationDate == null ? null : (Date)this.publicationDate.getValue();
    }

    public ModuleMetadata setPublicationDate(Date value) {
        if (value == null) {
            this.publicationDate = null;
        } else {
            if (this.publicationDate == null) {
                this.publicationDate = new DateType();
            }
            this.publicationDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ModuleMetadata setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ModuleMetadata setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public ModuleMetadata setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<ModuleMetadataCoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<ModuleMetadataCoverageComponent>();
        }
        return this.coverage;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (ModuleMetadataCoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleMetadataCoverageComponent addCoverage() {
        ModuleMetadataCoverageComponent t = new ModuleMetadataCoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<ModuleMetadataCoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public ModuleMetadata addCoverage(ModuleMetadataCoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<ModuleMetadataCoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public ModuleMetadata addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public List<ModuleMetadataContributorComponent> getContributor() {
        if (this.contributor == null) {
            this.contributor = new ArrayList<ModuleMetadataContributorComponent>();
        }
        return this.contributor;
    }

    public boolean hasContributor() {
        if (this.contributor == null) {
            return false;
        }
        for (ModuleMetadataContributorComponent item : this.contributor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleMetadataContributorComponent addContributor() {
        ModuleMetadataContributorComponent t = new ModuleMetadataContributorComponent();
        if (this.contributor == null) {
            this.contributor = new ArrayList<ModuleMetadataContributorComponent>();
        }
        this.contributor.add(t);
        return t;
    }

    public ModuleMetadata addContributor(ModuleMetadataContributorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contributor == null) {
            this.contributor = new ArrayList<ModuleMetadataContributorComponent>();
        }
        this.contributor.add(t);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public ModuleMetadata setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public ModuleMetadata setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ModuleMetadataContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ModuleMetadataContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ModuleMetadataContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleMetadataContactComponent addContact() {
        ModuleMetadataContactComponent t = new ModuleMetadataContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ModuleMetadataContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public ModuleMetadata addContact(ModuleMetadataContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ModuleMetadataContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleMetadata.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ModuleMetadata setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ModuleMetadata setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<ModuleMetadataRelatedResourceComponent> getRelatedResource() {
        if (this.relatedResource == null) {
            this.relatedResource = new ArrayList<ModuleMetadataRelatedResourceComponent>();
        }
        return this.relatedResource;
    }

    public boolean hasRelatedResource() {
        if (this.relatedResource == null) {
            return false;
        }
        for (ModuleMetadataRelatedResourceComponent item : this.relatedResource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleMetadataRelatedResourceComponent addRelatedResource() {
        ModuleMetadataRelatedResourceComponent t = new ModuleMetadataRelatedResourceComponent();
        if (this.relatedResource == null) {
            this.relatedResource = new ArrayList<ModuleMetadataRelatedResourceComponent>();
        }
        this.relatedResource.add(t);
        return t;
    }

    public ModuleMetadata addRelatedResource(ModuleMetadataRelatedResourceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.relatedResource == null) {
            this.relatedResource = new ArrayList<ModuleMetadataRelatedResourceComponent>();
        }
        this.relatedResource.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("url", "uri", "An absolute URL that is used to identify this module when it is referenced. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this module definition is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property("identifier", "Identifier", "A logical identifier for the module such as the CMS or NQF identifiers for a measure artifact.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("version", "string", "The version of the module, if any. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge modules, refer to the Decision Support Service specification. Note that the version is required for non-experimental published artifact.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property("name", "string", "A machine-friendly name for the module. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("title", "string", "A short, descriptive, user-friendly title for the module.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("type", "code", "Identifies the type of knowledge module, such as a rule, library, documentation template, or measure.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("status", "code", "The status of the module.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "Determines whether the module was developed for testing purposes (or education/evaluation/marketing), and is not intended to be used in production environments.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property("description", "string", "A free text natural language description of the module from the consumer's perspective.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("purpose", "string", "A brief description of the purpose of the module.", 0, Integer.MAX_VALUE, this.purpose));
        childrenList.add(new Property("usage", "string", "A detailed description of how the module is used from a clinical perspective.", 0, Integer.MAX_VALUE, this.usage));
        childrenList.add(new Property("publicationDate", "date", "The date on which the module was published.", 0, Integer.MAX_VALUE, this.publicationDate));
        childrenList.add(new Property("lastReviewDate", "date", "The date on which the module content was last reviewed.", 0, Integer.MAX_VALUE, this.lastReviewDate));
        childrenList.add(new Property("effectivePeriod", "Period", "The period during which the module content is effective.", 0, Integer.MAX_VALUE, this.effectivePeriod));
        childrenList.add(new Property("coverage", "", "Specifies various attributes of the patient population for whom and/or environment of care in which, the knowledge module is applicable.", 0, Integer.MAX_VALUE, this.coverage));
        childrenList.add(new Property("topic", "CodeableConcept", "Clinical topics related to the content of the module.", 0, Integer.MAX_VALUE, this.topic));
        childrenList.add(new Property("contributor", "", "A contributor to the content of the module, including authors, editors, reviewers, and endorsers.", 0, Integer.MAX_VALUE, this.contributor));
        childrenList.add(new Property("publisher", "string", "The name of the individual or organization that published the module (also known as the steward for the module). This information is required for non-experimental published artifacts.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the module and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the module.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("relatedResource", "", "Related resources such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedResource));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.type;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.usage;
                }
                return baseArray;
            }
            case 1470566394: {
                Base[] baseArray;
                if (this.publicationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.publicationDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -351767064: {
                return this.coverage == null ? new Base[]{} : this.coverage.toArray(new Base[this.coverage.size()]);
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1895276325: {
                return this.contributor == null ? new Base[]{} : this.contributor.toArray(new Base[this.contributor.size()]);
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.copyright;
                }
                return baseArray;
            }
            case 1554540889: {
                return this.relatedResource == null ? new Base[]{} : this.relatedResource.toArray(new Base[this.relatedResource.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case 110371416: {
                this.title = this.castToString(value);
                break;
            }
            case 3575610: {
                this.type = new ModuleMetadataTypeEnumFactory().fromType(value);
                break;
            }
            case -892481550: {
                this.status = new ModuleMetadataStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -220463842: {
                this.purpose = this.castToString(value);
                break;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                break;
            }
            case 1470566394: {
                this.publicationDate = this.castToDate(value);
                break;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                break;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                break;
            }
            case -351767064: {
                this.getCoverage().add((ModuleMetadataCoverageComponent)value);
                break;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                break;
            }
            case -1895276325: {
                this.getContributor().add((ModuleMetadataContributorComponent)value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((ModuleMetadataContactComponent)value);
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case 1554540889: {
                this.getRelatedResource().add((ModuleMetadataRelatedResourceComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = this.castToUri(value);
        } else if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals("name")) {
            this.name = this.castToString(value);
        } else if (name.equals("title")) {
            this.title = this.castToString(value);
        } else if (name.equals("type")) {
            this.type = new ModuleMetadataTypeEnumFactory().fromType(value);
        } else if (name.equals("status")) {
            this.status = new ModuleMetadataStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToString(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("publicationDate")) {
            this.publicationDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("coverage")) {
            this.getCoverage().add((ModuleMetadataCoverageComponent)value);
        } else if (name.equals("topic")) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("contributor")) {
            this.getContributor().add((ModuleMetadataContributorComponent)value);
        } else if (name.equals("publisher")) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ModuleMetadataContactComponent)value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("relatedResource")) {
            this.getRelatedResource().add((ModuleMetadataRelatedResourceComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case 110371416: {
                throw new FHIRException("Cannot make property title as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -220463842: {
                throw new FHIRException("Cannot make property purpose as it is not a complex type");
            }
            case 111574433: {
                throw new FHIRException("Cannot make property usage as it is not a complex type");
            }
            case 1470566394: {
                throw new FHIRException("Cannot make property publicationDate as it is not a complex type");
            }
            case -1687512484: {
                throw new FHIRException("Cannot make property lastReviewDate as it is not a complex type");
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -351767064: {
                return this.addCoverage();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1895276325: {
                return this.addContributor();
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case 1554540889: {
                return this.addRelatedResource();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.url");
        }
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.version");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.name");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.title");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.type");
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.experimental");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.description");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.usage");
        }
        if (name.equals("publicationDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.publicationDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        if (name.equals("topic")) {
            return this.addTopic();
        }
        if (name.equals("contributor")) {
            return this.addContributor();
        }
        if (name.equals("publisher")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.copyright");
        }
        if (name.equals("relatedResource")) {
            return this.addRelatedResource();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ModuleMetadata";
    }

    @Override
    public ModuleMetadata copy() {
        ModuleMetadata dst = new ModuleMetadata();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.publicationDate = this.publicationDate == null ? null : this.publicationDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.coverage != null) {
            dst.coverage = new ArrayList<ModuleMetadataCoverageComponent>();
            for (ModuleMetadataCoverageComponent moduleMetadataCoverageComponent : this.coverage) {
                dst.coverage.add(moduleMetadataCoverageComponent.copy());
            }
        }
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.contributor != null) {
            dst.contributor = new ArrayList<ModuleMetadataContributorComponent>();
            for (ModuleMetadataContributorComponent moduleMetadataContributorComponent : this.contributor) {
                dst.contributor.add(moduleMetadataContributorComponent.copy());
            }
        }
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ModuleMetadataContactComponent>();
            for (ModuleMetadataContactComponent moduleMetadataContactComponent : this.contact) {
                dst.contact.add(moduleMetadataContactComponent.copy());
            }
        }
        StringType stringType2 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.relatedResource != null) {
            dst.relatedResource = new ArrayList<ModuleMetadataRelatedResourceComponent>();
            for (ModuleMetadataRelatedResourceComponent moduleMetadataRelatedResourceComponent : this.relatedResource) {
                dst.relatedResource.add(moduleMetadataRelatedResourceComponent.copy());
            }
        }
        return dst;
    }

    @Override
    protected ModuleMetadata typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ModuleMetadata)) {
            return false;
        }
        ModuleMetadata o = (ModuleMetadata)other;
        return ModuleMetadata.compareDeep(this.url, o.url, true) && ModuleMetadata.compareDeep(this.identifier, o.identifier, true) && ModuleMetadata.compareDeep(this.version, o.version, true) && ModuleMetadata.compareDeep(this.name, o.name, true) && ModuleMetadata.compareDeep(this.title, o.title, true) && ModuleMetadata.compareDeep(this.type, o.type, true) && ModuleMetadata.compareDeep(this.status, o.status, true) && ModuleMetadata.compareDeep(this.experimental, o.experimental, true) && ModuleMetadata.compareDeep(this.description, o.description, true) && ModuleMetadata.compareDeep(this.purpose, o.purpose, true) && ModuleMetadata.compareDeep(this.usage, o.usage, true) && ModuleMetadata.compareDeep(this.publicationDate, o.publicationDate, true) && ModuleMetadata.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ModuleMetadata.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ModuleMetadata.compareDeep(this.coverage, o.coverage, true) && ModuleMetadata.compareDeep(this.topic, o.topic, true) && ModuleMetadata.compareDeep(this.contributor, o.contributor, true) && ModuleMetadata.compareDeep(this.publisher, o.publisher, true) && ModuleMetadata.compareDeep(this.contact, o.contact, true) && ModuleMetadata.compareDeep(this.copyright, o.copyright, true) && ModuleMetadata.compareDeep(this.relatedResource, o.relatedResource, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ModuleMetadata)) {
            return false;
        }
        ModuleMetadata o = (ModuleMetadata)other;
        return ModuleMetadata.compareValues(this.url, o.url, true) && ModuleMetadata.compareValues(this.version, o.version, true) && ModuleMetadata.compareValues(this.name, o.name, true) && ModuleMetadata.compareValues(this.title, o.title, true) && ModuleMetadata.compareValues(this.type, o.type, true) && ModuleMetadata.compareValues(this.status, o.status, true) && ModuleMetadata.compareValues(this.experimental, o.experimental, true) && ModuleMetadata.compareValues(this.description, o.description, true) && ModuleMetadata.compareValues(this.purpose, o.purpose, true) && ModuleMetadata.compareValues(this.usage, o.usage, true) && ModuleMetadata.compareValues(this.publicationDate, o.publicationDate, true) && ModuleMetadata.compareValues(this.lastReviewDate, o.lastReviewDate, true) && ModuleMetadata.compareValues(this.publisher, o.publisher, true) && ModuleMetadata.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.title != null && !this.title.isEmpty() || this.type != null && !this.type.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.description != null && !this.description.isEmpty() || this.purpose != null && !this.purpose.isEmpty() || this.usage != null && !this.usage.isEmpty() || this.publicationDate != null && !this.publicationDate.isEmpty() || this.lastReviewDate != null && !this.lastReviewDate.isEmpty() || this.effectivePeriod != null && !this.effectivePeriod.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.topic != null && !this.topic.isEmpty() || this.contributor != null && !this.contributor.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.relatedResource != null && !this.relatedResource.isEmpty());
    }

    public static class ModuleMetadataTypeEnumFactory
    implements EnumFactory<ModuleMetadataType> {
        @Override
        public ModuleMetadataType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("module".equals(codeString)) {
                return ModuleMetadataType.MODULE;
            }
            if ("library".equals(codeString)) {
                return ModuleMetadataType.LIBRARY;
            }
            if ("decision-support-rule".equals(codeString)) {
                return ModuleMetadataType.DECISIONSUPPORTRULE;
            }
            if ("documentation-template".equals(codeString)) {
                return ModuleMetadataType.DOCUMENTATIONTEMPLATE;
            }
            if ("order-set".equals(codeString)) {
                return ModuleMetadataType.ORDERSET;
            }
            throw new IllegalArgumentException("Unknown ModuleMetadataType code '" + codeString + "'");
        }

        public Enumeration<ModuleMetadataType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("module".equals(codeString)) {
                return new Enumeration<ModuleMetadataType>(this, ModuleMetadataType.MODULE);
            }
            if ("library".equals(codeString)) {
                return new Enumeration<ModuleMetadataType>(this, ModuleMetadataType.LIBRARY);
            }
            if ("decision-support-rule".equals(codeString)) {
                return new Enumeration<ModuleMetadataType>(this, ModuleMetadataType.DECISIONSUPPORTRULE);
            }
            if ("documentation-template".equals(codeString)) {
                return new Enumeration<ModuleMetadataType>(this, ModuleMetadataType.DOCUMENTATIONTEMPLATE);
            }
            if ("order-set".equals(codeString)) {
                return new Enumeration<ModuleMetadataType>(this, ModuleMetadataType.ORDERSET);
            }
            throw new FHIRException("Unknown ModuleMetadataType code '" + codeString + "'");
        }

        @Override
        public String toCode(ModuleMetadataType code) {
            if (code == ModuleMetadataType.NULL) {
                return null;
            }
            if (code == ModuleMetadataType.MODULE) {
                return "module";
            }
            if (code == ModuleMetadataType.LIBRARY) {
                return "library";
            }
            if (code == ModuleMetadataType.DECISIONSUPPORTRULE) {
                return "decision-support-rule";
            }
            if (code == ModuleMetadataType.DOCUMENTATIONTEMPLATE) {
                return "documentation-template";
            }
            if (code == ModuleMetadataType.ORDERSET) {
                return "order-set";
            }
            return "?";
        }

        @Override
        public String toSystem(ModuleMetadataType code) {
            return code.getSystem();
        }
    }

    public static enum ModuleMetadataType {
        MODULE,
        LIBRARY,
        DECISIONSUPPORTRULE,
        DOCUMENTATIONTEMPLATE,
        ORDERSET,
        NULL;


        public static ModuleMetadataType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("module".equals(codeString)) {
                return MODULE;
            }
            if ("library".equals(codeString)) {
                return LIBRARY;
            }
            if ("decision-support-rule".equals(codeString)) {
                return DECISIONSUPPORTRULE;
            }
            if ("documentation-template".equals(codeString)) {
                return DOCUMENTATIONTEMPLATE;
            }
            if ("order-set".equals(codeString)) {
                return ORDERSET;
            }
            throw new FHIRException("Unknown ModuleMetadataType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MODULE: {
                    return "module";
                }
                case LIBRARY: {
                    return "library";
                }
                case DECISIONSUPPORTRULE: {
                    return "decision-support-rule";
                }
                case DOCUMENTATIONTEMPLATE: {
                    return "documentation-template";
                }
                case ORDERSET: {
                    return "order-set";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MODULE: {
                    return "http://hl7.org/fhir/module-metadata-type";
                }
                case LIBRARY: {
                    return "http://hl7.org/fhir/module-metadata-type";
                }
                case DECISIONSUPPORTRULE: {
                    return "http://hl7.org/fhir/module-metadata-type";
                }
                case DOCUMENTATIONTEMPLATE: {
                    return "http://hl7.org/fhir/module-metadata-type";
                }
                case ORDERSET: {
                    return "http://hl7.org/fhir/module-metadata-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MODULE: {
                    return "The resource is a description of a knowledge module";
                }
                case LIBRARY: {
                    return "The resource is a shareable library of formalized knowledge";
                }
                case DECISIONSUPPORTRULE: {
                    return "An Event-Condition-Action Rule Artifact";
                }
                case DOCUMENTATIONTEMPLATE: {
                    return "A Documentation Template Artifact";
                }
                case ORDERSET: {
                    return "An Order Set Artifact";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MODULE: {
                    return "Module";
                }
                case LIBRARY: {
                    return "Library";
                }
                case DECISIONSUPPORTRULE: {
                    return "Decision Support Rule";
                }
                case DOCUMENTATIONTEMPLATE: {
                    return "Documentation Template";
                }
                case ORDERSET: {
                    return "Order Set";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ModuleMetadataStatusEnumFactory
    implements EnumFactory<ModuleMetadataStatus> {
        @Override
        public ModuleMetadataStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ModuleMetadataStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return ModuleMetadataStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return ModuleMetadataStatus.INACTIVE;
            }
            throw new IllegalArgumentException("Unknown ModuleMetadataStatus code '" + codeString + "'");
        }

        public Enumeration<ModuleMetadataStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ModuleMetadataStatus>(this, ModuleMetadataStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ModuleMetadataStatus>(this, ModuleMetadataStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<ModuleMetadataStatus>(this, ModuleMetadataStatus.INACTIVE);
            }
            throw new FHIRException("Unknown ModuleMetadataStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ModuleMetadataStatus code) {
            if (code == ModuleMetadataStatus.NULL) {
                return null;
            }
            if (code == ModuleMetadataStatus.DRAFT) {
                return "draft";
            }
            if (code == ModuleMetadataStatus.ACTIVE) {
                return "active";
            }
            if (code == ModuleMetadataStatus.INACTIVE) {
                return "inactive";
            }
            return "?";
        }

        @Override
        public String toSystem(ModuleMetadataStatus code) {
            return code.getSystem();
        }
    }

    public static enum ModuleMetadataStatus {
        DRAFT,
        ACTIVE,
        INACTIVE,
        NULL;


        public static ModuleMetadataStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            throw new FHIRException("Unknown ModuleMetadataStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/module-metadata-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/module-metadata-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/module-metadata-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The module is in draft state";
                }
                case ACTIVE: {
                    return "The module is active";
                }
                case INACTIVE: {
                    return "The module is inactive, either rejected before publication, or retired after publication";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class ModuleMetadataCoverageComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="focus", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="patient-gender | patient-age-group | clinical-focus | target-user | workflow-setting | workflow-task | clinical-venue | jurisdiction", formalDefinition="Specifies the focus of the coverage attribute.")
        protected Coding focus;
        @Child(name="value", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the coverage attribute", formalDefinition="Provides a value for the coverage attribute. Different values are appropriate in different focus areas, as specified in the description of values for focus.")
        protected CodeableConcept value;
        private static final long serialVersionUID = 65126300L;

        public ModuleMetadataCoverageComponent() {
        }

        public ModuleMetadataCoverageComponent(Coding focus, CodeableConcept value) {
            this.focus = focus;
            this.value = value;
        }

        public Coding getFocus() {
            if (this.focus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataCoverageComponent.focus");
                }
                if (Configuration.doAutoCreate()) {
                    this.focus = new Coding();
                }
            }
            return this.focus;
        }

        public boolean hasFocus() {
            return this.focus != null && !this.focus.isEmpty();
        }

        public ModuleMetadataCoverageComponent setFocus(Coding value) {
            this.focus = value;
            return this;
        }

        public CodeableConcept getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataCoverageComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new CodeableConcept();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ModuleMetadataCoverageComponent setValue(CodeableConcept value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("focus", "Coding", "Specifies the focus of the coverage attribute.", 0, Integer.MAX_VALUE, this.focus));
            childrenList.add(new Property("value", "CodeableConcept", "Provides a value for the coverage attribute. Different values are appropriate in different focus areas, as specified in the description of values for focus.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 97604824: {
                    Base[] baseArray;
                    if (this.focus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.focus;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 97604824: {
                    this.focus = this.castToCoding(value);
                    break;
                }
                case 111972721: {
                    this.value = this.castToCodeableConcept(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("focus")) {
                this.focus = this.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 97604824: {
                    return this.getFocus();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("focus")) {
                this.focus = new Coding();
                return this.focus;
            }
            if (name.equals("value")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ModuleMetadataCoverageComponent copy() {
            ModuleMetadataCoverageComponent dst = new ModuleMetadataCoverageComponent();
            this.copyValues(dst);
            dst.focus = this.focus == null ? null : this.focus.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataCoverageComponent)) {
                return false;
            }
            ModuleMetadataCoverageComponent o = (ModuleMetadataCoverageComponent)other;
            return ModuleMetadataCoverageComponent.compareDeep(this.focus, o.focus, true) && ModuleMetadataCoverageComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataCoverageComponent)) {
                return false;
            }
            ModuleMetadataCoverageComponent o = (ModuleMetadataCoverageComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.focus != null && !this.focus.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleMetadata.coverage";
        }
    }

    @Block
    public static class ModuleMetadataContributorComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="author | editor | reviewer | endorser", formalDefinition="The type of contributor.")
        protected Enumeration<ModuleMetadataContributorType> type;
        @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the contributor", formalDefinition="The name of the individual or organization responsible for the contribution.")
        protected StringType name;
        @Child(name="contact", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details of the contributor", formalDefinition="Contacts to assist a user in finding and communicating with the contributor.")
        protected List<ModuleMetadataContributorContactComponent> contact;
        private static final long serialVersionUID = 1033333886L;

        public ModuleMetadataContributorComponent() {
        }

        public ModuleMetadataContributorComponent(Enumeration<ModuleMetadataContributorType> type, StringType name) {
            this.type = type;
            this.name = name;
        }

        public Enumeration<ModuleMetadataContributorType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataContributorComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ModuleMetadataContributorType>(new ModuleMetadataContributorTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ModuleMetadataContributorComponent setTypeElement(Enumeration<ModuleMetadataContributorType> value) {
            this.type = value;
            return this;
        }

        public ModuleMetadataContributorType getType() {
            return this.type == null ? null : (ModuleMetadataContributorType)((Object)this.type.getValue());
        }

        public ModuleMetadataContributorComponent setType(ModuleMetadataContributorType value) {
            if (this.type == null) {
                this.type = new Enumeration<ModuleMetadataContributorType>(new ModuleMetadataContributorTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataContributorComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleMetadataContributorComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleMetadataContributorComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public List<ModuleMetadataContributorContactComponent> getContact() {
            if (this.contact == null) {
                this.contact = new ArrayList<ModuleMetadataContributorContactComponent>();
            }
            return this.contact;
        }

        public boolean hasContact() {
            if (this.contact == null) {
                return false;
            }
            for (ModuleMetadataContributorContactComponent item : this.contact) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ModuleMetadataContributorContactComponent addContact() {
            ModuleMetadataContributorContactComponent t = new ModuleMetadataContributorContactComponent();
            if (this.contact == null) {
                this.contact = new ArrayList<ModuleMetadataContributorContactComponent>();
            }
            this.contact.add(t);
            return t;
        }

        public ModuleMetadataContributorComponent addContact(ModuleMetadataContributorContactComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contact == null) {
                this.contact = new ArrayList<ModuleMetadataContributorContactComponent>();
            }
            this.contact.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of contributor.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("name", "string", "The name of the individual or organization responsible for the contribution.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the contributor.", 0, Integer.MAX_VALUE, this.contact));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case 951526432: {
                    return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new ModuleMetadataContributorTypeEnumFactory().fromType(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 951526432: {
                    this.getContact().add((ModuleMetadataContributorContactComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new ModuleMetadataContributorTypeEnumFactory().fromType(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("contact")) {
                this.getContact().add((ModuleMetadataContributorContactComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 951526432: {
                    return this.addContact();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.type");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.name");
            }
            if (name.equals("contact")) {
                return this.addContact();
            }
            return super.addChild(name);
        }

        @Override
        public ModuleMetadataContributorComponent copy() {
            ModuleMetadataContributorComponent dst = new ModuleMetadataContributorComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.contact != null) {
                dst.contact = new ArrayList<ModuleMetadataContributorContactComponent>();
                for (ModuleMetadataContributorContactComponent i : this.contact) {
                    dst.contact.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataContributorComponent)) {
                return false;
            }
            ModuleMetadataContributorComponent o = (ModuleMetadataContributorComponent)other;
            return ModuleMetadataContributorComponent.compareDeep(this.type, o.type, true) && ModuleMetadataContributorComponent.compareDeep(this.name, o.name, true) && ModuleMetadataContributorComponent.compareDeep(this.contact, o.contact, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataContributorComponent)) {
                return false;
            }
            ModuleMetadataContributorComponent o = (ModuleMetadataContributorComponent)other;
            return ModuleMetadataContributorComponent.compareValues(this.type, o.type, true) && ModuleMetadataContributorComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.name != null && !this.name.isEmpty() || this.contact != null && !this.contact.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleMetadata.contributor";
        }
    }

    @Block
    public static class ModuleMetadataContactComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the module.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details for an individual or publisher", formalDefinition="Contact details for the individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleMetadataContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleMetadataContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ModuleMetadataContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name of an individual to contact regarding the module.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for the individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ModuleMetadataContactComponent copy() {
            ModuleMetadataContactComponent dst = new ModuleMetadataContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataContactComponent)) {
                return false;
            }
            ModuleMetadataContactComponent o = (ModuleMetadataContactComponent)other;
            return ModuleMetadataContactComponent.compareDeep(this.name, o.name, true) && ModuleMetadataContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataContactComponent)) {
                return false;
            }
            ModuleMetadataContactComponent o = (ModuleMetadataContactComponent)other;
            return ModuleMetadataContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleMetadata.contact";
        }
    }

    @Block
    public static class ModuleMetadataRelatedResourceComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="documentation | justification | citation | predecessor | successor | derived-from", formalDefinition="The type of related resource.")
        protected Enumeration<ModuleMetadataResourceType> type;
        @Child(name="document", type={Attachment.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The related document", formalDefinition="The document being referenced, represented as an attachment. This is exclusive with the resource element.")
        protected Attachment document;
        @Child(name="resource", type={}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The related resource", formalDefinition="The related resource, such as a library, value set, profile, or other module.")
        protected Reference resource;
        protected Resource resourceTarget;
        private static final long serialVersionUID = -1400982664L;

        public ModuleMetadataRelatedResourceComponent() {
        }

        public ModuleMetadataRelatedResourceComponent(Enumeration<ModuleMetadataResourceType> type) {
            this.type = type;
        }

        public Enumeration<ModuleMetadataResourceType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataRelatedResourceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ModuleMetadataResourceType>(new ModuleMetadataResourceTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ModuleMetadataRelatedResourceComponent setTypeElement(Enumeration<ModuleMetadataResourceType> value) {
            this.type = value;
            return this;
        }

        public ModuleMetadataResourceType getType() {
            return this.type == null ? null : (ModuleMetadataResourceType)((Object)this.type.getValue());
        }

        public ModuleMetadataRelatedResourceComponent setType(ModuleMetadataResourceType value) {
            if (this.type == null) {
                this.type = new Enumeration<ModuleMetadataResourceType>(new ModuleMetadataResourceTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public Attachment getDocument() {
            if (this.document == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataRelatedResourceComponent.document");
                }
                if (Configuration.doAutoCreate()) {
                    this.document = new Attachment();
                }
            }
            return this.document;
        }

        public boolean hasDocument() {
            return this.document != null && !this.document.isEmpty();
        }

        public ModuleMetadataRelatedResourceComponent setDocument(Attachment value) {
            this.document = value;
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataRelatedResourceComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public ModuleMetadataRelatedResourceComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        public Resource getResourceTarget() {
            return this.resourceTarget;
        }

        public ModuleMetadataRelatedResourceComponent setResourceTarget(Resource value) {
            this.resourceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of related resource.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("document", "Attachment", "The document being referenced, represented as an attachment. This is exclusive with the resource element.", 0, Integer.MAX_VALUE, this.document));
            childrenList.add(new Property("resource", "Reference(Any)", "The related resource, such as a library, value set, profile, or other module.", 0, Integer.MAX_VALUE, this.resource));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 861720859: {
                    Base[] baseArray;
                    if (this.document == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.document;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new ModuleMetadataResourceTypeEnumFactory().fromType(value);
                    break;
                }
                case 861720859: {
                    this.document = this.castToAttachment(value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new ModuleMetadataResourceTypeEnumFactory().fromType(value);
            } else if (name.equals("document")) {
                this.document = this.castToAttachment(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 861720859: {
                    return this.getDocument();
                }
                case -341064690: {
                    return this.getResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.type");
            }
            if (name.equals("document")) {
                this.document = new Attachment();
                return this.document;
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            return super.addChild(name);
        }

        @Override
        public ModuleMetadataRelatedResourceComponent copy() {
            ModuleMetadataRelatedResourceComponent dst = new ModuleMetadataRelatedResourceComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.document = this.document == null ? null : this.document.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataRelatedResourceComponent)) {
                return false;
            }
            ModuleMetadataRelatedResourceComponent o = (ModuleMetadataRelatedResourceComponent)other;
            return ModuleMetadataRelatedResourceComponent.compareDeep(this.type, o.type, true) && ModuleMetadataRelatedResourceComponent.compareDeep(this.document, o.document, true) && ModuleMetadataRelatedResourceComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataRelatedResourceComponent)) {
                return false;
            }
            ModuleMetadataRelatedResourceComponent o = (ModuleMetadataRelatedResourceComponent)other;
            return ModuleMetadataRelatedResourceComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.document != null && !this.document.isEmpty() || this.resource != null && !this.resource.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleMetadata.relatedResource";
        }
    }

    @Block
    public static class ModuleMetadataContributorContactComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the contribution.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details for an individual or contributor", formalDefinition="Contact details for the individual (if a name was provided) or the contributor.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleMetadataContributorContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleMetadataContributorContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleMetadataContributorContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ModuleMetadataContributorContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name of an individual to contact regarding the contribution.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for the individual (if a name was provided) or the contributor.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property ModuleMetadata.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ModuleMetadataContributorContactComponent copy() {
            ModuleMetadataContributorContactComponent dst = new ModuleMetadataContributorContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataContributorContactComponent)) {
                return false;
            }
            ModuleMetadataContributorContactComponent o = (ModuleMetadataContributorContactComponent)other;
            return ModuleMetadataContributorContactComponent.compareDeep(this.name, o.name, true) && ModuleMetadataContributorContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleMetadataContributorContactComponent)) {
                return false;
            }
            ModuleMetadataContributorContactComponent o = (ModuleMetadataContributorContactComponent)other;
            return ModuleMetadataContributorContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleMetadata.contributor.contact";
        }
    }

    public static class ModuleMetadataResourceTypeEnumFactory
    implements EnumFactory<ModuleMetadataResourceType> {
        @Override
        public ModuleMetadataResourceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return ModuleMetadataResourceType.DOCUMENTATION;
            }
            if ("justification".equals(codeString)) {
                return ModuleMetadataResourceType.JUSTIFICATION;
            }
            if ("citation".equals(codeString)) {
                return ModuleMetadataResourceType.CITATION;
            }
            if ("predecessor".equals(codeString)) {
                return ModuleMetadataResourceType.PREDECESSOR;
            }
            if ("successor".equals(codeString)) {
                return ModuleMetadataResourceType.SUCCESSOR;
            }
            if ("derived-from".equals(codeString)) {
                return ModuleMetadataResourceType.DERIVEDFROM;
            }
            throw new IllegalArgumentException("Unknown ModuleMetadataResourceType code '" + codeString + "'");
        }

        public Enumeration<ModuleMetadataResourceType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return new Enumeration<ModuleMetadataResourceType>(this, ModuleMetadataResourceType.DOCUMENTATION);
            }
            if ("justification".equals(codeString)) {
                return new Enumeration<ModuleMetadataResourceType>(this, ModuleMetadataResourceType.JUSTIFICATION);
            }
            if ("citation".equals(codeString)) {
                return new Enumeration<ModuleMetadataResourceType>(this, ModuleMetadataResourceType.CITATION);
            }
            if ("predecessor".equals(codeString)) {
                return new Enumeration<ModuleMetadataResourceType>(this, ModuleMetadataResourceType.PREDECESSOR);
            }
            if ("successor".equals(codeString)) {
                return new Enumeration<ModuleMetadataResourceType>(this, ModuleMetadataResourceType.SUCCESSOR);
            }
            if ("derived-from".equals(codeString)) {
                return new Enumeration<ModuleMetadataResourceType>(this, ModuleMetadataResourceType.DERIVEDFROM);
            }
            throw new FHIRException("Unknown ModuleMetadataResourceType code '" + codeString + "'");
        }

        @Override
        public String toCode(ModuleMetadataResourceType code) {
            if (code == ModuleMetadataResourceType.NULL) {
                return null;
            }
            if (code == ModuleMetadataResourceType.DOCUMENTATION) {
                return "documentation";
            }
            if (code == ModuleMetadataResourceType.JUSTIFICATION) {
                return "justification";
            }
            if (code == ModuleMetadataResourceType.CITATION) {
                return "citation";
            }
            if (code == ModuleMetadataResourceType.PREDECESSOR) {
                return "predecessor";
            }
            if (code == ModuleMetadataResourceType.SUCCESSOR) {
                return "successor";
            }
            if (code == ModuleMetadataResourceType.DERIVEDFROM) {
                return "derived-from";
            }
            return "?";
        }

        @Override
        public String toSystem(ModuleMetadataResourceType code) {
            return code.getSystem();
        }
    }

    public static enum ModuleMetadataResourceType {
        DOCUMENTATION,
        JUSTIFICATION,
        CITATION,
        PREDECESSOR,
        SUCCESSOR,
        DERIVEDFROM,
        NULL;


        public static ModuleMetadataResourceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("documentation".equals(codeString)) {
                return DOCUMENTATION;
            }
            if ("justification".equals(codeString)) {
                return JUSTIFICATION;
            }
            if ("citation".equals(codeString)) {
                return CITATION;
            }
            if ("predecessor".equals(codeString)) {
                return PREDECESSOR;
            }
            if ("successor".equals(codeString)) {
                return SUCCESSOR;
            }
            if ("derived-from".equals(codeString)) {
                return DERIVEDFROM;
            }
            throw new FHIRException("Unknown ModuleMetadataResourceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DOCUMENTATION: {
                    return "documentation";
                }
                case JUSTIFICATION: {
                    return "justification";
                }
                case CITATION: {
                    return "citation";
                }
                case PREDECESSOR: {
                    return "predecessor";
                }
                case SUCCESSOR: {
                    return "successor";
                }
                case DERIVEDFROM: {
                    return "derived-from";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DOCUMENTATION: {
                    return "http://hl7.org/fhir/module-metadata-resource-type";
                }
                case JUSTIFICATION: {
                    return "http://hl7.org/fhir/module-metadata-resource-type";
                }
                case CITATION: {
                    return "http://hl7.org/fhir/module-metadata-resource-type";
                }
                case PREDECESSOR: {
                    return "http://hl7.org/fhir/module-metadata-resource-type";
                }
                case SUCCESSOR: {
                    return "http://hl7.org/fhir/module-metadata-resource-type";
                }
                case DERIVEDFROM: {
                    return "http://hl7.org/fhir/module-metadata-resource-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DOCUMENTATION: {
                    return "Additional documentation for the module. This would include additional instructions on usage as well additional information on clinical context or appropriateness";
                }
                case JUSTIFICATION: {
                    return "A summary of the justification for the artifact including supporting evidence, relevant guidelines, or other clinically important information. This information is intended to provide a way to make the justification for the module available to the consumer of interventions or results produced by the artifact";
                }
                case CITATION: {
                    return "Bibliographic citation for papers, references, or other relevant material for the module. This is intended to allow for citation of related material, but that was not necessarily specifically prepared in connection with this module";
                }
                case PREDECESSOR: {
                    return "The previous version of the module";
                }
                case SUCCESSOR: {
                    return "The next version of the module";
                }
                case DERIVEDFROM: {
                    return "The module is derived from the resource. This is intended to capture the relationship when a particular module is based on the content of another module, but is modified to capture either a different set of overall requirements, or a more specific set of requirements such as those involved in a particular institution or clinical setting";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DOCUMENTATION: {
                    return "Documentation";
                }
                case JUSTIFICATION: {
                    return "Justification";
                }
                case CITATION: {
                    return "Citation";
                }
                case PREDECESSOR: {
                    return "Predecessor";
                }
                case SUCCESSOR: {
                    return "Successor";
                }
                case DERIVEDFROM: {
                    return "Derived From";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ModuleMetadataContributorTypeEnumFactory
    implements EnumFactory<ModuleMetadataContributorType> {
        @Override
        public ModuleMetadataContributorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("author".equals(codeString)) {
                return ModuleMetadataContributorType.AUTHOR;
            }
            if ("editor".equals(codeString)) {
                return ModuleMetadataContributorType.EDITOR;
            }
            if ("reviewer".equals(codeString)) {
                return ModuleMetadataContributorType.REVIEWER;
            }
            if ("endorser".equals(codeString)) {
                return ModuleMetadataContributorType.ENDORSER;
            }
            throw new IllegalArgumentException("Unknown ModuleMetadataContributorType code '" + codeString + "'");
        }

        public Enumeration<ModuleMetadataContributorType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("author".equals(codeString)) {
                return new Enumeration<ModuleMetadataContributorType>(this, ModuleMetadataContributorType.AUTHOR);
            }
            if ("editor".equals(codeString)) {
                return new Enumeration<ModuleMetadataContributorType>(this, ModuleMetadataContributorType.EDITOR);
            }
            if ("reviewer".equals(codeString)) {
                return new Enumeration<ModuleMetadataContributorType>(this, ModuleMetadataContributorType.REVIEWER);
            }
            if ("endorser".equals(codeString)) {
                return new Enumeration<ModuleMetadataContributorType>(this, ModuleMetadataContributorType.ENDORSER);
            }
            throw new FHIRException("Unknown ModuleMetadataContributorType code '" + codeString + "'");
        }

        @Override
        public String toCode(ModuleMetadataContributorType code) {
            if (code == ModuleMetadataContributorType.NULL) {
                return null;
            }
            if (code == ModuleMetadataContributorType.AUTHOR) {
                return "author";
            }
            if (code == ModuleMetadataContributorType.EDITOR) {
                return "editor";
            }
            if (code == ModuleMetadataContributorType.REVIEWER) {
                return "reviewer";
            }
            if (code == ModuleMetadataContributorType.ENDORSER) {
                return "endorser";
            }
            return "?";
        }

        @Override
        public String toSystem(ModuleMetadataContributorType code) {
            return code.getSystem();
        }
    }

    public static enum ModuleMetadataContributorType {
        AUTHOR,
        EDITOR,
        REVIEWER,
        ENDORSER,
        NULL;


        public static ModuleMetadataContributorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("author".equals(codeString)) {
                return AUTHOR;
            }
            if ("editor".equals(codeString)) {
                return EDITOR;
            }
            if ("reviewer".equals(codeString)) {
                return REVIEWER;
            }
            if ("endorser".equals(codeString)) {
                return ENDORSER;
            }
            throw new FHIRException("Unknown ModuleMetadataContributorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AUTHOR: {
                    return "author";
                }
                case EDITOR: {
                    return "editor";
                }
                case REVIEWER: {
                    return "reviewer";
                }
                case ENDORSER: {
                    return "endorser";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AUTHOR: {
                    return "http://hl7.org/fhir/module-metadata-contributor";
                }
                case EDITOR: {
                    return "http://hl7.org/fhir/module-metadata-contributor";
                }
                case REVIEWER: {
                    return "http://hl7.org/fhir/module-metadata-contributor";
                }
                case ENDORSER: {
                    return "http://hl7.org/fhir/module-metadata-contributor";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AUTHOR: {
                    return "An author of the content of the module";
                }
                case EDITOR: {
                    return "An editor of the content of the module";
                }
                case REVIEWER: {
                    return "A reviewer of the content of the module";
                }
                case ENDORSER: {
                    return "An endorser of the content of the module";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AUTHOR: {
                    return "Author";
                }
                case EDITOR: {
                    return "Editor";
                }
                case REVIEWER: {
                    return "Reviewer";
                }
                case ENDORSER: {
                    return "Endorser";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

