/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcPractitionerPrivilege {
    E631014153084062A1760A03197FB489,
    _0A9A9B654F9F42FAADE80D2592BDE220,
    _77F1B390A4334708AD3B070E358868F4,
    _5750552B25D44EB886F98233756449F0,
    _45FC874FD78743F2A2AA5954446B163D,
    NULL;


    public static HspcPractitionerPrivilege fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("e6310141-5308-4062-a176-0a03197fb489".equals(codeString)) {
            return E631014153084062A1760A03197FB489;
        }
        if ("0a9a9b65-4f9f-42fa-ade8-0d2592bde220".equals(codeString)) {
            return _0A9A9B654F9F42FAADE80D2592BDE220;
        }
        if ("77f1b390-a433-4708-ad3b-070e358868f4".equals(codeString)) {
            return _77F1B390A4334708AD3B070E358868F4;
        }
        if ("5750552b-25d4-4eb8-86f9-8233756449f0".equals(codeString)) {
            return _5750552B25D44EB886F98233756449F0;
        }
        if ("45fc874f-d787-43f2-a2aa-5954446b163d".equals(codeString)) {
            return _45FC874FD78743F2A2AA5954446B163D;
        }
        throw new FHIRException("Unknown HspcPractitionerPrivilege code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case E631014153084062A1760A03197FB489: {
                return "e6310141-5308-4062-a176-0a03197fb489";
            }
            case _0A9A9B654F9F42FAADE80D2592BDE220: {
                return "0a9a9b65-4f9f-42fa-ade8-0d2592bde220";
            }
            case _77F1B390A4334708AD3B070E358868F4: {
                return "77f1b390-a433-4708-ad3b-070e358868f4";
            }
            case _5750552B25D44EB886F98233756449F0: {
                return "5750552b-25d4-4eb8-86f9-8233756449f0";
            }
            case _45FC874FD78743F2A2AA5954446B163D: {
                return "45fc874f-d787-43f2-a2aa-5954446b163d";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/practitioner-hspc-privilege";
    }

    public String getDefinition() {
        switch (this) {
            case E631014153084062A1760A03197FB489: {
                return "The provider is allowed to practice and admit";
            }
            case _0A9A9B654F9F42FAADE80D2592BDE220: {
                return "The provider is not allowed to practice or admit";
            }
            case _77F1B390A4334708AD3B070E358868F4: {
                return "The provider is not allowed to practice or admit at this time";
            }
            case _5750552B25D44EB886F98233756449F0: {
                return "The provider is allowed to practice only, cannot admit patients";
            }
            case _45FC874FD78743F2A2AA5954446B163D: {
                return "The provider is allowed to practice and admit for a limited time";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case E631014153084062A1760A03197FB489: {
                return "Full Privilege";
            }
            case _0A9A9B654F9F42FAADE80D2592BDE220: {
                return "No Privileges to practice or admit";
            }
            case _77F1B390A4334708AD3B070E358868F4: {
                return "Privileges Suspended";
            }
            case _5750552B25D44EB886F98233756449F0: {
                return "Practice Privileges Only (not allowed to admit)";
            }
            case _45FC874FD78743F2A2AA5954446B163D: {
                return "Temporary Privileges";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

