/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AnimalBreeds {
    GSD,
    IRT,
    TIBMAS,
    GRET,
    NULL;


    public static AnimalBreeds fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("gsd".equals(codeString)) {
            return GSD;
        }
        if ("irt".equals(codeString)) {
            return IRT;
        }
        if ("tibmas".equals(codeString)) {
            return TIBMAS;
        }
        if ("gret".equals(codeString)) {
            return GRET;
        }
        throw new FHIRException("Unknown AnimalBreeds code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GSD: {
                return "gsd";
            }
            case IRT: {
                return "irt";
            }
            case TIBMAS: {
                return "tibmas";
            }
            case GRET: {
                return "gret";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/animal-breed";
    }

    public String getDefinition() {
        switch (this) {
            case GSD: {
                return "";
            }
            case IRT: {
                return "";
            }
            case TIBMAS: {
                return "";
            }
            case GRET: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GSD: {
                return "German Shepherd Dog";
            }
            case IRT: {
                return "Irish Terrier";
            }
            case TIBMAS: {
                return "Tibetan Mastiff";
            }
            case GRET: {
                return "Golden Retriever";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

