/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.terminologies;

import java.util.List;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeSystem;

public class CodeSystemUtilities {
    public static boolean isDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptDefinitionPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("deprecated") || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static boolean isAbstract(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptDefinitionPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("abstract") || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static void setAbstract(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) {
        CodeSystemUtilities.defineAbstractProperty(cs);
        concept.addProperty().setCode("abstract").setValue(new BooleanType(true));
    }

    public static void setDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) {
        CodeSystemUtilities.defineAbstractProperty(cs);
        concept.addProperty().setCode("deprecated").setValue(new BooleanType(true));
    }

    public static void defineAbstractProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "abstract", "Indicates that the code is abstract - only intended to be used as a selector for other concepts", CodeSystem.PropertyType.BOOLEAN);
    }

    public static void defineDeprecatedProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "deprecated", "Indicates that the code should not longer be used", CodeSystem.PropertyType.BOOLEAN);
    }

    public static void defineCodeSystemProperty(CodeSystem cs, String code, String description, CodeSystem.PropertyType type) {
        for (CodeSystem.CodeSystemPropertyComponent p : cs.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return;
        }
        cs.addProperty().setCode(code).setDescription(description).setType(type);
    }

    public static String getCodeDefinition(CodeSystem cs, String code) {
        return CodeSystemUtilities.getCodeDefinition(cs.getConcept(), code);
    }

    private static String getCodeDefinition(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.getCode().equals(code)) {
                return c.getDefinition();
            }
            String s = CodeSystemUtilities.getCodeDefinition(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

